/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.automat;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import jmri.NamedBean;
import jmri.util.PropertyChangeEventQueue;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Siglet {
    public NamedBean[] inputs;
    public NamedBean[] outputs;
    private String name;
    protected PropertyChangeEventQueue pq;
    protected Thread thread;
    private static final Logger log = LoggerFactory.getLogger(Siglet.class);

    public Siglet() {
        this.name = "";
    }

    public Siglet(String name) {
        this.name = name;
    }

    public abstract void defineIO();

    public abstract void setOutput();

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public void start() {
        Thread previousThread = this.thread;
        try {
            if (previousThread != null) {
                previousThread.join();
            }
        }
        catch (InterruptedException e) {
            log.warn("Aborted start() due to interrupt");
        }
        if (this.thread != null) {
            log.error("Found thread != null, which is an internal synchronization error for {}", (Object)this.name);
        }
        this.defineIO();
        if (this.inputs == null || this.inputs.length < 1 || this.inputs.length == 1 && this.inputs[0] == null) {
            log.error("Siglet start invoked {}, but no inputs provided", this.name != null && !this.name.isEmpty() ? "for \"" + this.name + "\"" : "(without a name)");
            throw new IllegalArgumentException("No defineIO inputs");
        }
        this.pq = new PropertyChangeEventQueue(this.inputs);
        this.setOutput();
        this.thread = ThreadingUtil.newThread(() -> {
            do {
                try {
                    PropertyChangeEvent pe = this.pq.take();
                    log.trace("driving setOutput from {}", (Object)pe);
                    ThreadingUtil.runOnLayout(() -> this.setOutput());
                }
                catch (InterruptedException e) {
                    log.trace("InterruptedException");
                    this.thread.interrupt();
                }
            } while (!this.thread.isInterrupted());
            log.trace("isInterrupted()");
            this.pq.dispose();
            this.thread = null;
        });
        this.thread.setDaemon(true);
        this.thread.setName(this.getName());
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            Thread tempThread = this.thread;
            tempThread.interrupt();
            try {
                tempThread.join();
            }
            catch (InterruptedException ex) {
                log.debug("stop interrupted");
            }
        }
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public void setInputs(NamedBean[] in) {
        this.inputs = Arrays.copyOf(in, in.length);
    }
}

