/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.beantable.LogixNGModuleTableAction;
import jmri.jmrit.beantable.LogixNGTableAction;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.DeleteBean;
import jmri.jmrit.logixng.tools.swing.LogixNGBrowseWindow;
import jmri.jmrit.logixng.tools.swing.TreeEditor;
import jmri.jmrit.picker.PickFrame;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogixNGTableAction<E extends NamedBean>
extends AbstractTableAction<E> {
    private static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.logixng.LogixNGBundle");
    private static final ResourceBundle rbx2 = ResourceBundle.getBundle("jmri.jmrit.logixng.tools.swing.LogixNGSwingBundle");
    DeleteBean<E> deleteBean = new DeleteBean<E>(this.getManager());
    protected AbstractLogixNGEditor<E> _editor = null;
    boolean _showReminder = false;
    PickFrame _pickTables;
    protected E _curNamedBean = null;
    int conditionalRowNumber = 0;
    JmriJFrame addLogixNGFrame = null;
    JTextField _systemName = new JTextField(20);
    JTextField _addUserName = new JTextField(20);
    JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    JLabel _sysNameLabel = new JLabel(rbx.getString("BeanNameLogixNG") + " " + Bundle.getMessage("ColumnSystemName") + ":");
    JLabel _userNameLabel = new JLabel(rbx.getString("BeanNameLogixNG") + " " + Bundle.getMessage("ColumnUserName") + ":");
    String systemNameAuto = this.getClassName() + ".AutoSystemName";
    JButton create;
    private boolean _inEditMode = false;
    private boolean _inCopyMode = false;
    String _logixNGSysName;
    private static final Logger log = LoggerFactory.getLogger(AbstractLogixNGTableAction.class);

    public AbstractLogixNGTableAction(String s) {
        super(s);
        super.setEnabled(false);
    }

    protected abstract AbstractLogixNGEditor<E> getEditor(BeanTableDataModel<E> var1, String var2);

    protected boolean isEditSupported() {
        return true;
    }

    @Override
    @Nonnull
    protected abstract Manager<E> getManager();

    protected abstract void enableAll(boolean var1);

    protected abstract void setEnabled(E var1, boolean var2);

    protected abstract boolean isEnabled(E var1);

    protected abstract E createBean(String var1);

    protected abstract E createBean(String var1, String var2);

    protected abstract void deleteBean(E var1);

    protected boolean browseMonoSpace() {
        return false;
    }

    protected abstract String getBeanText(E var1, Base.PrintTreeSettings var2);

    protected abstract String getBrowserTitle();

    protected abstract String getAddTitleKey();

    protected abstract String getCreateButtonHintKey();

    protected abstract void getListenerRefsIncludingChildren(E var1, List<String> var2);

    protected abstract boolean hasChildren(E var1);

    @Override
    protected void createModel() {
        this.m = new TableModel();
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLogixNGTable"));
    }

    @Override
    public void setMenuBar(BeanTableFrame<E> f) {
        JMenu menu = new JMenu(Bundle.getMessage("MenuOptions"));
        menu.setMnemonic(79);
        JMenuBar menuBar = f.getJMenuBar();
        int pos = menuBar.getMenuCount() - 1;
        int offset = 1;
        log.debug("setMenuBar number of menu items = {}", (Object)pos);
        for (int i = 0; i <= pos; ++i) {
            if (!(menuBar.getComponent(i) instanceof JMenu) || !((JMenu)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuHelp"))) continue;
            offset = -1;
        }
        if (this instanceof LogixNGTableAction) {
            JMenuItem r = new JMenuItem(Bundle.getMessage("EnableAllLogixNGs"));
            r.addActionListener(e -> this.enableAll(true));
            menu.add(r);
            r = new JMenuItem(Bundle.getMessage("DisableAllLogixNGs"));
            r.addActionListener(e -> this.enableAll(false));
            menu.add(r);
            menuBar.add((Component)menu, pos + offset);
            ++offset;
        }
        menu = new JMenu(Bundle.getMessage("MenuTools"));
        menu.setMnemonic(84);
        JMenuItem item = new JMenuItem(rbx2.getString("MenuOpenClipboard"));
        item.addActionListener(e -> TreeEditor.openClipboard());
        menu.add(item);
        item = new JMenuItem(Bundle.getMessage("OpenPickListTables"));
        item.addActionListener(e -> this.openPickListTable());
        menu.add(item);
        menuBar.add((Component)menu, pos + offset);
    }

    private void openPickListTable() {
        if (this._pickTables == null) {
            this._pickTables = new PickFrame(Bundle.getMessage("TitlePickList"));
        } else {
            this._pickTables.setVisible(true);
        }
        this._pickTables.toFront();
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LogixNGTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        if (!this.checkFlags(null)) {
            return;
        }
        this._showReminder = true;
        if (this.addLogixNGFrame == null) {
            String titleKey = this.getAddTitleKey();
            String buttonHintKey = this.getCreateButtonHintKey();
            JPanel panel5 = this.makeAddFrame(titleKey, "Add");
            this.create = new JButton(Bundle.getMessage("ButtonCreate"));
            panel5.add(this.create);
            this.create.addActionListener(this::createPressed);
            this.create.setToolTipText(Bundle.getMessage(buttonHintKey));
        }
        this.addLogixNGFrame.pack();
        this.addLogixNGFrame.setVisible(true);
        this._autoSystemName.setSelected(false);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> this._autoSystemName.setSelected(prefMgr.getCheckboxPreferenceState(this.systemNameAuto, true)));
    }

    protected abstract JPanel makeAddFrame(String var1, String var2);

    void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this._sysNameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this._sysNameLabel.setEnabled(true);
        }
    }

    void cancelAddPressed(ActionEvent e) {
        this.addLogixNGFrame.setVisible(false);
        this.addLogixNGFrame.dispose();
        this.addLogixNGFrame = null;
        this._inCopyMode = false;
        if (this.f != null) {
            this.f.setVisible(true);
        }
    }

    void copyPressed(String sName) {
        if (!this.checkFlags(sName)) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                JPanel panel5 = AbstractLogixNGTableAction.this.makeAddFrame("TitleCopyLogixNG", "Copy");
                JButton create = new JButton(Bundle.getMessage("ButtonCopy"));
                panel5.add(create);
                create.addActionListener(e -> AbstractLogixNGTableAction.this.copyBeanPressed(e));
                AbstractLogixNGTableAction.this.addLogixNGFrame.pack();
                AbstractLogixNGTableAction.this.addLogixNGFrame.setVisible(true);
                AbstractLogixNGTableAction.this._autoSystemName.setSelected(false);
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> AbstractLogixNGTableAction.this._autoSystemName.setSelected(prefMgr.getCheckboxPreferenceState(AbstractLogixNGTableAction.this.systemNameAuto, true)));
                AbstractLogixNGTableAction.this._inCopyMode = false;
            }
        };
        log.debug("copyPressed started for {}", (Object)sName);
        SwingUtilities.invokeLater(t);
        this._inCopyMode = true;
        this._logixNGSysName = sName;
    }

    protected void copyBean(@Nonnull E sourceBean, @Nonnull E targetBean) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected boolean isCopyBeanSupported() {
        return false;
    }

    protected boolean isExecuteSupported() {
        return false;
    }

    protected void execute(@Nonnull E bean) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void copyBeanPressed(ActionEvent e) {
        E targetBean;
        String uName = this._addUserName.getText().trim();
        if (uName.length() == 0) {
            uName = null;
        }
        if (this._autoSystemName.isSelected()) {
            if (!this.checkLogixNGUserName(uName)) {
                return;
            }
            targetBean = this.createBean(uName);
        } else {
            if (!this.checkLogixNGSysName()) {
                return;
            }
            String sName = this._systemName.getText().trim();
            boolean createLogix = true;
            targetBean = this.getManager().getBySystemName(sName);
            if (targetBean != null) {
                int result = JmriJOptionPane.showConfirmDialog(this.f, Bundle.getMessage("ConfirmLogixDuplicate", sName, this._logixNGSysName), Bundle.getMessage("QuestionTitle"), 0, 3);
                if (1 == result) {
                    return;
                }
                createLogix = false;
                String userName = targetBean.getUserName();
                if (userName != null && userName.length() > 0) {
                    this._addUserName.setText(userName);
                    uName = userName;
                }
            } else if (!this.checkLogixNGUserName(uName)) {
                return;
            }
            if (createLogix) {
                targetBean = this.createBean(sName, uName);
                if (targetBean == null) {
                    log.error("Failure to create LogixNG with System Name: {}", (Object)sName);
                    return;
                }
            } else {
                if (targetBean == null) {
                    log.error("Error targetLogix is null!");
                    return;
                }
                targetBean.setUserName(uName);
            }
        }
        E sourceBean = this.getManager().getBySystemName(this._logixNGSysName);
        if (sourceBean != null) {
            this.copyBean(sourceBean, targetBean);
        } else {
            log.error("Error targetLogix is null!");
        }
        this.cancelAddPressed(null);
    }

    boolean checkLogixNGUserName(String uName) {
        E x;
        if (uName != null && uName.trim().length() > 0 && (x = this.getManager().getByUserName(uName)) != null) {
            JmriJOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("LogixNGError3"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    boolean checkLogixNGSysName() {
        if (this._autoSystemName.isSelected()) {
            return true;
        }
        String sName = this._systemName.getText().trim();
        String prefix = this.getManager().getSubSystemNamePrefix();
        if (!sName.isEmpty() && !sName.startsWith(prefix)) {
            boolean isNumber = sName.matches("^\\d+$");
            boolean hasDollar = sName.startsWith("$");
            StringBuilder newName = new StringBuilder(prefix);
            if (!isNumber && !hasDollar) {
                newName.append("$");
            }
            newName.append(sName);
            sName = newName.toString();
        }
        if (this.getManager().validSystemNameFormat(sName) != Manager.NameValidity.VALID) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("LogixNGError8", sName), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        this._systemName.setText(sName);
        return true;
    }

    boolean checkFlags(String sName) {
        E x;
        if (this._inEditMode) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("LogixNGError32", this._curNamedBean.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
            if (this._editor != null) {
                this._editor.bringToFront();
            }
            return false;
        }
        if (this._inCopyMode) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("LogixNGError31", this._logixNGSysName), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        if (sName != null && (x = this.getManager().getBySystemName(sName)) == null) {
            log.error("No bean with system name: {}", (Object)sName);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("LogixNGError5"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    void createPressed(ActionEvent e) {
        String sName;
        this._showReminder = true;
        String uName = this._addUserName.getText().trim();
        if (uName.length() == 0) {
            uName = null;
        }
        if (this._autoSystemName.isSelected()) {
            if (!this.checkLogixNGUserName(uName)) {
                return;
            }
            try {
                this._curNamedBean = this.createBean(uName);
            }
            catch (NamedBean.BadSystemNameException | NamedBean.BadUserNameException ex) {
                JmriJOptionPane.showMessageDialog(this.addLogixNGFrame, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            if (this._curNamedBean == null) {
                log.error("Failure to create bean with System Name: {}", (Object)"none");
                return;
            }
            sName = this._curNamedBean.getSystemName();
        } else {
            E x;
            if (!this.checkLogixNGSysName()) {
                return;
            }
            sName = this._systemName.getText();
            try {
                x = this.getManager().getBySystemName(sName);
            }
            catch (Exception ex) {
                this.handleCreateException(sName);
                return;
            }
            if (x != null) {
                JmriJOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("LogixNGError1"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            if (!this.checkLogixNGUserName(uName)) {
                return;
            }
            this._curNamedBean = this.createBean(sName, uName);
            if (this._curNamedBean == null) {
                log.error("Failure to create bean with System Name: {}", (Object)sName);
                return;
            }
        }
        this.cancelAddPressed(null);
        this.editPressed(sName);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setCheckboxPreferenceState(this.systemNameAuto, this._autoSystemName.isSelected()));
    }

    void handleCreateException(String sysName) {
        JmriJOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("ErrorLogixAddFailed", sysName), Bundle.getMessage("ErrorTitle"), 0);
    }

    void editPressed(String sName) {
        this._curNamedBean = this.getManager().getBySystemName(sName);
        if (!this.checkFlags(sName)) {
            return;
        }
        this._editor = this.getEditor(this.m, sName);
        if (this._editor == null) {
            return;
        }
        this._inEditMode = true;
        this._editor.addEditorEventListener(data -> {
            String lgxName = sName;
            data.forEach((key, value) -> {
                if (key.equals("Finish")) {
                    this._editor = null;
                    this._inEditMode = false;
                    this.f.setVisible(true);
                } else if (key.equals("Delete")) {
                    this._inEditMode = false;
                    this.deletePressed((String)value);
                } else if (key.equals("chgUname")) {
                    E x = this.getManager().getBySystemName(lgxName);
                    if (x == null) {
                        log.error("Found no logixNG for name {} when changing user name (2)", (Object)lgxName);
                        return;
                    }
                    x.setUserName((String)value);
                    this.m.fireTableDataChanged();
                }
            });
        });
    }

    void deletePressed(String sName) {
        if (!this.checkFlags(sName)) {
            return;
        }
        E x = this.getManager().getBySystemName(sName);
        if (x == null) {
            return;
        }
        this.deleteBean.delete((NamedBean)x, this.hasChildren(x), t -> this.deleteBean(t), (t, list) -> this.getListenerRefsIncludingChildren(t, list), this.getClassName());
    }

    void executePressed(String sName) {
        E x = this.getManager().getBySystemName(sName);
        if (x == null) {
            return;
        }
        this.execute(x);
    }

    @Override
    protected String getClassName() {
        return LogixNG_UserPreferences.class.getName();
    }

    void browserPressed(String sName) {
        this._curNamedBean = this.getManager().getBySystemName(sName);
        if (this._curNamedBean == null) {
            throw new RuntimeException("_curNamedBean is null");
        }
        String title = Bundle.getMessage("BrowserLogixNG") + " " + this._curNamedBean.getSystemName() + "    " + this._curNamedBean.getUserName() + "    " + (this.isEnabled(this._curNamedBean) ? Bundle.getMessage("BrowserEnabled") : Bundle.getMessage("BrowserDisabled"));
        LogixNGBrowseWindow browseWindow = new LogixNGBrowseWindow(Bundle.getMessage("LogixNG_Browse_Title"));
        browseWindow.getPrintTreeSettings();
        boolean showSettingsPanel = this instanceof LogixNGTableAction || this instanceof LogixNGModuleTableAction;
        browseWindow.makeBrowserWindow(this.browseMonoSpace(), showSettingsPanel, title, this._curNamedBean.getSystemName(), printTreeSettings -> this.getBeanText(this._curNamedBean, printTreeSettings));
    }

    protected class TableModel
    extends BeanTableDataModel<E> {
        public static final int ENABLECOL = 2;
        public static final int EDITCOL = 4;
        protected String enabledString = Bundle.getMessage("ColumnHeadEnabled");

        protected TableModel() {
        }

        @Override
        public String getColumnName(int col) {
            if (col == 4) {
                return Bundle.getMessage("ColumnHeadMenu");
            }
            if (col == 2) {
                return this.enabledString;
            }
            return super.getColumnName(col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 4) {
                return String.class;
            }
            if (col == 2) {
                return Boolean.class;
            }
            return super.getColumnClass(col);
        }

        @Override
        public int getPreferredWidth(int col) {
            if (col == 0) {
                return new JTextField((int)12).getPreferredSize().width;
            }
            if (col == 1) {
                return new JTextField((int)17).getPreferredSize().width;
            }
            if (col == 4) {
                return new JTextField((int)12).getPreferredSize().width;
            }
            if (col == 2) {
                return new JTextField((int)5).getPreferredSize().width;
            }
            return super.getPreferredWidth(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 4) {
                return true;
            }
            if (col == 2) {
                return true;
            }
            return super.isCellEditable(row, col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 4) {
                return Bundle.getMessage("ButtonSelect");
            }
            if (col == 2) {
                NamedBean x = (NamedBean)this.getValueAt(row, 0);
                if (x == null) {
                    return null;
                }
                return AbstractLogixNGTableAction.this.isEnabled(x);
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 4) {
                String sName = ((NamedBean)this.getValueAt(row, 0)).getSystemName();
                if (Bundle.getMessage("ButtonEdit").equals(value)) {
                    AbstractLogixNGTableAction.this.editPressed(sName);
                } else if (Bundle.getMessage("BrowserButton").equals(value)) {
                    AbstractLogixNGTableAction.this.conditionalRowNumber = row;
                    AbstractLogixNGTableAction.this.browserPressed(sName);
                } else if (Bundle.getMessage("ButtonCopy").equals(value)) {
                    AbstractLogixNGTableAction.this.copyPressed(sName);
                } else if (Bundle.getMessage("ButtonDelete").equals(value)) {
                    AbstractLogixNGTableAction.this.deletePressed(sName);
                } else if (Bundle.getMessage("LogixNG_ButtonExecute").equals(value)) {
                    AbstractLogixNGTableAction.this.executePressed(sName);
                }
            } else if (col == 2) {
                NamedBean x;
                boolean v = AbstractLogixNGTableAction.this.isEnabled(x = (NamedBean)this.getValueAt(row, 0));
                AbstractLogixNGTableAction.this.setEnabled(x, !v);
            } else {
                super.setValueAt(value, row, col);
            }
        }

        @Override
        protected void doDelete(E bean) {
            AbstractLogixNGTableAction.this.deleteBean(bean);
        }

        @Override
        protected boolean matchPropertyName(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(this.enabledString)) {
                return true;
            }
            return super.matchPropertyName(e);
        }

        @Override
        public Manager<E> getManager() {
            return AbstractLogixNGTableAction.this.getManager();
        }

        @Override
        public E getBySystemName(String name) {
            return AbstractLogixNGTableAction.this.getManager().getBySystemName(name);
        }

        @Override
        public E getByUserName(String name) {
            return AbstractLogixNGTableAction.this.getManager().getByUserName(name);
        }

        @Override
        protected String getMasterClassName() {
            return AbstractLogixNGTableAction.this.getClassName();
        }

        @Override
        public void configureTable(JTable table) {
            table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
            table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
            table.setDefaultEditor(JComboBox.class, new ValueEditor());
            if (!(this.getManager() instanceof LogixNG_Manager)) {
                table.getColumnModel().getColumn(2).setMinWidth(0);
                table.getColumnModel().getColumn(2).setMaxWidth(0);
            }
            super.configureTable(table);
        }

        @Override
        protected void configDeleteColumn(JTable table) {
            JComboBox<String> editCombo = new JComboBox<String>();
            editCombo.addItem(Bundle.getMessage("ButtonSelect"));
            if (AbstractLogixNGTableAction.this.isEditSupported()) {
                editCombo.addItem(Bundle.getMessage("ButtonEdit"));
            }
            editCombo.addItem(Bundle.getMessage("BrowserButton"));
            if (AbstractLogixNGTableAction.this.isCopyBeanSupported()) {
                editCombo.addItem(Bundle.getMessage("ButtonCopy"));
            }
            editCombo.addItem(Bundle.getMessage("ButtonDelete"));
            if (AbstractLogixNGTableAction.this.isExecuteSupported()) {
                editCombo.addItem(Bundle.getMessage("LogixNG_ButtonExecute"));
            }
            TableColumn col = table.getColumnModel().getColumn(4);
            col.setCellEditor(new DefaultCellEditor(editCombo));
        }

        @Override
        public void clickOn(NamedBean t) {
        }

        @Override
        public String getValue(String s) {
            return "";
        }

        @Override
        protected String getBeanType() {
            return rbx.getString("BeanNameLogixNG");
        }
    }
}

