/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ProxyManager;
import jmri.SystemConnectionMemo;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableTabAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.ListedTableFrame;
import jmri.jmrix.SystemConnectionMemoManager;
import jmri.swing.ManagerComboBox;
import jmri.util.swing.TriStateJCheckBox;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableAction<E extends NamedBean>
extends AbstractAction {
    protected BeanTableDataModel<E> m;
    protected BeanTableFrame<E> f;
    protected boolean includeAddButton = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractTableAction.class);

    public AbstractTableAction(String actionName) {
        super(actionName);
    }

    public AbstractTableAction(String actionName, Object option) {
        super(actionName);
    }

    protected abstract void createModel();

    protected abstract void setTitle();

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createModel();
        TableRowSorter<BeanTableDataModel<E>> sorter = new TableRowSorter<BeanTableDataModel<E>>(this.m);
        JTable dataTable = this.m.makeJTable(this.m.getMasterClassName(), this.m, sorter);
        dataTable.getTableHeader().setReorderingAllowed(true);
        this.f = new BeanTableFrame<E>(this.m, this.helpTarget(), dataTable){

            @Override
            void extras() {
                AbstractTableAction.this.addBottomButtons(this, this.dataTable);
            }
        };
        this.setMenuBar(this.f);
        this.configureTable(dataTable);
        this.setTitle();
        this.addToFrame(this.f);
        this.f.pack();
        this.f.setVisible(true);
    }

    protected void addBottomButtons(BeanTableFrame<E> ata, JTable dataTable) {
        TableItem<E> ti = new TableItem<E>(this);
        ti.setTableFrame(ata);
        ti.includeAddButton(this.includeAddButton);
        ti.dataTable = dataTable;
        TableModel dm = dataTable.getModel();
        if (dm instanceof BeanTableDataModel) {
            ti.dataModel = (BeanTableDataModel)dm;
        }
        ti.includePropertyCheckBox();
    }

    protected void columnsVisibleUpdated(boolean[] colsVisible) {
        log.debug("columns updated {}", (Object)colsVisible);
    }

    public void setFrame(@Nonnull BeanTableFrame<E> frame) {
        this.f = frame;
    }

    public BeanTableFrame<E> getFrame() {
        return this.f;
    }

    public BeanTableDataModel<E> getDataModel() {
        return this.m;
    }

    public final BeanTableDataModel<E> getTableDataModel() {
        this.createModel();
        return this.m;
    }

    public void addToFrame(@Nonnull BeanTableFrame<E> f) {
    }

    public void addToFrame(@Nonnull ListedTableFrame.TabbedTableItem<E> tti) {
    }

    public void addToPanel(AbstractTableTabAction<E> f) {
    }

    protected void setManager(@Nonnull Manager<E> man) {
    }

    @CheckForNull
    protected Manager<E> getManager() {
        return null;
    }

    public void setMenuBar(BeanTableFrame<E> f) {
    }

    public JComponent getPanel() {
        return null;
    }

    protected void configureTable(JTable table) {
    }

    public void dispose() {
        if (this.m != null) {
            this.m.dispose();
        }
    }

    @Nonnull
    protected String nextName(@Nonnull String name) {
        String[] parts = name.split("(?=\\d+$)", 2);
        String numString = "0";
        if (parts.length == 2) {
            numString = parts[1];
        }
        int numStringLength = numString.length();
        int num = Integer.parseInt(numString) + 1;
        return parts[0] + String.format("%0" + numStringLength + "d", num);
    }

    protected String helpTarget() {
        return "index";
    }

    public String getClassDescription() {
        return "Abstract Table Action";
    }

    public void setMessagePreferencesDetails() {
        HashMap<Integer, String> options = new HashMap<Integer, String>(3);
        options.put(0, Bundle.getMessage("DeleteAsk"));
        options.put(1, Bundle.getMessage("DeleteNever"));
        options.put(2, Bundle.getMessage("DeleteAlways"));
        InstanceManager.getDefault(UserPreferencesManager.class).setMessageItemDetails(this.getClassName(), "deleteInUse", Bundle.getMessage("DeleteItemInUse"), options, 0);
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "remindSaveReLoad", Bundle.getMessage("HideMoveUserReminder"));
    }

    protected abstract String getClassName();

    public boolean includeAddButton() {
        return this.includeAddButton;
    }

    public void print(JTable.PrintMode mode, MessageFormat headerFormat, MessageFormat footerFormat) {
        log.error("Printing not handled for {} tables.", (Object)this.m.getBeanType());
    }

    protected abstract void addPressed(ActionEvent var1);

    protected void configureManagerComboBox(ManagerComboBox<E> comboBox, Manager<E> manager, Class<? extends Manager<E>> managerClass) {
        log.trace("configureManagerComboBox called with manager {}", manager);
        Manager<E> defaultManager = InstanceManager.getDefault(managerClass);
        log.trace("default manager is {}", defaultManager);
        if (defaultManager instanceof ProxyManager) {
            comboBox.setManagers(defaultManager);
        } else {
            comboBox.setManagers(manager);
        }
        if (manager instanceof ProxyManager) {
            String systemSelectionCombo;
            UserPreferencesManager upm = InstanceManager.getDefault(UserPreferencesManager.class);
            String userPref = upm.getComboBoxLastSelection(systemSelectionCombo = this.getClass().getName() + ".SystemSelected");
            if (userPref != null) {
                SystemConnectionMemo memo = SystemConnectionMemoManager.getDefault().getSystemConnectionMemoForUserName(userPref);
                if (memo != null) {
                    log.trace("managerClass is {}, memo is {}", managerClass, (Object)memo);
                    comboBox.setSelectedItem(memo.get(managerClass));
                } else {
                    ProxyManager proxy = (ProxyManager)manager;
                    comboBox.setSelectedItem(proxy.getDefaultManager());
                }
            } else {
                ProxyManager proxy = (ProxyManager)manager;
                comboBox.setSelectedItem(proxy.getDefaultManager());
            }
        } else {
            comboBox.setSelectedItem(manager);
        }
    }

    protected void removePrefixBoxListener(ManagerComboBox<E> prefixBox) {
        Arrays.asList(prefixBox.getActionListeners()).forEach(l -> prefixBox.removeActionListener((ActionListener)l));
    }

    protected void displayHwError(String curAddress, Exception ex) {
        log.warn("Invalid Entry: {}", (Object)ex.getMessage());
        InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorConvertHW", curAddress), "" + ex, "", true, false);
    }

    protected static class TableItem<E extends NamedBean>
    implements TableColumnModelListener {
        BeanTableDataModel<E> dataModel;
        JTable dataTable;
        final AbstractTableAction<E> tableAction;
        BeanTableFrame<E> beanTableFrame;
        final TriStateJCheckBox propertyVisible = new TriStateJCheckBox(Bundle.getMessage("ShowSystemSpecificProperties"));

        void setTableFrame(BeanTableFrame<E> frame) {
            this.beanTableFrame = frame;
        }

        public TableItem(@Nonnull AbstractTableAction<E> tableAction) {
            this.tableAction = tableAction;
        }

        public AbstractTableAction<E> getAAClass() {
            return this.tableAction;
        }

        public JTable getDataTable() {
            return this.dataTable;
        }

        void includePropertyCheckBox() {
            if (this.dataModel == null) {
                log.error("datamodel for dataTable {} should not be null", (Object)this.dataTable);
                return;
            }
            if (this.dataModel.getPropertyColumnCount() > 0) {
                this.propertyVisible.setToolTipText(Bundle.getMessage("ShowSystemSpecificPropertiesToolTip"));
                this.addToBottomBox(this.propertyVisible);
                this.propertyVisible.addActionListener(e -> this.dataModel.setPropertyColumnsVisible(this.dataTable, this.propertyVisible.isSelected()));
            }
            this.fireColumnsUpdated();
            this.dataTable.getColumnModel().addColumnModelListener(this);
        }

        void includeAddButton(boolean includeAddButton) {
            if (includeAddButton) {
                JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
                this.addToBottomBox(addButton);
                addButton.addActionListener(this.tableAction::addPressed);
            }
        }

        protected void addToBottomBox(JComponent comp) {
            if (this.beanTableFrame != null) {
                this.beanTableFrame.addToBottomBox(comp, this.getClass().getName());
            }
        }

        private void fireColumnsUpdated() {
            TableColumnModel model = this.dataTable.getColumnModel();
            if (model instanceof XTableColumnModel) {
                Enumeration<TableColumn> e = ((XTableColumnModel)model).getColumns(false);
                int numCols = ((XTableColumnModel)model).getColumnCount(false);
                if (numCols != this.dataModel.getColumnCount()) {
                    log.debug("Difference with Xtable cols: {} Model cols: {}", (Object)numCols, (Object)this.dataModel.getColumnCount());
                    return;
                }
                boolean[] colsVisible = new boolean[numCols];
                while (e.hasMoreElements()) {
                    boolean visible;
                    TableColumn column = e.nextElement();
                    colsVisible[column.getModelIndex()] = visible = ((XTableColumnModel)model).isColumnVisible(column);
                }
                this.tableAction.columnsVisibleUpdated(colsVisible);
                this.setPropertyVisibleCheckbox(colsVisible);
            }
        }

        private void setPropertyVisibleCheckbox(boolean[] colsVisible) {
            int numberofCustomCols = this.dataModel.getPropertyColumnCount();
            if (numberofCustomCols > 0) {
                boolean[] customColVisibility = new boolean[numberofCustomCols];
                for (int i = 0; i < numberofCustomCols; ++i) {
                    customColVisibility[i] = colsVisible[colsVisible.length - i - 1];
                }
                this.propertyVisible.setState(customColVisibility);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            this.fireColumnsUpdated();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            this.fireColumnsUpdated();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        protected void dispose() {
            if (this.dataTable != null) {
                this.dataTable.getColumnModel().removeColumnModelListener(this);
            }
            if (this.dataModel != null) {
                this.dataModel.stopPersistingTable(this.dataTable);
                this.dataModel.dispose();
            }
            this.dataModel = null;
            this.dataTable = null;
        }
    }
}

