/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.managers.AbstractProxyManager;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.swing.WrapLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableTabAction<E extends NamedBean>
extends AbstractTableAction<E> {
    protected JTabbedPane dataTabs;
    protected boolean init = false;
    protected ArrayList<TabbedTableItem<E>> tabbedTableArray = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(AbstractTableTabAction.class);

    public AbstractTableTabAction(String s) {
        super(s);
    }

    @Override
    protected void createModel() {
        this.dataTabs = new JTabbedPane();
        Manager<E> mgr = this.getManager();
        if (mgr instanceof AbstractProxyManager) {
            AbstractProxyManager proxy = (AbstractProxyManager)mgr;
            this.tabbedTableArray.add(new TabbedTableItem<E>(Bundle.getMessage("All"), true, mgr, this.getNewTableAction("All")));
            proxy.getDisplayOrderManagerList().stream().map(manager -> {
                String manuName = manager.getMemo().getUserName();
                return new TabbedTableItem<E>(manuName, true, manager, this.getNewTableAction(manuName));
            }).forEachOrdered(itemModel -> this.tabbedTableArray.add((TabbedTableItem<TabbedTableItem>)itemModel));
        } else {
            Manager<E> man = this.getManager();
            String manuName = man != null ? man.getMemo().getUserName() : "Unknown Manager";
            this.tabbedTableArray.add(new TabbedTableItem<E>(manuName, true, this.getManager(), this.getNewTableAction(manuName)));
        }
        for (int x = 0; x < this.tabbedTableArray.size(); ++x) {
            AbstractTableAction table = this.tabbedTableArray.get(x).getAAClass();
            table.addToPanel(this);
            this.dataTabs.addTab(this.tabbedTableArray.get(x).getItemString(), this.tabbedTableArray.get(x).getPanel());
        }
        this.dataTabs.addChangeListener(evt -> this.setMenuBar(this.f));
        this.init = true;
    }

    @Override
    protected abstract Manager<E> getManager();

    protected abstract AbstractTableAction<E> getNewTableAction(String var1);

    @Override
    public JComponent getPanel() {
        if (!this.init) {
            this.createModel();
        }
        return this.dataTabs;
    }

    @Override
    protected void setTitle() {
    }

    @Override
    protected abstract String helpTarget();

    @Override
    protected void addPressed(ActionEvent e) {
        log.warn("This should not have happened");
    }

    @Override
    public void addToFrame(BeanTableFrame<E> f) {
        try {
            TabbedTableItem<E> table = this.tabbedTableArray.get(this.dataTabs.getSelectedIndex());
            if (table != null) {
                table.getAAClass().addToFrame(f);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("{} in add to Frame {} {}", new Object[]{ex.toString(), this.dataTabs.getSelectedIndex(), this.dataTabs.getSelectedComponent()});
        }
    }

    @Override
    public void setMenuBar(BeanTableFrame<E> f) {
        try {
            this.tabbedTableArray.get(this.dataTabs.getSelectedIndex()).getAAClass().setMenuBar(f);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("{} in add to Menu {} {}", new Object[]{ex.toString(), this.dataTabs.getSelectedIndex(), this.dataTabs.getSelectedComponent()});
        }
    }

    public void addToBottomBox(JComponent c, String str) {
        this.tabbedTableArray.forEach((Consumer<TabbedTableItem<TabbedTableItem>>)((Consumer<TabbedTableItem>)table -> {
            String item = table.getItemString();
            if (item != null && item.equals(str)) {
                table.addToBottomBox(c);
            }
        }));
    }

    @Override
    public BeanTableDataModel<E> getDataModel() {
        TableModel model = this.tabbedTableArray.get(this.dataTabs.getSelectedIndex()).getDataTable().getModel();
        if (model instanceof BeanTableDataModel) {
            return (BeanTableDataModel)model;
        }
        log.warn("Did not find suitable model type, result is null");
        return null;
    }

    @Override
    public void print(JTable.PrintMode mode, MessageFormat headerFormat, MessageFormat footerFormat) {
        try {
            this.tabbedTableArray.get(this.dataTabs.getSelectedIndex()).getDataTable().print(mode, headerFormat, footerFormat);
        }
        catch (PrinterException e1) {
            log.warn("error printing", (Throwable)e1);
        }
        catch (NullPointerException ex) {
            log.error("Trying to print returned a NPE error");
        }
    }

    @Override
    public void dispose() {
        for (int x = 0; x < this.tabbedTableArray.size(); ++x) {
            this.tabbedTableArray.get(x).dispose();
        }
        super.dispose();
    }

    protected static class TabbedTableItem<E extends NamedBean>
    extends AbstractTableAction.TableItem<E> {
        final String itemText;
        final JPanel bottomBox;
        private boolean addToFrameRan = false;
        final Manager<E> manager;
        private boolean standardModel = true;
        private final JPanel tabPanel;

        public TabbedTableItem(String choice, boolean stdModel, Manager<E> manager, @Nonnull AbstractTableAction<E> tableAction) {
            super(tableAction);
            this.itemText = choice;
            this.standardModel = stdModel;
            this.manager = manager;
            this.tabPanel = new JPanel();
            this.tabPanel.setLayout(new BorderLayout());
            this.bottomBox = new JPanel();
            this.bottomBox.setLayout(new WrapLayout(0, 20, 5));
            if (stdModel) {
                this.createDataModel();
            } else {
                this.addPanelModel();
            }
        }

        final void createDataModel() {
            this.tableAction.setManager(this.manager);
            this.dataModel = this.tableAction.getTableDataModel();
            TableRowSorter<BeanTableDataModel> sorter = new TableRowSorter<BeanTableDataModel>(this.dataModel);
            this.dataTable = this.dataModel.makeJTable(this.dataModel.getMasterClassName() + ":" + this.getItemString(), this.dataModel, sorter);
            JScrollPane dataScroll = new JScrollPane(this.dataTable);
            RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
            sorter.setComparator(1, new AlphanumComparator());
            RowSorterUtil.setSortOrder(sorter, 1, SortOrder.ASCENDING);
            this.dataModel.configureTable(this.dataTable);
            this.tableAction.configureTable(this.dataTable);
            Dimension dataTableSize = this.dataTable.getPreferredSize();
            dataTableSize.height = Math.max(dataTableSize.height, 400);
            dataScroll.getViewport().setPreferredSize(dataTableSize);
            dataScroll.setHorizontalScrollBarPolicy(32);
            dataScroll.setVerticalScrollBarPolicy(22);
            this.tabPanel.add((Component)dataScroll, "Center");
            this.tabPanel.add((Component)this.bottomBox, "South");
            this.includeAddButton(this.tableAction.includeAddButton());
            this.includePropertyCheckBox();
        }

        final void addPanelModel() {
            this.tabPanel.add((Component)this.tableAction.getPanel(), "Center");
            this.tabPanel.add((Component)this.bottomBox, "South");
        }

        public boolean getStandardTableModel() {
            return this.standardModel;
        }

        public String getItemString() {
            return this.itemText;
        }

        public JComponent getPanel() {
            return this.tabPanel;
        }

        public boolean getAdditionsToFrameDone() {
            return this.addToFrameRan;
        }

        public void setAddToFrameRan() {
            this.addToFrameRan = true;
        }

        @Override
        protected void addToBottomBox(JComponent comp) {
            this.bottomBox.add(comp);
        }
    }
}

