/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jmri.Block;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanPropertyDescriptor;
import jmri.SelectionPropertyDescriptor;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.BeanTableJTable;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.swing.JTablePersistenceManager;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.swing.ComboBoxToolTipRenderer;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanTableDataModel<T extends NamedBean>
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int SYSNAMECOL = 0;
    public static final int USERNAMECOL = 1;
    public static final int VALUECOL = 2;
    public static final int COMMENTCOL = 3;
    public static final int DELETECOL = 4;
    public static final int NUMCOLUMN = 5;
    protected List<String> sysNameList = null;
    private NamedBeanHandleManager nbMan;
    private Predicate<? super T> filter;
    private static final Logger log = LoggerFactory.getLogger(BeanTableDataModel.class);

    public BeanTableDataModel() {
        this.initModel();
    }

    private void initModel() {
        this.nbMan = InstanceManager.getDefault(NamedBeanHandleManager.class);
        this.getManager().addPropertyChangeListener(this);
        this.updateNameList();
    }

    protected int getPropertyColumnCount() {
        return this.getManager().getKnownBeanProperties().size();
    }

    @CheckForNull
    protected NamedBeanPropertyDescriptor<?> getPropertyColumnDescriptor(int column) {
        int propertyCount;
        List<NamedBeanPropertyDescriptor<?>> propertyColumns = this.getManager().getKnownBeanProperties();
        int totalCount = this.getColumnCount();
        int tgt = column - (totalCount - (propertyCount = propertyColumns.size()));
        if (tgt < 0 || tgt >= propertyCount) {
            return null;
        }
        return propertyColumns.get(tgt);
    }

    protected synchronized void updateNameList() {
        if (this.sysNameList != null) {
            for (String s : this.sysNameList) {
                T b = this.getBySystemName(s);
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
        Stream<Object> stream = this.getManager().getNamedBeanSet().stream();
        if (this.filter != null) {
            stream = stream.filter(this.filter);
        }
        this.sysNameList = stream.map(NamedBean::getSystemName).collect(Collectors.toList());
        for (String s : this.sysNameList) {
            T b = this.getBySystemName(s);
            if (b == null) continue;
            b.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length")) {
            this.updateNameList();
            log.debug("Table changed length to {}", (Object)this.sysNameList.size());
            this.fireTableDataChanged();
        } else if (this.matchPropertyName(e) && e.getSource() instanceof NamedBean) {
            String name = ((NamedBean)e.getSource()).getSystemName();
            int row = this.sysNameList.indexOf(name);
            log.debug("Update cell {},{} for {}", new Object[]{row, 2, name});
            try {
                this.fireTableRowsUpdated(row, row);
            }
            catch (Exception ex) {
                log.error("Exception updating table", (Throwable)ex);
            }
        }
    }

    protected boolean matchPropertyName(PropertyChangeEvent e) {
        String name = e.getPropertyName().toLowerCase();
        return name.contains("state") || name.contains("value") || name.contains("appearance") || name.contains("comment") || name.contains("username") || name.contains("commanded") || name.contains("known");
    }

    @Override
    public int getRowCount() {
        return this.sysNameList.size();
    }

    @Override
    public int getColumnCount() {
        return 5 + this.getPropertyColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnSystemName");
            }
            case 1: {
                return Bundle.getMessage("ColumnUserName");
            }
            case 2: {
                return Bundle.getMessage("ColumnState");
            }
            case 3: {
                return Bundle.getMessage("ColumnComment");
            }
            case 4: {
                return "";
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            return "btm unknown";
        }
        return desc.getColumnHeaderText();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return NamedBean.class;
            }
            case 1: 
            case 3: {
                return String.class;
            }
            case 2: 
            case 4: {
                return JButton.class;
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            return null;
        }
        if (desc instanceof SelectionPropertyDescriptor) {
            return JComboBox.class;
        }
        return desc.getValueClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 1: {
                T b = this.getBySystemName(this.sysNameList.get(row));
                String uname = b.getUserName();
                return uname == null || uname.isEmpty();
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            return false;
        }
        return desc.isEditable((NamedBean)this.getBySystemName(this.sysNameList.get(row)));
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.getBySystemName(this.sysNameList.get(row));
            }
            case 1: {
                T b = this.getBySystemName(this.sysNameList.get(row));
                return b != null ? b.getUserName() : null;
            }
            case 2: {
                return this.getValue(this.sysNameList.get(row));
            }
            case 3: {
                T b = this.getBySystemName(this.sysNameList.get(row));
                return b != null ? b.getComment() : null;
            }
            case 4: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null) {
            log.error("internal state inconsistent with table requst for getValueAt {} {}", (Object)row, (Object)col);
            return null;
        }
        if (!this.isCellEditable(row, col)) {
            return null;
        }
        T b = this.getBySystemName(this.sysNameList.get(row));
        Object value = b.getProperty(desc.propertyKey);
        if (desc instanceof SelectionPropertyDescriptor) {
            JComboBox<String> c = new JComboBox<String>(((SelectionPropertyDescriptor)desc).getOptions());
            c.setSelectedItem(value != null ? value.toString() : desc.defaultValue.toString());
            ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
            c.setRenderer(renderer);
            renderer.setTooltips(((SelectionPropertyDescriptor)desc).getOptionToolTips());
            return c;
        }
        if (value == null) {
            return desc.defaultValue;
        }
        return value;
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 1: 
            case 3: {
                return new JTextField((int)15).getPreferredSize().width;
            }
            case 2: 
            case 4: {
                return new JTextField((String)Bundle.getMessage((String)"ButtonDelete")).getPreferredSize().width;
            }
        }
        NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
        if (desc == null || desc.getColumnHeaderText() == null) {
            log.error("Unexpected column in getPreferredWidth: {} table {}", (Object)col, (Object)this);
            return new JTextField((int)8).getPreferredSize().width;
        }
        return new JTextField((String)desc.getColumnHeaderText()).getPreferredSize().width;
    }

    public abstract String getValue(String var1);

    protected abstract Manager<T> getManager();

    protected void setManager(@Nonnull Manager<T> man) {
    }

    protected abstract T getBySystemName(@Nonnull String var1);

    protected abstract T getByUserName(@Nonnull String var1);

    protected abstract void clickOn(T var1);

    public int getDisplayDeleteMsg() {
        return InstanceManager.getDefault(UserPreferencesManager.class).getMultipleChoiceOption(this.getMasterClassName(), "deleteInUse");
    }

    public void setDisplayDeleteMsg(int boo) {
        InstanceManager.getDefault(UserPreferencesManager.class).setMultipleChoiceOption(this.getMasterClassName(), "deleteInUse", boo);
    }

    protected abstract String getMasterClassName();

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 1: {
                String msg;
                int optionPane;
                if (value.equals("")) {
                    value = null;
                } else {
                    T nB = this.getByUserName((String)value);
                    if (nB != null) {
                        log.error("User name is not unique {}", value);
                        String msg2 = Bundle.getMessage("WarningUserName", "" + value);
                        JmriJOptionPane.showMessageDialog(null, msg2, Bundle.getMessage("WarningTitle"), 0);
                        return;
                    }
                }
                T nBean = this.getBySystemName(this.sysNameList.get(row));
                nBean.setUserName((String)value);
                if (!this.nbMan.inUse(this.sysNameList.get(row), nBean) || (optionPane = JmriJOptionPane.showConfirmDialog(null, msg = Bundle.getMessage("UpdateToUserName", this.getBeanType(), value, this.sysNameList.get(row)), Bundle.getMessage("UpdateToUserNameTitle"), 0)) != 0) break;
                try {
                    this.nbMan.updateBeanFromSystemToUser((NamedBean)nBean);
                }
                catch (JmriException ex) {
                    log.error("Impossible exception setting user name", (Throwable)ex);
                }
                break;
            }
            case 3: {
                this.getBySystemName(this.sysNameList.get(row)).setComment((String)value);
                break;
            }
            case 2: {
                T t = this.getBySystemName(this.sysNameList.get(row));
                this.clickOn(t);
                break;
            }
            case 4: {
                this.deleteBean(row, col);
                return;
            }
            default: {
                NamedBeanPropertyDescriptor<?> desc = this.getPropertyColumnDescriptor(col);
                if (desc == null) {
                    log.error("btdm setvalueat {} {}", (Object)row, (Object)col);
                    break;
                }
                if (value instanceof JComboBox) {
                    value = ((JComboBox)value).getSelectedItem();
                }
                T b = this.getBySystemName(this.sysNameList.get(row));
                b.setProperty(desc.propertyKey, value);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    protected void deleteBean(int row, int col) {
        ThreadingUtil.runOnGUI(() -> {
            try {
                DeleteBeanWorker worker = new DeleteBeanWorker(this, this.getBySystemName(this.sysNameList.get(row)));
                log.debug("Delete Bean {}", (Object)worker.toString());
            }
            catch (Exception e) {
                log.error("Exception while deleting bean", (Throwable)e);
            }
        });
    }

    protected void doDelete(T bean) {
        try {
            this.getManager().deleteBean(bean, "DoDelete");
        }
        catch (PropertyVetoException e) {
            log.error("doDelete should not fail after canDelete. {}", (Object)e.getMessage());
        }
    }

    public void configureTable(JTable table) {
        this.setPropertyColumnsVisible(table, false);
        table.setDefaultRenderer(JComboBox.class, new BtValueRenderer());
        table.setDefaultEditor(JComboBox.class, new BtComboboxEditor());
        table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
        table.setDefaultRenderer(Date.class, new DateRenderer());
        table.getTableHeader().setReorderingAllowed(true);
        table.setAutoResizeMode(0);
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(false); ++i) {
            int width = this.getPreferredWidth(i);
            columnModel.getColumnByModelIndex(i).setPreferredWidth(width);
        }
        table.sizeColumnsToFit(-1);
        this.configValueColumn(table);
        this.configDeleteColumn(table);
        PopupListener popupListener = new PopupListener();
        table.addMouseListener(JmriMouseListener.adapt(popupListener));
        this.persistTable(table);
    }

    protected void configValueColumn(JTable table) {
        this.setColumnToHoldButton(table, 2, this.configureButton());
    }

    public JButton configureButton() {
        JButton b = new JButton(Bundle.getMessage("BeanStateInconsistent"));
        b.putClientProperty("JComponent.sizeVariant", "small");
        b.putClientProperty("JButton.buttonType", "square");
        return b;
    }

    protected void configDeleteColumn(JTable table) {
        this.setColumnToHoldButton(table, 4, new JButton(Bundle.getMessage("ButtonDelete")));
    }

    protected void setColumnToHoldButton(JTable table, int column, JButton sample) {
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        table.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        table.setDefaultEditor(JButton.class, buttonEditor);
        table.setRowHeight(sample.getPreferredSize().height);
        table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 4);
    }

    public synchronized void dispose() {
        this.getManager().removePropertyChangeListener(this);
        if (this.sysNameList != null) {
            for (String s : this.sysNameList) {
                T b = this.getBySystemName(s);
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
    }

    public void printTable(HardcopyWriter w) {
        int i;
        int columnSize = (w.getCharactersPerLine() - this.getColumnCount() - 1) / this.getColumnCount();
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
        String[] columnStrings = new String[this.getColumnCount()];
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            columnStrings[i2] = this.getColumnName(i2);
        }
        w.setFontStyle(1);
        this.printColumns(w, columnStrings, columnSize);
        w.setFontStyle(0);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
        StringBuilder spaces = new StringBuilder();
        for (i = 0; i < columnSize; ++i) {
            spaces.append(" ");
        }
        for (i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Object value = this.getValueAt(i, j);
                columnStrings[j] = value == null ? spaces.toString() : (value instanceof JComboBox ? Objects.requireNonNull(((JComboBox)value).getSelectedItem()).toString() : value.toString());
            }
            this.printColumns(w, columnStrings, columnSize);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
        }
        w.close();
    }

    protected void printColumns(HardcopyWriter w, String[] columnStrings, int columnSize) {
        StringBuilder spaces = new StringBuilder();
        for (int i = 0; i < columnSize; ++i) {
            spaces.append(" ");
        }
        boolean complete = false;
        while (!complete) {
            int i;
            StringBuilder lineString = new StringBuilder();
            complete = true;
            for (i = 0; i < columnStrings.length; ++i) {
                Object columnString = "";
                if (columnStrings[i].length() > columnSize) {
                    boolean noWord = true;
                    for (int k = columnSize; k >= 1; --k) {
                        if (columnStrings[i].charAt(k - 1) != ' ' && columnStrings[i].charAt(k - 1) != '-' && columnStrings[i].charAt(k - 1) != '_') continue;
                        columnString = columnStrings[i].substring(0, k) + spaces.substring(columnStrings[i].substring(0, k).length());
                        columnStrings[i] = columnStrings[i].substring(k);
                        noWord = false;
                        complete = false;
                        break;
                    }
                    if (noWord) {
                        columnString = columnStrings[i].substring(0, columnSize);
                        columnStrings[i] = columnStrings[i].substring(columnSize);
                        complete = false;
                    }
                } else {
                    columnString = columnStrings[i] + spaces.substring(columnStrings[i].length());
                    columnStrings[i] = "";
                }
                lineString.append((String)columnString).append(" ");
            }
            try {
                w.write(lineString.toString());
                i = 0;
                while (i < w.getCharactersPerLine()) {
                    w.write(w.getCurrentLineNumber(), i, w.getCurrentLineNumber() + 1, i);
                    i = i + columnSize + 1;
                }
                w.write("\n");
            }
            catch (IOException e) {
                log.warn("error during printing: {}", (Object)e.getMessage());
            }
        }
    }

    public void exportToCSV(File file) {
        if (file == null) {
            JFileChooser chooser = new JFileChooser(FileUtil.getUserFilesPath());
            int retVal = chooser.showSaveDialog(null);
            if (retVal != 0) {
                log.info("Export to CSV abandoned");
                return;
            }
            file = chooser.getSelectedFile();
        }
        try {
            int i;
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            CSVPrinter csvFile = new CSVPrinter((Appendable)bufferedWriter, CSVFormat.DEFAULT);
            for (i = 0; i < this.getColumnCount(); ++i) {
                csvFile.print((Object)this.getColumnName(i));
            }
            csvFile.println();
            for (i = 0; i < this.getRowCount(); ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    Object value = this.getValueAt(i, j);
                    if (value instanceof JComboBox) {
                        value = ((JComboBox)value).getSelectedItem().toString();
                    }
                    csvFile.print(value);
                }
                csvFile.println();
            }
            csvFile.flush();
            csvFile.close();
        }
        catch (IOException e) {
            log.error("Failed to write file", (Throwable)e);
        }
    }

    public JTable makeJTable(@Nonnull String name, @Nonnull TableModel model, @CheckForNull RowSorter<? extends TableModel> sorter) {
        Objects.requireNonNull(name, "the table name must be nonnull");
        Objects.requireNonNull(model, "the table model must be nonnull");
        if (!(model instanceof BeanTableDataModel)) {
            throw new IllegalArgumentException(model.getClass() + " is Not a BeanTableDataModel");
        }
        BeanTableDataModel vv = (BeanTableDataModel)model;
        BeanTableJTable table = new BeanTableJTable(vv);
        return this.configureJTable(name, table, sorter);
    }

    protected JTable configureJTable(@Nonnull String name, @Nonnull JTable table, @CheckForNull RowSorter<? extends TableModel> sorter) {
        Objects.requireNonNull(table, "the table must be nonnull");
        Objects.requireNonNull(name, "the table name must be nonnull");
        table.setRowSorter(sorter);
        table.setName(name);
        table.getTableHeader().setReorderingAllowed(true);
        table.setColumnModel(new XTableColumnModel());
        table.createDefaultColumnsFromModel();
        this.addMouseListenerToHeader(table);
        table.getTableHeader().setDefaultRenderer(new BeanTableTooltipHeaderRenderer(table.getTableHeader().getDefaultRenderer()));
        return table;
    }

    protected String getBeanType() {
        return this.getManager().getBeanTypeHandled(false);
    }

    public void setPropertyColumnsVisible(JTable table, boolean visible) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        for (int i = this.getColumnCount() - 1; i >= this.getColumnCount() - this.getPropertyColumnCount(); --i) {
            TableColumn column = columnModel.getColumnByModelIndex(i);
            columnModel.setColumnVisible(column, visible);
        }
    }

    protected boolean isClearUserNameAllowed() {
        return true;
    }

    protected void showPopup(JmriMouseEvent e) {
        JTable source = (JTable)e.getSource();
        int row = source.rowAtPoint(e.getPoint());
        int column = source.columnAtPoint(e.getPoint());
        if (!source.isRowSelected(row)) {
            source.changeSelection(row, column, false, false);
        }
        int rowindex = source.convertRowIndexToModel(row);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Bundle.getMessage("CopyName"));
        menuItem.addActionListener(e1 -> this.copyUserName(rowindex, 0));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("Rename"));
        menuItem.addActionListener(e1 -> this.renameBean(rowindex, 0));
        popupMenu.add(menuItem);
        if (this.isClearUserNameAllowed()) {
            menuItem = new JMenuItem(Bundle.getMessage("ClearName"));
            menuItem.addActionListener(e1 -> this.removeName(rowindex, 0));
            popupMenu.add(menuItem);
        }
        menuItem = new JMenuItem(Bundle.getMessage("MoveName"));
        menuItem.addActionListener(e1 -> this.moveBean(rowindex, 0));
        if (this.getRowCount() == 1) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("EditComment"));
        menuItem.addActionListener(e1 -> this.editComment(rowindex, 0));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("CopySystemName"));
        menuItem.addActionListener(e1 -> this.copySystemName(rowindex, 0));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("ButtonDelete"));
        menuItem.addActionListener(e1 -> this.deleteBean(rowindex, 0));
        popupMenu.add(menuItem);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void copyUserName(int row, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(row));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection name = new StringSelection(nBean.getUserName());
        clipboard.setContents(name, null);
    }

    public void copySystemName(int row, int column) {
        String systemName = this.sysNameList.get(row);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection name = new StringSelection(systemName);
        clipboard.setContents(name, null);
    }

    public void renameBean(int row, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(row));
        String oldName = nBean.getUserName() == null ? "" : nBean.getUserName();
        String newName = JmriJOptionPane.showInputDialog(null, Bundle.getMessage("RenameFrom", this.getBeanType(), "\"" + oldName + "\""), oldName);
        if (newName == null || newName.equals(nBean.getUserName())) {
            return;
        }
        T nB = this.getByUserName(newName);
        if (nB != null) {
            log.error("User name is not unique {}", (Object)newName);
            String msg = Bundle.getMessage("WarningUserName", newName);
            JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        if (!this.allowBlockNameChange("Rename", nBean, newName)) {
            return;
        }
        try {
            nBean.setUserName(newName);
        }
        catch (NamedBean.BadSystemNameException | NamedBean.BadUserNameException ex) {
            JmriJOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.fireTableRowsUpdated(row, row);
        if (!newName.isEmpty()) {
            if (oldName == null || oldName.isEmpty()) {
                if (!this.nbMan.inUse(this.sysNameList.get(row), nBean)) {
                    return;
                }
                String msg = Bundle.getMessage("UpdateToUserName", this.getBeanType(), newName, this.sysNameList.get(row));
                int optionPane = JmriJOptionPane.showConfirmDialog(null, msg, Bundle.getMessage("UpdateToUserNameTitle"), 0);
                if (optionPane == 0) {
                    try {
                        this.nbMan.updateBeanFromSystemToUser((NamedBean)nBean);
                    }
                    catch (JmriException ex) {
                        log.error("Impossible exception renaming Bean", (Throwable)ex);
                    }
                }
            } else {
                this.nbMan.renameBean(oldName, newName, nBean);
            }
        } else {
            this.nbMan.updateBeanFromUserToSystem((NamedBean)nBean);
        }
    }

    public void removeName(int modelRow, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(modelRow));
        if (!this.allowBlockNameChange("Remove", nBean, "")) {
            return;
        }
        String msg = Bundle.getMessage("UpdateToSystemName", this.getBeanType());
        int optionPane = JmriJOptionPane.showConfirmDialog(null, msg, Bundle.getMessage("UpdateToSystemNameTitle"), 0);
        if (optionPane == 0) {
            this.nbMan.updateBeanFromUserToSystem((NamedBean)nBean);
        }
        nBean.setUserName(null);
        this.fireTableRowsUpdated(modelRow, modelRow);
    }

    boolean allowBlockNameChange(String changeType, T bean, String newName) {
        if (!(bean instanceof Block)) {
            return true;
        }
        String oldName = bean.getUserName();
        if (oldName == null) {
            return true;
        }
        LayoutBlock layoutBlock = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(oldName);
        if (layoutBlock == null) {
            return true;
        }
        if (changeType.equals("Remove")) {
            log.warn("Cannot remove user name for block {}", (Object)oldName);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("BlockRemoveUserNameWarning", oldName), Bundle.getMessage("WarningTitle"), 2);
            return false;
        }
        int optionPane = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("BlockChangeUserName", oldName, newName), Bundle.getMessage("QuestionTitle"), 0);
        return optionPane == 0;
    }

    public void moveBean(int row, int column) {
        T t = this.getBySystemName(this.sysNameList.get(row));
        String currentName = t.getUserName();
        T oldNameBean = this.getBySystemName(this.sysNameList.get(row));
        if (currentName == null || currentName.isEmpty()) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MoveDialogErrorMessage"));
            return;
        }
        JComboBox box = new JComboBox();
        this.getManager().getNamedBeanSet().forEach(b -> {
            String userName = b.getUserName();
            if (userName == null || userName.isEmpty()) {
                box.addItem(b.getSystemName());
            }
        });
        int retval = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("MoveDialog", this.getBeanType(), currentName, oldNameBean.getSystemName()), Bundle.getMessage("MoveDialogTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonOK"), box}, null);
        log.debug("Dialog value {} selected {}:{}", new Object[]{retval, box.getSelectedIndex(), box.getSelectedItem()});
        if (retval != 1) {
            return;
        }
        String entry = (String)box.getSelectedItem();
        assert (entry != null);
        T newNameBean = this.getBySystemName(entry);
        if (oldNameBean != newNameBean) {
            String msg;
            int optionPane;
            oldNameBean.setUserName(null);
            newNameBean.setUserName(currentName);
            InstanceManager.getDefault(NamedBeanHandleManager.class).moveBean(oldNameBean, newNameBean, currentName);
            if (this.nbMan.inUse(newNameBean.getSystemName(), newNameBean) && (optionPane = JmriJOptionPane.showConfirmDialog(null, msg = Bundle.getMessage("UpdateToUserName", this.getBeanType(), currentName, this.sysNameList.get(row)), Bundle.getMessage("UpdateToUserNameTitle"), 0)) == 0) {
                try {
                    this.nbMan.updateBeanFromSystemToUser((NamedBean)newNameBean);
                }
                catch (JmriException ex) {
                    log.error("Impossible exception moving Bean", (Throwable)ex);
                }
            }
            this.fireTableRowsUpdated(row, row);
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("UpdateComplete", this.getBeanType()), this.getMasterClassName(), "remindSaveReLoad");
        }
    }

    public void editComment(int row, int column) {
        T nBean = this.getBySystemName(this.sysNameList.get(row));
        JTextArea commentField = new JTextArea(5, 50);
        JScrollPane commentFieldScroller = new JScrollPane(commentField);
        commentField.setText(nBean.getComment());
        Object[] editCommentOption = new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonUpdate")};
        int retval = JmriJOptionPane.showOptionDialog(null, commentFieldScroller, Bundle.getMessage("EditComment"), 0, 1, null, editCommentOption, editCommentOption[1]);
        if (retval != 1) {
            return;
        }
        nBean.setComment(commentField.getText());
    }

    public String getCellToolTip(JTable table, int modelRow, int modelCol) {
        String tip = null;
        T nBean = this.getBySystemName(this.sysNameList.get(modelRow));
        if (nBean != null) {
            tip = this.formatToolTip(nBean.getRecommendedToolTip());
        }
        return tip;
    }

    @OverridingMethodsMustInvokeSuper
    protected String getHeaderTooltip(int columnModelIndex) {
        return null;
    }

    protected String formatToolTip(String tooltip) {
        String tip = null;
        if (tooltip != null && !tooltip.isEmpty()) {
            tip = "<html>" + tooltip.replaceAll(System.getProperty("line.separator"), "<br>") + "</html>";
        }
        return tip;
    }

    protected void showTableHeaderPopup(JmriMouseEvent e, JTable table) {
        JPopupMenu popupMenu = new JPopupMenu();
        XTableColumnModel tcm = (XTableColumnModel)table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(false); ++i) {
            TableColumn tc = tcm.getColumnByModelIndex(i);
            String columnName = table.getModel().getColumnName(i);
            if (columnName == null || columnName.isEmpty()) continue;
            StayOpenCheckBoxItem menuItem = new StayOpenCheckBoxItem(table.getModel().getColumnName(i), tcm.isColumnVisible(tc));
            menuItem.addActionListener(new HeaderActionListener(tc, tcm));
            TableModel mod = table.getModel();
            if (mod instanceof BeanTableDataModel) {
                menuItem.setToolTipText(((BeanTableDataModel)mod).getHeaderTooltip(i));
            }
            popupMenu.add(menuItem);
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void addMouseListenerToHeader(JTable table) {
        TableHeaderListener mouseHeaderListener = new TableHeaderListener(table);
        table.getTableHeader().addMouseListener(JmriMouseListener.adapt(mouseHeaderListener));
    }

    public void persistTable(@Nonnull JTable table) throws NullPointerException {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(manager -> {
            this.setColumnIdentities(table);
            manager.resetState(table);
            manager.persist(table);
        });
    }

    public void stopPersistingTable(@Nonnull JTable table) throws NullPointerException {
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(manager -> manager.stopPersisting(table));
    }

    protected void setColumnIdentities(JTable table) {
        Objects.requireNonNull(table.getModel(), "Table must have data model");
        Objects.requireNonNull(table.getColumnModel(), "Table must have column model");
        Enumeration<TableColumn> columns = table.getColumnModel() instanceof XTableColumnModel ? ((XTableColumnModel)table.getColumnModel()).getColumns(false) : table.getColumnModel().getColumns();
        int i = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (column.getIdentifier() == null || column.getIdentifier().toString().isEmpty()) {
                column.setIdentifier(String.format("Column%d", i));
            }
            ++i;
        }
    }

    public synchronized void setFilter(Predicate<? super T> filter) {
        this.filter = filter;
        this.updateNameList();
    }

    public synchronized Predicate<? super T> getFilter() {
        return this.filter;
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        private final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);

        DateRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                c.setText(this.dateFormat.format(value));
            }
            return c;
        }
    }

    private class BtValueRenderer
    implements TableCellRenderer {
        BtValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Component) {
                return (Component)value;
            }
            if (value instanceof String) {
                return new JLabel((String)value);
            }
            JPanel f = new JPanel();
            f.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return f;
        }
    }

    private class BtComboboxEditor
    extends ValueEditor {
        BtComboboxEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof JComboBox) {
                ((JComboBox)value).addActionListener(e1 -> table.getCellEditor().stopCellEditing());
            }
            if (value instanceof JComponent) {
                int modelcol = table.convertColumnIndexToModel(column);
                int modelrow = table.convertRowIndexToModel(row);
                boolean editable = table.getModel().isCellEditable(modelrow, modelcol);
                ((JComponent)value).setEnabled(editable);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class TableHeaderListener
    extends JmriMouseAdapter {
        private final JTable table;

        TableHeaderListener(JTable tbl) {
            this.table = tbl;
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showTableHeaderPopup(e, this.table);
            }
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showTableHeaderPopup(e, this.table);
            }
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showTableHeaderPopup(e, this.table);
            }
        }
    }

    class PopupListener
    extends JmriMouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                BeanTableDataModel.this.showPopup(e);
            }
        }
    }

    static class DeleteBeanWorker {
        final /* synthetic */ BeanTableDataModel this$0;

        public DeleteBeanWorker(T bean) {
            this.this$0 = this$0;
            StringBuilder message = new StringBuilder();
            try {
                this$0.getManager().deleteBean(bean, "CanDelete");
            }
            catch (PropertyVetoException e) {
                if (e.getPropertyChangeEvent().getPropertyName().equals("DoNotDelete")) {
                    log.warn("Should not delete {}, {}", (Object)bean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), (Object)e.getMessage());
                    message.append(Bundle.getMessage("VetoDeleteBean", bean.getBeanType(), bean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), e.getMessage()));
                    JmriJOptionPane.showMessageDialog(null, message.toString(), Bundle.getMessage("WarningTitle"), 0);
                    return;
                }
                message.append(e.getMessage());
            }
            int count = bean.getListenerRefs().size();
            log.debug("Delete with {}", (Object)count);
            if (this$0.getDisplayDeleteMsg() == 2 && message.toString().isEmpty()) {
                this$0.doDelete(bean);
            } else {
                JPanel container = new JPanel();
                container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                container.setLayout(new BoxLayout(container, 1));
                if (count > 0) {
                    JLabel question = new JLabel(Bundle.getMessage("DeletePrompt", bean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    ArrayList<String> listenerRefs = bean.getListenerRefs();
                    if (!listenerRefs.isEmpty()) {
                        ArrayList<String> listeners = new ArrayList<String>();
                        for (String listenerRef : listenerRefs) {
                            if (listeners.contains(listenerRef)) continue;
                            listeners.add(listenerRef);
                        }
                        message.append("<br>");
                        message.append(Bundle.getMessage("ReminderInUse", count));
                        message.append("<ul>");
                        for (String listener : listeners) {
                            message.append("<li>");
                            message.append(listener);
                            message.append("</li>");
                        }
                        message.append("</ul>");
                        JEditorPane pane = new JEditorPane();
                        pane.setContentType("text/html");
                        pane.setText("<html>" + message.toString() + "</html>");
                        pane.setEditable(false);
                        JScrollPane jScrollPane = new JScrollPane(pane);
                        container.add(jScrollPane);
                    }
                } else {
                    String msg = MessageFormat.format(Bundle.getMessage("DeletePrompt"), bean.getSystemName());
                    JLabel question = new JLabel(msg);
                    question.setAlignmentX(0.5f);
                    container.add(question);
                }
                JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                remember.setAlignmentX(0.5f);
                container.add(remember);
                container.setAlignmentX(0.5f);
                container.setAlignmentY(0.5f);
                Object[] options = new String[]{JmriJOptionPane.YES_STRING, JmriJOptionPane.NO_STRING};
                int result = JmriJOptionPane.showOptionDialog(null, container, Bundle.getMessage("WarningTitle"), -1, 2, null, options, JmriJOptionPane.NO_STRING);
                if (result == 0) {
                    if (remember.isSelected()) {
                        this$0.setDisplayDeleteMsg(2);
                    }
                    this$0.doDelete(bean);
                }
            }
        }
    }

    static class HeaderActionListener
    implements ActionListener {
        private final TableColumn tc;
        private final XTableColumnModel tcm;

        HeaderActionListener(TableColumn tc, XTableColumnModel tcm) {
            this.tc = tc;
            this.tcm = tcm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem check = (JCheckBoxMenuItem)e.getSource();
            if (!check.isSelected() && this.tcm.getColumnCount(true) == 1) {
                return;
            }
            this.tcm.setColumnVisible(this.tc, check.isSelected());
        }
    }

    protected class BeanTableTooltipHeaderRenderer
    extends DefaultTableCellRenderer {
        private final TableCellRenderer _existingRenderer;

        protected BeanTableTooltipHeaderRenderer(TableCellRenderer existingRenderer) {
            this._existingRenderer = existingRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComponent = this._existingRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel mod = table.getModel();
            if (rendererComponent instanceof JLabel && mod instanceof BeanTableDataModel) {
                int modelIndex = table.getColumnModel().getColumn(column).getModelIndex();
                String tooltip = ((BeanTableDataModel)mod).getHeaderTooltip(modelIndex);
                ((JLabel)rendererComponent).setToolTipText(tooltip);
            }
            return rendererComponent;
        }
    }
}

