/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jmri.NamedBean;
import jmri.configurexml.StoreMenu;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.JmriJFrame;
import jmri.util.swing.WrapLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanTableFrame<E extends NamedBean>
extends JmriJFrame {
    BeanTableDataModel<E> dataModel;
    JTable dataTable;
    final JPanel bottomBox = new JPanel();
    private static final Logger log = LoggerFactory.getLogger(BeanTableFrame.class);

    public BeanTableFrame() {
        this.bottomBox.setLayout(new WrapLayout(0, 20, 5));
    }

    public BeanTableFrame(String s) {
        super(s);
        this.bottomBox.setLayout(new WrapLayout(0, 20, 5));
    }

    public BeanTableFrame(BeanTableDataModel<E> model, String helpTarget, JTable dataTab) {
        this();
        this.dataModel = model;
        this.dataTable = dataTab;
        JScrollPane dataScroll = new JScrollPane(this.dataTable);
        TableRowSorter<BeanTableDataModel<E>> sorter = new TableRowSorter<BeanTableDataModel<E>>(this.dataModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        sorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(sorter, 1, SortOrder.ASCENDING);
        this.dataTable.setRowSorter(sorter);
        this.dataModel.configureTable(this.dataTable);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        fileMenu.add(new StoreMenu());
        JMenuItem printItem = new JMenuItem(Bundle.getMessage("PrintTable"));
        fileMenu.add(printItem);
        printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MessageFormat footerFormat = new MessageFormat(BeanTableFrame.this.getTitle() + " page {0,number}");
                    BeanTableFrame.this.dataTable.print(JTable.PrintMode.FIT_WIDTH, null, footerFormat);
                }
                catch (PrinterException e1) {
                    log.warn("error printing: {}", (Object)e1, (Object)e1);
                }
            }
        });
        JMenuItem exportItem = new JMenuItem(Bundle.getMessage("ExportTable"));
        fileMenu.add(exportItem);
        exportItem.addActionListener(e -> this.dataModel.exportToCSV(null));
        this.setJMenuBar(menuBar);
        this.addHelpMenu(helpTarget, true);
        this.getContentPane().add(dataScroll);
        this.getContentPane().add(this.bottomBox);
        this.extras();
        Dimension dataTableSize = this.dataTable.getPreferredSize();
        dataTableSize.height = Math.max(dataTableSize.height, 400);
        dataScroll.getViewport().setPreferredSize(dataTableSize);
        dataScroll.setHorizontalScrollBarPolicy(32);
        dataScroll.setVerticalScrollBarPolicy(22);
        this.dataModel.persistTable(this.dataTable);
    }

    void extras() {
    }

    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="param c is required in the listedtableframe")
    protected void addToBottomBox(Component comp, String c) {
        this.bottomBox.add(comp);
    }

    public JTable getTable() {
        return this.dataTable;
    }

    @Override
    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.stopPersistingTable(this.dataTable);
            this.dataModel.dispose();
        }
        this.dataModel = null;
        this.dataTable = null;
        super.dispose();
    }
}

