/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AddNewBeanPanel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.block.BlockTableDataModel;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTableAction
extends AbstractTableAction<Block> {
    private final JRadioButton inchBox = new JRadioButton(Bundle.getMessage("LengthInches"));
    private final JRadioButton centimeterBox = new JRadioButton(Bundle.getMessage("LengthCentimeters"));
    public static final String BLOCK_METRIC_PREF = BlockTableAction.class.getName() + ":LengthUnitMetric";
    private JmriJFrame addFrame = null;
    private final JTextField sysName = new JTextField(20);
    private final JTextField userName = new JTextField(20);
    private final SpinnerNumberModel numberToAddSpinnerNumberModel = new SpinnerNumberModel(1, 1, 100, 1);
    private final JSpinner numberToAddSpinner = new JSpinner(this.numberToAddSpinnerNumberModel);
    private final JCheckBox addRangeCheckBox = new JCheckBox(Bundle.getMessage("AddRangeBox"));
    private final JCheckBox _autoSystemNameCheckBox = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    private final JLabel statusBar = new JLabel(Bundle.getMessage("AddBeanStatusEnter"), 10);
    private JButton newButton = null;
    private RestoreRule _restoreRule;
    private final String systemNameAuto = this.getClass().getName() + ".AutoSystemName";
    private static final Logger log = LoggerFactory.getLogger(BlockTableAction.class);

    public BlockTableAction(String actionName) {
        super(actionName);
        if (InstanceManager.getNullableDefault(BlockManager.class) == null) {
            this.setEnabled(false);
        }
    }

    public BlockTableAction() {
        this(Bundle.getMessage("TitleBlockTable"));
    }

    @Override
    protected void createModel() {
        this.m = new BlockTableDataModel(this.getManager());
    }

    @Override
    @Nonnull
    protected Manager<Block> getManager() {
        return InstanceManager.getDefault(BlockManager.class);
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleBlockTable"));
    }

    private void initRadioButtons() {
        this.inchBox.setToolTipText(Bundle.getMessage("InchBoxToolTip"));
        this.centimeterBox.setToolTipText(Bundle.getMessage("CentimeterBoxToolTip"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.inchBox);
        group.add(this.centimeterBox);
        this.inchBox.setSelected(true);
        this.centimeterBox.setSelected(InstanceManager.getDefault(UserPreferencesManager.class).getSimplePreferenceState(BLOCK_METRIC_PREF));
        this.inchBox.addActionListener(e -> this.metricSelectionChanged());
        this.centimeterBox.addActionListener(e -> this.metricSelectionChanged());
        this.inchBox.setFocusable(false);
        this.centimeterBox.setFocusable(false);
    }

    @Override
    public void addToFrame(BeanTableFrame<Block> f) {
        this.initRadioButtons();
        f.addToBottomBox(this.inchBox, this.getClass().getName());
        f.addToBottomBox(this.centimeterBox, this.getClass().getName());
    }

    @Override
    public void setMenuBar(BeanTableFrame<Block> f) {
        BeanTableFrame<Block> finalF = f;
        JMenuBar menuBar = f.getJMenuBar();
        int pos = menuBar.getMenuCount() - 1;
        int offset = 1;
        log.debug("setMenuBar number of menu items = {}", (Object)pos);
        for (int i = 0; i <= pos; ++i) {
            Component comp = menuBar.getComponent(i);
            if (!(comp instanceof JMenu) || !((JMenu)comp).getText().equals(Bundle.getMessage("MenuHelp"))) continue;
            offset = -1;
        }
        this._restoreRule = BlockTableAction.getRestoreRule();
        JMenu pathMenu = new JMenu(Bundle.getMessage("MenuPaths"));
        JMenuItem item = new JMenuItem(Bundle.getMessage("MenuItemDeletePaths"));
        pathMenu.add(item);
        item.addActionListener(e -> this.deletePaths(finalF));
        menuBar.add((Component)pathMenu, pos + offset);
        JMenu speedMenu = new JMenu(Bundle.getMessage("SpeedsMenu"));
        item = new JMenuItem(Bundle.getMessage("SpeedsMenuItemDefaults"));
        speedMenu.add(item);
        item.addActionListener(e -> ((BlockTableDataModel)this.m).setDefaultSpeeds(finalF));
        menuBar.add((Component)speedMenu, pos + offset + 1);
        JMenu valuesMenu = new JMenu(Bundle.getMessage("ValuesMenu"));
        ButtonGroup valuesButtonGroup = new ButtonGroup();
        JRadioButtonMenuItem jrbmi = new JRadioButtonMenuItem(Bundle.getMessage("ValuesMenuRestoreAlways"));
        jrbmi.addItemListener(e -> this.setRestoreRule(RestoreRule.RESTOREALWAYS));
        valuesButtonGroup.add(jrbmi);
        valuesMenu.add(jrbmi);
        jrbmi.setSelected(this._restoreRule == RestoreRule.RESTOREALWAYS);
        jrbmi = new JRadioButtonMenuItem(Bundle.getMessage("ValuesMenuRestoreOccupiedOnly"));
        jrbmi.addItemListener(e -> this.setRestoreRule(RestoreRule.RESTOREOCCUPIEDONLY));
        valuesButtonGroup.add(jrbmi);
        valuesMenu.add(jrbmi);
        jrbmi.setSelected(this._restoreRule == RestoreRule.RESTOREOCCUPIEDONLY);
        jrbmi = new JRadioButtonMenuItem(Bundle.getMessage("ValuesMenuRestoreOnlyIfAllOccupied"));
        jrbmi.addItemListener(e -> this.setRestoreRule(RestoreRule.RESTOREONLYIFALLOCCUPIED));
        valuesButtonGroup.add(jrbmi);
        valuesMenu.add(jrbmi);
        jrbmi.setSelected(this._restoreRule == RestoreRule.RESTOREONLYIFALLOCCUPIED);
        menuBar.add((Component)valuesMenu, pos + offset + 2);
    }

    void setRestoreRule(RestoreRule newRule) {
        this._restoreRule = newRule;
        InstanceManager.getDefault(UserPreferencesManager.class).setProperty(this.getClassName(), "Restore Rule", newRule.name());
    }

    public static RestoreRule getRestoreRule() {
        RestoreRule rr = RestoreRule.RESTOREONLYIFALLOCCUPIED;
        Object rro = InstanceManager.getDefault(UserPreferencesManager.class).getProperty("jmri.jmrit.beantable.BlockTableAction", "Restore Rule");
        if (rro != null) {
            try {
                rr = RestoreRule.valueOf(rro.toString());
            }
            catch (IllegalArgumentException ignored) {
                log.warn("Invalid Block Restore Rule value '{}' ignored", rro);
            }
        }
        return rr;
    }

    private void metricSelectionChanged() {
        InstanceManager.getDefault(UserPreferencesManager.class).setSimplePreferenceState(BLOCK_METRIC_PREF, this.centimeterBox.isSelected());
        ((BlockTableDataModel)this.m).setMetric(this.centimeterBox.isSelected());
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.BlockTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddBlock"), false, true);
            this.addFrame.setEscapeKeyClosesWindow(true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.BlockAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            ActionListener oklistener = this::okPressed;
            ActionListener cancellistener = this::cancelPressed;
            AddNewBeanPanel anbp = new AddNewBeanPanel(this.sysName, this.userName, this.numberToAddSpinner, this.addRangeCheckBox, this._autoSystemNameCheckBox, "ButtonCreate", oklistener, cancellistener, this.statusBar);
            this.addFrame.add(anbp);
            this.newButton = anbp.ok;
            this.sysName.setToolTipText(Bundle.getMessage("SysNameToolTip", "B"));
        }
        this.sysName.setBackground(Color.white);
        this.statusBar.setText(Bundle.getMessage("AddBeanStatusEnter"));
        this.statusBar.setForeground(Color.gray);
        if (InstanceManager.getDefault(UserPreferencesManager.class).getSimplePreferenceState(this.systemNameAuto)) {
            this._autoSystemNameCheckBox.setSelected(true);
        }
        if (this.newButton != null) {
            this.addFrame.getRootPane().setDefaultButton(this.newButton);
        }
        this.addRangeCheckBox.setSelected(false);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    void cancelPressed(ActionEvent e) {
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void okPressed(ActionEvent e) {
        String sName;
        int numberOfBlocks = 1;
        if (this.addRangeCheckBox.isSelected()) {
            numberOfBlocks = (Integer)this.numberToAddSpinner.getValue();
        }
        if (numberOfBlocks >= 65 && JmriJOptionPane.showConfirmDialog(this.addFrame, Bundle.getMessage("WarnExcessBeans", Bundle.getMessage("Blocks"), numberOfBlocks), Bundle.getMessage("WarningTitle"), 0) != 0) {
            return;
        }
        String user = NamedBean.normalizeUserName(this.userName.getText());
        if (user == null || user.isEmpty()) {
            user = null;
        }
        String uName = user;
        String system = "";
        if (!this._autoSystemNameCheckBox.isSelected()) {
            system = InstanceManager.getDefault(BlockManager.class).makeSystemName(this.sysName.getText());
        }
        if ((sName = system).length() < 3 && !this._autoSystemNameCheckBox.isSelected()) {
            this.statusBar.setText(Bundle.getMessage("WarningSysNameEmpty"));
            this.statusBar.setForeground(Color.red);
            this.sysName.setBackground(Color.red);
            return;
        }
        this.sysName.setBackground(Color.white);
        StringBuilder statusMessage = new StringBuilder(Bundle.getMessage("ItemCreateFeedback", Bundle.getMessage("BeanNameBlock")));
        for (int x = 0; x < numberOfBlocks; ++x) {
            Block blk;
            if (x != 0) {
                if (!this._autoSystemNameCheckBox.isSelected()) {
                    do {
                        system = this.nextName(system);
                        log.debug("Trying sys {}", (Object)system);
                    } while ((blk = (Block)InstanceManager.getDefault(BlockManager.class).getBySystemName(system)) != null);
                    sName = system;
                }
                if (user != null) {
                    do {
                        user = this.nextName(user);
                        log.debug("Trying user {}", (Object)user);
                    } while ((blk = (Block)InstanceManager.getDefault(BlockManager.class).getByUserName(user)) != null);
                    uName = user;
                }
            }
            String xName = "";
            try {
                if (this._autoSystemNameCheckBox.isSelected()) {
                    blk = InstanceManager.getDefault(BlockManager.class).createNewBlock(uName);
                    if (blk == null) {
                        xName = uName;
                        throw new IllegalArgumentException();
                    }
                } else {
                    blk = InstanceManager.getDefault(BlockManager.class).createNewBlock(sName, uName);
                    if (blk == null) {
                        xName = sName;
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                this.handleCreateException(xName);
                this.statusBar.setText(Bundle.getMessage("ErrorAddFailedCheck"));
                this.statusBar.setForeground(Color.red);
                return;
            }
            if (x == 0 || x == numberOfBlocks - 1) {
                statusMessage.append(" ").append(sName).append(" (").append(user).append(")");
            }
            if (x != numberOfBlocks - 2) continue;
            statusMessage.append(" ").append(Bundle.getMessage("ItemCreateUpTo")).append(" ");
        }
        this.statusBar.setText(statusMessage.toString());
        this.statusBar.setForeground(Color.gray);
        InstanceManager.getDefault(UserPreferencesManager.class).setSimplePreferenceState(this.systemNameAuto, this._autoSystemNameCheckBox.isSelected());
    }

    void handleCreateException(String sysName) {
        JmriJOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("ErrorBlockAddFailed", sysName) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
    }

    void deletePaths(JmriJFrame f) {
        Object[] options = new Object[]{Bundle.getMessage("ButtonRemove"), Bundle.getMessage("ButtonKeep")};
        int retval = JmriJOptionPane.showOptionDialog(f, Bundle.getMessage("BlockPathMessage"), Bundle.getMessage("BlockPathSaveTitle"), 0, 3, null, options, options[1]);
        if (retval != 0) {
            InstanceManager.getDefault(BlockManager.class).setSavedPathInfo(true);
            log.info("Requested to save path information via Block Menu.");
        } else {
            InstanceManager.getDefault(BlockManager.class).setSavedPathInfo(false);
            log.info("Requested not to save path information via Block Menu.");
        }
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleBlockTable");
    }

    @Override
    protected String getClassName() {
        return BlockTableAction.class.getName();
    }

    public static enum RestoreRule {
        RESTOREALWAYS,
        RESTOREOCCUPIEDONLY,
        RESTOREONLYIFALLOCCUPIED;

    }
}

