/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AbstractTableTabAction;
import jmri.jmrit.beantable.AddNewDevicePanel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.IdTagTableDataModel;
import jmri.managers.DefaultRailComManager;
import jmri.managers.ProxyIdTagManager;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdTagTableAction
extends AbstractTableAction<IdTag>
implements PropertyChangeListener {
    @Nonnull
    protected IdTagManager tagManager = InstanceManager.getDefault(IdTagManager.class);
    JmriJFrame addFrame = null;
    JTextField sysName = new JTextField(12);
    JTextField userName = new JTextField(15);
    JCheckBox isStateStored = new JCheckBox(Bundle.getMessage("IdStoreState"));
    JCheckBox isFastClockUsed = new JCheckBox(Bundle.getMessage("IdUseFastClock"));
    private static final Logger log = LoggerFactory.getLogger(IdTagTableAction.class);

    public IdTagTableAction(String actionName) {
        super(actionName);
        this.init();
    }

    final void init() {
        this.tagManager.addPropertyChangeListener(this);
    }

    @Override
    public void setManager(@Nonnull Manager<IdTag> t) {
        this.tagManager.removePropertyChangeListener(this);
        if (t instanceof IdTagManager) {
            this.tagManager = (IdTagManager)t;
            if (this.m != null) {
                this.m.setManager(this.tagManager);
            }
        }
        this.tagManager.addPropertyChangeListener(this);
    }

    public IdTagTableAction() {
        this(Bundle.getMessage("TitleIdTagTable"));
    }

    @Override
    protected void createModel() {
        this.m = new IdTagTableDataModel(this.tagManager);
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleIdTagTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.IdTagTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddIdTag"), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.IdTagAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            ActionListener okListener = ev -> this.okPressed(ev);
            ActionListener cancelListener = ev -> this.cancelPressed(ev);
            this.addFrame.setEscapeKeyClosesWindow(true);
            this.addFrame.add(new AddNewDevicePanel(this.sysName, this.userName, "ButtonOK", okListener, cancelListener));
        }
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    void cancelPressed(ActionEvent e) {
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void okPressed(ActionEvent e) {
        String user = this.userName.getText();
        if (user.isEmpty()) {
            user = null;
        }
        String sName = this.sysName.getText();
        try {
            this.tagManager.newIdTag(sName, user);
        }
        catch (IllegalArgumentException ex) {
            this.handleCreateException(sName, ex);
        }
    }

    void handleCreateException(String sysName, IllegalArgumentException ex) {
        JmriJOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("ErrorIdTagAddFailed", sysName) + "\n" + Bundle.getMessage("ErrorAddFailedCheck") + "\n" + ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleIdTagTable");
    }

    @Override
    public void addToFrame(BeanTableFrame<IdTag> f) {
        f.addToBottomBox(this.isStateStored, this.getClass().getName());
        this.isStateStored.setSelected(this.tagManager.isStateStored());
        this.isStateStored.addActionListener(e -> this.tagManager.setStateStored(this.isStateStored.isSelected()));
        f.addToBottomBox(this.isFastClockUsed, this.getClass().getName());
        this.isFastClockUsed.setSelected(this.tagManager.isFastClockUsed());
        this.isFastClockUsed.addActionListener(e -> this.tagManager.setFastClockUsed(this.isFastClockUsed.isSelected()));
        log.debug("Added CheckBox in addToFrame method");
    }

    @Override
    public void addToPanel(AbstractTableTabAction<IdTag> f) {
        String connectionName = this.tagManager.getMemo().getUserName();
        if (this.tagManager instanceof ProxyIdTagManager) {
            connectionName = "All";
        } else if (connectionName == null && this.tagManager instanceof DefaultRailComManager) {
            connectionName = "RailCom";
        }
        f.addToBottomBox(this.isStateStored, connectionName);
        this.isStateStored.setSelected(this.tagManager.isStateStored());
        this.isStateStored.addActionListener(e -> this.tagManager.setStateStored(this.isStateStored.isSelected()));
        f.addToBottomBox(this.isFastClockUsed, connectionName);
        this.isFastClockUsed.setSelected(this.tagManager.isFastClockUsed());
        this.isFastClockUsed.addActionListener(e -> this.tagManager.setFastClockUsed(this.isFastClockUsed.isSelected()));
        log.debug("Added CheckBox in addToPanel method for system {}", (Object)connectionName);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("StateStored")) {
            this.isStateStored.setSelected(this.tagManager.isStateStored());
        } else if (e.getPropertyName().equals("UseFastClock")) {
            this.isFastClockUsed.setSelected(this.tagManager.isFastClockUsed());
        }
    }

    @Override
    protected String getClassName() {
        return IdTagTableAction.class.getName();
    }

    @Override
    public void dispose() {
        this.tagManager.removePropertyChangeListener(this);
        super.dispose();
    }
}

