/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.beans.PropertyChangeEvent;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Reporter;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.IdTagTableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdTagTableDataModel
extends BeanTableDataModel<IdTag> {
    private IdTagManager tagManager;
    public static final int WHERECOL = 5;
    public static final int WHENCOL = 6;
    public static final int CLEARCOL = 7;
    private static final Logger log = LoggerFactory.getLogger(IdTagTableDataModel.class);

    public IdTagTableDataModel(Manager<IdTag> mgr) {
        this.setManager(mgr);
    }

    @Override
    protected final void setManager(Manager<IdTag> mgr) {
        if (mgr instanceof IdTagManager) {
            this.tagManager = (IdTagManager)mgr;
        }
    }

    @Override
    public String getValue(String name) {
        IdTag tag = this.getManager().getBySystemName(name);
        if (tag == null) {
            return "?";
        }
        return tag.getTagID();
    }

    @Override
    public Manager<IdTag> getManager() {
        return this.tagManager != null ? this.tagManager : (Manager)InstanceManager.getDefault(IdTagManager.class);
    }

    @Override
    public IdTag getBySystemName(@Nonnull String name) {
        return this.getManager().getBySystemName(name);
    }

    @Override
    public IdTag getByUserName(@Nonnull String name) {
        return this.getManager().getByUserName(name);
    }

    @Override
    public void clickOn(IdTag t) {
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 7) {
            IdTag t = this.getBySystemName((String)this.sysNameList.get(row));
            log.debug("Clear where & when last seen for {}", (Object)t.getSystemName());
            t.setWhereLastSeen(null);
            this.fireTableRowsUpdated(row, row);
        } else {
            super.setValueAt(value, row, col);
        }
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 2: {
                return Bundle.getMessage("ColumnIdTagID");
            }
            case 5: {
                return Bundle.getMessage("ColumnIdWhere");
            }
            case 6: {
                return Bundle.getMessage("ColumnIdWhen");
            }
            case 7: {
                return "";
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: 
            case 5: {
                return String.class;
            }
            case 7: {
                return JButton.class;
            }
            case 6: {
                return Date.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: 
            case 5: 
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 5: {
                Reporter r;
                IdTag t = this.getBySystemName((String)this.sysNameList.get(row));
                if (t != null && (r = t.getWhereLastSeen()) != null) {
                    return r.getDisplayName();
                }
                return null;
            }
            case 6: {
                IdTag t = this.getBySystemName((String)this.sysNameList.get(row));
                return t != null ? t.getWhenLastSeen() : null;
            }
            case 7: {
                return Bundle.getMessage("ButtonClear");
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 5: 
            case 6: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 7: {
                return new JButton((String)Bundle.getMessage((String)"ButtonClear")).getPreferredSize().width + 4;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public void configValueColumn(JTable table) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!((IdTagManager)this.getManager()).isInitialised()) {
            return;
        }
        switch (e.getPropertyName()) {
            case "whenLastSeen": {
                this.fireTableDataChanged();
                break;
            }
            case "initialised": {
                this.updateNameList();
                this.fireTableDataChanged();
                break;
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "whereLastSeen": 
            case "beans": {
                return false;
            }
        }
        return true;
    }

    @Override
    public JButton configureButton() {
        log.error("configureButton should not have been called");
        return null;
    }

    @Override
    protected String getMasterClassName() {
        return IdTagTableAction.class.getName();
    }
}

