/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import com.alexandriasoftware.swing.Validation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightControl;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.UserPreferencesManager;
import jmri.VariableLight;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.light.LightControlPane;
import jmri.jmrit.beantable.light.LightIntensityPane;
import jmri.jmrit.beantable.light.LightTableDataModel;
import jmri.swing.ManagerComboBox;
import jmri.swing.SystemNameValidator;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightTableAction
extends AbstractTableAction<Light> {
    protected LightManager lightManager = InstanceManager.getNullableDefault(LightManager.class);
    JmriJFrame addFrame = null;
    Light curLight = null;
    boolean lightCreatedOrUpdated = false;
    boolean noWarn = false;
    JLabel systemLabel = new JLabel(Bundle.getMessage("SystemConnectionLabel"));
    ManagerComboBox<Light> prefixBox = new ManagerComboBox();
    JCheckBox addRangeBox = new JCheckBox(Bundle.getMessage("AddRangeBox"));
    JTextField hardwareAddressTextField = new JTextField(10);
    SystemNameValidator hardwareAddressValidator;
    SpinnerNumberModel rangeSpinner = new SpinnerNumberModel(1, 1, 50, 1);
    JSpinner numberToAdd = new JSpinner(this.rangeSpinner);
    JLabel labelNumToAdd = new JLabel("   " + Bundle.getMessage("LabelNumberToAdd"));
    String systemSelectionCombo = this.getClass().getName() + ".SystemSelected";
    JLabel systemNameLabel = new JLabel(Bundle.getMessage("LabelSystemName") + " ");
    JTextField userName = new JTextField(20);
    JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName") + " ");
    JButton create;
    JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
    PropertyChangeListener colorChangeListener;
    JLabel status1 = new JLabel(Bundle.getMessage("LightCreateInst"));
    JLabel status2 = new JLabel("");
    Manager<Light> connectionChoice = null;
    private LightIntensityPane lightIntensityPanel;
    private LightControlPane lightControlPanel;
    private boolean checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    private String addEntryToolTip;
    public static String lightControlTitle = Bundle.getMessage("LightControlBorder");
    private static final Logger log = LoggerFactory.getLogger(LightTableAction.class);

    public LightTableAction(String s) {
        super(s);
        if (this.lightManager == null) {
            super.setEnabled(false);
        }
    }

    public LightTableAction() {
        this(Bundle.getMessage("TitleLightTable"));
    }

    @Override
    public void setManager(@Nonnull Manager<Light> man) {
        if (man instanceof LightManager) {
            this.lightManager = (LightManager)man;
        }
    }

    @Override
    protected void createModel() {
        this.m = new LightTableDataModel(this.lightManager);
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLightTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LightTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.cancelPressed(null);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddLight"), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.LightAddEdit", true);
            this.addFrame.setLocation(100, 30);
            Container contentPane = this.addFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            this.configureManagerComboBox(this.prefixBox, this.lightManager, LightManager.class);
            panel1.add(this.systemLabel);
            panel1.add(this.prefixBox);
            panel1.add(new JLabel("   "));
            panel1.add(this.addRangeBox);
            this.addRangeBox.setVisible(true);
            this.addRangeBox.setToolTipText(Bundle.getMessage("LightAddRangeHint"));
            this.addRangeBox.addActionListener(e1 -> this.addRangeChanged());
            panel1.add(this.systemNameLabel);
            this.systemNameLabel.setVisible(false);
            this.prefixBox.setToolTipText(Bundle.getMessage("LightSystemHint"));
            this.prefixBox.addActionListener(e1 -> this.prefixChanged());
            contentPane.add(panel1);
            JPanel hardwareAddressPanel = new JPanel();
            hardwareAddressPanel.setLayout(new FlowLayout());
            hardwareAddressPanel.add(new JLabel(Bundle.getMessage("LabelHardwareAddress")));
            hardwareAddressPanel.add(this.hardwareAddressTextField);
            this.hardwareAddressTextField.setText("");
            this.hardwareAddressTextField.setToolTipText(Bundle.getMessage("LightHardwareAddressHint"));
            this.hardwareAddressTextField.setName("hwAddressTextField");
            if (this.hardwareAddressValidator == null) {
                this.hardwareAddressValidator = new SystemNameValidator(this.hardwareAddressTextField, (Manager)Objects.requireNonNull(this.prefixBox.getSelectedItem()), true);
            } else {
                this.hardwareAddressValidator.setManager((Manager<?>)this.prefixBox.getSelectedItem());
            }
            this.hardwareAddressTextField.setInputVerifier((InputVerifier)((Object)this.hardwareAddressValidator));
            this.prefixBox.addActionListener(evt -> this.hardwareAddressValidator.setManager((Manager<?>)this.prefixBox.getSelectedItem()));
            this.hardwareAddressValidator.addPropertyChangeListener("validation", evt -> {
                Validation validation = this.hardwareAddressValidator.getValidation();
                Validation.Type type = validation.getType();
                this.create.setEnabled(type != Validation.Type.WARNING && type != Validation.Type.DANGER);
                Object message = validation.getMessage();
                if (message == null) {
                    this.status1.setText("");
                } else {
                    if (((String)(message = ((String)message).trim())).startsWith("<html>") && ((String)message).contains("<br>") && !((String)(message = ((String)message).substring(0, ((String)message).indexOf("<br>")))).endsWith("</html>")) {
                        message = (String)message + "</html>";
                    }
                    this.status1.setText((String)message);
                }
            });
            hardwareAddressPanel.add(this.labelNumToAdd);
            hardwareAddressPanel.add(this.numberToAdd);
            this.numberToAdd.setToolTipText(Bundle.getMessage("LightNumberToAddHint"));
            contentPane.add(hardwareAddressPanel);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            panel2.add(this.userNameLabel);
            panel2.add(this.userName);
            this.userName.setText("");
            this.userName.setToolTipText(Bundle.getMessage("LightUserNameHint"));
            this.userName.setName("userName");
            this.prefixBox.setName("prefixBox");
            contentPane.add(panel2);
            this.lightIntensityPanel = new LightIntensityPane(false);
            TitledBorder varPanelTitled = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("LightVariableBorder"));
            this.lightIntensityPanel.setBorder(varPanelTitled);
            contentPane.add(this.lightIntensityPanel);
            this.lightControlPanel = new LightControlPane();
            TitledBorder panel3Titled = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("LightControllerTitlePlural"));
            this.lightControlPanel.setBorder(panel3Titled);
            contentPane.add(this.lightControlPanel);
            JPanel panel4 = new JPanel();
            panel4.setLayout(new BoxLayout(panel4, 1));
            JPanel panel41 = new JPanel();
            panel41.setLayout(new FlowLayout());
            panel41.add(this.status1);
            this.status1.setText(Bundle.getMessage("LightCreateInst"));
            this.status1.setFont(this.status1.getFont().deriveFont(0.9f * (float)this.systemNameLabel.getFont().getSize()));
            this.status1.setForeground(Color.gray);
            JPanel panel42 = new JPanel();
            panel42.setLayout(new FlowLayout());
            panel42.add(this.status2);
            this.status2.setText(Bundle.getMessage("LightCreateInst"));
            this.status2.setFont(this.status2.getFont().deriveFont(0.9f * (float)this.systemNameLabel.getFont().getSize()));
            this.status2.setForeground(Color.gray);
            this.status2.setText("");
            this.status2.setVisible(false);
            panel4.add(panel41);
            panel4.add(panel42);
            contentPane.add(panel4);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout(4));
            panel5.add(this.cancel);
            this.cancel.setText(Bundle.getMessage("ButtonCancel"));
            this.cancel.addActionListener(this::cancelPressed);
            this.cancel.setToolTipText(Bundle.getMessage("LightCancelButtonHint"));
            this.create = new JButton(Bundle.getMessage("ButtonCreate"));
            panel5.add(this.create);
            this.create.addActionListener(this::createPressed);
            this.create.setToolTipText(Bundle.getMessage("LightCreateButtonHint"));
            this.create.setName("createButton");
            this.create.setVisible(true);
            contentPane.add(panel5);
            this.hardwareAddressValidator.verify(this.hardwareAddressTextField);
        }
        this.prefixChanged();
        this.addFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LightTableAction.this.cancelPressed(null);
            }
        });
        this.create.setEnabled(false);
        this.status1.setText(Bundle.getMessage("LightCreateInst"));
        this.status1.setForeground(Color.gray);
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.addFrame.getRootPane().setDefaultButton(this.create);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    protected void prefixChanged() {
        if (this.prefixBox.getSelectedItem() != null) {
            this.lightIntensityPanel.setVisible(this.supportsVariableLights());
            this.addRangeBox.setEnabled(this.canAddRange());
            this.addRangeBox.setSelected(false);
            this.numberToAdd.setValue(1);
            this.numberToAdd.setEnabled(false);
            this.labelNumToAdd.setEnabled(false);
            this.connectionChoice = this.prefixBox.getSelectedItem();
            log.debug("Connection choice = [{}]", this.connectionChoice);
            String systemPrefix = this.connectionChoice.getSystemPrefix();
            this.addEntryToolTip = this.connectionChoice.getEntryToolTip();
            this.addRangeBox.setEnabled(((LightManager)this.connectionChoice).allowMultipleAdditions(systemPrefix));
            log.debug("DefaultLightManager tip: {}", (Object)this.addEntryToolTip);
            if (this.addEntryToolTip != null) {
                this.hardwareAddressTextField.setToolTipText(Bundle.getMessage("AddEntryToolTipLine1", this.connectionChoice.getMemo().getUserName(), Bundle.getMessage("Lights"), this.addEntryToolTip));
                this.hardwareAddressValidator.setToolTipText(this.hardwareAddressTextField.getToolTipText());
                this.hardwareAddressValidator.verify(this.hardwareAddressTextField);
            }
            this.create.setEnabled(true);
            this.addFrame.pack();
            this.addFrame.setVisible(true);
        }
    }

    protected void addRangeChanged() {
        this.numberToAdd.setEnabled(this.addRangeBox.isSelected());
        this.labelNumToAdd.setEnabled(this.addRangeBox.isSelected());
    }

    private boolean canAddRange() {
        String testSysName = ((Manager)Objects.requireNonNull(this.prefixBox.getSelectedItem())).getSystemPrefix() + "L11";
        return this.lightManager.allowMultipleAdditions(testSysName);
    }

    boolean supportsVariableLights() {
        String testSysName = ((Manager)Objects.requireNonNull(this.prefixBox.getSelectedItem())).getSystemPrefix() + "L11";
        return this.lightManager.supportsVariableLights(testSysName);
    }

    void createPressed(ActionEvent e) {
        this.status1.setForeground(Color.gray);
        this.status1.setText("");
        String lightPrefix = ((Manager)Objects.requireNonNull(this.prefixBox.getSelectedItem())).getSystemPrefix() + "L";
        String turnoutPrefix = this.prefixBox.getSelectedItem().getSystemPrefix() + "T";
        String curAddress = this.hardwareAddressTextField.getText();
        if (curAddress.length() < 1) {
            log.warn("Hardware Address was not entered");
            this.status1.setText(Bundle.getMessage("LightError17"));
            this.status1.setForeground(Color.red);
            this.status2.setVisible(false);
            this.hardwareAddressTextField.setBackground(Color.red);
            this.addFrame.pack();
            this.addFrame.setVisible(true);
            return;
        }
        this.hardwareAddressTextField.setBackground(Color.white);
        Object suName = lightPrefix + curAddress;
        String uName = this.userName.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        if (InstanceManager.getDefault(LightManager.class).validSystemNameFormat((String)suName) != Manager.NameValidity.VALID) {
            log.warn("Invalid Light system name format entered: {}", suName);
            this.status1.setText(Bundle.getMessage("LightError3"));
            this.status1.setForeground(Color.red);
            this.status2.setText(Bundle.getMessage("LightError6"));
            this.status2.setVisible(true);
            this.hardwareAddressTextField.setBackground(Color.red);
            this.addFrame.pack();
            this.addFrame.setVisible(true);
            return;
        }
        this.hardwareAddressTextField.setBackground(Color.white);
        Light g = InstanceManager.getDefault(LightManager.class).getBySystemName((String)suName);
        if (g != null) {
            this.status1.setText(Bundle.getMessage("LightError1"));
            this.status1.setForeground(Color.red);
            this.status2.setText(Bundle.getMessage("LightError2"));
            this.status2.setVisible(true);
            this.addFrame.pack();
            this.addFrame.setVisible(true);
            return;
        }
        String altName = InstanceManager.getDefault(LightManager.class).convertSystemNameToAlternate((String)suName);
        if (!altName.isEmpty() && (g = InstanceManager.getDefault(LightManager.class).getBySystemName(altName)) != null) {
            this.status1.setText(Bundle.getMessage("LightError10", altName));
            this.status1.setForeground(Color.red);
            this.status2.setVisible(false);
            this.addFrame.pack();
            this.addFrame.setVisible(true);
            return;
        }
        if (uName != null && (g = InstanceManager.getDefault(LightManager.class).getByUserName(uName)) != null) {
            this.status1.setText(Bundle.getMessage("LightError8"));
            this.status1.setForeground(Color.red);
            this.status2.setText(Bundle.getMessage("LightError9"));
            this.status2.setVisible(true);
            this.addFrame.pack();
            this.addFrame.setVisible(true);
            return;
        }
        if (!InstanceManager.getDefault(LightManager.class).validSystemNameConfig((String)suName)) {
            this.status1.setText(Bundle.getMessage("LightError5"));
            this.status1.setForeground(Color.red);
            this.status2.setText(Bundle.getMessage("LightError6"));
            this.status2.setVisible(true);
            this.addFrame.pack();
            this.addFrame.setVisible(true);
            return;
        }
        String testSN = turnoutPrefix + curAddress;
        Turnout testT = InstanceManager.turnoutManagerInstance().getBySystemName(testSN);
        if (testT != null) {
            log.warn("Requested Light {} uses same address as Turnout {}", suName, (Object)testT);
            if (!this.noWarn) {
                int selectedValue = JmriJOptionPane.showOptionDialog(this.addFrame, Bundle.getMessage("LightWarn5", suName, testSN), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonYesPlus"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
                if (selectedValue == 1) {
                    return;
                }
                if (selectedValue == 2) {
                    this.noWarn = true;
                }
            }
            this.status2.setText(Bundle.getMessage("LightWarn4") + " " + testSN + ".");
            this.status1.setForeground(Color.red);
            this.status2.setVisible(true);
        }
        try {
            g = InstanceManager.getDefault(LightManager.class).newLight((String)suName, uName);
        }
        catch (IllegalArgumentException ex) {
            this.handleCreateException(ex, (String)suName);
            return;
        }
        this.lightControlPanel.setLightFromControlTable(g);
        if (g instanceof VariableLight) {
            this.lightIntensityPanel.setLightFromPane((VariableLight)g);
        }
        g.activateLight();
        this.lightCreatedOrUpdated = true;
        this.status2.setText("");
        this.status2.setVisible(false);
        String feedback = Bundle.getMessage("LightCreateFeedback") + " " + g.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        int numberOfLights = 1;
        if (InstanceManager.getDefault(LightManager.class).allowMultipleAdditions((String)suName) && this.addRangeBox.isSelected()) {
            numberOfLights = (Integer)this.numberToAdd.getValue();
        }
        if (numberOfLights > 1) {
            for (int i = 1; i < numberOfLights; ++i) {
                try {
                    suName = InstanceManager.getDefault(LightManager.class).getNextValidSystemName(g);
                    g = this.lightManager.newLight((String)suName, uName);
                    log.debug("Light {} created", (Object)g);
                    this.lightControlPanel.setLightFromControlTable(g);
                    if (!(g instanceof VariableLight)) continue;
                    this.lightIntensityPanel.setLightFromPane((VariableLight)g);
                    continue;
                }
                catch (IllegalArgumentException | JmriException ex) {
                    this.handleCreateException(ex, (String)suName);
                    return;
                }
            }
            feedback = feedback + " - " + (String)suName + ", " + uName;
        }
        this.create.setEnabled(false);
        this.status1.setText(feedback);
        this.status1.setForeground(Color.gray);
        this.cancel.setText(Bundle.getMessage("ButtonClose"));
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    void handleCreateException(Exception ex, String sysName) {
        this.status1.setText(ex.getLocalizedMessage());
        String err = Bundle.getMessage("ErrorBeanCreateFailed", InstanceManager.getDefault(LightManager.class).getBeanTypeHandled(), sysName);
        JmriJOptionPane.showMessageDialog(this.addFrame, err + "\n" + ex.getLocalizedMessage(), err, 0);
    }

    void cancelPressed(ActionEvent e) {
        if (this.addFrame != null) {
            this.addFrame.setVisible(false);
        }
        if (this.lightCreatedOrUpdated && !this.checkEnabled) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemLightTable")), this.getClassName(), "remindSaveLight");
        }
        this.lightCreatedOrUpdated = false;
        if (this.addFrame != null) {
            this.lightControlPanel.dispose();
            this.removePrefixBoxListener(this.prefixBox);
            InstanceManager.getDefault(UserPreferencesManager.class).setComboBoxLastSelection(this.systemSelectionCombo, this.prefixBox.getSelectedItem().getMemo().getUserName());
            this.addFrame.dispose();
            this.addFrame = null;
            this.create.removePropertyChangeListener(this.colorChangeListener);
        }
    }

    public static String getDescriptionText(LightControl lc, int type) {
        switch (type) {
            case 1: {
                return MessageFormat.format(Bundle.getMessage("LightSensorControlDes"), lc.getControlSensorName(), LightTableAction.getControlSensorSenseText(lc));
            }
            case 2: {
                return MessageFormat.format(Bundle.getMessage("LightFastClockDes"), String.format("%02d:%02d", lc.getFastClockOnHour(), lc.getFastClockOnMin()), String.format("%02d:%02d", lc.getFastClockOffHour(), lc.getFastClockOffMin()));
            }
            case 3: {
                return MessageFormat.format(Bundle.getMessage("LightTurnoutControlDes"), lc.getControlTurnoutName(), LightTableAction.getControlTurnoutStateText(lc));
            }
            case 4: {
                return MessageFormat.format(Bundle.getMessage("LightTimedOnControlDes"), "" + lc.getTimedOnDuration(), lc.getControlTimedOnSensorName(), LightTableAction.getControlSensorSenseText(lc));
            }
            case 5: {
                return MessageFormat.format(Bundle.getMessage("LightTwoSensorControlDes"), lc.getControlSensorName(), lc.getControlSensor2Name(), LightTableAction.getControlSensorSenseText(lc));
            }
        }
        return "";
    }

    private static String getControlSensorSenseText(LightControl lc) {
        if (lc.getControlSensorSense() == 2) {
            return Bundle.getMessage("SensorStateActive");
        }
        return Bundle.getMessage("SensorStateInactive");
    }

    private static String getControlTurnoutStateText(LightControl lc) {
        if (lc.getControlTurnoutState() == 2) {
            return InstanceManager.turnoutManagerInstance().getClosedText();
        }
        return InstanceManager.turnoutManagerInstance().getThrownText();
    }

    public boolean validatePhysicalTurnout(String inTurnoutName, Component inOpenPane) {
        if (inTurnoutName.isEmpty()) {
            log.debug("no turnout was selected");
            return false;
        }
        Turnout t = InstanceManager.turnoutManagerInstance().getTurnout(inTurnoutName);
        if (t == null) {
            if (inOpenPane != null) {
                JmriJOptionPane.showMessageDialog(inOpenPane, MessageFormat.format(Bundle.getMessage("LightWarn2"), inTurnoutName), Bundle.getMessage("ErrorTitle"), 0);
            }
            return false;
        }
        log.debug("validatePhysicalTurnout('{}')", (Object)inTurnoutName);
        return true;
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleLightTable");
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "remindSaveLight", Bundle.getMessage("HideSaveReminder"));
        super.setMessagePreferencesDetails();
    }

    @Override
    protected String getClassName() {
        return LightTableAction.class.getName();
    }
}

