/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.jmrit.beantable.AbstractLogixNGTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.ListedTableFrame;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.LocalVariableTableModel;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNGGlobalVariableTableAction
extends AbstractLogixNGTableAction<GlobalVariable> {
    private static final Logger log = LoggerFactory.getLogger(LogixNGGlobalVariableTableAction.class);

    public LogixNGGlobalVariableTableAction(String s) {
        super(s);
    }

    public LogixNGGlobalVariableTableAction() {
        this(Bundle.getMessage("TitleLogixNGGlobalVariablesTable"));
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLogixNGGlobalVariablesTable"));
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleLogixNGGlobalVariablesTable");
    }

    @Override
    protected AbstractLogixNGEditor<GlobalVariable> getEditor(BeanTableDataModel<GlobalVariable> m, String sName) {
        return null;
    }

    @Override
    protected boolean isEditSupported() {
        return false;
    }

    @Override
    protected Manager<GlobalVariable> getManager() {
        return InstanceManager.getDefault(GlobalVariableManager.class);
    }

    @Override
    public void setEnabled(GlobalVariable globalVariable, boolean enable) {
    }

    @Override
    protected boolean isEnabled(GlobalVariable globalVariable) {
        return true;
    }

    @Override
    public void enableAll(boolean enable) {
    }

    @Override
    protected GlobalVariable createBean(String userName) {
        GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).createGlobalVariable(userName);
        return globalVariable;
    }

    @Override
    protected GlobalVariable createBean(String systemName, String userName) {
        GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).createGlobalVariable(systemName, userName);
        return globalVariable;
    }

    @Override
    public void deleteBean(GlobalVariable globalVariable) {
        try {
            InstanceManager.getDefault(GlobalVariableManager.class).deleteBean(globalVariable, "DoDelete");
        }
        catch (PropertyVetoException e) {
            log.error("{} : Could not Delete.", (Object)e.getMessage());
        }
    }

    @Override
    protected boolean isCopyBeanSupported() {
        return false;
    }

    @Override
    protected String getBeanText(GlobalVariable e, Base.PrintTreeSettings printTreeSettings) {
        StringBuilder content = new StringBuilder(Bundle.getMessage("LogixNG_GlobalVar_Browse_Header", new Object[]{e.getSystemName(), e.getUserName(), e.getInitialValueType()}));
        content.append(Bundle.getMessage("LogixNG_GlobalVar_Browse_Value"));
        Object value = e.getValue();
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                String line = String.format("%n        %s -> %s", entry.getKey(), entry.getValue());
                content.append(line);
            }
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                String line = String.format("%n        %s", list.get(i));
                content.append(line);
            }
        } else {
            content.append(value);
        }
        return content.toString();
    }

    @Override
    protected String getBrowserTitle() {
        return Bundle.getMessage("LogixNG_GlobalVar_Browse_Title");
    }

    @Override
    protected String getAddTitleKey() {
        return "TitleAddLogixNGGlobalVariable";
    }

    @Override
    protected String getCreateButtonHintKey() {
        return "LogixNGCreateGlobalVariableButtonHint";
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LogixNGGlobalVariables";
    }

    @Override
    protected JPanel makeAddFrame(String titleId, String startMessageId) {
        this.addLogixNGFrame = new JmriJFrame(Bundle.getMessage(titleId));
        this.addLogixNGFrame.addHelpMenu("package.jmri.jmrit.beantable.LogixNGGlobalVariables", true);
        this.addLogixNGFrame.setLocation(50, 30);
        Container contentPane = this.addLogixNGFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._sysNameLabel, c);
        this._sysNameLabel.setLabelFor(this._systemName);
        c.gridy = 1;
        p.add((Component)this._userNameLabel, c);
        this._userNameLabel.setLabelFor(this._addUserName);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._systemName, c);
        c.gridy = 1;
        p.add((Component)this._addUserName, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        p.add((Component)this._autoSystemName, c);
        this._addUserName.setToolTipText(Bundle.getMessage("LogixNGGlobalVariableUserNameHint"));
        this._systemName.setToolTipText(Bundle.getMessage("LogixNGGlobalVariableSystemNameHint"));
        contentPane.add(p);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        JLabel message1 = new JLabel(Bundle.getMessage(startMessageId + "LogixNGMessage1"));
        panel31.add(message1);
        JPanel panel32 = new JPanel();
        JLabel message2 = new JLabel(Bundle.getMessage(startMessageId + "LogixNGMessage2"));
        panel32.add(message2);
        panel3.add(panel31);
        panel3.add(panel32);
        contentPane.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(this::cancelAddPressed);
        cancel.setToolTipText(Bundle.getMessage("CancelLogixNGGlobalVariableButtonHint"));
        this.addLogixNGFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogixNGGlobalVariableTableAction.this.cancelAddPressed(null);
            }
        });
        contentPane.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        return panel5;
    }

    @Override
    protected void getListenerRefsIncludingChildren(GlobalVariable globalVariable, List<String> list) {
        globalVariable.getListenerRefsIncludingChildren(list);
    }

    @Override
    protected boolean hasChildren(GlobalVariable globalVariable) {
        return false;
    }

    @Override
    protected void createModel() {
        this.m = new TableModel();
    }

    @Override
    public void addToFrame(@Nonnull BeanTableFrame<GlobalVariable> f) {
        f.addToBottomBox(new JLabel(Bundle.getMessage("LogixNGGlobalVariable_InfoAboutGlobalVariables")), null);
    }

    @Override
    public void addToFrame(@Nonnull ListedTableFrame.TabbedTableItem<GlobalVariable> tti) {
        tti.addToBottomBox(new JLabel(Bundle.getMessage("LogixNGGlobalVariable_InfoAboutGlobalVariables")));
    }

    protected class TableModel
    extends AbstractLogixNGTableAction.TableModel {
        private static final int VARIABLE_TYPE_COL = 5;
        private static final int VARIABLE_INIT_VALUE_COL = 6;
        private static final int SET_TO_INIT_VALUE_COL = 7;
        private static final int NUM_COLUMNS = 8;

        protected TableModel() {
        }

        @Override
        protected boolean isClearUserNameAllowed() {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 5: {
                    return Bundle.getMessage("LogixNGGlobalVariableColumnHeadInitialType");
                }
                case 6: {
                    return Bundle.getMessage("LogixNGGlobalVariableColumnHeadInitialValue");
                }
                case 7: {
                    return Bundle.getMessage("LogixNGGlobalVariableColumnHeadSetToInitValue");
                }
            }
            return super.getColumnName(col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 5: {
                    return SymbolTable.InitialValueType.class;
                }
                case 6: {
                    return String.class;
                }
                case 7: {
                    return JButton.class;
                }
            }
            return super.getColumnClass(col);
        }

        @Override
        public int getPreferredWidth(int col) {
            switch (col) {
                case 5: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 6: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 7: {
                    return new JButton((String)Bundle.getMessage((String)"LogixNGGlobalVariableColumnHeadSetToInitValue")).getPreferredSize().width;
                }
            }
            return super.getPreferredWidth(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 5: 
                case 6: 
                case 7: {
                    return true;
                }
            }
            return super.isCellEditable(row, col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 5: {
                    GlobalVariable gv = (GlobalVariable)this.getValueAt(row, 0);
                    if (gv == null) {
                        return null;
                    }
                    return gv.getInitialValueType();
                }
                case 6: {
                    GlobalVariable gv = (GlobalVariable)this.getValueAt(row, 0);
                    if (gv == null) {
                        return null;
                    }
                    return gv.getInitialValueData();
                }
                case 7: {
                    return Bundle.getMessage("LogixNGGlobalVariableColumnHeadSetToInitValue");
                }
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 5: {
                    GlobalVariable gv = (GlobalVariable)this.getValueAt(row, 0);
                    gv.setInitialValueType((SymbolTable.InitialValueType)((Object)value));
                    break;
                }
                case 6: {
                    GlobalVariable gv = (GlobalVariable)this.getValueAt(row, 0);
                    gv.setInitialValueData((String)value);
                    break;
                }
                case 7: {
                    GlobalVariable gv = (GlobalVariable)this.getValueAt(row, 0);
                    try {
                        gv.initialize();
                    }
                    catch (RuntimeException | JmriException e) {
                        JmriJOptionPane.showMessageDialog(null, e.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
                    }
                    break;
                }
                default: {
                    super.setValueAt(value, row, col);
                }
            }
        }

        @Override
        public void configureTable(JTable table) {
            table.setDefaultRenderer(SymbolTable.InitialValueType.class, new LocalVariableTableModel.TypeCellRenderer());
            table.setDefaultEditor(SymbolTable.InitialValueType.class, new LocalVariableTableModel.TypeCellEditor());
            super.configureTable(table);
        }
    }
}

