/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellEditor;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.jmrit.beantable.AbstractLogixNGTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingTriStateCheckboxRenderer;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.LogixNGEditor;
import jmri.util.JmriJFrame;
import jmri.util.swing.TriStateJCheckBox;
import jmri.util.swing.XTableColumnModel;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNGTableAction
extends AbstractLogixNGTableAction<LogixNG> {
    private static final Logger log = LoggerFactory.getLogger(LogixNGTableAction.class);

    public LogixNGTableAction(String s) {
        super(s);
    }

    public LogixNGTableAction() {
        this(Bundle.getMessage("TitleLogixNGTable"));
    }

    @Override
    protected void createModel() {
        this.m = new TableModel();
        this.m.setFilter(t -> !t.isInline());
    }

    @Override
    protected AbstractLogixNGEditor<LogixNG> getEditor(BeanTableDataModel<LogixNG> m, String sName) {
        return new LogixNGEditor(m, sName);
    }

    @Override
    protected Manager<LogixNG> getManager() {
        return InstanceManager.getDefault(LogixNG_Manager.class);
    }

    @Override
    protected void setEnabled(LogixNG logixNG, boolean enable) {
        logixNG.setEnabled(enable);
    }

    @Override
    protected boolean isEnabled(LogixNG logixNG) {
        return logixNG.isEnabled();
    }

    @Override
    protected void enableAll(boolean enable) {
        for (LogixNG x : this.getManager().getNamedBeanSet()) {
            x.setEnabled(enable);
        }
        this.m.fireTableDataChanged();
    }

    @Override
    protected LogixNG createBean(String userName) {
        LogixNG logixNG = InstanceManager.getDefault(LogixNG_Manager.class).createLogixNG(userName);
        logixNG.activate();
        logixNG.setEnabled(true);
        logixNG.clearStartup();
        return logixNG;
    }

    @Override
    protected LogixNG createBean(String systemName, String userName) {
        LogixNG logixNG = InstanceManager.getDefault(LogixNG_Manager.class).createLogixNG(systemName, userName);
        logixNG.activate();
        logixNG.setEnabled(true);
        logixNG.clearStartup();
        return logixNG;
    }

    @Override
    public void deleteBean(LogixNG logixNG) {
        logixNG.setEnabled(false);
        try {
            InstanceManager.getDefault(LogixNG_Manager.class).deleteBean(logixNG, "DoDelete");
        }
        catch (PropertyVetoException e) {
            log.error("{} : Could not Delete.", (Object)e.getMessage());
        }
    }

    private void copyConditionalNGToLogixNG(@Nonnull ConditionalNG sourceConditionalNG, @Nonnull LogixNG targetBean) {
        String sysName = InstanceManager.getDefault(ConditionalNG_Manager.class).getAutoSystemName();
        String oldUserName = sourceConditionalNG.getUserName();
        String userName = oldUserName != null ? Bundle.getMessage("CopyOfConditionalNG", oldUserName) : null;
        ConditionalNG targetConditionalNG = InstanceManager.getDefault(ConditionalNG_Manager.class).createConditionalNG(targetBean, sysName, userName);
        sourceConditionalNG.getFemaleSocket().unregisterListeners();
        targetConditionalNG.getFemaleSocket().unregisterListeners();
        HashMap<String, String> systemNames = new HashMap<String, String>();
        HashMap<String, String> userNames = new HashMap<String, String>();
        try {
            FemaleDigitalActionSocket femaleSourceSocket = sourceConditionalNG.getFemaleSocket();
            if (femaleSourceSocket.isConnected()) {
                targetConditionalNG.getFemaleSocket().connect((MaleSocket)femaleSourceSocket.getConnectedSocket().getDeepCopy(systemNames, userNames));
            }
        }
        catch (JmriException ex) {
            log.error("Could not Copy ConditionalNG.", (Throwable)ex);
        }
        sourceConditionalNG.getFemaleSocket().registerListeners();
        targetConditionalNG.getFemaleSocket().registerListeners();
    }

    @Override
    protected void copyBean(@Nonnull LogixNG sourceBean, @Nonnull LogixNG targetBean) {
        for (int i = 0; i < sourceBean.getNumConditionalNGs(); ++i) {
            this.copyConditionalNGToLogixNG(sourceBean.getConditionalNG(i), targetBean);
        }
    }

    @Override
    protected boolean isCopyBeanSupported() {
        return true;
    }

    @Override
    protected boolean isExecuteSupported() {
        return true;
    }

    @Override
    protected void execute(@Nonnull LogixNG logixNG) {
        if (!logixNG.isActivated() && !logixNG.isEnabled()) {
            JOptionPane.showMessageDialog(this.f, Bundle.getMessage("LogixNG_CantExecuteLogixNG_InactiveAndNotEnabled"), Bundle.getMessage("LogixNG_Error"), 0);
        } else if (!logixNG.isActivated()) {
            JOptionPane.showMessageDialog(this.f, Bundle.getMessage("LogixNG_CantExecuteLogixNG_Inactive"), Bundle.getMessage("LogixNG_Error"), 0);
        } else if (!logixNG.isEnabled()) {
            JOptionPane.showMessageDialog(this.f, Bundle.getMessage("LogixNG_CantExecuteLogixNG_NotEnabled"), Bundle.getMessage("LogixNG_Error"), 0);
        } else {
            logixNG.execute();
        }
    }

    @Override
    protected String getBeanText(LogixNG e, Base.PrintTreeSettings printTreeSettings) {
        StringWriter writer = new StringWriter();
        ((LogixNG)this._curNamedBean).printTree(printTreeSettings, new PrintWriter(writer), "    ", new MutableInt(0));
        return writer.toString();
    }

    @Override
    protected String getBrowserTitle() {
        return Bundle.getMessage("LogixNG_Browse_Title");
    }

    @Override
    protected String getAddTitleKey() {
        return "TitleAddLogixNG";
    }

    @Override
    protected String getCreateButtonHintKey() {
        return "LogixNGCreateButtonHint";
    }

    @Override
    protected JPanel makeAddFrame(String titleId, String startMessageId) {
        this.addLogixNGFrame = new JmriJFrame(Bundle.getMessage(titleId));
        this.addLogixNGFrame.addHelpMenu("package.jmri.jmrit.beantable.LogixNGTable", true);
        this.addLogixNGFrame.setLocation(50, 30);
        Container contentPane = this.addLogixNGFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._sysNameLabel, c);
        this._sysNameLabel.setLabelFor(this._systemName);
        c.gridy = 1;
        p.add((Component)this._userNameLabel, c);
        this._userNameLabel.setLabelFor(this._addUserName);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._systemName, c);
        c.gridy = 1;
        p.add((Component)this._addUserName, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        p.add((Component)this._autoSystemName, c);
        this._addUserName.setToolTipText(Bundle.getMessage("LogixNGUserNameHint"));
        this._systemName.setToolTipText(Bundle.getMessage("LogixNGSystemNameHint"));
        contentPane.add(p);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        JLabel message1 = new JLabel(Bundle.getMessage(startMessageId + "LogixNGMessage1"));
        panel31.add(message1);
        JPanel panel32 = new JPanel();
        JLabel message2 = new JLabel(Bundle.getMessage(startMessageId + "LogixNGMessage2"));
        panel32.add(message2);
        panel3.add(panel31);
        panel3.add(panel32);
        contentPane.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(this::cancelAddPressed);
        cancel.setToolTipText(Bundle.getMessage("CancelLogixNGButtonHint"));
        this.addLogixNGFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogixNGTableAction.this.cancelAddPressed(null);
            }
        });
        contentPane.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        return panel5;
    }

    @Override
    protected void getListenerRefsIncludingChildren(LogixNG logixNG, List<String> list) {
        logixNG.getListenerRefsIncludingChildren(list);
    }

    @Override
    protected boolean hasChildren(LogixNG logixNG) {
        return logixNG.getNumConditionalNGs() > 0;
    }

    private static class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    TreeCellEditor {
        TriStateJCheckBox _tristateCheckBox;

        public CellEditor(TriStateJCheckBox tristateCheckBox) {
            this._tristateCheckBox = tristateCheckBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this._tristateCheckBox.getState();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this._tristateCheckBox;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            return this._tristateCheckBox;
        }
    }

    protected class TableModel
    extends AbstractLogixNGTableAction.TableModel {
        public static final int STARTUP_COL = 5;

        protected TableModel() {
        }

        @Override
        public void configureTable(JTable table) {
            super.configureTable(table);
            table.setDefaultRenderer(TriStateJCheckBox.State.class, new EnablingTriStateCheckboxRenderer());
            TriStateJCheckBox startupCheckBox = new TriStateJCheckBox();
            TableColumn col = ((XTableColumnModel)table.getColumnModel()).getColumnByModelIndex(5);
            col.setCellEditor(new CellEditor(startupCheckBox));
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 5) {
                return Bundle.getMessage("ColumnLogixNGStartup");
            }
            return super.getColumnName(col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 5) {
                return TriStateJCheckBox.State.class;
            }
            return super.getColumnClass(col);
        }

        @Override
        public int getPreferredWidth(int col) {
            if (col == 5) {
                return new JTextField((int)5).getPreferredSize().width;
            }
            return super.getPreferredWidth(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 5) {
                return true;
            }
            return super.isCellEditable(row, col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 5) {
                LogixNG x = (LogixNG)this.getValueAt(row, 0);
                if (x == null) {
                    return null;
                }
                boolean anyTrue = false;
                boolean anyFalse = false;
                for (int i = 0; i < x.getNumConditionalNGs(); ++i) {
                    ConditionalNG cng = x.getConditionalNG(i);
                    if (cng.isExecuteAtStartup()) {
                        anyTrue = true;
                        continue;
                    }
                    anyFalse = true;
                }
                if (anyTrue && anyFalse) {
                    return TriStateJCheckBox.State.PARTIAL;
                }
                if (anyTrue) {
                    return TriStateJCheckBox.State.CHECKED;
                }
                return TriStateJCheckBox.State.UNCHECKED;
            }
            return super.getValueAt(row, col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 5) {
                LogixNG x = (LogixNG)this.getValueAt(row, 0);
                for (int i = 0; i < x.getNumConditionalNGs(); ++i) {
                    ConditionalNG cng = x.getConditionalNG(i);
                    cng.setExecuteAtStartup(value == TriStateJCheckBox.State.CHECKED);
                }
            } else {
                super.setValueAt(value, row, col);
            }
        }

        @Override
        public String getValue(String s) {
            return "";
        }
    }
}

