/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.jmrit.beantable.AbstractLogixNGTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.Table;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.TableEditor;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNGTableTableAction
extends AbstractLogixNGTableAction<NamedTable> {
    JRadioButton _typeExternalTable = new JRadioButton(Bundle.getMessage("LogixNG_typeExternalTable"));
    JRadioButton _typeInternalTable = new JRadioButton(Bundle.getMessage("LogixNG_typeInternalTable"));
    ButtonGroup _buttonGroup = new ButtonGroup();
    JTextField _csvFileName = new JTextField(50);
    ButtonGroup _csvGroup = new ButtonGroup();
    JRadioButton _csvTabbed = new JRadioButton(Table.CsvType.TABBED.toString());
    JRadioButton _csvComma = new JRadioButton(Table.CsvType.COMMA.toString());
    JRadioButton _csvSemicolon = new JRadioButton(Table.CsvType.SEMICOLON.toString());
    JLabel _csvLabel = new JLabel(Bundle.getMessage("LogixNG_CsvType") + ":");
    private static final Logger log = LoggerFactory.getLogger(LogixNGTableTableAction.class);

    public LogixNGTableTableAction(String s) {
        super(s);
    }

    public LogixNGTableTableAction() {
        this(Bundle.getMessage("TitleLogixNGTableTable"));
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleLogixNGTableTable"));
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleLogixNGTableTable");
    }

    @Override
    protected AbstractLogixNGEditor<NamedTable> getEditor(BeanTableDataModel<NamedTable> m, String sName) {
        return new TableEditor(m, sName);
    }

    @Override
    protected Manager<NamedTable> getManager() {
        return InstanceManager.getDefault(NamedTableManager.class);
    }

    @Override
    protected void enableAll(boolean enable) {
    }

    @Override
    protected void setEnabled(NamedTable bean, boolean enable) {
    }

    @Override
    protected boolean isEnabled(NamedTable bean) {
        return true;
    }

    @Override
    protected NamedTable createBean(String userName) {
        String systemName = InstanceManager.getDefault(NamedTableManager.class).getAutoSystemName();
        return this.createBean(systemName, userName);
    }

    @Override
    protected NamedTable createBean(String systemName, String userName) {
        if (this._typeExternalTable.isSelected()) {
            String fileName = this._csvFileName.getText();
            if (fileName == null || fileName.isEmpty()) {
                JmriJOptionPane.showMessageDialog(this.addLogixNGFrame, Bundle.getMessage("LogixNGError2"), Bundle.getMessage("ErrorTitle"), 0);
                return null;
            }
            if (this._csvTabbed.isSelected()) {
                return InstanceManager.getDefault(NamedTableManager.class).newCSVTable(systemName, userName, fileName, Table.CsvType.TABBED);
            }
            if (this._csvComma.isSelected()) {
                return InstanceManager.getDefault(NamedTableManager.class).newCSVTable(systemName, userName, fileName, Table.CsvType.COMMA);
            }
            if (this._csvSemicolon.isSelected()) {
                return InstanceManager.getDefault(NamedTableManager.class).newCSVTable(systemName, userName, fileName, Table.CsvType.SEMICOLON);
            }
        } else if (!this._typeInternalTable.isSelected()) {
            log.error("No table type selected");
            throw new RuntimeException("No table type selected");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void deleteBean(NamedTable bean) {
        try {
            InstanceManager.getDefault(NamedTableManager.class).deleteBean(bean, "DoDelete");
        }
        catch (PropertyVetoException e) {
            log.error("{} : Could not Delete.", (Object)e.getMessage());
        }
    }

    @Override
    protected boolean browseMonoSpace() {
        return true;
    }

    @Override
    protected String getBeanText(NamedTable bean, Base.PrintTreeSettings printTreeSettings) {
        int maxColumnWidth = 0;
        int[] columnWidth = new int[bean.numColumns() + 1];
        String[][] cells = new String[bean.numRows() + 1][];
        for (int row = 0; row <= bean.numRows(); ++row) {
            cells[row] = new String[bean.numColumns() + 1];
            for (int col = 0; col <= bean.numColumns(); ++col) {
                Object value = bean.getCell(row, col);
                cells[row][col] = value != null ? value.toString() : "<null>";
                columnWidth[col] = Math.max(columnWidth[col], cells[row][col].length());
                maxColumnWidth = Math.max(maxColumnWidth, columnWidth[col]);
            }
        }
        String columnLine = "-".repeat(maxColumnWidth + 2);
        String columnPadding = " ".repeat(maxColumnWidth);
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        for (int col = 0; col <= bean.numColumns(); ++col) {
            sb.append(columnLine.substring(0, columnWidth[col] + 2));
            sb.append("+");
            if (col != bean.numColumns()) continue;
            sb.append(String.format("%n", new Object[0]));
        }
        for (int row = 0; row <= bean.numRows(); ++row) {
            int col;
            sb.append("|");
            for (col = 0; col <= bean.numColumns(); ++col) {
                sb.append(" ");
                sb.append((cells[row][col] + columnPadding).substring(0, columnWidth[col]));
                sb.append(" |");
                if (col != bean.numColumns()) continue;
                sb.append(String.format("%n", new Object[0]));
            }
            sb.append("+");
            for (col = 0; col <= bean.numColumns(); ++col) {
                sb.append(columnLine.substring(0, columnWidth[col] + 2));
                sb.append("+");
                if (col != bean.numColumns()) continue;
                sb.append(String.format("%n", new Object[0]));
            }
        }
        return sb.toString();
    }

    @Override
    protected String getBrowserTitle() {
        return Bundle.getMessage("LogixNG_Table_Browse_Title");
    }

    @Override
    protected String getAddTitleKey() {
        return "TitleLogixNGTableTable";
    }

    @Override
    protected String getCreateButtonHintKey() {
        return "LogixNGTableCreateButtonHint";
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.LogixNGTableTable";
    }

    private JButton createFileChooser() {
        JButton selectFileButton = new JButton("...");
        selectFileButton.setMaximumSize(selectFileButton.getPreferredSize());
        selectFileButton.setToolTipText(Bundle.getMessage("LogixNG_FileButtonHint"));
        selectFileButton.addActionListener(e -> {
            JmriJFileChooser csvFileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
            csvFileChooser.setFileFilter(new FileNameExtensionFilter("CSV files", "csv", "txt", "tsv"));
            csvFileChooser.rescanCurrentDirectory();
            int retVal = csvFileChooser.showOpenDialog(null);
            if (retVal == 0) {
                try {
                    this._csvFileName.setText(FileUtil.getPortableFilename(csvFileChooser.getSelectedFile().getCanonicalPath()));
                }
                catch (IOException ex) {
                    log.error("exception setting file location", (Throwable)ex);
                    this._csvFileName.setText("");
                }
            }
        });
        return selectFileButton;
    }

    @Override
    protected JPanel makeAddFrame(String titleId, String startMessageId) {
        this.addLogixNGFrame = new JmriJFrame(Bundle.getMessage(titleId));
        this.addLogixNGFrame.addHelpMenu("package.jmri.jmrit.beantable.LogixNGTableTable", true);
        this.addLogixNGFrame.setLocation(50, 30);
        Container contentPane = this.addLogixNGFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._sysNameLabel, c);
        this._sysNameLabel.setLabelFor(this._systemName);
        c.gridy = 1;
        p.add((Component)this._userNameLabel, c);
        this._userNameLabel.setLabelFor(this._addUserName);
        c.gridy = 2;
        this._csvLabel.setLabelFor(null);
        p.add((Component)this._csvLabel, c);
        JPanel csvPanel = new JPanel();
        csvPanel.setLayout(new FlowLayout());
        this._csvGroup.add(this._csvTabbed);
        this._csvGroup.add(this._csvComma);
        this._csvGroup.add(this._csvSemicolon);
        this._csvTabbed.setSelected(true);
        csvPanel.add(this._csvTabbed);
        csvPanel.add(this._csvComma);
        csvPanel.add(this._csvSemicolon);
        c.gridx = 1;
        p.add((Component)csvPanel, c);
        c.gridx = 0;
        c.gridy = 3;
        p.add((Component)new JLabel(Bundle.getMessage("LogixNG_CsvFileName")), c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._systemName, c);
        c.gridy = 1;
        p.add((Component)this._addUserName, c);
        c.gridy = 3;
        this.createFileChooser();
        p.add((Component)this.createFileChooser(), c);
        c.gridx = 2;
        c.gridwidth = 0;
        p.add((Component)this._csvFileName, c);
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        p.add((Component)this._autoSystemName, c);
        this._buttonGroup.add(this._typeExternalTable);
        this._buttonGroup.add(this._typeInternalTable);
        this._typeExternalTable.setSelected(true);
        this._typeInternalTable.setEnabled(false);
        this._addUserName.setToolTipText(Bundle.getMessage("LogixNGUserNameHint"));
        this._systemName.setToolTipText(Bundle.getMessage("LogixNGSystemNameHint"));
        contentPane.add(p);
        JPanel panel98 = new JPanel();
        panel98.setLayout(new FlowLayout());
        JPanel panel99 = new JPanel();
        panel99.setLayout(new BoxLayout(panel99, 1));
        panel99.add((Component)this._typeExternalTable, c);
        panel99.add((Component)this._typeInternalTable, c);
        panel98.add(panel99);
        contentPane.add(panel98);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        JLabel message1 = new JLabel(Bundle.getMessage(startMessageId + "LogixNGTableMessage1"));
        panel31.add(message1);
        JPanel panel32 = new JPanel();
        JLabel message2 = new JLabel(Bundle.getMessage(startMessageId + "LogixNGTableMessage2"));
        panel32.add(message2);
        panel3.add(panel31);
        panel3.add(panel32);
        contentPane.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(this::cancelAddPressed);
        cancel.setToolTipText(Bundle.getMessage("CancelLogixNGTableButtonHint"));
        this.addLogixNGFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LogixNGTableTableAction.this.cancelAddPressed(null);
            }
        });
        contentPane.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        return panel5;
    }

    @Override
    protected void getListenerRefsIncludingChildren(NamedTable table, List<String> list) {
    }

    @Override
    protected boolean hasChildren(NamedTable table) {
        return false;
    }
}

