/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.Block;
import jmri.BlockManager;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Route;
import jmri.RouteManager;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Transit;
import jmri.TransitManager;
import jmri.TransitSection;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.blockboss.BlockBossLogic;
import jmri.jmrit.blockboss.BlockBossLogicProvider;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.IndicatorTrackIcon;
import jmri.jmrit.display.IndicatorTurnoutIcon;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.SignalHeadIcon;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.picker.PickListModel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Maintenance {
    static final ResourceBundle rbm = ResourceBundle.getBundle("jmri.jmrit.beantable.MaintenanceBundle");
    private static final Logger log = LoggerFactory.getLogger(Maintenance.class);

    public static void deviceReportPressed(String devName, Frame parent) {
        JTextArea text = new JTextArea(25, 50);
        text.setEditable(false);
        text.setTabSize(4);
        Maintenance.search(devName, text);
        JScrollPane scrollPane = new JScrollPane(text);
        Maintenance.makeDialog(scrollPane, null, parent, rbm.getString("CrossReferenceTitle"));
    }

    private static List<String> getSystemNameList(Manager<?> mgr) {
        ArrayList systemNameList = new ArrayList();
        mgr.getNamedBeanSet().forEach(b -> systemNameList.add(b.getSystemName()));
        return Collections.unmodifiableList(systemNameList);
    }

    public static void findOrphansPressed(Frame parent) {
        ArrayList<String> display = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (String name : Maintenance.getSystemNameList(InstanceManager.sensorManagerInstance())) {
            if (Maintenance.search(name, null) || name.equals("ISCLOCKRUNNING")) continue;
            display.add(MessageFormat.format(rbm.getString("OrphanName"), Maintenance.getTypeAndNames(name)));
            names.add(name);
        }
        for (String name : Maintenance.getSystemNameList(InstanceManager.turnoutManagerInstance())) {
            if (Maintenance.search(name, null)) continue;
            display.add(MessageFormat.format(rbm.getString("OrphanName"), Maintenance.getTypeAndNames(name)));
            names.add(name);
        }
        for (String name : Maintenance.getSystemNameList(InstanceManager.getDefault(SignalHeadManager.class))) {
            if (Maintenance.search(name, null)) continue;
            display.add(MessageFormat.format(rbm.getString("OrphanName"), Maintenance.getTypeAndNames(name)));
            names.add(name);
        }
        for (String name : Maintenance.getSystemNameList(InstanceManager.lightManagerInstance())) {
            if (Maintenance.search(name, null)) continue;
            display.add(MessageFormat.format(rbm.getString("OrphanName"), Maintenance.getTypeAndNames(name)));
            names.add(name);
        }
        for (String name : Maintenance.getSystemNameList(InstanceManager.getDefault(ConditionalManager.class))) {
            if (Maintenance.search(name, null)) continue;
            display.add(MessageFormat.format(rbm.getString("OrphanName"), Maintenance.getTypeAndNames(name)));
            names.add(name);
        }
        for (String name : Maintenance.getSystemNameList(InstanceManager.getDefault(SectionManager.class))) {
            if (Maintenance.search(name, null)) continue;
            display.add(MessageFormat.format(rbm.getString("OrphanName"), Maintenance.getTypeAndNames(name)));
            names.add(name);
        }
        for (String name : Maintenance.getSystemNameList(InstanceManager.getDefault(BlockManager.class))) {
            if (Maintenance.search(name, null)) continue;
            display.add(MessageFormat.format(rbm.getString("OrphanName"), Maintenance.getTypeAndNames(name)));
            names.add(name);
        }
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (int i = 0; i < display.size(); ++i) {
            listModel.addElement((String)display.get(i));
        }
        JList<String> list = new JList<String>(listModel);
        list.setSelectionMode(1);
        JButton button = new JButton(Bundle.getMessage("ButtonDelete"));
        button.setToolTipText(rbm.getString("OrphanDeleteHint"));
        JScrollPane scrollPane = new JScrollPane(list);
        class SearchListener
        implements ActionListener {
            JList<String> list;
            List<String> n;

            SearchListener(JList<String> list, List<String> name) {
                this.list = list;
                this.n = name;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = this.list.getMaxSelectionIndex();
                if (index < 0) {
                    JmriJOptionPane.showMessageDialog(null, rbm.getString("OrphanDeleteHint"), rbm.getString("DeleteTitle"), 1);
                    return;
                }
                int min = this.list.getMinSelectionIndex();
                DefaultListModel model = (DefaultListModel)this.list.getModel();
                while (index >= min) {
                    String[] names = Maintenance.getTypeAndNames(this.n.get(index));
                    if (names[0].equals("Sensor")) {
                        Sensor s = InstanceManager.getDefault(SensorManager.class).getBySystemName(names[2]);
                        if (s == null) {
                            s = InstanceManager.getDefault(SensorManager.class).getBySystemName(names[1]);
                        }
                        if (s != null) {
                            InstanceManager.getDefault(SensorManager.class).deregister(s);
                        }
                    } else if (names[0].equals("Turnout")) {
                        Turnout t = InstanceManager.getDefault(TurnoutManager.class).getBySystemName(names[2]);
                        if (t == null) {
                            t = InstanceManager.getDefault(TurnoutManager.class).getBySystemName(names[1]);
                        }
                        if (t != null) {
                            InstanceManager.getDefault(TurnoutManager.class).deregister(t);
                        }
                    } else if (names[0].equals("SignalHead")) {
                        SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(names[2]);
                        if (sh == null) {
                            sh = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(names[1]);
                        }
                        if (sh != null) {
                            InstanceManager.getDefault(SignalHeadManager.class).deregister(sh);
                        }
                    } else if (names[0].equals("Light")) {
                        Light l = InstanceManager.getDefault(LightManager.class).getBySystemName(names[2]);
                        if (l == null) {
                            l = InstanceManager.getDefault(LightManager.class).getBySystemName(names[1]);
                        }
                        if (l != null) {
                            InstanceManager.getDefault(LightManager.class).deregister(l);
                        }
                    } else if (names[0].equals("Conditional")) {
                        Conditional c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(names[2]);
                        if (c == null) {
                            c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(names[1]);
                        }
                        if (c != null) {
                            InstanceManager.getDefault(ConditionalManager.class).deregister(c);
                        }
                    } else if (names[0].equals("Section")) {
                        Section sec = (Section)InstanceManager.getDefault(SectionManager.class).getBySystemName(names[2]);
                        if (sec == null) {
                            sec = (Section)InstanceManager.getDefault(SectionManager.class).getBySystemName(names[1]);
                        }
                        if (sec != null) {
                            InstanceManager.getDefault(SectionManager.class).deregister(sec);
                        }
                    } else if (names[0].equals("Block")) {
                        Block b = (Block)InstanceManager.getDefault(BlockManager.class).getBySystemName(names[2]);
                        if (b == null) {
                            b = (Block)InstanceManager.getDefault(BlockManager.class).getBySystemName(names[1]);
                        }
                        if (b != null) {
                            InstanceManager.getDefault(BlockManager.class).deregister(b);
                        }
                    }
                    model.remove(index);
                    this.n.remove(index);
                    --index;
                }
                if (++index >= model.getSize()) {
                    index = model.getSize() - 1;
                }
                if (index >= 0) {
                    this.list.setSelectedIndex(index);
                }
            }
        }
        button.addActionListener(new SearchListener(list, names));
        button.setMaximumSize(button.getPreferredSize());
        Maintenance.makeDialog(scrollPane, button, parent, rbm.getString("OrphanTitle"));
    }

    public static void findEmptyPressed(Frame parent) {
        ArrayList<String> display = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        log.debug("findEmptyPressed");
        Iterator<String> iter = Maintenance.getSystemNameList(InstanceManager.getDefault(ConditionalManager.class)).iterator();
        ConditionalManager cm = InstanceManager.getDefault(ConditionalManager.class);
        while (iter.hasNext()) {
            List<ConditionalVariable> variableList;
            String name = iter.next();
            Conditional c = cm.getBySystemName(name);
            if (c == null || !(variableList = c.getCopyOfStateVariables()).isEmpty()) continue;
            String userName = c.getUserName();
            display.add(MessageFormat.format(rbm.getString("OrphanName"), "Conditional", userName, name));
            names.add(name);
        }
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (int i = 0; i < display.size(); ++i) {
            listModel.addElement((String)display.get(i));
        }
        JList<String> list = new JList<String>(listModel);
        list.setSelectionMode(1);
        JButton button = new JButton(Bundle.getMessage("ButtonDelete"));
        button.setToolTipText(rbm.getString("OrphanDeleteHint") + Bundle.getMessage("ButtonDelete"));
        JScrollPane scrollPane = new JScrollPane(list);
        class EmptyListener
        implements ActionListener {
            JList<String> list;
            List<String> name;

            EmptyListener(JList<String> list, List<String> name) {
                this.list = list;
                this.name = name;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = this.list.getMaxSelectionIndex();
                if (index < 0) {
                    JmriJOptionPane.showMessageDialog(null, rbm.getString("OrphanDeleteHint"), rbm.getString("DeleteTitle"), 1);
                    return;
                }
                int min = this.list.getMinSelectionIndex();
                DefaultListModel model = (DefaultListModel)this.list.getModel();
                while (index >= min) {
                    String[] names = Maintenance.getTypeAndNames(this.name.get(index));
                    model.remove(index);
                    Conditional c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(names[2]);
                    if (c == null) continue;
                    Logix x = InstanceManager.getDefault(ConditionalManager.class).getParentLogix(names[2]);
                    if (x != null) {
                        x.deActivateLogix();
                        x.deleteConditional(names[2]);
                        x.activateLogix();
                    }
                    InstanceManager.getDefault(ConditionalManager.class).deregister(c);
                    this.name.remove(index);
                    --index;
                }
                if (++index >= model.getSize()) {
                    index = model.getSize() - 1;
                }
                if (index >= 0) {
                    this.list.setSelectedIndex(index);
                }
            }
        }
        button.addActionListener(new EmptyListener(list, names));
        button.setMaximumSize(button.getPreferredSize());
        Maintenance.makeDialog(scrollPane, button, parent, rbm.getString("EmptyConditionalTitle"));
    }

    @Nonnull
    static String[] getTypeAndNames(@Nonnull String name) {
        log.debug("getTypeAndNames for \"{}\"", (Object)name);
        String[] result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(SensorManager.class), "Sensor", name);
        if (result != null) {
            return result;
        }
        result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(TurnoutManager.class), "Turnout", name);
        if (result != null) {
            return result;
        }
        result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(LightManager.class), "Light", name);
        if (result != null) {
            return result;
        }
        result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(SignalHeadManager.class), "SignalHead", name);
        if (result != null) {
            return result;
        }
        result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(ConditionalManager.class), "Conditional", name);
        if (result != null) {
            return result;
        }
        result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(BlockManager.class), "Block", name);
        if (result != null) {
            return result;
        }
        result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(SectionManager.class), "Section", name);
        if (result != null) {
            return result;
        }
        result = Maintenance.checkForOneTypeAndNames(InstanceManager.getDefault(OBlockManager.class), "OBlock", name);
        if (result != null) {
            return result;
        }
        return new String[]{"", name, name, "0"};
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null return for normal (no error) case is easy to check, and this is a really wierd array")
    private static String[] checkForOneTypeAndNames(@Nonnull Manager<? extends NamedBean> manager, @Nonnull String type, @Nonnull String beanName) {
        NamedBean bean = manager.getBySystemName(beanName);
        if (bean != null) {
            return new String[]{type, bean.getUserName(), bean.getSystemName(), Integer.toString(bean.getNumPropertyChangeListeners())};
        }
        bean = manager.getByUserName(beanName);
        if (bean != null) {
            return new String[]{type, bean.getUserName(), bean.getSystemName(), Integer.toString(bean.getNumPropertyChangeListeners())};
        }
        return null;
    }

    static boolean testName(String name, boolean found, String[] names, String line1, String line2, String line, StringBuilder tempText) {
        if (name == null) {
            return false;
        }
        String sysName = names[2];
        String userName = names[1];
        if (name.equals(sysName) || name.equals(userName)) {
            if (!found) {
                if (line1 != null) {
                    tempText.append(line1);
                }
                if (line2 != null) {
                    tempText.append(line2);
                }
            }
            tempText.append(line);
            return true;
        }
        return false;
    }

    static boolean search(String name, JTextArea text) {
        String line;
        String line1;
        String line2;
        TransitSection transitSection;
        Object line3;
        StringBuilder tempText;
        String[] names = Maintenance.getTypeAndNames(name);
        if (log.isDebugEnabled()) {
            log.debug("search for {} as {} \"{}\" ({})", new Object[]{name, names[0], names[1], names[2]});
        }
        if (names[0].length() == 0 && text != null) {
            text.append(MessageFormat.format(rbm.getString("ElementNotFound"), names));
            return false;
        }
        if (text != null) {
            text.append(MessageFormat.format(rbm.getString("ReferenceFollows"), names));
        }
        String sysName = names[2];
        String userName = names[1];
        int referenceCount = 0;
        boolean found = false;
        boolean empty = true;
        for (String sName : Maintenance.getSystemNameList(InstanceManager.getDefault(LogixManager.class))) {
            Logix x = InstanceManager.getDefault(LogixManager.class).getBySystemName(sName);
            if (x == null) {
                log.error("Error getting Logix  - {}", (Object)sName);
                break;
            }
            tempText = new StringBuilder();
            String uName = x.getUserName();
            String line12 = MessageFormat.format(rbm.getString("ReferenceTitle"), "", Bundle.getMessage("BeanNameLogix"), uName, sName);
            for (int i = 0; i < x.getNumConditionals(); ++i) {
                sName = x.getConditionalByNumberOrder(i);
                if (sName == null) {
                    log.error("Null conditional system name");
                    break;
                }
                Conditional c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(sName);
                if (c == null) {
                    log.error("Invalid conditional system name - {}", (Object)sName);
                    break;
                }
                uName = c.getUserName();
                String line22 = MessageFormat.format(rbm.getString("ReferenceTitle"), "\t", Bundle.getMessage("BeanNameConditional"), uName, sName);
                String line4 = MessageFormat.format(rbm.getString("ConditionalReference"), "\t");
                if ((sysName.equals(sName) || userName != null && userName.length() > 0 && userName.equals(uName)) && Maintenance.testName(sysName, found, names, line12, null, line4, tempText)) {
                    found = true;
                    ++referenceCount;
                }
                List<ConditionalVariable> variableList = c.getCopyOfStateVariables();
                for (int k = 0; k < variableList.size(); ++k) {
                    ConditionalVariable v = variableList.get(k);
                    line4 = MessageFormat.format(rbm.getString("VariableReference"), "\t\t", v.getTestTypeString(), v.getDataString());
                    if (!Maintenance.testName(v.getName(), found, names, line12, line22, line4, tempText)) continue;
                    found = true;
                    ++referenceCount;
                }
                List<ConditionalAction> actionList = c.getCopyOfActions();
                for (int k = 0; k < actionList.size(); ++k) {
                    ConditionalAction a = actionList.get(k);
                    line4 = MessageFormat.format(rbm.getString("ActionReference"), "\t\t", a.getTypeString(), a.getOptionString(false), a.getActionDataString());
                    if (!Maintenance.testName(a.getDeviceName(), found, names, line12, line22, line4, tempText)) continue;
                    found = true;
                    ++referenceCount;
                }
                if (text == null || !found) continue;
                text.append(tempText.toString());
                tempText = new StringBuilder();
                found = false;
                empty = false;
                line12 = null;
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append("\t" + MessageFormat.format(rbm.getString("NoReference"), "Logix"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        OBlockManager oBlockManager = InstanceManager.getDefault(OBlockManager.class);
        for (String sName : Maintenance.getSystemNameList(oBlockManager)) {
            OBlock block = (OBlock)oBlockManager.getBySystemName(sName);
            if (block == null) continue;
            String uName = block.getUserName();
            String line13 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", Bundle.getMessage("BeanNameOBlock"), uName, sName);
            Sensor sensor = block.getSensor();
            if (sensor != null) {
                line3 = MessageFormat.format(rbm.getString("OBlockSensor"), "\t");
                if (Maintenance.testName(sensor.getSystemName(), found, names, line13, null, (String)line3, tempText)) {
                    found = true;
                    ++referenceCount;
                }
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "OBlock"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
        for (String sName : Maintenance.getSystemNameList(routeManager)) {
            int i;
            Route r = routeManager.getBySystemName(sName);
            if (r == null) {
                log.error("Error getting Route  - {}", (Object)sName);
                break;
            }
            String uName = r.getUserName();
            String line14 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", Bundle.getMessage("BeanNameRoute"), uName, sName);
            for (int i2 = 0; i2 < 3; ++i2) {
                String line5 = "\t" + MessageFormat.format(rbm.getString("ControlReference"), Bundle.getMessage("BeanNameSensor"));
                if (!Maintenance.testName(r.getRouteSensorName(i2), found, names, line14, null, line5, tempText)) continue;
                found = true;
                ++referenceCount;
            }
            line3 = MessageFormat.format("TurnoutsAlignedSensor", Bundle.getMessage("BeanNameSensor"));
            if (Maintenance.testName(r.getTurnoutsAlignedSensor(), found, names, line14, null, (String)line3, tempText)) {
                found = true;
                ++referenceCount;
            }
            line3 = "\t" + MessageFormat.format(rbm.getString("ControlReference"), Bundle.getMessage("BeanNameTurnout"));
            if (Maintenance.testName(r.getControlTurnout(), found, names, line14, null, (String)line3, tempText)) {
                found = true;
                ++referenceCount;
            }
            line3 = MessageFormat.format("LockControlTurnout", Bundle.getMessage("BeanNameTurnout"));
            if (Maintenance.testName(r.getLockControlTurnout(), found, names, line14, null, (String)line3, tempText)) {
                found = true;
                ++referenceCount;
            }
            for (i = 0; i < r.getNumOutputTurnouts(); ++i) {
                line3 = "\t" + MessageFormat.format(rbm.getString("OutputReference"), Bundle.getMessage("BeanNameTurnout"));
                if (!Maintenance.testName(r.getOutputTurnoutByIndex(i), found, names, line14, null, (String)line3, tempText)) continue;
                found = true;
                ++referenceCount;
            }
            for (i = 0; i < r.getNumOutputSensors(); ++i) {
                line3 = "\t" + MessageFormat.format(rbm.getString("OutputReference"), Bundle.getMessage("BeanNameSensor"));
                if (!Maintenance.testName(r.getOutputSensorByIndex(i), found, names, line14, null, (String)line3, tempText)) continue;
                found = true;
                ++referenceCount;
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "Route"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        TransitManager transitManager = InstanceManager.getDefault(TransitManager.class);
        for (String sName : Maintenance.getSystemNameList(transitManager)) {
            Transit transit = (Transit)transitManager.getBySystemName(sName);
            if (transit == null) {
                log.error("Error getting Transit - {}", (Object)sName);
                break;
            }
            String uName = transit.getUserName();
            String line15 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", Bundle.getMessage("BeanNameTransit"), uName, sName);
            ArrayList<TransitSection> sectionList = transit.getTransitSectionList();
            for (int i = 0; i < sectionList.size(); ++i) {
                transitSection = (TransitSection)sectionList.get(i);
                Section section = transitSection.getSection();
                uName = section.getUserName();
                sName = section.getSystemName();
                String line23 = MessageFormat.format(rbm.getString("ReferenceTitle"), "\t", rbm.getString("TransitSection"), uName, sName);
                if (sName.equals(sysName) || uName.equals(userName)) {
                    tempText.append(line15);
                    tempText.append(line23);
                    tempText.append(MessageFormat.format(rbm.getString("SectionReference"), "\t\t"));
                    found = true;
                    ++referenceCount;
                }
                line2 = MessageFormat.format(rbm.getString("ForwardBlocking"), "\t\t");
                if (Maintenance.testName(section.getForwardBlockingSensorName(), found, names, line15, line23, line2, tempText)) {
                    found = true;
                    ++referenceCount;
                }
                line2 = MessageFormat.format(rbm.getString("ForwardStopping"), "\t\t");
                if (Maintenance.testName(section.getForwardStoppingSensorName(), found, names, line15, line23, line2, tempText)) {
                    found = true;
                    ++referenceCount;
                }
                line2 = MessageFormat.format(rbm.getString("ReverseBlocking"), "\t\t");
                if (Maintenance.testName(section.getReverseBlockingSensorName(), found, names, line15, line23, line2, tempText)) {
                    found = true;
                    ++referenceCount;
                }
                line2 = MessageFormat.format(rbm.getString("ReverseStopping"), "\t\t");
                if (Maintenance.testName(section.getReverseStoppingSensorName(), found, names, line15, line23, line2, tempText)) {
                    found = true;
                    ++referenceCount;
                }
                List<Block> blockList = section.getBlockList();
                for (int k = 0; k < blockList.size(); ++k) {
                    Sensor sensor;
                    Block block = blockList.get(k);
                    sName = block.getSystemName();
                    uName = block.getUserName();
                    tempText.append(MessageFormat.format(rbm.getString("ReferenceTitle"), "\t\t", Bundle.getMessage("BeanNameBlock"), uName, sName));
                    if (sName.equals(sysName) || uName.equals(userName)) {
                        tempText.append(MessageFormat.format(rbm.getString("BlockReference"), "\t\t"));
                        found = true;
                        ++referenceCount;
                    }
                    if ((sensor = block.getSensor()) == null) continue;
                    line2 = MessageFormat.format(rbm.getString("BlockSensor"), "\t\t");
                    if (!Maintenance.testName(sensor.getSystemName(), found, names, line15, line23, line2, tempText)) continue;
                    found = true;
                    ++referenceCount;
                }
                if (text == null || !found) continue;
                text.append(tempText.toString());
                tempText = new StringBuilder();
                found = false;
                empty = false;
                line15 = null;
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "Transit"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        SectionManager sectionManager = InstanceManager.getDefault(SectionManager.class);
        ArrayList<String> sysNameList = new ArrayList<String>(Maintenance.getSystemNameList(sectionManager));
        transitManager = InstanceManager.getDefault(TransitManager.class);
        for (String sName : Maintenance.getSystemNameList(transitManager)) {
            Transit transit = (Transit)transitManager.getBySystemName(sName);
            if (transit == null) continue;
            ArrayList<TransitSection> sectionList = transit.getTransitSectionList();
            for (int i = 0; i < sectionList.size(); ++i) {
                transitSection = (TransitSection)sectionList.get(i);
                Section section = transitSection.getSection();
                sysNameList.remove(section.getSystemName());
            }
        }
        for (String sName : sysNameList) {
            Section section = (Section)sectionManager.getBySystemName(sName);
            if (section == null) {
                log.error("Error getting Section - {}", (Object)sName);
                break;
            }
            String uName = section.getUserName();
            String line16 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", Bundle.getMessage("BeanNameSection"), uName, sName);
            if (sName.equals(sysName) || uName.equals(userName)) {
                tempText.append(MessageFormat.format(rbm.getString("SectionReference"), "\t"));
                found = true;
                ++referenceCount;
            }
            String line6 = MessageFormat.format(rbm.getString("ForwardBlocking"), "\t");
            if (Maintenance.testName(section.getForwardBlockingSensorName(), found, names, line16, null, line6, tempText)) {
                found = true;
                ++referenceCount;
            }
            line6 = MessageFormat.format(rbm.getString("ForwardStopping"), "\t");
            if (Maintenance.testName(section.getForwardStoppingSensorName(), found, names, line16, null, line6, tempText)) {
                found = true;
                ++referenceCount;
            }
            line6 = MessageFormat.format(rbm.getString("ReverseBlocking"), "\t");
            if (Maintenance.testName(section.getReverseBlockingSensorName(), found, names, line16, null, line6, tempText)) {
                found = true;
                ++referenceCount;
            }
            line6 = MessageFormat.format(rbm.getString("ReverseStopping"), "\t");
            if (Maintenance.testName(section.getReverseStoppingSensorName(), found, names, line16, null, line6, tempText)) {
                found = true;
                ++referenceCount;
            }
            List<Block> blockList = section.getBlockList();
            for (int k = 0; k < blockList.size(); ++k) {
                Sensor sensor;
                Block block = blockList.get(k);
                sName = block.getSystemName();
                uName = block.getUserName();
                String line24 = MessageFormat.format(rbm.getString("ReferenceTitle"), "\t", Bundle.getMessage("BeanNameBlock"), uName, sName);
                if (sName.equals(sysName) || uName != null && uName.equals(userName)) {
                    tempText.append(line24);
                    tempText.append(MessageFormat.format(rbm.getString("BlockReference"), "\t"));
                    found = true;
                    ++referenceCount;
                }
                if ((sensor = block.getSensor()) == null) continue;
                line6 = MessageFormat.format(rbm.getString("BlockSensor"), "\t\t");
                if (!Maintenance.testName(sensor.getSystemName(), found, names, line16, line24, line6, tempText)) continue;
                found = true;
                ++referenceCount;
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "Section"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        BlockManager blockManager = InstanceManager.getDefault(BlockManager.class);
        sysNameList = new ArrayList<String>(Maintenance.getSystemNameList(blockManager));
        sectionManager = InstanceManager.getDefault(SectionManager.class);
        for (String sName : Maintenance.getSystemNameList(sectionManager)) {
            Section section = (Section)sectionManager.getBySystemName(sName);
            if (section == null) continue;
            for (Block block : section.getBlockList()) {
                sysNameList.remove(block.getSystemName());
            }
        }
        for (String sName : sysNameList) {
            Sensor s;
            Block b = (Block)blockManager.getBySystemName(sName);
            if (b == null) continue;
            String uName = b.getUserName();
            String line17 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", Bundle.getMessage("BeanNameBlock"), uName, sName);
            if (sName.equals(sysName) || uName != null && uName.equals(userName)) {
                tempText.append(line17);
                tempText.append(MessageFormat.format(rbm.getString("BlockReference"), "\t"));
                found = true;
                ++referenceCount;
            }
            if ((s = b.getSensor()) != null) {
                String line7 = MessageFormat.format(rbm.getString("BlockSensor"), "\t\t");
                if (Maintenance.testName(s.getSystemName(), found, names, line17, null, line7, tempText)) {
                    found = true;
                    ++referenceCount;
                }
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "Block"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        for (String sName : Maintenance.getSystemNameList(lbm)) {
            LayoutBlock lb = (LayoutBlock)lbm.getBySystemName(sName);
            if (lb == null) {
                log.error("Error getting LayoutBlock - {}", (Object)sName);
                break;
            }
            String uName = lb.getUserName();
            String line18 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", rbm.getString("LayoutBlock"), uName, sName);
            Sensor s = lb.getOccupancySensor();
            if (s != null) {
                line2 = MessageFormat.format(rbm.getString("OccupancySensor"), "\t\t");
                if (Maintenance.testName(s.getSystemName(), found, names, line18, null, line2, tempText)) {
                    found = true;
                    ++referenceCount;
                }
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "LayoutBlock"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        Enumeration<BlockBossLogic> enumeration = Collections.enumeration(InstanceManager.getDefault(BlockBossLogicProvider.class).provideAll());
        while (enumeration.hasMoreElements()) {
            BlockBossLogic bbl = enumeration.nextElement();
            String sName = bbl.getName();
            String uName = bbl.getDrivenSignal();
            String line19 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", rbm.getString("BlockBossLogic"), uName, sName);
            if (uName.equals(sysName) || uName.equals(userName) || sName.equals(sysName) || sName.equals(userName)) {
                tempText.append(line19);
                tempText.append(MessageFormat.format(rbm.getString("SignalReference"), "\t"));
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "1\t");
            if (Maintenance.testName(bbl.getSensor1(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "2\t");
            if (Maintenance.testName(bbl.getSensor2(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "3\t");
            if (Maintenance.testName(bbl.getSensor3(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "4\t");
            if (Maintenance.testName(bbl.getSensor4(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "5\t");
            if (Maintenance.testName(bbl.getSensor5(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchTurnoutReference"), "\t");
            if (Maintenance.testName(bbl.getTurnout(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSignalReference"), "1\t");
            if (Maintenance.testName(bbl.getWatchedSignal1(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchTurnoutReference"), "1Alt\t");
            if (Maintenance.testName(bbl.getWatchedSignal1Alt(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchTurnoutReference"), "2\t");
            if (Maintenance.testName(bbl.getWatchedSignal2(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchTurnoutReference"), "2Alt\t");
            if (Maintenance.testName(bbl.getWatchedSignal2Alt(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "1\t");
            if (Maintenance.testName(bbl.getWatchedSensor1(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "1Alt\t");
            if (Maintenance.testName(bbl.getWatchedSensor1Alt(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "2\t");
            if (Maintenance.testName(bbl.getWatchedSensor2(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            line2 = MessageFormat.format(rbm.getString("WatchSensorReference"), "2Alt\t");
            if (Maintenance.testName(bbl.getWatchedSensor2Alt(), found, names, line19, null, line2, tempText)) {
                found = true;
                ++referenceCount;
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "BlockBossLogic"));
            } else {
                text.append("\n");
            }
        }
        tempText = new StringBuilder();
        found = false;
        empty = true;
        ConditionalManager conditionalManager = InstanceManager.getDefault(ConditionalManager.class);
        sysNameList = new ArrayList<String>(Maintenance.getSystemNameList(conditionalManager));
        for (String sName : Maintenance.getSystemNameList(InstanceManager.getDefault(LogixManager.class))) {
            Logix x = InstanceManager.getDefault(LogixManager.class).getBySystemName(sName);
            if (x == null) continue;
            for (int i = 0; i < x.getNumConditionals(); ++i) {
                sName = x.getConditionalByNumberOrder(i);
                sysNameList.remove(sName);
            }
        }
        for (String sName : sysNameList) {
            Conditional c = conditionalManager.getBySystemName(sName);
            if (c == null) {
                log.error("Error getting Condition - {}", (Object)sName);
                break;
            }
            String uName = c.getUserName();
            line1 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", Bundle.getMessage("BeanNameConditional"), uName, sName);
            if (sName.equals(sysName) || uName.equals(userName)) {
                tempText.append(line1);
                tempText.append(MessageFormat.format(rbm.getString("ConditionalReference"), "\t"));
                found = true;
            }
            List<ConditionalVariable> variableList = c.getCopyOfStateVariables();
            for (int k = 0; k < variableList.size(); ++k) {
                ConditionalVariable v = variableList.get(k);
                line = MessageFormat.format(rbm.getString("VariableReference"), "\t\t", v.getTestTypeString(), v.getDataString());
                if (!Maintenance.testName(v.getName(), found, names, line1, null, line, tempText)) continue;
                found = true;
            }
            List<ConditionalAction> actionList = c.getCopyOfActions();
            for (int k = 0; k < actionList.size(); ++k) {
                ConditionalAction a = actionList.get(k);
                String line8 = MessageFormat.format(rbm.getString("ActionReference"), "\t\t", a.getTypeString(), a.getOptionString(false), a.getActionDataString());
                if (!Maintenance.testName(a.getDeviceName(), found, names, line1, null, line8, tempText)) continue;
                found = true;
            }
            if (text == null || !found) continue;
            text.append(tempText.toString());
            tempText = new StringBuilder();
            found = false;
            empty = false;
            line1 = null;
        }
        if (text != null) {
            if (empty) {
                text.append(MessageFormat.format(rbm.getString("NoReference"), "Conditional"));
            }
            text.append("\n");
        }
        found = false;
        empty = true;
        SortedSet<Editor> panelList = InstanceManager.getDefault(EditorManager.class).getAll();
        for (Editor panelEditor : panelList) {
            name = panelEditor.getTitle();
            line1 = MessageFormat.format(rbm.getString("ReferenceTitle"), " ", rbm.getString("Panel"), name, name);
            List<Positionable> contents = panelEditor.getContents();
            for (int k = 0; k < contents.size(); ++k) {
                String line9;
                Positionable o = contents.get(k);
                if (o.getClass().getName().equals("jmri.jmrit.display.SensorIcon")) {
                    name = ((SensorIcon)o).getSensor().getSystemName();
                    if (Maintenance.testName(name, found, names, line1, null, line = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("BeanNameSensor")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                } else if (o.getClass().getName().equals("jmri.jmrit.display.TurnoutIcon")) {
                    name = ((TurnoutIcon)o).getTurnout().getSystemName();
                    if (Maintenance.testName(name, found, names, line1, null, line = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("BeanNameTurnout")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                } else if (o.getClass().getName().equals("jmri.jmrit.display.SignalHeadIcon")) {
                    name = ((SignalHeadIcon)o).getSignalHead().getSystemName();
                    if (Maintenance.testName(name, found, names, line1, null, line = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("BeanNameSignalHead")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                } else if (o.getClass().getName().equals("jmri.jmrit.display.MultiSensorIcon")) {
                    MultiSensorIcon msi = (MultiSensorIcon)o;
                    for (int j = 0; j < msi.getNumEntries(); ++j) {
                        name = msi.getSensorName(j);
                        if (!Maintenance.testName(name, found, names, line1, null, line9 = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("MultiSensor")), tempText)) continue;
                        found = true;
                        ++referenceCount;
                    }
                } else if (o.getClass().getName().equals("jmri.jmrit.display.IndicatorTurnoutIcon")) {
                    OBlock block;
                    Sensor sensor;
                    String line10;
                    IndicatorTurnoutIcon ito = (IndicatorTurnoutIcon)o;
                    name = ito.getTurnout().getSystemName();
                    if (Maintenance.testName(name, found, names, line1, null, line10 = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("IndicatorTO")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                    if ((sensor = ito.getOccSensor()) != null && Maintenance.testName(name = sensor.getSystemName(), found, names, line1, null, line10 = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("IndicatorTO")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                    if ((block = ito.getOccBlock()) != null && (sensor = block.getSensor()) != null && Maintenance.testName(name = sensor.getSystemName(), found, names, line1, null, line10 = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("IndicatorTO")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                } else if (o.getClass().getName().equals("jmri.jmrit.display.IndicatorTrackIcon")) {
                    String line11;
                    OBlock block;
                    IndicatorTrackIcon track = (IndicatorTrackIcon)o;
                    Sensor sensor = track.getOccSensor();
                    if (sensor != null && Maintenance.testName(name = sensor.getSystemName(), found, names, line1, null, line9 = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("IndicatorTrack")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                    if ((block = track.getOccBlock()) != null && (sensor = block.getSensor()) != null && Maintenance.testName(name = sensor.getSystemName(), found, names, line1, null, line11 = MessageFormat.format(rbm.getString("PanelReference"), "\t", Bundle.getMessage("IndicatorTrack")), tempText)) {
                        found = true;
                        ++referenceCount;
                    }
                }
                if (text == null || !found) continue;
                text.append(tempText.toString());
                tempText = new StringBuilder();
                found = false;
                empty = false;
                line1 = null;
            }
            if (text == null || !empty) continue;
            text.append(MessageFormat.format(rbm.getString("NoReference"), "Panel"));
        }
        if (text != null) {
            if (referenceCount == 0) {
                text.append(MessageFormat.format(rbm.getString("Orphan"), names));
            } else {
                text.append(MessageFormat.format(rbm.getString("ReferenceFound"), referenceCount, userName, sysName));
            }
        }
        if (names[0] != null) {
            int numListeners = Integer.parseInt(names[3]) - 1;
            numListeners -= PickListModel.getNumInstances(names[0]);
            if (names[0].equals("Sensor")) {
                numListeners -= PickListModel.getNumInstances("MultiSensor");
            }
            if (numListeners > referenceCount) {
                if (names[0].length() == 0) {
                    names[0] = "Unknown Type?";
                }
                if (text != null) {
                    text.append(MessageFormat.format(rbm.getString("OrphanName"), names) + " has " + numListeners + " listeners installed and only " + referenceCount + " references found.\n" + names[0] + " Tables are listeneners.  Check that the table is closed.");
                }
            }
        }
        return referenceCount > 0;
    }

    static void makeDialog(Component component, Component button, Frame parent, String title) {
        JDialog dialog = new JDialog(parent, title, true);
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        class MyListener
        implements ActionListener {
            Window _w;

            MyListener(Window w) {
                this._w = w;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadingUtil.runOnGUIEventually(() -> this._w.dispose());
            }
        }
        ok.addActionListener(new MyListener(dialog));
        ok.setMaximumSize(ok.getPreferredSize());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(component, "Center");
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(Box.createVerticalGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(ok);
        if (button != null) {
            panel.add(Box.createHorizontalStrut(5));
            panel.add(button);
        }
        contentPane.add((Component)panel, "South");
        dialog.setDefaultCloseOperation(2);
        dialog.setLocationRelativeTo(parent);
        dialog.pack();
        ThreadingUtil.runOnGUIEventually(() -> dialog.setVisible(true));
    }
}

