/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AddNewBeanPanel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.MemoryTableDataModel;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;

public class MemoryTableAction
extends AbstractTableAction<Memory> {
    JmriJFrame addFrame = null;
    JTextField sysNameField = new JTextField(20);
    JTextField userNameField = new JTextField(20);
    JLabel sysNameLabel = new JLabel(Bundle.getMessage("LabelSystemName"));
    JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName"));
    SpinnerNumberModel rangeSpinner = new SpinnerNumberModel(1, 1, 100, 1);
    JSpinner numberToAddSpinner = new JSpinner(this.rangeSpinner);
    JCheckBox rangeBox = new JCheckBox(Bundle.getMessage("AddRangeBox"));
    JCheckBox autoSystemNameBox = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    JLabel statusBarLabel = new JLabel(Bundle.getMessage("AddBeanStatusEnter"), 10);
    UserPreferencesManager p;
    String systemNameAuto = this.getClass().getName() + ".AutoSystemName";

    public MemoryTableAction(String actionName) {
        super(actionName);
        if (InstanceManager.getNullableDefault(MemoryManager.class) == null) {
            super.setEnabled(false);
        }
    }

    public MemoryTableAction() {
        this(Bundle.getMessage("TitleMemoryTable"));
    }

    @Override
    protected void createModel() {
        this.m = new MemoryTableDataModel(InstanceManager.getDefault(MemoryManager.class));
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleMemoryTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.MemoryTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddMemory"), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.MemoryAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            ActionListener okListener = e1 -> this.okPressed(e1);
            ActionListener cancelListener = e1 -> this.cancelPressed(e1);
            AddNewBeanPanel anbp = new AddNewBeanPanel(this.sysNameField, this.userNameField, this.numberToAddSpinner, this.rangeBox, this.autoSystemNameBox, "ButtonCreate", okListener, cancelListener, this.statusBarLabel);
            this.addFrame.add(anbp);
            this.addFrame.getRootPane().setDefaultButton(anbp.ok);
            this.addFrame.setEscapeKeyClosesWindow(true);
            this.sysNameField.setToolTipText(Bundle.getMessage("SysNameToolTip", "M"));
        }
        this.sysNameField.setBackground(Color.white);
        this.statusBarLabel.setText(Bundle.getMessage("AddBeanStatusEnter"));
        this.statusBarLabel.setForeground(Color.gray);
        if (this.p.getSimplePreferenceState(this.systemNameAuto)) {
            this.autoSystemNameBox.setSelected(true);
        }
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    void cancelPressed(ActionEvent e) {
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void okPressed(ActionEvent e) {
        String sName;
        int numberOfMemory = 1;
        if (this.rangeBox.isSelected()) {
            numberOfMemory = (Integer)this.numberToAddSpinner.getValue();
        }
        if (numberOfMemory >= 65 && JmriJOptionPane.showConfirmDialog(this.addFrame, Bundle.getMessage("WarnExcessBeans", Bundle.getMessage("Memories"), numberOfMemory), Bundle.getMessage("WarningTitle"), 0) != 0) {
            return;
        }
        String uName = NamedBean.normalizeUserName(this.userNameField.getText());
        if (uName == null || uName.isEmpty()) {
            uName = null;
        }
        if ((sName = this.sysNameField.getText()).isEmpty() && !this.autoSystemNameBox.isSelected()) {
            this.statusBarLabel.setText(Bundle.getMessage("WarningSysNameEmpty"));
            this.statusBarLabel.setForeground(Color.red);
            this.sysNameField.setBackground(Color.red);
            return;
        }
        this.sysNameField.setBackground(Color.white);
        Object statusMessage = Bundle.getMessage("ItemCreateFeedback", Bundle.getMessage("BeanNameMemory"));
        String errorMessage = null;
        for (int x = 0; x < numberOfMemory; ++x) {
            if (uName != null && !uName.isEmpty() && InstanceManager.getDefault(MemoryManager.class).getByUserName(uName) != null && !this.p.getPreferenceState(this.getClassName(), "duplicateUserName")) {
                InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorDuplicateUserName", uName), this.getClassName(), "duplicateUserName", false, true);
                errorMessage = Bundle.getMessage("ErrorDuplicateUserName", uName);
                this.statusBarLabel.setText(errorMessage);
                this.statusBarLabel.setForeground(Color.red);
                uName = null;
            }
            if (!sName.isEmpty() && InstanceManager.getDefault(MemoryManager.class).getBySystemName(sName) != null && !this.p.getPreferenceState(this.getClassName(), "duplicateSystemName")) {
                InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorDuplicateSystemName", sName), this.getClassName(), "duplicateSystemName", false, true);
                errorMessage = Bundle.getMessage("ErrorDuplicateSystemName", sName);
                this.statusBarLabel.setText(errorMessage);
                this.statusBarLabel.setForeground(Color.red);
                return;
            }
            try {
                if (this.autoSystemNameBox.isSelected()) {
                    InstanceManager.getDefault(MemoryManager.class).newMemory(uName);
                } else {
                    InstanceManager.getDefault(MemoryManager.class).newMemory(sName, uName);
                }
            }
            catch (IllegalArgumentException ex) {
                this.handleCreateException(sName);
                errorMessage = Bundle.getMessage("ErrorAddFailedCheck");
                this.statusBarLabel.setText(errorMessage);
                this.statusBarLabel.setForeground(Color.red);
                return;
            }
            if (x == 0 || x == numberOfMemory - 1) {
                statusMessage = (String)statusMessage + " " + sName + " (" + uName + ")";
            }
            if (x == numberOfMemory - 2) {
                statusMessage = (String)statusMessage + " " + Bundle.getMessage("ItemCreateUpTo") + " ";
            }
            if (!this.autoSystemNameBox.isSelected()) {
                sName = this.nextName(sName);
            }
            if (uName == null) continue;
            uName = this.nextName(uName);
        }
        if (errorMessage == null) {
            this.statusBarLabel.setText((String)statusMessage);
            this.statusBarLabel.setForeground(Color.gray);
        } else {
            this.statusBarLabel.setText(errorMessage);
        }
        this.p.setSimplePreferenceState(this.systemNameAuto, this.autoSystemNameBox.isSelected());
    }

    void handleCreateException(String sysName) {
        JmriJOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("ErrorMemoryAddFailed", sysName) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleMemoryTable");
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "duplicateUserName", Bundle.getMessage("HideDupUserError"));
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "duplicateSystemName", Bundle.getMessage("HideDupSysError"));
        super.setMessagePreferencesDetails();
    }

    @Override
    protected String getClassName() {
        return MemoryTableAction.class.getName();
    }
}

