/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.beans.PropertyChangeEvent;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.Reportable;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.MemoryTableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTableDataModel
extends BeanTableDataModel<Memory> {
    private static final Logger log = LoggerFactory.getLogger(MemoryTableDataModel.class);

    public MemoryTableDataModel(Manager<Memory> mgr) {
        this.setManager(mgr);
    }

    public MemoryTableDataModel() {
        this.setManager(InstanceManager.getDefault(MemoryManager.class));
    }

    @Override
    public String getValue(String name) {
        Memory mem = InstanceManager.getDefault(MemoryManager.class).getBySystemName(name);
        if (mem == null) {
            return "?";
        }
        Object m = mem.getValue();
        if (m != null) {
            if (m instanceof Reportable) {
                return ((Reportable)m).toReportString();
            }
            return m.toString();
        }
        return "";
    }

    @Override
    public Manager<Memory> getManager() {
        return InstanceManager.getDefault(MemoryManager.class);
    }

    @Override
    public Memory getBySystemName(@Nonnull String name) {
        return InstanceManager.getDefault(MemoryManager.class).getBySystemName(name);
    }

    @Override
    public Memory getByUserName(@Nonnull String name) {
        return InstanceManager.getDefault(MemoryManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return MemoryTableAction.class.getName();
    }

    @Override
    public void clickOn(Memory t) {
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            this.getBySystemName((String)this.sysNameList.get(row)).setValue(value);
            this.fireTableRowsUpdated(row, row);
        } else {
            super.setValueAt(value, row, col);
        }
    }

    @Override
    public String getColumnName(int col) {
        if (col == 2) {
            return Bundle.getMessage("BlockValue");
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 2) {
            return String.class;
        }
        return super.getColumnClass(col);
    }

    @Override
    public void configValueColumn(JTable table) {
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return true;
    }

    @Override
    public JButton configureButton() {
        log.error("configureButton should not have been called");
        return null;
    }

    @Override
    public String getCellToolTip(JTable table, int row, int col) {
        switch (col) {
            case 2: {
                Memory m = this.getBySystemName((String)this.sysNameList.get(row));
                Object o = m.getValue();
                return o == null ? null : o.getClass().getName();
            }
        }
        return super.getCellToolTip(table, row, col);
    }
}

