/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.beans.PropertyChangeEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.Reporter;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.RailComTableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailComTableDataModel
extends BeanTableDataModel<IdTag> {
    public static final int VALUECOL = 0;
    public static final int WHERECOL = 1;
    public static final int WHENCOL = 2;
    public static final int CLEARCOL = 3;
    public static final int SPEEDCOL = 4;
    public static final int LOADCOL = 5;
    public static final int TEMPCOL = 6;
    public static final int FUELCOL = 7;
    public static final int WATERCOL = 8;
    public static final int LOCATIONCOL = 9;
    public static final int ROUTINGCOL = 10;
    public static final int DELETECOL = 11;
    public static final int NUMCOLUMN = 12;
    private RailComManager manager;
    private static final Logger log = LoggerFactory.getLogger(RailComTableDataModel.class);

    public RailComTableDataModel(Manager<IdTag> mgr) {
        this.setManager(mgr);
    }

    @Override
    public String getValue(String name) {
        RailCom tag = (RailCom)this.getManager().getBySystemName(name);
        if (tag == null) {
            return "?";
        }
        return tag.getTagID();
    }

    @Override
    public final void setManager(Manager<IdTag> mgr) {
        if (mgr instanceof RailComManager) {
            this.manager = (RailComManager)mgr;
        }
    }

    public RailComManager getManager() {
        return this.manager != null ? this.manager : InstanceManager.getDefault(RailComManager.class);
    }

    @Override
    public RailCom getBySystemName(@Nonnull String name) {
        return (RailCom)this.getManager().getBySystemName(name);
    }

    @Override
    public RailCom getByUserName(@Nonnull String name) {
        return (RailCom)this.getManager().getByUserName(name);
    }

    @Override
    public void clickOn(IdTag t) {
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 3) {
            RailCom t = this.getBySystemName((String)this.sysNameList.get(row));
            if (log.isDebugEnabled()) {
                log.debug("Clear where & when last seen for {}", (Object)t.getSystemName());
            }
            t.setWhereLastSeen(null);
            this.fireTableRowsUpdated(row, row);
        } else if (col == 11) {
            this.deleteBean(row, col);
        }
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnAddress");
            }
            case 1: {
                return Bundle.getMessage("ColumnIdWhere");
            }
            case 2: {
                return Bundle.getMessage("ColumnIdWhen");
            }
            case 4: {
                return Bundle.getMessage("ColumnSpeed");
            }
            case 5: {
                return Bundle.getMessage("ColumnLoad");
            }
            case 6: {
                return Bundle.getMessage("ColumnTemp");
            }
            case 7: {
                return Bundle.getMessage("ColumnFuelLevel");
            }
            case 8: {
                return Bundle.getMessage("ColumnWaterLevel");
            }
            case 9: {
                return Bundle.getMessage("ColumnLocation");
            }
            case 10: {
                return Bundle.getMessage("ColumnRouting");
            }
            case 11: {
                return "";
            }
            case 3: {
                return "";
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 3: 
            case 11: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 3: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        RailCom t = this.getBySystemName((String)this.sysNameList.get(row));
        if (t == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return t.getLocoAddress().toString();
            }
            case 1: {
                Reporter r = t.getWhereLastSeen();
                return r != null ? r.getSystemName() : null;
            }
            case 2: {
                Date d = t.getWhenLastSeen();
                return d != null ? DateFormat.getDateTimeInstance(3, 2).format(d) : null;
            }
            case 3: {
                return Bundle.getMessage("ButtonClear");
            }
            case 4: {
                return t.getActualSpeed() != -1 ? Integer.valueOf(t.getActualSpeed()) : null;
            }
            case 5: {
                return t.getActualLoad() != -1 ? Integer.valueOf(t.getActualLoad()) : null;
            }
            case 6: {
                return t.getActualTemperature() != -1 ? Integer.valueOf(t.getActualTemperature()) : null;
            }
            case 7: {
                return t.getFuelLevel() != -1 ? Integer.valueOf(t.getFuelLevel()) : null;
            }
            case 8: {
                return t.getWaterLevel() != -1 ? Integer.valueOf(t.getWaterLevel()) : null;
            }
            case 9: {
                return t.getLocation() != -1 ? Integer.valueOf(t.getLocation()) : null;
            }
            case 10: {
                return t.getRoutingNo() != -1 ? Integer.valueOf(t.getRoutingNo()) : null;
            }
            case 11: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 1: 
            case 2: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 0: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 3: 
            case 11: {
                return new JButton((String)Bundle.getMessage((String)"ButtonClear")).getPreferredSize().width + 4;
            }
        }
        return new JTextField((int)5).getPreferredSize().width;
    }

    @Override
    public void configValueColumn(JTable table) {
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return true;
    }

    @Override
    public JButton configureButton() {
        log.error("configureButton should not have been called");
        return null;
    }

    @Override
    protected String getMasterClassName() {
        return RailComTableAction.class.getName();
    }

    @Override
    protected String getBeanType() {
        return "ID Tag";
    }
}

