/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AddNewHardwareDevicePanel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.ReporterTableDataModel;
import jmri.swing.ManagerComboBox;
import jmri.swing.SystemNameValidator;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;

public class ReporterTableAction
extends AbstractTableAction<Reporter> {
    protected ReporterManager reporterManager = InstanceManager.getDefault(ReporterManager.class);
    private JmriJFrame addFrame = null;
    private final JTextField hardwareAddressTextField = new JTextField(20);
    private final JTextField userNameTextField = new JTextField(20);
    private final ManagerComboBox<Reporter> prefixBox = new ManagerComboBox();
    private final SpinnerNumberModel rangeSpinner = new SpinnerNumberModel(1, 1, 100, 1);
    private final JSpinner numberToAddSpinner = new JSpinner(this.rangeSpinner);
    private final JCheckBox rangeCheckBox = new JCheckBox(Bundle.getMessage("AddRangeBox"));
    private final String systemSelectionCombo = this.getClass().getName() + ".SystemSelected";
    private JButton addButton;
    private final JLabel statusBarLabel = new JLabel(Bundle.getMessage("HardwareAddStatusEnter"), 10);
    private Manager<Reporter> connectionChoice = null;
    private UserPreferencesManager pref;
    private SystemNameValidator hardwareAddressValidator;
    private String addEntryToolTip;

    public ReporterTableAction(String actionName) {
        super(actionName);
        if (this.reporterManager == null) {
            super.setEnabled(false);
        }
    }

    @Override
    public void setManager(@Nonnull Manager<Reporter> man) {
        if (man instanceof ReporterManager) {
            this.reporterManager = (ReporterManager)man;
        }
    }

    public ReporterTableAction() {
        this(Bundle.getMessage("TitleReporterTable"));
    }

    @Override
    protected void createModel() {
        this.m = new ReporterTableDataModel(this.reporterManager);
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleReporterTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.ReporterTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddReporter"), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.ReporterAddEdit", true);
            ActionListener createListener = this::createPressed;
            ActionListener cancelListener = this::cancelPressed;
            ActionListener rangeListener = this::canAddRange;
            this.configureManagerComboBox(this.prefixBox, this.reporterManager, ReporterManager.class);
            this.userNameTextField.setName("userName");
            this.prefixBox.setName("prefixBox");
            this.addButton = new JButton(Bundle.getMessage("ButtonCreate"));
            this.addButton.addActionListener(createListener);
            if (this.hardwareAddressValidator == null) {
                this.hardwareAddressValidator = new SystemNameValidator(this.hardwareAddressTextField, (Manager)Objects.requireNonNull(this.prefixBox.getSelectedItem()), true);
            } else {
                this.hardwareAddressValidator.setManager((Manager<?>)this.prefixBox.getSelectedItem());
            }
            this.addFrame.add(new AddNewHardwareDevicePanel(this.hardwareAddressTextField, this.hardwareAddressValidator, this.userNameTextField, this.prefixBox, this.numberToAddSpinner, this.rangeCheckBox, this.addButton, cancelListener, rangeListener, this.statusBarLabel));
            this.canAddRange(null);
        }
        this.hardwareAddressTextField.setName("sysName");
        this.hardwareAddressTextField.setName("hwAddressTextField");
        this.addButton.setName("createButton");
        this.statusBarLabel.setText(Bundle.getMessage("HardwareAddStatusEnter"));
        this.statusBarLabel.setForeground(Color.gray);
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.addFrame.getRootPane().setDefaultButton(this.addButton);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    void cancelPressed(ActionEvent e) {
        this.removePrefixBoxListener(this.prefixBox);
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void createPressed(ActionEvent e) {
        int numberOfReporters = 1;
        if (this.rangeCheckBox.isSelected()) {
            numberOfReporters = (Integer)this.numberToAddSpinner.getValue();
        }
        if (numberOfReporters >= 65 && JmriJOptionPane.showConfirmDialog(this.addFrame, Bundle.getMessage("WarnExcessBeans", Bundle.getMessage("Reporters"), numberOfReporters), Bundle.getMessage("WarningTitle"), 0) != 0) {
            return;
        }
        String reporterPrefix = this.prefixBox.getSelectedItem().getSystemPrefix();
        String curAddress = this.hardwareAddressTextField.getText();
        if (curAddress.isEmpty()) {
            this.statusBarLabel.setText(Bundle.getMessage("WarningEmptyHardwareAddress"));
            this.statusBarLabel.setForeground(Color.red);
            this.hardwareAddressTextField.setBackground(Color.red);
            return;
        }
        this.hardwareAddressTextField.setBackground(Color.white);
        StringBuilder statusMessage = new StringBuilder(Bundle.getMessage("ItemCreateFeedback", Bundle.getMessage("BeanNameReporter")));
        String uName = this.userNameTextField.getText();
        Object rName = reporterPrefix + this.reporterManager.typeLetter() + curAddress;
        for (int x = 0; x < numberOfReporters; ++x) {
            Reporter r;
            try {
                r = this.reporterManager.provideReporter((String)rName);
            }
            catch (IllegalArgumentException ex) {
                this.handleCreateException(ex, (String)rName);
                return;
            }
            if (!uName.isEmpty()) {
                if (this.reporterManager.getByUserName(uName) == null) {
                    r.setUserName(uName);
                } else {
                    this.pref.showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorDuplicateUserName", uName), this.getClassName(), "duplicateUserName", false, true);
                }
            }
            if (x == 0 || x == numberOfReporters - 1) {
                statusMessage.append(" ").append((String)rName).append(" (").append(uName).append(")");
            }
            if (x == numberOfReporters - 2) {
                statusMessage.append(" ").append(Bundle.getMessage("ItemCreateUpTo")).append(" ");
            }
            if (x >= numberOfReporters - 1) continue;
            try {
                rName = InstanceManager.getDefault(ReporterManager.class).getNextValidSystemName(r);
            }
            catch (JmriException ex) {
                this.displayHwError(r.getSystemName(), ex);
                this.statusBarLabel.setText(Bundle.getMessage("ErrorConvertHW", rName));
                this.statusBarLabel.setForeground(Color.red);
                return;
            }
            if (uName.isEmpty()) continue;
            uName = this.nextName(uName);
        }
        this.statusBarLabel.setText(statusMessage.toString());
        this.statusBarLabel.setForeground(Color.gray);
        this.pref.setComboBoxLastSelection(this.systemSelectionCombo, this.prefixBox.getSelectedItem().getMemo().getUserName());
        this.removePrefixBoxListener(this.prefixBox);
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    private void canAddRange(ActionEvent e) {
        this.rangeCheckBox.setEnabled(false);
        this.rangeCheckBox.setSelected(false);
        if (this.prefixBox.getSelectedIndex() == -1) {
            this.prefixBox.setSelectedIndex(0);
        }
        this.connectionChoice = this.prefixBox.getSelectedItem();
        String systemPrefix = this.connectionChoice.getSystemPrefix();
        this.rangeCheckBox.setEnabled(((ReporterManager)this.connectionChoice).allowMultipleAdditions(systemPrefix));
        this.addEntryToolTip = this.connectionChoice.getEntryToolTip();
        this.hardwareAddressTextField.setToolTipText(Bundle.getMessage("AddEntryToolTipLine1", this.connectionChoice.getMemo().getUserName(), Bundle.getMessage("Reporters"), this.addEntryToolTip));
        this.hardwareAddressValidator.setToolTipText(this.hardwareAddressTextField.getToolTipText());
        this.hardwareAddressValidator.verify(this.hardwareAddressTextField);
    }

    void handleCreateException(Exception ex, String sysName) {
        this.statusBarLabel.setText(ex.getLocalizedMessage());
        this.statusBarLabel.setForeground(Color.red);
        String err = Bundle.getMessage("ErrorBeanCreateFailed", InstanceManager.getDefault(ReporterManager.class).getBeanTypeHandled(), sysName);
        JmriJOptionPane.showMessageDialog(this.addFrame, err + "\n" + ex.getLocalizedMessage(), err, 0);
    }

    @Override
    protected String getClassName() {
        return ReporterTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleReporterTable");
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "duplicateUserName", Bundle.getMessage("DuplicateUserNameWarn"));
        super.setMessagePreferencesDetails();
    }
}

