/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.beans.PropertyChangeEvent;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.beantable.RouteTableAction;
import jmri.jmrit.beantable.routetable.RouteEditFrame;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteTableDataModel
extends BeanTableDataModel<Route> {
    private static final int ENABLECOL = 5;
    private static final int LOCKCOL = 6;
    private static final int SETCOL = 7;
    private static final Logger log = LoggerFactory.getLogger(RouteTableDataModel.class);

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 2: 
            case 7: {
                return "";
            }
            case 5: {
                return Bundle.getMessage("ColumnHeadEnabled");
            }
            case 6: {
                return Bundle.getMessage("Locked");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 7: {
                return JButton.class;
            }
            case 5: 
            case 6: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 5: 
            case 6: 
            case 7: {
                return new JTextField((int)6).getPreferredSize().width;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 1: 
            case 5: 
            case 7: {
                return true;
            }
            case 6: {
                return ((Route)this.getValueAt(row, 0)).canLock();
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 5: {
                return ((Route)this.getValueAt(row, 0)).getEnabled();
            }
            case 6: {
                Route r = (Route)this.getValueAt(row, 0);
                if (r.canLock()) {
                    return r.getLocked();
                }
                r.setLocked(false);
                return false;
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 1: {
                if ("".equals(value)) {
                    value = null;
                } else {
                    Route nB = this.getByUserName((String)value);
                    if (nB != null) {
                        log.error("User Name is not unique {}", value);
                        String msg = Bundle.getMessage("WarningUserName", "" + value);
                        JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 0);
                        return;
                    }
                }
                Route nBean = this.getBySystemName((String)this.sysNameList.get(row));
                nBean.setUserName((String)value);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 7: {
                SwingUtilities.invokeLater(() -> {
                    RouteEditFrame editFrame = new RouteEditFrame(((Route)this.getValueAt(row, 0)).getSystemName());
                    editFrame.setVisible(true);
                });
                break;
            }
            case 5: {
                Route r = (Route)this.getValueAt(row, 0);
                r.setEnabled(!r.getEnabled());
                break;
            }
            case 6: {
                Route r = (Route)this.getValueAt(row, 0);
                r.setLocked(!r.getLocked());
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    public void configureTable(JTable table) {
        table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
        table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        table.setDefaultEditor(JComboBox.class, new ValueEditor());
        super.configureTable(table);
    }

    @Override
    protected void doDelete(Route bean) {
        bean.deActivateRoute();
        super.doDelete(bean);
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "Enabled": 
            case "Locked": {
                return true;
            }
        }
        return super.matchPropertyName(e);
    }

    public RouteManager getManager() {
        return InstanceManager.getDefault(RouteManager.class);
    }

    @Override
    public Route getBySystemName(@Nonnull String name) {
        return InstanceManager.getDefault(RouteManager.class).getBySystemName(name);
    }

    @Override
    public Route getByUserName(@Nonnull String name) {
        return InstanceManager.getDefault(RouteManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return RouteTableAction.class.getName();
    }

    @Override
    public void clickOn(Route t) {
        t.setRoute();
    }

    @Override
    public String getValue(String s) {
        return Bundle.getMessage("Set");
    }
}

