/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.Block;
import jmri.BlockManager;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Path;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.Transit;
import jmri.TransitManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionTableAction
extends AbstractTableAction<Section> {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.beantable.SectionTransitTableBundle");
    ArrayList<Block> blockList = new ArrayList();
    private BlockTableModel blockTableModel = null;
    EntryPointTableModel entryPointTableModel = null;
    SectionManager sectionManager = null;
    BlockManager blockManager = InstanceManager.getDefault(BlockManager.class);
    boolean editMode = false;
    Section curSection = null;
    boolean addCreateActive = true;
    ArrayList<LayoutEditor> lePanelList = null;
    LayoutEditor curLayoutEditor = null;
    Block beginBlock = null;
    Block endBlock = null;
    Sensor fSensor = null;
    Sensor rSensor = null;
    Sensor fStopSensor = null;
    Sensor rStopSensor = null;
    ArrayList<EntryPoint> entryPointList = new ArrayList();
    boolean manualEntryPoints = true;
    JmriJFrame addFrame = null;
    JTextField sysName = new JTextField(15);
    JLabel sysNameFixed = new JLabel("");
    JTextField userName = new JTextField(17);
    JLabel sysNameLabel = new JLabel(Bundle.getMessage("LabelSystemName"));
    JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName"));
    JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    UserPreferencesManager pref;
    JButton create = null;
    JButton update = null;
    JButton addBlock = null;
    JButton deleteBlocks = null;
    JComboBox<String> layoutEditorBox = new JComboBox();
    NamedBeanComboBox<Block> blockBox;
    NamedBeanComboBox<Sensor> forwardSensorBox;
    NamedBeanComboBox<Sensor> reverseSensorBox;
    NamedBeanComboBox<Sensor> forwardStopSensorBox;
    NamedBeanComboBox<Sensor> reverseStopSensorBox;
    JRadioButton manually = new JRadioButton(rbx.getString("SetManually"), true);
    JRadioButton automatic = new JRadioButton(rbx.getString("UseConnectivity"), false);
    ButtonGroup entryPointOptions = null;
    String systemNameAuto = this.getClass().getName() + ".AutoSystemName";
    JLabel generationStateLabel = new JLabel();
    JmriJFrame frame = null;
    private static final Logger log = LoggerFactory.getLogger(SectionTableAction.class);

    public SectionTableAction(String actionName) {
        super(actionName);
        this.sectionManager = InstanceManager.getNullableDefault(SectionManager.class);
        if (this.sectionManager == null) {
            super.setEnabled(false);
        }
    }

    public SectionTableAction() {
        this(Bundle.getMessage("TitleSectionTable"));
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<Section>(){
            public static final int BEGINBLOCKCOL = 5;
            public static final int ENDBLOCKCOL = 6;
            public static final int EDITCOL = 7;

            @Override
            public String getValue(String name) {
                return "";
            }

            @Override
            public Manager<Section> getManager() {
                return InstanceManager.getDefault(SectionManager.class);
            }

            @Override
            public Section getBySystemName(@Nonnull String name) {
                return (Section)InstanceManager.getDefault(SectionManager.class).getBySystemName(name);
            }

            @Override
            public Section getByUserName(@Nonnull String name) {
                return (Section)InstanceManager.getDefault(SectionManager.class).getByUserName(name);
            }

            @Override
            protected String getMasterClassName() {
                return SectionTableAction.this.getClassName();
            }

            @Override
            public void clickOn(Section t) {
            }

            @Override
            public int getColumnCount() {
                return 8;
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row >= this.sysNameList.size()) {
                    log.debug("row is greater than name list");
                    return "";
                }
                switch (col) {
                    case 5: {
                        Section z = this.getBySystemName((String)this.sysNameList.get(row));
                        if (z != null) {
                            return z.getBeginBlockName();
                        }
                        return "  ";
                    }
                    case 6: {
                        Section z = this.getBySystemName((String)this.sysNameList.get(row));
                        if (z != null) {
                            return z.getEndBlockName();
                        }
                        return "  ";
                    }
                    case 2: {
                        Section z = this.getBySystemName((String)this.sysNameList.get(row));
                        if (z == null) {
                            return "";
                        }
                        switch (z.getState()) {
                            case 2: {
                                return rbx.getString("SectionFree");
                            }
                            case 4: {
                                return rbx.getString("SectionForward");
                            }
                            case 8: {
                                return rbx.getString("SectionReverse");
                            }
                        }
                        break;
                    }
                    case 7: {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    default: {
                        return super.getValueAt(row, col);
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col != 5 && col != 6) {
                    if (col == 7) {
                        SwingUtilities.invokeLater(() -> SectionTableAction.this.editPressed(((Section)this.getValueAt(row, 0)).getSystemName()));
                    } else if (col == 4) {
                        SectionTableAction.this.deleteSectionPressed((String)this.sysNameList.get(row));
                    } else {
                        super.setValueAt(value, row, col);
                    }
                }
            }

            @Override
            public String getColumnName(int col) {
                if (col == 5) {
                    return rbx.getString("SectionFirstBlock");
                }
                if (col == 6) {
                    return rbx.getString("SectionLastBlock");
                }
                if (col == 7) {
                    return "";
                }
                return super.getColumnName(col);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 2: 
                    case 5: 
                    case 6: {
                        return String.class;
                    }
                    case 7: {
                        return JButton.class;
                    }
                }
                return super.getColumnClass(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 2: 
                    case 5: 
                    case 6: {
                        return false;
                    }
                    case 7: {
                        return true;
                    }
                }
                return super.isCellEditable(row, col);
            }

            @Override
            public int getPreferredWidth(int col) {
                switch (col) {
                    case 0: {
                        return new JTextField((int)9).getPreferredSize().width;
                    }
                    case 1: {
                        return new JTextField((int)17).getPreferredSize().width;
                    }
                    case 2: 
                    case 7: {
                        return new JTextField((int)6).getPreferredSize().width;
                    }
                    case 5: 
                    case 6: {
                        return new JTextField((int)15).getPreferredSize().width;
                    }
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public void configValueColumn(JTable table) {
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                return true;
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleSectionTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.SectionTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.editMode = false;
        if (this.blockManager.getNamedBeanSet().size() > 0) {
            this.addEditPressed();
        } else {
            JmriJOptionPane.showMessageDialog(null, rbx.getString("Message1"), Bundle.getMessage("ErrorTitle"), 0);
        }
    }

    void editPressed(String sName) {
        this.curSection = (Section)this.sectionManager.getBySystemName(sName);
        if (this.curSection == null) {
            return;
        }
        this.sysNameFixed.setText(sName);
        this.editMode = true;
        this.addEditPressed();
    }

    void addEditPressed() {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddSection"));
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.SectionAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.sysNameLabel);
            this.sysNameLabel.setLabelFor(this.sysName);
            p.add(this.sysNameFixed);
            p.add(this.sysName);
            p.add(this._autoSystemName);
            this._autoSystemName.addActionListener(e -> this.autoSystemName());
            if (this.pref.getSimplePreferenceState(this.systemNameAuto)) {
                this._autoSystemName.setSelected(true);
            }
            this.sysName.setToolTipText(rbx.getString("SectionSystemNameHint"));
            this.addFrame.getContentPane().add(p);
            JPanel pu = new JPanel();
            pu.setLayout(new FlowLayout());
            pu.add(this.userNameLabel);
            this.userNameLabel.setLabelFor(this.userName);
            pu.add(this.userName);
            this.userName.setToolTipText(rbx.getString("SectionUserNameHint"));
            this.addFrame.getContentPane().add(pu);
            JPanel pa = new JPanel();
            pa.setLayout(new FlowLayout());
            pa.add(this.generationStateLabel);
            this.addFrame.getContentPane().add(pa);
            this.addFrame.getContentPane().add(new JSeparator());
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 1));
            JPanel p11 = new JPanel();
            p11.setLayout(new FlowLayout());
            p11.add(new JLabel(rbx.getString("BlockTableMessage")));
            p1.add(p11);
            JPanel p12 = new JPanel();
            this.blockTableModel = new BlockTableModel();
            JTable blockTable = new JTable(this.blockTableModel);
            blockTable.setRowSelectionAllowed(false);
            blockTable.setPreferredScrollableViewportSize(new Dimension(350, 100));
            TableColumnModel blockColumnModel = blockTable.getColumnModel();
            TableColumn sNameColumn = blockColumnModel.getColumn(0);
            sNameColumn.setResizable(true);
            sNameColumn.setMinWidth(90);
            sNameColumn.setMaxWidth(130);
            TableColumn uNameColumn = blockColumnModel.getColumn(1);
            uNameColumn.setResizable(true);
            uNameColumn.setMinWidth(210);
            uNameColumn.setMaxWidth(260);
            JScrollPane blockTableScrollPane = new JScrollPane(blockTable);
            p12.add((Component)blockTableScrollPane, "Center");
            p1.add(p12);
            JPanel p13 = new JPanel();
            p13.setLayout(new FlowLayout());
            this.deleteBlocks = new JButton(rbx.getString("DeleteAllBlocksButton"));
            p13.add(this.deleteBlocks);
            this.deleteBlocks.addActionListener(this::deleteBlocksPressed);
            this.deleteBlocks.setToolTipText(rbx.getString("DeleteAllBlocksButtonHint"));
            p13.add(new JLabel("     "));
            this.initializeBlockCombo();
            p13.add(this.blockBox);
            this.blockBox.setToolTipText(rbx.getString("BlockBoxHint"));
            this.addBlock = new JButton(rbx.getString("AddBlockButton"));
            p13.add(this.addBlock);
            this.addBlock.addActionListener(this::addBlockPressed);
            this.addBlock.setToolTipText(rbx.getString("AddBlockButtonHint"));
            p1.add(p13);
            this.addFrame.getContentPane().add(p1);
            JPanel p34 = new JPanel();
            p34.setLayout(new FlowLayout());
            JLabel direction = new JLabel(rbx.getString("DirectionNote"));
            direction.setFont(direction.getFont().deriveFont(0.9f * (float)this.blockBox.getFont().getSize()));
            direction.setForeground(Color.gray);
            p34.add(direction);
            this.addFrame.getContentPane().add(p34);
            this.addFrame.getContentPane().add(new JSeparator());
            JPanel p31 = new JPanel();
            p31.setLayout(new FlowLayout());
            p31.add(new JLabel(rbx.getString("EntryPointTable")));
            this.addFrame.getContentPane().add(p31);
            JPanel p32 = new JPanel();
            p32.setLayout(new FlowLayout());
            this.entryPointOptions = new ButtonGroup();
            p32.add(this.manually);
            this.entryPointOptions.add(this.manually);
            this.manually.addActionListener(e -> {
                this.manualEntryPoints = true;
            });
            this.manually.setToolTipText(rbx.getString("SetManuallyHint"));
            p32.add(new JLabel("   "));
            p32.add(this.automatic);
            this.entryPointOptions.add(this.automatic);
            this.automatic.addActionListener(e -> {
                this.manualEntryPoints = false;
            });
            this.automatic.setToolTipText(rbx.getString("SetAutomaticHint"));
            p32.add(this.layoutEditorBox);
            this.layoutEditorBox.setToolTipText(rbx.getString("LayoutEditorBoxHint"));
            this.layoutEditorBox.addActionListener(e -> this.layoutEditorSelectionChanged());
            JPanel p33 = new JPanel();
            this.entryPointTableModel = new EntryPointTableModel();
            JTable entryPointTable = new JTable(this.entryPointTableModel);
            entryPointTable.setRowSelectionAllowed(false);
            entryPointTable.setPreferredScrollableViewportSize(new Dimension(550, 100));
            TableColumnModel entryPointColumnModel = entryPointTable.getColumnModel();
            TableColumn fromBlockColumn = entryPointColumnModel.getColumn(0);
            fromBlockColumn.setResizable(true);
            fromBlockColumn.setMinWidth(250);
            fromBlockColumn.setMaxWidth(310);
            TableColumn toBlockColumn = entryPointColumnModel.getColumn(1);
            toBlockColumn.setResizable(true);
            toBlockColumn.setMinWidth(150);
            toBlockColumn.setMaxWidth(210);
            JComboBox<String> directionCombo = new JComboBox<String>();
            directionCombo.addItem(rbx.getString("SectionForward"));
            directionCombo.addItem(rbx.getString("SectionReverse"));
            directionCombo.addItem(Bundle.getMessage("BeanStateUnknown"));
            TableColumn directionColumn = entryPointColumnModel.getColumn(2);
            directionColumn.setCellEditor(new DefaultCellEditor(directionCombo));
            entryPointTable.setRowHeight(directionCombo.getPreferredSize().height);
            directionColumn.setPreferredWidth(directionCombo.getPreferredSize().width);
            directionColumn.setResizable(false);
            JScrollPane entryPointTableScrollPane = new JScrollPane(entryPointTable);
            p33.add((Component)entryPointTableScrollPane, "Center");
            this.addFrame.getContentPane().add(p33);
            p33.setVisible(true);
            this.addFrame.getContentPane().add(new JSeparator());
            this.forwardSensorBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
            this.forwardSensorBox.setAllowNull(true);
            this.forwardSensorBox.setSelectedItem(null);
            this.reverseSensorBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
            this.reverseSensorBox.setAllowNull(true);
            this.reverseSensorBox.setSelectedItem(null);
            JComboBoxUtil.setupComboBoxMaxRows(this.forwardSensorBox);
            JComboBoxUtil.setupComboBoxMaxRows(this.reverseSensorBox);
            JPanel p20 = new JPanel();
            p20.setLayout(new FlowLayout());
            p20.add(new JLabel(rbx.getString("DirectionSensorLabel")));
            this.addFrame.getContentPane().add(p20);
            JPanel p21 = new JPanel();
            p21.setLayout(new FlowLayout());
            p21.add(new JLabel(rbx.getString("ForwardSensor")));
            p21.add(this.forwardSensorBox);
            this.forwardSensorBox.setToolTipText(rbx.getString("ForwardSensorHint"));
            p21.add(new JLabel("     "));
            p21.add(new JLabel(rbx.getString("ReverseSensor")));
            p21.add(this.reverseSensorBox);
            this.reverseSensorBox.setToolTipText(rbx.getString("ReverseSensorHint"));
            this.addFrame.getContentPane().add(p21);
            this.addFrame.getContentPane().add(new JSeparator());
            this.forwardStopSensorBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
            this.forwardStopSensorBox.setAllowNull(true);
            this.forwardStopSensorBox.setSelectedItem(null);
            this.reverseStopSensorBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
            this.reverseStopSensorBox.setAllowNull(true);
            this.reverseStopSensorBox.setSelectedItem(null);
            JComboBoxUtil.setupComboBoxMaxRows(this.forwardStopSensorBox);
            JComboBoxUtil.setupComboBoxMaxRows(this.reverseStopSensorBox);
            JPanel p40 = new JPanel();
            p40.setLayout(new FlowLayout());
            p40.add(new JLabel(rbx.getString("StoppingSensorLabel")));
            this.addFrame.getContentPane().add(p40);
            JPanel p41 = new JPanel();
            p41.setLayout(new FlowLayout());
            p41.add(new JLabel(rbx.getString("ForwardStopSensor")));
            p41.add(this.forwardStopSensorBox);
            this.forwardStopSensorBox.setToolTipText(rbx.getString("ForwardStopSensorHint"));
            p41.add(new JLabel("     "));
            p41.add(new JLabel(rbx.getString("ReverseStopSensor")));
            p41.add(this.reverseStopSensorBox);
            this.reverseStopSensorBox.setToolTipText(rbx.getString("ReverseStopSensorHint"));
            this.addFrame.getContentPane().add(p41);
            this.addFrame.getContentPane().add(new JSeparator());
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            JPanel pb = new JPanel();
            pb.setLayout(new FlowLayout());
            pb.add(cancel);
            cancel.addActionListener(this::cancelPressed);
            cancel.setToolTipText(rbx.getString("CancelButtonHint"));
            this.create = new JButton(Bundle.getMessage("ButtonCreate"));
            pb.add(this.create);
            this.create.addActionListener(this::createPressed);
            this.create.setToolTipText(rbx.getString("SectionCreateButtonHint"));
            this.update = new JButton(Bundle.getMessage("ButtonUpdate"));
            pb.add(this.update);
            this.update.addActionListener(this::updatePressed);
            this.update.setToolTipText(rbx.getString("SectionUpdateButtonHint"));
            this.addFrame.getContentPane().add(pb);
        }
        if (this.editMode) {
            this._autoSystemName.setVisible(false);
            this.sysNameLabel.setEnabled(true);
            this.create.setVisible(false);
            this.update.setVisible(true);
            this.sysName.setVisible(true);
            this.sysName.setVisible(false);
            this.sysNameFixed.setVisible(true);
            this.initializeEditInformation();
            this.addFrame.getRootPane().setDefaultButton(this.update);
            this.addFrame.setTitle(Bundle.getMessage("TitleEditSection"));
        } else {
            this._autoSystemName.setVisible(true);
            this.create.setVisible(true);
            this.update.setVisible(false);
            this.sysName.setVisible(true);
            this.sysNameFixed.setVisible(false);
            this.autoSystemName();
            this.clearForCreate();
            this.addFrame.getRootPane().setDefaultButton(this.create);
            this.addFrame.setTitle(Bundle.getMessage("TitleAddSection"));
        }
        if (this.initializeLayoutEditorCombo(this.layoutEditorBox)) {
            this.manually.setVisible(true);
            this.automatic.setVisible(true);
            this.layoutEditorBox.setVisible(true);
        } else {
            this.manually.setVisible(false);
            this.automatic.setVisible(false);
            this.layoutEditorBox.setVisible(false);
        }
        this.initializeBlockCombo();
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    private void initializeEditInformation() {
        int j;
        this.userName.setText(this.curSection.getUserName());
        switch (this.curSection.getSectionType()) {
            case SIGNALMASTLOGIC: {
                this.generationStateLabel.setText(rbx.getString("SectionTypeSMLLabel"));
                break;
            }
            case DYNAMICADHOC: {
                this.generationStateLabel.setText(rbx.getString("SectionTypeDynLabel"));
                break;
            }
            default: {
                this.generationStateLabel.setText("");
            }
        }
        this.deleteBlocksPressed(null);
        int i = 0;
        while (this.curSection.getBlockBySequenceNumber(i) != null) {
            Block b = this.curSection.getBlockBySequenceNumber(i);
            this.blockList.add(b);
            ++i;
            if (this.blockList.size() == 1) {
                this.beginBlock = b;
            }
            this.endBlock = b;
        }
        this.forwardSensorBox.setSelectedItem(this.curSection.getForwardBlockingSensor());
        this.reverseSensorBox.setSelectedItem(this.curSection.getReverseBlockingSensor());
        this.forwardStopSensorBox.setSelectedItem(this.curSection.getForwardStoppingSensor());
        this.reverseStopSensorBox.setSelectedItem(this.curSection.getReverseStoppingSensor());
        List<EntryPoint> list = this.curSection.getForwardEntryPointList();
        if (list.size() > 0) {
            for (j = 0; j < list.size(); ++j) {
                this.entryPointList.add(list.get(j));
            }
        }
        if ((list = this.curSection.getReverseEntryPointList()).size() > 0) {
            for (j = 0; j < list.size(); ++j) {
                this.entryPointList.add(list.get(j));
            }
        }
    }

    private void clearForCreate() {
        this.deleteBlocksPressed(null);
        this.curSection = null;
        this.forwardSensorBox.setSelectedItem(null);
        this.reverseSensorBox.setSelectedItem(null);
        this.forwardStopSensorBox.setSelectedItem(null);
        this.reverseStopSensorBox.setSelectedItem(null);
        this.generationStateLabel.setText("");
    }

    void createPressed(ActionEvent e) {
        if (!this.checkSectionInformation()) {
            return;
        }
        String uName = this.userName.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        String sName = this.sysName.getText();
        try {
            this.curSection = this._autoSystemName.isSelected() ? this.sectionManager.createNewSection(uName) : this.sectionManager.createNewSection(sName, uName);
        }
        catch (IllegalArgumentException ex) {
            if (this._autoSystemName.isSelected()) {
                this.handleCreateException(uName, ex);
            } else {
                this.handleCreateException(sName, ex);
            }
            return;
        }
        this.sysName.setText(this.curSection.getSystemName());
        this.setSectionInformation();
        this.addFrame.setVisible(false);
        this.blockTableModel.dispose();
        this.addFrame.dispose();
        this.addFrame = null;
        this.pref.setSimplePreferenceState(this.systemNameAuto, this._autoSystemName.isSelected());
    }

    void handleCreateException(String sysName, Exception ex) {
        JmriJOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("ErrorSectionAddFailed", sysName) + "\n" + Bundle.getMessage("ErrorAddFailedCheck") + "\n" + ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
    }

    void cancelPressed(ActionEvent e) {
        this.addFrame.setVisible(false);
        this.blockTableModel.dispose();
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void updatePressed(ActionEvent e) {
        Section tSection;
        if (!this.checkSectionInformation()) {
            return;
        }
        String uName = this.userName.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        if (uName != null && !uName.equals(this.curSection.getUserName()) && (tSection = (Section)this.sectionManager.getByUserName(uName)) != null) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message2"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.curSection.setUserName(uName);
        if (this.setSectionInformation()) {
            this.addFrame.setVisible(false);
            this.blockTableModel.dispose();
            this.addFrame.dispose();
            this.addFrame = null;
        }
    }

    private boolean checkSectionInformation() {
        if (this.blockList.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message6"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        boolean unknownPresent = false;
        for (int i = 0; i < this.entryPointList.size(); ++i) {
            if (!this.entryPointList.get(i).isUnknownType()) continue;
            unknownPresent = true;
        }
        if (unknownPresent) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message10"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        this.fSensor = (Sensor)this.forwardSensorBox.getSelectedItem();
        this.rSensor = (Sensor)this.reverseSensorBox.getSelectedItem();
        if (this.fSensor != null && this.fSensor.equals(this.rSensor)) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message9"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        this.fStopSensor = (Sensor)this.forwardStopSensorBox.getSelectedItem();
        this.rStopSensor = (Sensor)this.reverseStopSensorBox.getSelectedItem();
        return true;
    }

    private boolean setSectionInformation() {
        this.curSection.removeAllBlocksFromSection();
        for (int i = 0; i < this.blockList.size(); ++i) {
            if (this.curSection.addBlock(this.blockList.get(i))) continue;
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message4"), Bundle.getMessage("ErrorTitle"), 0);
        }
        this.curSection.setForwardBlockingSensorName(this.forwardSensorBox.getSelectedItemDisplayName());
        this.curSection.setReverseBlockingSensorName(this.reverseSensorBox.getSelectedItemDisplayName());
        this.curSection.setForwardStoppingSensorName(this.forwardStopSensorBox.getSelectedItemDisplayName());
        this.curSection.setReverseStoppingSensorName(this.reverseStopSensorBox.getSelectedItemDisplayName());
        for (int j = 0; j < this.entryPointList.size(); ++j) {
            EntryPoint ep = this.entryPointList.get(j);
            if (ep.isForwardType()) {
                this.curSection.addToForwardList(ep);
                continue;
            }
            if (!ep.isReverseType()) continue;
            this.curSection.addToReverseList(ep);
        }
        return true;
    }

    void deleteBlocksPressed(ActionEvent e) {
        for (int j = this.blockList.size(); j > 0; --j) {
            this.blockList.remove(j - 1);
        }
        this.beginBlock = null;
        this.endBlock = null;
        this.initializeBlockCombo();
        this.initializeEntryPoints();
        this.blockTableModel.fireTableDataChanged();
    }

    void addBlockPressed(ActionEvent e) {
        if (this.blockBox.getItemCount() == 0) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message5"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        Block b = (Block)this.blockBox.getSelectedItem();
        if (b != null) {
            this.blockList.add(b);
            if (this.blockList.size() == 1) {
                this.beginBlock = b;
            }
            this.endBlock = b;
            this.initializeBlockCombo();
            this.initializeEntryPoints();
            this.blockTableModel.fireTableDataChanged();
        }
    }

    private boolean initializeLayoutEditorCombo(JComboBox<String> box) {
        this.lePanelList = new ArrayList<LayoutEditor>(InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class));
        if (this.lePanelList.isEmpty()) {
            return false;
        }
        box.removeAllItems();
        box.addItem("<" + Bundle.getMessage("None").toLowerCase() + ">");
        for (int i = 0; i < this.lePanelList.size(); ++i) {
            box.addItem(this.lePanelList.get(i).getTitle());
        }
        box.setSelectedIndex(1);
        return true;
    }

    private void layoutEditorSelectionChanged() {
        int i = this.layoutEditorBox.getSelectedIndex();
        this.curLayoutEditor = i <= 0 || i > this.lePanelList.size() ? null : this.lePanelList.get(i - 1);
    }

    private void initializeBlockCombo() {
        if (this.blockBox == null) {
            this.blockBox = new NamedBeanComboBox(InstanceManager.getDefault(BlockManager.class));
        }
        this.blockBox.setSelectedItem(null);
        if (this.blockList.isEmpty()) {
            this.blockBox.setExcludedItems(new HashSet());
        } else {
            HashSet excludes = new HashSet(InstanceManager.getDefault(BlockManager.class).getNamedBeanSet());
            for (Block b : this.blockManager.getNamedBeanSet()) {
                if (this.inSection(b) || !this.connected(b, this.endBlock)) continue;
                excludes.remove(b);
            }
            this.blockBox.setExcludedItems(excludes);
        }
        if (this.blockBox.getItemCount() > 0) {
            this.blockBox.setSelectedIndex(0);
            JComboBoxUtil.setupComboBoxMaxRows(this.blockBox);
        }
    }

    private boolean inSection(Block b) {
        for (int i = 0; i < this.blockList.size(); ++i) {
            if (this.blockList.get(i) != b) continue;
            return true;
        }
        return false;
    }

    private boolean connected(Block b1, Block b2) {
        if (b1 != null && b2 != null) {
            List<Path> paths = b1.getPaths();
            for (int i = 0; i < paths.size(); ++i) {
                if (paths.get(i).getBlock() != b2) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeEntryPoints() {
        int i;
        ArrayList<EntryPoint> oldList = new ArrayList<EntryPoint>();
        for (i = 0; i < this.entryPointList.size(); ++i) {
            oldList.add(this.entryPointList.get(i));
        }
        this.entryPointList.clear();
        if (this.blockList.size() > 0) {
            for (i = 0; i < this.blockList.size(); ++i) {
                Block sb = this.blockList.get(i);
                List<Path> paths = sb.getPaths();
                for (int j = 0; j < paths.size(); ++j) {
                    Path p = paths.get(j);
                    if (this.inSection(p.getBlock())) continue;
                    String pbDir = Path.decodeDirection(p.getFromBlockDirection());
                    EntryPoint ep = this.getEntryPointInList(oldList, sb, p.getBlock(), pbDir);
                    if (ep == null) {
                        ep = new EntryPoint(sb, p.getBlock(), pbDir);
                    }
                    this.entryPointList.add(ep);
                }
            }
            ArrayList<EntryPoint> epList = this.getBlockEntryPointsList(this.beginBlock);
            if (epList.size() == 2 && this.blockList.size() == 1) {
                if (epList.get(0).isUnknownType() && epList.get(1).isUnknownType()) {
                    epList.get(0).setTypeForward();
                    epList.get(1).setTypeReverse();
                }
            } else if (epList.size() == 1) {
                epList.get(0).setTypeForward();
            }
            if ((epList = this.getBlockEntryPointsList(this.endBlock)).size() == 1) {
                epList.get(0).setTypeReverse();
            }
        }
        this.entryPointTableModel.fireTableDataChanged();
    }

    private EntryPoint getEntryPointInList(ArrayList<EntryPoint> list, Block b, Block pb, String pbDir) {
        for (int i = 0; i < list.size(); ++i) {
            EntryPoint ep = list.get(i);
            if (ep.getBlock() != b || ep.getFromBlock() != pb || !pbDir.equals(ep.getFromBlockDirection())) continue;
            return ep;
        }
        return null;
    }

    private ArrayList<EntryPoint> getBlockEntryPointsList(Block b) {
        ArrayList<EntryPoint> list = new ArrayList<EntryPoint>();
        for (int i = 0; i < this.entryPointList.size(); ++i) {
            EntryPoint ep = this.entryPointList.get(i);
            if (ep.getBlock() != b) continue;
            list.add(ep);
        }
        return list;
    }

    private void deleteSectionPressed(String sName) {
        Section s = (Section)InstanceManager.getDefault(SectionManager.class).getBySystemName(sName);
        if (s == null) {
            throw new IllegalArgumentException("Not deleting Section :" + sName + ": , Not Found.");
        }
        String fullName = s.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        ArrayList<Transit> affectedTransits = InstanceManager.getDefault(TransitManager.class).getListUsingSection(s);
        JDialog dialog = new JDialog();
        dialog.setTitle(Bundle.getMessage("WarningTitle"));
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().setLayout(new BoxLayout(dialog.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        if (affectedTransits.size() > 0) {
            JLabel iLabel = new JLabel(MessageFormat.format(rbx.getString("Message17"), fullName));
            p1.add(iLabel);
            dialog.add(p1);
            for (int i = 0; i < affectedTransits.size(); ++i) {
                Transit aTransit = affectedTransits.get(i);
                String tFullName = aTransit.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
                p1 = new JPanel();
                p1.setLayout(new FlowLayout());
                iLabel = new JLabel("   " + tFullName);
                p1.add(iLabel);
                dialog.add(p1);
            }
            dialog.add(p1);
            JPanel p3 = new JPanel();
            p3.setLayout(new FlowLayout());
            JLabel question = new JLabel(rbx.getString("Message18"));
            p3.add(question);
            dialog.add(p3);
            JPanel p4 = new JPanel();
            p4.setLayout(new FlowLayout());
            question = new JLabel(rbx.getString("Message18a"));
            p4.add(question);
            dialog.add(p4);
        } else {
            String msg = MessageFormat.format(rbx.getString("Message19"), fullName);
            JLabel question = new JLabel(msg);
            p1.add(question);
            dialog.add(p1);
        }
        JPanel p6 = new JPanel();
        p6.setLayout(new FlowLayout());
        JLabel quest = new JLabel(rbx.getString("Message20"));
        p6.add(quest);
        dialog.add(p6);
        JButton yesButton = new JButton(rbx.getString("YesDeleteIt"));
        JButton noButton = new JButton(rbx.getString("NoCancel"));
        JPanel button = new JPanel();
        button.add(yesButton);
        button.add(noButton);
        dialog.add(button);
        noButton.addActionListener(e -> dialog.dispose());
        yesButton.addActionListener(e -> {
            InstanceManager.getDefault(SectionManager.class).deregister(s);
            s.dispose();
            dialog.dispose();
        });
        dialog.pack();
        dialog.setModal(true);
        dialog.setVisible(true);
    }

    @Override
    public void setMenuBar(BeanTableFrame<Section> f) {
        this.frame = f;
        JMenuBar menuBar = f.getJMenuBar();
        int pos = menuBar.getMenuCount() - 1;
        int offset = 1;
        log.debug("setMenuBar number of menu items = {}", (Object)pos);
        for (int i = 0; i <= pos; ++i) {
            if (!(menuBar.getComponent(i) instanceof JMenu) || !((JMenu)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuHelp"))) continue;
            offset = -1;
        }
        JMenu toolsMenu = new JMenu(Bundle.getMessage("MenuTools"));
        menuBar.add((Component)toolsMenu, pos + offset);
        JMenuItem validate = new JMenuItem(rbx.getString("ValidateAllSections") + "...");
        toolsMenu.add(validate);
        validate.addActionListener(e -> {
            if (this.sectionManager != null) {
                int n = this.sectionManager.validateAllSections();
                if (n > 0) {
                    JmriJOptionPane.showMessageDialog(this.frame, MessageFormat.format(rbx.getString("Message14"), "" + n), Bundle.getMessage("ErrorTitle"), 0);
                } else if (n == -2) {
                    JmriJOptionPane.showMessageDialog(this.frame, rbx.getString("Message16"), Bundle.getMessage("ErrorTitle"), 0);
                } else if (n == 0) {
                    JmriJOptionPane.showMessageDialog(this.frame, rbx.getString("Message15"), Bundle.getMessage("MessageTitle"), 1);
                }
            }
        });
        JMenuItem setDirSensors = new JMenuItem(rbx.getString("SetupDirectionSensors") + "...");
        toolsMenu.add(setDirSensors);
        setDirSensors.addActionListener(e -> {
            if (this.sectionManager != null) {
                int n = this.sectionManager.setupDirectionSensors();
                if (n > 0) {
                    JmriJOptionPane.showMessageDialog(this.frame, MessageFormat.format(rbx.getString("Message27"), "" + n), Bundle.getMessage("ErrorTitle"), 0);
                } else if (n == -2) {
                    JmriJOptionPane.showMessageDialog(this.frame, rbx.getString("Message30"), Bundle.getMessage("ErrorTitle"), 0);
                } else if (n == 0) {
                    JmriJOptionPane.showMessageDialog(this.frame, rbx.getString("Message28"), Bundle.getMessage("MessageTitle"), 1);
                }
            }
        });
        JMenuItem removeDirSensors = new JMenuItem(rbx.getString("RemoveDirectionSensors") + "...");
        toolsMenu.add(removeDirSensors);
        removeDirSensors.addActionListener(e -> {
            if (this.sectionManager != null) {
                int n = this.sectionManager.removeDirectionSensorsFromSSL();
                if (n > 0) {
                    JmriJOptionPane.showMessageDialog(this.frame, MessageFormat.format(rbx.getString("Message33"), "" + n), Bundle.getMessage("ErrorTitle"), 0);
                } else if (n == -2) {
                    JmriJOptionPane.showMessageDialog(this.frame, rbx.getString("Message32"), Bundle.getMessage("ErrorTitle"), 0);
                } else if (n == 0) {
                    JmriJOptionPane.showMessageDialog(this.frame, rbx.getString("Message31"), Bundle.getMessage("MessageTitle"), 1);
                }
            }
        });
    }

    private void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this.sysName.setEnabled(false);
            this.sysName.setText("");
            this.sysNameLabel.setEnabled(false);
        } else {
            this.sysName.setEnabled(true);
            this.sysNameLabel.setEnabled(true);
        }
    }

    @Override
    protected String getClassName() {
        return SectionTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleSectionTable");
    }

    public class EntryPointTableModel
    extends AbstractTableModel {
        public static final int BLOCK_COLUMN = 0;
        public static final int TO_BLOCK_COLUMN = 1;
        public static final int DIRECTION_COLUMN = 2;

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2) {
                return JComboBox.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SectionTableAction.this.entryPointList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            if (c == 2) {
                if (!SectionTableAction.this.manualEntryPoints) {
                    return false;
                }
                if (r < SectionTableAction.this.entryPointList.size()) {
                    return !SectionTableAction.this.entryPointList.get(r).isFixed();
                }
                return true;
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return rbx.getString("FromBlock");
                }
                case 1: {
                    return rbx.getString("ToBlock");
                }
                case 2: {
                    return rbx.getString("TravelDirection");
                }
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            if (col == 0 || col == 1) {
                return new JTextField((int)37).getPreferredSize().width;
            }
            if (col == 2) {
                return new JTextField((int)9).getPreferredSize().width;
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx >= SectionTableAction.this.entryPointList.size()) {
                return null;
            }
            switch (c) {
                case 0: {
                    return SectionTableAction.this.entryPointList.get(rx).getFromBlockName();
                }
                case 1: {
                    return SectionTableAction.this.entryPointList.get(rx).getBlock().getDisplayName();
                }
                case 2: {
                    if (SectionTableAction.this.entryPointList.get(rx).isForwardType()) {
                        return rbx.getString("SectionForward");
                    }
                    if (SectionTableAction.this.entryPointList.get(rx).isReverseType()) {
                        return rbx.getString("SectionReverse");
                    }
                    return Bundle.getMessage("BeanStateUnknown");
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2) {
                if (((String)value).equals(rbx.getString("SectionForward"))) {
                    SectionTableAction.this.entryPointList.get(row).setTypeForward();
                } else if (((String)value).equals(rbx.getString("SectionReverse"))) {
                    SectionTableAction.this.entryPointList.get(row).setTypeReverse();
                } else if (((String)value).equals(Bundle.getMessage("BeanStateUnknown"))) {
                    SectionTableAction.this.entryPointList.get(row).setTypeUnknown();
                }
            }
        }
    }

    public class BlockTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;

        public BlockTableModel() {
            this.init();
        }

        final void init() {
            SectionTableAction.this.blockManager.addPropertyChangeListener(this);
        }

        public void dispose() {
            SectionTableAction.this.blockManager.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SectionTableAction.this.blockList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("LabelSystemName");
                }
                case 1: {
                    return Bundle.getMessage("LabelUserName");
                }
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx > SectionTableAction.this.blockList.size()) {
                return null;
            }
            switch (c) {
                case 0: {
                    return SectionTableAction.this.blockList.get(rx).getSystemName();
                }
                case 1: {
                    return SectionTableAction.this.blockList.get(rx).getUserName();
                }
            }
            return Bundle.getMessage("BeanStateUnknown");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

