/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.util.PhysicalLocation;
import jmri.util.PhysicalLocationPanel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPhysicalLocationAction
extends AbstractAction {
    Reporter _reporter;
    static ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.beantable.JmritBeantablePhysicalLocationBundle");
    SetPhysicalLocationFrame f = null;
    private static final Logger log = LoggerFactory.getLogger(SetPhysicalLocationAction.class);

    public SetPhysicalLocationAction(String s, Reporter reporter) {
        super(s);
        this._reporter = reporter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.f == null || !this.f.isVisible()) {
            this.f = new SetPhysicalLocationFrame(this._reporter);
            this.f.setVisible(true);
        }
        this.f.setExtendedState(0);
    }

    private static class SetPhysicalLocationPanel
    extends OperationsPanel {
        Reporter _reporter;
        String emptyReporterString = "(No Reporters)";
        List<Reporter> _reporterList = new ArrayList<Reporter>();
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        JButton closeButton = new JButton(Bundle.getMessage("ButtonClose"));
        JComboBox<String> reporterBox = this.getReporterComboBox();
        PhysicalLocationPanel physicalLocation;

        public SetPhysicalLocationPanel(Reporter l) {
            this._reporter = l;
            this.setLayout(new BoxLayout(this, 1));
            this.saveButton.setToolTipText(rb.getString("TipSaveButton"));
            this.closeButton.setToolTipText(rb.getString("TipCloseButton"));
            JPanel pLocation = new JPanel();
            pLocation.setBorder(BorderFactory.createTitledBorder(rb.getString("ReporterName")));
            pLocation.setToolTipText(rb.getString("TipSelectReporter"));
            pLocation.add(this.reporterBox);
            this.physicalLocation = new PhysicalLocationPanel(rb.getString("PhysicalLocation"));
            this.physicalLocation.setToolTipText(rb.getString("TipPhysicalLocation"));
            this.physicalLocation.setVisible(true);
            JPanel pControl = new JPanel();
            pControl.setLayout(new GridBagLayout());
            pControl.setBorder(BorderFactory.createTitledBorder(""));
            this.addItem(pControl, this.saveButton, 1, 0);
            this.addItem(pControl, this.closeButton, 2, 0);
            this.add(pLocation);
            this.add(this.physicalLocation);
            this.add(pControl);
            this.saveButton.addActionListener(this::saveButtonActionPerformed);
            this.closeButton.addActionListener(this::closeButtonActionPerformed);
            this.addComboBoxAction(this.reporterBox);
            this.reporterBox.setSelectedIndex(0);
            if (this._reporter != null) {
                this.reporterBox.setSelectedItem(this._reporter);
            }
            this.setVisible(true);
        }

        protected JComboBox<String> getReporterComboBox() {
            ReporterManager mgr = InstanceManager.getDefault(ReporterManager.class);
            ArrayList<String> displayList = new ArrayList<String>();
            for (Reporter r : mgr.getNamedBeanSet()) {
                if (r == null) continue;
                this._reporterList.add(r);
                displayList.add(r.getDisplayName());
            }
            if (displayList.isEmpty()) {
                displayList.add(this.emptyReporterString);
                this.saveButton.setEnabled(false);
            }
            String[] sa = new String[displayList.size()];
            displayList.toArray(sa);
            JComboBox<String> retv = new JComboBox<String>(sa);
            return retv;
        }

        public void closeButtonActionPerformed(ActionEvent ae) {
            JmriJOptionPane.showMessageDialog(this, rb.getString("CloseButtonSaveWarning"), rb.getString("CloseButtonSaveWarningTitle"), 2);
            this.dispose();
        }

        public void saveButtonActionPerformed(ActionEvent ae) {
            if (this.reporterBox.getSelectedItem() == null || this.reporterBox.getSelectedItem().equals("")) {
                JmriJOptionPane.showMessageDialog(this, rb.getString("SelectLocationToEdit"), rb.getString("NoLocationSelected"), 0);
                return;
            }
            Reporter l = this.getReporterFromList();
            if (l == null) {
                return;
            }
            int value = JmriJOptionPane.showConfirmDialog(null, MessageFormat.format(rb.getString("UpdatePhysicalLocation"), l.getDisplayName()), rb.getString("SaveLocation?"), 0);
            if (value == 0) {
                this.saveSpinnerValues(l);
            }
        }

        private Reporter getReporterFromList() {
            String s = (String)this.reporterBox.getSelectedItem();
            Reporter r = InstanceManager.getDefault(ReporterManager.class).getByDisplayName(s);
            return r;
        }

        @Override
        public void comboBoxActionPerformed(ActionEvent ae) {
            if (this.reporterBox.getSelectedItem() != null) {
                if (this.reporterBox.getSelectedItem().equals("") || this.reporterBox.getSelectedItem().equals(this.emptyReporterString)) {
                    this.resetSpinners();
                } else {
                    Reporter l = this.getReporterFromList();
                    this.loadSpinners(l);
                }
            }
        }

        @Override
        public void spinnerChangeEvent(ChangeEvent ae) {
            Reporter l;
            if (ae.getSource() == this.physicalLocation && (l = this.getReporterFromList()) != null) {
                PhysicalLocation.setBeanPhysicalLocation(this.physicalLocation.getValue(), l);
            }
        }

        private void resetSpinners() {
            this.physicalLocation.setValue(new PhysicalLocation());
        }

        private void loadSpinners(Reporter r) {
            log.debug("Load spinners Reporter location {}", (Object)r.getSystemName());
            this.physicalLocation.setValue(PhysicalLocation.getBeanPhysicalLocation(r));
        }

        private void saveSpinnerValues(Reporter r) {
            log.debug("Save train icons coordinates for location {}", (Object)r.getSystemName());
            PhysicalLocation.setBeanPhysicalLocation(this.physicalLocation.getValue(), r);
        }
    }

    private static class SetPhysicalLocationFrame
    extends OperationsFrame {
        public SetPhysicalLocationFrame(Reporter reporter) {
            super(rb.getString("MenuSetPhysicalLocation"), new SetPhysicalLocationPanel(reporter));
            this.addHelpMenu("package.jmri.jmrit.operations.Operations_SetTrainIconCoordinates", true);
            super.pack();
        }
    }
}

