/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SignalGroup;
import jmri.SignalGroupManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.implementation.SingleTurnoutSignalHead;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.SignalGroupSubTableAction;
import jmri.swing.NamedBeanComboBox;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalGroupTableAction
extends AbstractTableAction<SignalGroup>
implements PropertyChangeListener {
    JTextField _systemName = new JTextField(10);
    JTextField _userName = new JTextField(22);
    JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    String systemNameAuto = this.getClass().getName() + ".AutoSystemName";
    UserPreferencesManager pref;
    JmriJFrame addFrame = null;
    SignalGroupSignalHeadModel _SignalGroupHeadModel;
    JScrollPane _SignalGroupHeadScrollPane;
    SignalMastAspectModel _AspectModel;
    JScrollPane _SignalAppearanceScrollPane;
    NamedBeanComboBox<SignalMast> mainSignalComboBox;
    ButtonGroup selGroup = null;
    JRadioButton allButton = null;
    JRadioButton includedButton = null;
    JLabel nameLabel = new JLabel(Bundle.getMessage("LabelSystemName"), 11);
    JLabel userLabel = new JLabel(Bundle.getMessage("LabelUserName"), 11);
    JLabel fixedSystemName = new JLabel("xxxxxxxxxxx");
    JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete") + " " + Bundle.getMessage("BeanNameSignalGroup"));
    JButton createButton = new JButton(Bundle.getMessage("ButtonCreate"));
    JButton updateButton = new JButton(Bundle.getMessage("ButtonApply"));
    JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    static final String createInst = Bundle.getMessage("SignalGroupAddStatusInitial1", Bundle.getMessage("ButtonCreate"));
    static final String updateInst = Bundle.getMessage("SignalGroupAddStatusInitial3", Bundle.getMessage("ButtonApply"));
    static final String cancelInst = Bundle.getMessage("SignalGroupAddStatusInitial4", Bundle.getMessage("ButtonCancel"));
    JLabel status1 = new JLabel(createInst);
    JLabel status2 = new JLabel(cancelInst);
    JPanel p2xs = null;
    JPanel p2xsi = null;
    JPanel p3xsi = null;
    SignalGroup curSignalGroup = null;
    boolean signalGroupDirty = false;
    private boolean checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    boolean inEditMode = false;
    JmriJFrame signalHeadEditFrame = null;
    private boolean showAll = true;
    private static int ROW_HEIGHT;
    private static String[] COLUMN_NAMES;
    private static String[] COLUMN_SIG_NAMES;
    private static String[] signalStates;
    private static int[] signalStatesValues;
    private ArrayList<SignalGroupSignalHead> _signalHeadsList;
    private ArrayList<SignalGroupSignalHead> _includedSignalHeadsList;
    private ArrayList<SignalMastAspect> _mastAspectsList;
    private ArrayList<SignalMastAspect> _includedMastAspectsList;
    private static final Logger log;

    public SignalGroupTableAction(String s) {
        super(s);
        if (InstanceManager.getNullableDefault(SignalGroupManager.class) == null) {
            super.setEnabled(false);
        }
    }

    public SignalGroupTableAction() {
        this(Bundle.getMessage("TitleSignalGroupTable"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("UpdateCondition")) {
            for (int i = this._signalHeadsList.size() - 1; i >= 0; --i) {
                SignalGroupSignalHead signalHead = this._signalHeadsList.get(i);
                SignalHead sigBean = signalHead.getBean();
                if (this.curSignalGroup.isHeadIncluded(sigBean)) {
                    signalHead.setIncluded(true);
                    signalHead.setOnState(this.curSignalGroup.getHeadOnState(sigBean));
                    signalHead.setOffState(this.curSignalGroup.getHeadOffState(sigBean));
                    continue;
                }
                signalHead.setIncluded(false);
            }
        }
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<SignalGroup>(){
            public static final int COMMENTCOL = 2;
            public static final int DELETECOL = 3;
            public static final int ENABLECOL = 4;
            public static final int EDITCOL = 5;

            @Override
            public int getColumnCount() {
                return 6;
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 5: {
                        return "";
                    }
                    case 4: {
                        return Bundle.getMessage("ColumnHeadEnabled");
                    }
                    case 2: {
                        return Bundle.getMessage("ColumnComment");
                    }
                    case 3: {
                        return "";
                    }
                }
                return super.getColumnName(col);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 3: 
                    case 5: {
                        return JButton.class;
                    }
                    case 4: {
                        return Boolean.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                return super.getColumnClass(col);
            }

            @Override
            public int getPreferredWidth(int col) {
                switch (col) {
                    case 5: {
                        return new JTextField((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width;
                    }
                    case 4: {
                        return new JTextField((int)6).getPreferredSize().width;
                    }
                    case 2: {
                        return new JTextField((int)30).getPreferredSize().width;
                    }
                    case 3: {
                        return new JTextField((String)Bundle.getMessage((String)"ButtonDelete")).getPreferredSize().width;
                    }
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                return super.isCellEditable(row, col);
            }

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 5: {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    case 4: {
                        return ((SignalGroup)this.getValueAt(row, 0)).getEnabled();
                    }
                    case 2: {
                        SignalGroup b = (SignalGroup)this.getValueAt(row, 0);
                        return b != null ? b.getComment() : null;
                    }
                    case 3: {
                        return Bundle.getMessage("ButtonDelete");
                    }
                }
                return super.getValueAt(row, col);
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                switch (col) {
                    case 5: {
                        SwingUtilities.invokeLater(() -> {
                            SignalGroupTableAction.this.addPressed(null);
                            SignalGroupTableAction.this._systemName.setText(((SignalGroup)this.getValueAt(row, 0)).toString());
                            SignalGroupTableAction.this.editPressed(null);
                        });
                        break;
                    }
                    case 4: {
                        SignalGroup r = (SignalGroup)this.getValueAt(row, 0);
                        r.setEnabled(!r.getEnabled());
                        break;
                    }
                    case 2: {
                        this.getBySystemName((String)this.sysNameList.get(row)).setComment((String)value);
                        this.fireTableRowsUpdated(row, row);
                        break;
                    }
                    case 3: {
                        this.deleteBean(row, col);
                        break;
                    }
                    default: {
                        super.setValueAt(value, row, col);
                    }
                }
            }

            @Override
            protected void configDeleteColumn(JTable table) {
                SignalGroupTableAction.this.setColumnToHoldButton(table, 3, new JButton(Bundle.getMessage("ButtonDelete")));
            }

            @Override
            protected void doDelete(SignalGroup bean) {
                super.doDelete(bean);
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Enabled")) {
                    return true;
                }
                return super.matchPropertyName(e);
            }

            public SignalGroupManager getManager() {
                return InstanceManager.getDefault(SignalGroupManager.class);
            }

            @Override
            public SignalGroup getBySystemName(@Nonnull String name) {
                return InstanceManager.getDefault(SignalGroupManager.class).getBySystemName(name);
            }

            @Override
            public SignalGroup getByUserName(@Nonnull String name) {
                return InstanceManager.getDefault(SignalGroupManager.class).getByUserName(name);
            }

            @Override
            public int getDisplayDeleteMsg() {
                return 0;
            }

            @Override
            public void setDisplayDeleteMsg(int boo) {
            }

            @Override
            protected String getMasterClassName() {
                return SignalGroupTableAction.this.getClassName();
            }

            @Override
            public void clickOn(SignalGroup t) {
            }

            @Override
            public String getValue(String s) {
                return "Set";
            }

            @Override
            protected String getBeanType() {
                return "Signal Group";
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleSignalGroupTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.SignalGroupTable";
    }

    int signalStateFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, signalStatesValues, signalStates);
        if (result < 0) {
            log.warn("unexpected mode string in signalState Aspect: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setSignalStateBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, signalStatesValues, signalStates);
        box.setSelectedItem(result);
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.inEditMode) {
            log.debug("Can not open another editing session for Signal Groups.");
            String workingTitle = this._systemName.getText();
            if (workingTitle == null || workingTitle.isEmpty()) {
                workingTitle = Bundle.getMessage("NONE");
                this._systemName.setText(workingTitle);
            }
            JmriJOptionPane.showMessageDialog(this.addFrame, Bundle.getMessage("SigGroupEditBusyWarning", workingTitle), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this._mastAspectsList = null;
        SignalHeadManager shm = InstanceManager.getDefault(SignalHeadManager.class);
        this._signalHeadsList = new ArrayList();
        for (SignalHead sh : shm.getNamedBeanSet()) {
            String systemName = sh.getSystemName();
            if (sh.getClass().getName().contains("SingleTurnoutSignalHead")) {
                String userName = sh.getUserName();
                this._signalHeadsList.add(new SignalGroupSignalHead(systemName, userName));
                continue;
            }
            log.debug("Signal Head {} is not a Single Output Controlled Signal Head", (Object)systemName);
        }
        if (this.addFrame == null) {
            this.mainSignalComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalMastManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
            JComboBoxUtil.setupComboBoxMaxRows(this.mainSignalComboBox);
            this.mainSignalComboBox.setAllowNull(true);
            this.addFrame = new JmriJFrame(Bundle.getMessage("AddSignalGroup"), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.SignalGroupAddEdit", true);
            this.addFrame.setEscapeKeyClosesWindow(true);
            this.addFrame.setLocation(100, 30);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            Container contentPane = this.addFrame.getContentPane();
            JPanel namesGrid = new JPanel();
            GridLayout layout = new GridLayout(2, 2, 10, 0);
            namesGrid.setLayout(layout);
            namesGrid.add(this.nameLabel);
            this.nameLabel.setLabelFor(this._systemName);
            JPanel ps = new JPanel();
            ps.setLayout(new BoxLayout(ps, 0));
            ps.add(this._systemName);
            this._systemName.setToolTipText(Bundle.getMessage("SignalGroupSysNameTooltip"));
            ps.add(this.fixedSystemName);
            this.fixedSystemName.setVisible(false);
            ps.add(this._autoSystemName);
            this._autoSystemName.addActionListener(e1 -> this.autoSystemName());
            if (this.pref.getSimplePreferenceState(this.systemNameAuto)) {
                this._autoSystemName.setSelected(true);
            }
            namesGrid.add(ps);
            namesGrid.add(this.userLabel);
            this.userLabel.setLabelFor(this._userName);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(this._userName);
            this._userName.setToolTipText(Bundle.getMessage("SignalGroupUserNameTooltip"));
            namesGrid.add(p);
            contentPane.add(namesGrid);
            JPanel py = new JPanel();
            py.add(new JLabel(Bundle.getMessage("Show")));
            this.selGroup = new ButtonGroup();
            this.allButton = new JRadioButton(Bundle.getMessage("All"), true);
            this.selGroup.add(this.allButton);
            py.add(this.allButton);
            this.allButton.addActionListener(e1 -> {
                if (!this.showAll) {
                    this.showAll = true;
                    this._SignalGroupHeadModel.fireTableDataChanged();
                    this._AspectModel.fireTableDataChanged();
                }
            });
            this.includedButton = new JRadioButton(Bundle.getMessage("Included"), false);
            this.selGroup.add(this.includedButton);
            py.add(this.includedButton);
            this.includedButton.addActionListener(e1 -> {
                if (this.showAll) {
                    this.showAll = false;
                    this.initializeIncludedList();
                    this._SignalGroupHeadModel.fireTableDataChanged();
                    this._AspectModel.fireTableDataChanged();
                }
            });
            py.add(new JLabel("  " + Bundle.getMessage("_and_", Bundle.getMessage("LabelAspects"), Bundle.getMessage("SignalHeads"))));
            contentPane.add(py);
            JPanel p3 = new JPanel();
            p3.setLayout(new BoxLayout(p3, 1));
            JPanel p31 = new JPanel();
            p31.add(new JLabel(Bundle.getMessage("EnterMastAttached", Bundle.getMessage("BeanNameSignalMast"))));
            p3.add(p31);
            JPanel p32 = new JPanel();
            p32.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameSignalMast"))));
            p32.add(this.mainSignalComboBox);
            p3.add(p32);
            this.p3xsi = new JPanel();
            JPanel p3xsiSpace = new JPanel();
            p3xsiSpace.setLayout(new BoxLayout(p3xsiSpace, 1));
            p3xsiSpace.add(new JLabel(" "));
            this.p3xsi.add(p3xsiSpace);
            JPanel p31si = new JPanel();
            p31si.setLayout(new BoxLayout(p31si, 1));
            p31si.add(new JLabel(Bundle.getMessage("SelectAppearanceTrigger")));
            this.p3xsi.add(p31si);
            this._AspectModel = new SignalMastAspectModel();
            JTable SignalMastAspectTable = new JTable(this._AspectModel);
            TableRowSorter<SignalMastAspectModel> smaSorter = new TableRowSorter<SignalMastAspectModel>(this._AspectModel);
            smaSorter.setComparator(0, new AlphanumComparator());
            RowSorterUtil.setSortOrder(smaSorter, 0, SortOrder.ASCENDING);
            SignalMastAspectTable.setRowSorter(smaSorter);
            SignalMastAspectTable.setRowSelectionAllowed(false);
            SignalMastAspectTable.setPreferredScrollableViewportSize(new Dimension(200, 80));
            TableColumnModel SignalMastAspectColumnModel = SignalMastAspectTable.getColumnModel();
            TableColumn includeColumnA = SignalMastAspectColumnModel.getColumn(1);
            includeColumnA.setResizable(false);
            includeColumnA.setMinWidth(30);
            includeColumnA.setMaxWidth(60);
            TableColumn sNameColumnA = SignalMastAspectColumnModel.getColumn(0);
            sNameColumnA.setResizable(true);
            sNameColumnA.setMinWidth(75);
            sNameColumnA.setMaxWidth(140);
            this._SignalAppearanceScrollPane = new JScrollPane(SignalMastAspectTable);
            this.p3xsi.add((Component)this._SignalAppearanceScrollPane, "Center");
            p3.add(this.p3xsi);
            this.p3xsi.setVisible(true);
            this.mainSignalComboBox.addActionListener(event -> {
                if (this.mainSignalComboBox.getSelectedItem() == null) {
                    log.debug("Empty line in mainSignal comboBox");
                } else if (this.curSignalGroup == null || this.mainSignalComboBox.getSelectedItem() != this.curSignalGroup.getSignalMast()) {
                    log.debug("comboBox closed, choice: {}", this.mainSignalComboBox.getSelectedItem());
                    this.setValidSignalMastAspects();
                } else {
                    log.debug("Mast {} picked in mainSignal comboBox", this.mainSignalComboBox.getSelectedItem());
                }
            });
            Border p3Border = BorderFactory.createEtchedBorder();
            p3.setBorder(p3Border);
            contentPane.add(p3);
            this.p2xsi = new JPanel();
            JPanel p2xsiSpace = new JPanel();
            p2xsiSpace.setLayout(new BoxLayout(p2xsiSpace, 1));
            p2xsiSpace.add(new JLabel("XXX"));
            this.p2xsi.add(p2xsiSpace);
            JPanel p21si = new JPanel();
            p21si.setLayout(new BoxLayout(p21si, 1));
            p21si.add(new JLabel(Bundle.getMessage("SelectInGroup", Bundle.getMessage("SignalHeads"))));
            this.p2xsi.add(p21si);
            this._SignalGroupHeadModel = new SignalGroupSignalHeadModel();
            JTable SignalGroupHeadTable = new JTable(this._SignalGroupHeadModel);
            TableRowSorter<SignalGroupSignalHeadModel> sgsSorter = new TableRowSorter<SignalGroupSignalHeadModel>(this._SignalGroupHeadModel);
            RowSorterUtil.setSortOrder(sgsSorter, 0, SortOrder.ASCENDING);
            SignalGroupHeadTable.setRowSorter(sgsSorter);
            SignalGroupHeadTable.setRowSelectionAllowed(false);
            SignalGroupHeadTable.setPreferredScrollableViewportSize(new Dimension(480, 160));
            TableColumnModel SignalGroupSignalColumnModel = SignalGroupHeadTable.getColumnModel();
            TableColumn includeColumnSi = SignalGroupSignalColumnModel.getColumn(2);
            includeColumnSi.setResizable(false);
            includeColumnSi.setMinWidth(30);
            includeColumnSi.setMaxWidth(60);
            TableColumn sNameColumnSi = SignalGroupSignalColumnModel.getColumn(0);
            sNameColumnSi.setResizable(true);
            sNameColumnSi.setMinWidth(75);
            sNameColumnSi.setMaxWidth(95);
            TableColumn uNameColumnSi = SignalGroupSignalColumnModel.getColumn(1);
            uNameColumnSi.setResizable(true);
            uNameColumnSi.setMinWidth(100);
            uNameColumnSi.setMaxWidth(260);
            TableColumn stateOnColumnSi = SignalGroupSignalColumnModel.getColumn(3);
            stateOnColumnSi.setResizable(false);
            stateOnColumnSi.setMinWidth(Bundle.getMessage("SignalHeadStateFlashingYellow").length());
            stateOnColumnSi.setMaxWidth(100);
            TableColumn stateOffColumnSi = SignalGroupSignalColumnModel.getColumn(4);
            stateOffColumnSi.setResizable(false);
            stateOffColumnSi.setMinWidth(50);
            stateOffColumnSi.setMaxWidth(100);
            TableColumn editColumnSi = SignalGroupSignalColumnModel.getColumn(5);
            editColumnSi.setResizable(false);
            editColumnSi.setMinWidth(Bundle.getMessage("ButtonEdit").length());
            editColumnSi.setMaxWidth(100);
            JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
            this.setColumnToHoldButton(SignalGroupHeadTable, 5, editButton);
            this._SignalGroupHeadScrollPane = new JScrollPane(SignalGroupHeadTable);
            this.p2xsi.add((Component)this._SignalGroupHeadScrollPane, "Center");
            this.p2xsi.setToolTipText(Bundle.getMessage("SignalGroupHeadTableTooltip"));
            contentPane.add(this.p2xsi);
            this.p2xsi.setVisible(true);
            JPanel pa = new JPanel();
            pa.setLayout(new BoxLayout(pa, 1));
            JPanel p1 = new JPanel();
            p1.setLayout(new FlowLayout());
            this.status1.setFont(this.status1.getFont().deriveFont(0.9f * (float)this.nameLabel.getFont().getSize()));
            this.status1.setForeground(Color.gray);
            p1.add(this.status1);
            JPanel p2 = new JPanel();
            p2.setLayout(new FlowLayout());
            this.status2.setFont(this.status1.getFont().deriveFont(0.9f * (float)this.nameLabel.getFont().getSize()));
            this.status2.setForeground(Color.gray);
            p2.add(this.status2);
            pa.add(p1);
            pa.add(p2);
            Border pBorder = BorderFactory.createEtchedBorder();
            pa.setBorder(pBorder);
            contentPane.add(pa);
            JPanel pb = new JPanel();
            pb.setLayout(new FlowLayout(4));
            pb.add(this.cancelButton);
            this.cancelButton.addActionListener(this::cancelPressed);
            this.cancelButton.setVisible(true);
            pb.add(this.deleteButton);
            this.deleteButton.addActionListener(this::deletePressed);
            this.deleteButton.setToolTipText(Bundle.getMessage("DeleteSignalGroupInSystem"));
            pb.add(this.createButton);
            this.createButton.addActionListener(this::createPressed);
            this.createButton.setToolTipText(Bundle.getMessage("TooltipCreateGroup"));
            pb.add(this.updateButton);
            this.updateButton.addActionListener(e1 -> this.updatePressed(e1, false, false));
            this.updateButton.setToolTipText(Bundle.getMessage("TooltipUpdateGroup"));
            contentPane.add(pb);
            this.addFrame.pack();
            p2xsiSpace.setVisible(false);
        } else {
            this.mainSignalComboBox.setSelectedItem(null);
            this.addFrame.setTitle(Bundle.getMessage("AddSignalGroup"));
        }
        this.status1.setText(createInst);
        this._autoSystemName.setVisible(true);
        this.updateButton.setVisible(false);
        this.createButton.setVisible(true);
        this.addFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SignalGroupTableAction.this.signalGroupDirty && !SignalGroupTableAction.this.checkEnabled) {
                    InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("SignalGroup")), SignalGroupTableAction.this.getClassName(), "remindSignalGroup");
                    SignalGroupTableAction.this.signalGroupDirty = false;
                }
                if (SignalGroupTableAction.this.addFrame != null) {
                    SignalGroupTableAction.this.addFrame.setVisible(false);
                }
                SignalGroupTableAction.this.inEditMode = false;
                SignalGroupTableAction.this.finishUpdate();
                SignalGroupTableAction.this._SignalGroupHeadModel.dispose();
                SignalGroupTableAction.this._AspectModel.dispose();
            }
        });
        this.addFrame.setVisible(true);
        this.autoSystemName();
    }

    void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this.nameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this.nameLabel.setEnabled(true);
        }
    }

    void setColumnToHoldButton(JTable table, int column, JButton sample) {
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        table.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        table.setDefaultEditor(JButton.class, buttonEditor);
        table.setRowHeight(sample.getPreferredSize().height);
        table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 4);
    }

    void initializeIncludedList() {
        int i;
        this._includedMastAspectsList = new ArrayList();
        for (i = 0; i < this._mastAspectsList.size(); ++i) {
            if (!this._mastAspectsList.get(i).isIncluded()) continue;
            this._includedMastAspectsList.add(this._mastAspectsList.get(i));
        }
        this._includedSignalHeadsList = new ArrayList();
        for (i = 0; i < this._signalHeadsList.size(); ++i) {
            if (!this._signalHeadsList.get(i).isIncluded()) continue;
            this._includedSignalHeadsList.add(this._signalHeadsList.get(i));
        }
    }

    void createPressed(ActionEvent e) {
        if (!this._autoSystemName.isSelected() && !this.checkNewNamesOK()) {
            log.debug("NewNames not OK");
            return;
        }
        this.updatePressed(e, true, true);
        this.pref.setSimplePreferenceState(this.systemNameAuto, this._autoSystemName.isSelected());
    }

    boolean checkNewNamesOK() {
        SignalGroup g;
        String sName = this._systemName.getText();
        String uName = this._userName.getText();
        if (sName.length() == 0) {
            this.status1.setText(Bundle.getMessage("AddBeanStatusEnter"));
            this.status1.setForeground(Color.red);
            return false;
        }
        if (!uName.isEmpty() && (g = InstanceManager.getDefault(SignalGroupManager.class).getByUserName(uName)) != null) {
            this.status1.setText(Bundle.getMessage("SignalGroupDuplicateUserNameWarning", uName));
            return false;
        }
        sName = InstanceManager.getDefault(SignalGroupManager.class).makeSystemName(sName);
        g = InstanceManager.getDefault(SignalGroupManager.class).getBySystemName(sName);
        if (g != null) {
            this.status1.setText(Bundle.getMessage("SignalGroupDuplicateSystemNameWarning", sName));
            return false;
        }
        return true;
    }

    boolean checkValidSignalMast() {
        SignalMast mMast = (SignalMast)this.mainSignalComboBox.getSelectedItem();
        if (mMast == null) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("NoMastSelectedWarning"), Bundle.getMessage("ErrorTitle"), 2);
            return false;
        }
        return true;
    }

    SignalGroup checkNamesOK() {
        SignalGroup g;
        String sName = this._systemName.getText();
        String uName = this._userName.getText();
        if (this._autoSystemName.isSelected() && !this.inEditMode) {
            log.debug("SignalGroupTableAction checkNamesOK new autogroup");
            g = InstanceManager.getDefault(SignalGroupManager.class).newSignalGroupWithUserName(uName);
        } else {
            if (sName.length() == 0) {
                this.status1.setText(Bundle.getMessage("AddBeanStatusEnter"));
                this.status1.setForeground(Color.red);
                return null;
            }
            try {
                sName = InstanceManager.getDefault(SignalGroupManager.class).makeSystemName(sName);
                g = InstanceManager.getDefault(SignalGroupManager.class).provideSignalGroup(sName, uName);
            }
            catch (IllegalArgumentException ex) {
                log.error("checkNamesOK; Unknown failure to create Signal Group with System Name: {}", (Object)sName);
                g = null;
            }
        }
        if (g == null) {
            log.error("Unknown failure to create Signal Group with System Name: {}", (Object)sName);
        }
        return g;
    }

    int setHeadInformation(SignalGroup g) {
        int i;
        for (i = 0; i < g.getNumHeadItems(); ++i) {
            SignalHead sig = g.getHeadItemBeanByIndex(i);
            boolean valid = false;
            for (int x = 0; x < this._includedSignalHeadsList.size(); ++x) {
                SignalGroupSignalHead sh = this._includedSignalHeadsList.get(x);
                if (sig != sh.getBean()) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            g.deleteSignalHead(sig);
        }
        for (i = 0; i < this._includedSignalHeadsList.size(); ++i) {
            SignalGroupSignalHead s = this._includedSignalHeadsList.get(i);
            SignalHead sig = s.getBean();
            if (g.isHeadIncluded(sig)) continue;
            g.addSignalHead(sig);
            g.setHeadOnState(sig, s.getOnStateInt());
            g.setHeadOffState(sig, s.getOffStateInt());
        }
        return this._includedSignalHeadsList.size();
    }

    void setMastAspectInformation(SignalGroup g) {
        g.clearSignalMastAspect();
        for (int x = 0; x < this._includedMastAspectsList.size(); ++x) {
            g.addSignalMastAspect(this._includedMastAspectsList.get(x).getAspect());
        }
    }

    void setValidSignalMastAspects() {
        SignalMast sm = (SignalMast)this.mainSignalComboBox.getSelectedItem();
        if (sm == null) {
            log.debug("Null picked in mainSignal comboBox. Probably line 1 or no masts in system");
            return;
        }
        log.debug("Mast {} picked in mainSignal comboBox", this.mainSignalComboBox.getSelectedItem());
        Vector<String> aspects = sm.getValidAspects();
        this._mastAspectsList = new ArrayList(aspects.size());
        for (int i = 0; i < aspects.size(); ++i) {
            this._mastAspectsList.add(new SignalMastAspect(aspects.get(i)));
        }
        this._AspectModel.fireTableDataChanged();
    }

    void cancelPressed(ActionEvent e) {
        this.cancelEdit();
    }

    void cancelEdit() {
        if (this.inEditMode) {
            this.status1.setText(createInst);
        }
        if (this.addFrame != null) {
            this.addFrame.setVisible(false);
        }
        this.inEditMode = false;
        this.finishUpdate();
        this._SignalGroupHeadModel.dispose();
        this._AspectModel.dispose();
    }

    void editPressed(ActionEvent e) {
        int i;
        String sName = InstanceManager.getDefault(SignalGroupManager.class).makeSystemName(this._systemName.getText());
        SignalGroup g = InstanceManager.getDefault(SignalGroupManager.class).getBySystemName(sName);
        if (g == null) {
            return;
        }
        g.addPropertyChangeListener(this);
        this.curSignalGroup = g;
        log.debug("curSignalGroup was set");
        SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(g.getSignalMastName());
        if (sm != null) {
            Vector<String> aspects = sm.getValidAspects();
            this._mastAspectsList = new ArrayList(aspects.size());
            for (i = 0; i < aspects.size(); ++i) {
                this._mastAspectsList.add(new SignalMastAspect(aspects.get(i)));
            }
        } else {
            log.error("Failed to get signal mast {}", (Object)g.getSignalMastName());
        }
        this.nameLabel.setEnabled(true);
        this.fixedSystemName.setText(sName);
        this.fixedSystemName.setVisible(true);
        this._systemName.setVisible(false);
        this.mainSignalComboBox.setSelectedItem(g.getSignalMast());
        this._userName.setText(g.getUserName());
        int setRow = 0;
        for (i = this._signalHeadsList.size() - 1; i >= 0; --i) {
            SignalGroupSignalHead sgsh = this._signalHeadsList.get(i);
            SignalHead sigBean = sgsh.getBean();
            if (g.isHeadIncluded(sigBean)) {
                sgsh.setIncluded(true);
                sgsh.setOnState(g.getHeadOnState(sigBean));
                sgsh.setOffState(g.getHeadOffState(sigBean));
                setRow = i;
                continue;
            }
            sgsh.setIncluded(false);
        }
        this._SignalGroupHeadScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._SignalGroupHeadModel.fireTableDataChanged();
        for (i = 0; i < this._mastAspectsList.size(); ++i) {
            SignalMastAspect _aspect = this._mastAspectsList.get(i);
            String asp = _aspect.getAspect();
            if (g.isSignalMastAspectIncluded(asp)) {
                _aspect.setIncluded(true);
                setRow = i;
                continue;
            }
            _aspect.setIncluded(false);
        }
        this._SignalAppearanceScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._AspectModel.fireTableDataChanged();
        this.initializeIncludedList();
        this.signalGroupDirty = true;
        this.status1.setText(updateInst);
        this.updateButton.setVisible(true);
        this.createButton.setVisible(false);
        this._autoSystemName.setVisible(false);
        this.fixedSystemName.setVisible(true);
        this._systemName.setVisible(false);
        this.addFrame.setTitle(Bundle.getMessage("EditSignalGroup"));
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.inEditMode = true;
    }

    void deletePressed(ActionEvent e) {
        InstanceManager.getDefault(SignalGroupManager.class).deleteSignalGroup(this.curSignalGroup);
        this.curSignalGroup = null;
        log.debug("DeletePressed; curSignalGroup set to null");
        this.finishUpdate();
    }

    void updatePressed(ActionEvent e, boolean newSignalGroup, boolean close) {
        String uName = this._userName.getText();
        SignalGroup g = this.checkNamesOK();
        if (g == null) {
            log.debug("null signalGroup under edit");
            return;
        }
        if (!this.checkValidSignalMast()) {
            log.debug("invalid signal mast under edit");
            return;
        }
        g.setUserName(uName);
        this.initializeIncludedList();
        this.setHeadInformation(g);
        this.setMastAspectInformation(g);
        g.setSignalMast((SignalMast)this.mainSignalComboBox.getSelectedItem(), this.mainSignalComboBox.getSelectedItemDisplayName());
        this.signalGroupDirty = true;
        this.curSignalGroup = g;
        if (close) {
            this.finishUpdate();
        }
        this.status1.setForeground(Color.gray);
        this.status1.setText((newSignalGroup ? Bundle.getMessage("SignalGroupAddStatusCreated") : Bundle.getMessage("SignalGroupAddStatusUpdated")) + ": \"" + uName + "\"");
    }

    void finishUpdate() {
        int i;
        if (this.curSignalGroup != null) {
            this.curSignalGroup.removePropertyChangeListener(this);
        }
        this._systemName.setVisible(true);
        this.fixedSystemName.setVisible(false);
        this._systemName.setText("");
        this._userName.setText("");
        this._autoSystemName.setVisible(true);
        this.autoSystemName();
        this.mainSignalComboBox.setSelectedItem(null);
        if (this._signalHeadsList == null) {
            log.debug("FinishUpdate; _signalHeadsList empty; no heads present");
        } else {
            for (i = this._signalHeadsList.size() - 1; i >= 0; --i) {
                this._signalHeadsList.get(i).setIncluded(false);
            }
        }
        if (this._mastAspectsList == null) {
            log.debug("FinishUpdate; _mastAspectsList empty; no mast was selected");
        } else {
            for (i = this._mastAspectsList.size() - 1; i >= 0; --i) {
                this._mastAspectsList.get(i).setIncluded(false);
            }
        }
        this.inEditMode = false;
        this.showAll = true;
        this.curSignalGroup = null;
        log.debug("FinishUpdate; curSignalGroup set to null. Hiding addFrame next");
        if (this.addFrame != null) {
            this.addFrame.setVisible(false);
        }
    }

    void signalHeadEditPressed(int row) {
        if (this.curSignalGroup == null) {
            log.debug("From signalHeadCreatePressed");
            if (!this._autoSystemName.isSelected() && !this.checkNewNamesOK()) {
                log.debug("signalHeadEditPressed: checkNewNamesOK = false");
                return;
            }
            if (!this.checkValidSignalMast()) {
                return;
            }
            this.updatePressed(null, true, false);
        }
        if (!this.curSignalGroup.isHeadIncluded(this._SignalGroupHeadModel.getBean(row))) {
            this.curSignalGroup.addSignalHead(this._SignalGroupHeadModel.getBean(row));
        }
        this._SignalGroupHeadModel.fireTableDataChanged();
        log.debug("signalHeadEditPressed: opening sbaTableAction for edit");
        SignalGroupSubTableAction editSignalHead = new SignalGroupSubTableAction();
        editSignalHead.editHead(this.curSignalGroup, this._SignalGroupHeadModel.getDisplayName(row));
    }

    @Override
    protected String getClassName() {
        return SignalGroupTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleSignalGroupTable");
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "remindSignalGroup", Bundle.getMessage("HideSaveReminder"));
        super.setMessagePreferencesDetails();
    }

    static {
        COLUMN_NAMES = new String[]{Bundle.getMessage("ColumnSystemName"), Bundle.getMessage("ColumnUserName"), Bundle.getMessage("Include"), Bundle.getMessage("ColumnLabelSetState")};
        COLUMN_SIG_NAMES = new String[]{Bundle.getMessage("ColumnSystemName"), Bundle.getMessage("ColumnUserName"), Bundle.getMessage("Include"), Bundle.getMessage("OnAppearance"), Bundle.getMessage("OffAppearance"), ""};
        signalStates = new String[]{Bundle.getMessage("SignalHeadStateDark"), Bundle.getMessage("SignalHeadStateRed"), Bundle.getMessage("SignalHeadStateYellow"), Bundle.getMessage("SignalHeadStateGreen"), Bundle.getMessage("SignalHeadStateLunar")};
        signalStatesValues = new int[]{0, 1, 4, 16, 64};
        log = LoggerFactory.getLogger(SignalGroupTableAction.class);
    }

    private static class SignalMastAspect {
        boolean _include;
        String _aspect;

        SignalMastAspect(String aspect) {
            this._aspect = aspect;
        }

        void setIncluded(boolean include) {
            this._include = include;
        }

        boolean isIncluded() {
            return this._include;
        }

        void setAspect(String asp) {
            this._aspect = asp;
        }

        String getAspect() {
            return this._aspect;
        }
    }

    private static class SignalGroupSignalHead {
        SignalHead _signalHead = null;
        boolean _included = false;
        int _onState = 0;
        int _offState = 0;

        SignalGroupSignalHead(String sysName, String userName) {
            SignalHead anySigHead = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sysName);
            if (anySigHead != null) {
                if (anySigHead.getClass().getName().contains("SingleTurnoutSignalHead")) {
                    SingleTurnoutSignalHead oneSigHead = (SingleTurnoutSignalHead)InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sysName);
                    if (oneSigHead != null) {
                        this._onState = oneSigHead.getOnAppearance();
                        this._offState = oneSigHead.getOffAppearance();
                        this._signalHead = oneSigHead;
                    } else {
                        log.error("SignalGroupSignalHead: Failed to get oneSigHead head {}", (Object)sysName);
                    }
                }
            } else {
                log.error("SignalGroupSignalHead: Failed to get signal head {}", (Object)sysName);
            }
        }

        SignalHead getBean() {
            return this._signalHead;
        }

        String getSysName() {
            return this._signalHead.getSystemName();
        }

        String getUserName() {
            return this._signalHead.getUserName();
        }

        boolean isIncluded() {
            return this._included;
        }

        void setIncluded(boolean include) {
            this._included = include;
        }

        String getOnState() {
            switch (this._onState) {
                case 0: {
                    return Bundle.getMessage("SignalHeadStateDark");
                }
                case 1: {
                    return Bundle.getMessage("SignalHeadStateRed");
                }
                case 4: {
                    return Bundle.getMessage("SignalHeadStateYellow");
                }
                case 16: {
                    return Bundle.getMessage("SignalHeadStateGreen");
                }
                case 64: {
                    return Bundle.getMessage("SignalHeadStateLunar");
                }
                case 2: {
                    return Bundle.getMessage("SignalHeadStateFlashingRed");
                }
                case 8: {
                    return Bundle.getMessage("SignalHeadStateFlashingYellow");
                }
                case 32: {
                    return Bundle.getMessage("SignalHeadStateFlashingGreen");
                }
                case 128: {
                    return Bundle.getMessage("SignalHeadStateFlashingLunar");
                }
            }
            return "";
        }

        String getOffState() {
            switch (this._offState) {
                case 0: {
                    return Bundle.getMessage("SignalHeadStateDark");
                }
                case 1: {
                    return Bundle.getMessage("SignalHeadStateRed");
                }
                case 4: {
                    return Bundle.getMessage("SignalHeadStateYellow");
                }
                case 16: {
                    return Bundle.getMessage("SignalHeadStateGreen");
                }
                case 64: {
                    return Bundle.getMessage("SignalHeadStateLunar");
                }
                case 2: {
                    return Bundle.getMessage("SignalHeadStateFlashingRed");
                }
                case 8: {
                    return Bundle.getMessage("SignalHeadStateFlashingYellow");
                }
                case 32: {
                    return Bundle.getMessage("SignalHeadStateFlashingGreen");
                }
                case 128: {
                    return Bundle.getMessage("SignalHeadStateFlashingLunar");
                }
            }
            return "";
        }

        int getOnStateInt() {
            return this._onState;
        }

        int getOffStateInt() {
            return this._offState;
        }

        void setSetOnState(String state) {
            if (state.equals(Bundle.getMessage("SignalHeadStateDark"))) {
                this._onState = 0;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateRed"))) {
                this._onState = 1;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateYellow"))) {
                this._onState = 4;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateGreen"))) {
                this._onState = 16;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateLunar"))) {
                this._onState = 64;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingRed"))) {
                this._onState = 2;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingYellow"))) {
                this._onState = 8;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingGreen"))) {
                this._onState = 32;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingLunar"))) {
                this._onState = 128;
            }
        }

        void setSetOffState(String state) {
            if (state.equals(Bundle.getMessage("SignalHeadStateDark"))) {
                this._offState = 0;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateRed"))) {
                this._offState = 1;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateYellow"))) {
                this._offState = 4;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateGreen"))) {
                this._offState = 16;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateLunar"))) {
                this._offState = 64;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingRed"))) {
                this._offState = 2;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingYellow"))) {
                this._offState = 8;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingGreen"))) {
                this._offState = 32;
            } else if (state.equals(Bundle.getMessage("SignalHeadStateFlashingLunar"))) {
                this._offState = 128;
            }
        }

        public void setOnState(int state) {
            this._onState = state;
        }

        public void setOffState(int state) {
            this._offState = state;
        }
    }

    class SignalGroupSignalHeadModel
    extends SignalGroupOutputModel {
        public static final int STATE_ON_COLUMN = 3;
        public static final int STATE_OFF_COLUMN = 4;
        public static final int EDIT_COLUMN = 5;

        SignalGroupSignalHeadModel() {
            this.addPcl();
        }

        final void addPcl() {
            InstanceManager.getDefault(SignalHeadManager.class).addPropertyChangeListener(this);
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2 || c == 3 || c == 4 || c == 5;
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 2: {
                    return Boolean.class;
                }
                case 5: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int c) {
            return COLUMN_SIG_NAMES[c];
        }

        public void setSetToState(String x) {
        }

        @Override
        public int getRowCount() {
            return SignalGroupTableAction.this.showAll ? SignalGroupTableAction.this._signalHeadsList.size() : SignalGroupTableAction.this._includedSignalHeadsList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            ArrayList<SignalGroupSignalHead> headsList;
            ArrayList<SignalGroupSignalHead> arrayList = headsList = SignalGroupTableAction.this.showAll ? SignalGroupTableAction.this._signalHeadsList : SignalGroupTableAction.this._includedSignalHeadsList;
            if (r >= headsList.size()) {
                log.debug("Row num {} is greater than headsList size {}", (Object)r, (Object)headsList.size());
                return null;
            }
            switch (c) {
                case 2: {
                    return headsList.get(r).isIncluded();
                }
                case 0: {
                    return headsList.get(r).getSysName();
                }
                case 1: {
                    return headsList.get(r).getUserName();
                }
                case 3: {
                    return headsList.get(r).getOnState();
                }
                case 4: {
                    return headsList.get(r).getOffState();
                }
                case 5: {
                    return Bundle.getMessage("ButtonEdit");
                }
            }
            return null;
        }

        public String getDisplayName(int r) {
            if ((String)this.getValueAt(r, 1) != null && !((String)this.getValueAt(r, 1)).isEmpty()) {
                return (String)this.getValueAt(r, 1);
            }
            return (String)this.getValueAt(r, 0);
        }

        public SignalHead getBean(int r) {
            return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead((String)this.getValueAt(r, 0));
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            ArrayList<SignalGroupSignalHead> headsList = SignalGroupTableAction.this.showAll ? SignalGroupTableAction.this._signalHeadsList : SignalGroupTableAction.this._includedSignalHeadsList;
            switch (c) {
                case 2: {
                    headsList.get(r).setIncluded((Boolean)type);
                    break;
                }
                case 3: {
                    headsList.get(r).setSetOnState((String)type);
                    break;
                }
                case 4: {
                    headsList.get(r).setSetOffState((String)type);
                    break;
                }
                case 5: {
                    headsList.get(r).setIncluded(true);
                    SwingUtilities.invokeLater(() -> SignalGroupTableAction.this.signalHeadEditPressed(r));
                    break;
                }
            }
        }

        public void dispose() {
            InstanceManager.getDefault(SignalHeadManager.class).removePropertyChangeListener(this);
        }
    }

    public abstract class SignalGroupOutputModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;
        public static final int INCLUDE_COLUMN = 2;
        public static final int STATE_COLUMN = 3;

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            } else if (e.getPropertyName().equals("UpdateCondition")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public String getColumnName(int c) {
            return COLUMN_NAMES[c];
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2 || c == 3;
        }
    }

    public class SignalMastAspectModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int ASPECT_COLUMN = 0;
        public static final int INCLUDE_COLUMN = 1;

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 1) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 1) {
                return Bundle.getMessage("Include");
            }
            if (col == 0) {
                return Bundle.getMessage("LabelAspectType");
            }
            return "";
        }

        public void dispose() {
            InstanceManager.getDefault(SignalMastManager.class).removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1;
        }

        public void setSetToState(String x) {
        }

        @Override
        public int getRowCount() {
            if (SignalGroupTableAction.this._mastAspectsList == null) {
                return 0;
            }
            if (SignalGroupTableAction.this.showAll) {
                return SignalGroupTableAction.this._mastAspectsList.size();
            }
            return SignalGroupTableAction.this._includedMastAspectsList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            ArrayList<SignalMastAspect> aspectList;
            ArrayList<SignalMastAspect> arrayList = aspectList = SignalGroupTableAction.this.showAll ? SignalGroupTableAction.this._mastAspectsList : SignalGroupTableAction.this._includedMastAspectsList;
            if (aspectList == null || r >= aspectList.size()) {
                if (aspectList == null) {
                    log.debug("SGTA getValueAt: row value {} aspectList is null", (Object)r);
                } else {
                    log.debug("SGTA getValueAt: row value {} is greater than aspectList size {}", (Object)r, (Object)aspectList.size());
                }
                return null;
            }
            switch (c) {
                case 1: {
                    return aspectList.get(r).isIncluded();
                }
                case 0: {
                    return aspectList.get(r).getAspect();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            ArrayList<SignalMastAspect> aspectList;
            log.debug("SigGroupEditSet A; row = {}", (Object)r);
            ArrayList<SignalMastAspect> arrayList = aspectList = SignalGroupTableAction.this.showAll ? SignalGroupTableAction.this._mastAspectsList : SignalGroupTableAction.this._includedMastAspectsList;
            if (SignalGroupTableAction.this._mastAspectsList == null || r >= aspectList.size()) {
                log.debug("row value {} is greater than aspectList size {}", (Object)r, aspectList);
                return;
            }
            log.debug("SigGroupEditSet B; row = {}; aspectList.size() = {}.", (Object)r, (Object)aspectList.size());
            switch (c) {
                case 1: {
                    aspectList.get(r).setIncluded((Boolean)type);
                    break;
                }
                case 0: {
                    aspectList.get(r).setAspect((String)type);
                    break;
                }
            }
        }
    }
}

