/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.implementation.DccSignalHead;
import jmri.implementation.DoubleTurnoutSignalHead;
import jmri.implementation.LsDecSignalHead;
import jmri.implementation.MergSD2SignalHead;
import jmri.implementation.QuadOutputSignalHead;
import jmri.implementation.SE8cSignalHead;
import jmri.implementation.SingleTurnoutSignalHead;
import jmri.implementation.TripleOutputSignalHead;
import jmri.implementation.TripleTurnoutSignalHead;
import jmri.implementation.VirtualSignalHead;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaSignalHead;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialSignalHead;
import jmri.util.ConnectionNameFromSystemName;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.BeanSelectCreatePanel;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadAddEditFrame
extends JmriJFrame {
    private final SignalHead signalHeadBeingEdited;
    private final NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private final JTextField systemNameField = new JTextField(5);
    private final JTextField userNameField = new JTextField(10);
    private final JLabel systemNameLabel = new JLabel("");
    private final JLabel userNameLabel = new JLabel("");
    private JPanel dccOptionsPanel = new JPanel();
    private JPanel dccAppearanceNumberingPanel = new JPanel();
    private JPanel acelaHeadPanel = new JPanel();
    private JPanel centrePanel1 = new JPanel();
    private JPanel centrePanel2 = new JPanel();
    private JPanel centrePanel3 = new JPanel();
    private JPanel centrePanel4 = new JPanel();
    private JPanel centrePanel5 = new JPanel();
    private JPanel centrePanel6 = new JPanel();
    private JPanel centrePanel7 = new JPanel();
    private final FlowLayout defaultFlow = new FlowLayout(1, 5, 0);
    private final Border blackline = BorderFactory.createLineBorder(Color.black);
    private final TitledBorder centrePanBorder1 = BorderFactory.createTitledBorder(this.blackline);
    private final TitledBorder centrePanBorder2 = BorderFactory.createTitledBorder(this.blackline);
    private final TitledBorder centrePanBorder3 = BorderFactory.createTitledBorder(this.blackline);
    private final TitledBorder centrePanBorder4 = BorderFactory.createTitledBorder(this.blackline);
    private final TitledBorder centrePanBorder5 = BorderFactory.createTitledBorder(this.blackline);
    private final TitledBorder centrePanBorder6 = BorderFactory.createTitledBorder(this.blackline);
    private final TitledBorder centrePanBorder7 = BorderFactory.createTitledBorder(this.blackline);
    private BeanSelectCreatePanel<Turnout> turnoutSelect1;
    private BeanSelectCreatePanel<Turnout> turnoutSelect2;
    private BeanSelectCreatePanel<Turnout> turnoutSelect3;
    private BeanSelectCreatePanel<Turnout> turnoutSelect4;
    private BeanSelectCreatePanel<Turnout> turnoutSelect5;
    private BeanSelectCreatePanel<Turnout> turnoutSelect6;
    private BeanSelectCreatePanel<Turnout> turnoutSelect7;
    private static final String TURNOUT_STATE_THROWN = InstanceManager.getDefault(TurnoutManager.class).getThrownText();
    private static final String TURNOUT_STATE_CLOSED = InstanceManager.getDefault(TurnoutManager.class).getClosedText();
    private static final int[] TURNOUT_STATE_VALUES = new int[]{2, 4};
    private static final String[] TURNOUT_STATE_STRINGS = new String[]{TURNOUT_STATE_CLOSED, TURNOUT_STATE_THROWN};
    private static final String[] SIGNAL_STATE_STRINGS = new String[]{Bundle.getMessage("SignalHeadStateDark"), Bundle.getMessage("SignalHeadStateRed"), Bundle.getMessage("SignalHeadStateLunar"), Bundle.getMessage("SignalHeadStateYellow"), Bundle.getMessage("SignalHeadStateGreen")};
    private static final int[] SIGNAL_STATE_VALUES = new int[]{0, 1, 64, 4, 16};
    private static final String ACELA_ASPECT = Bundle.getMessage("StringAcelaaspect");
    private static final String SE8C4_ASPECT = Bundle.getMessage("StringSE8c4aspect");
    private static final String TRIPLE_OUTPUT = Bundle.getMessage("StringTripleOutput");
    private static final String QUAD_OUTPUT = Bundle.getMessage("StringQuadOutput");
    private static final String SINGLE_TURNOUT = Bundle.getMessage("StringSingle");
    private static final String DOUBLE_TURNOUT = Bundle.getMessage("StringDoubleTurnout");
    private static final String TRIPLE_TURNOUT = Bundle.getMessage("StringTripleTurnout");
    private static final String VIRTUAL_HEAD = Bundle.getMessage("StringVirtual");
    private static final String GRAPEVINE = Bundle.getMessage("StringGrapevine");
    private static final String LSDEC = Bundle.getMessage("StringLsDec");
    private static final String DCC_SIGNAL_DECODER = Bundle.getMessage("StringDccSigDec");
    private static final String MERG_SIGNAL_DRIVER = Bundle.getMessage("StringMerg");
    private static final String ACELA_SIG_HEAD_DOUBLE = Bundle.getMessage("StringSignalheadDouble");
    private static final String ACELA_SIG_HEAD_TRIPLE = Bundle.getMessage("StringSignalheadTriple");
    private static final String ACELA_SIG_HEAD_BIPLOAR = Bundle.getMessage("StringSignalheadBiPolar");
    private static final String ACELA_SIG_HEAD_WIGWAG = Bundle.getMessage("StringSignalheadWigwag");
    private static final String[] ACELA_SIG_HEAD_TYPES = new String[]{ACELA_SIG_HEAD_DOUBLE, ACELA_SIG_HEAD_TRIPLE, ACELA_SIG_HEAD_BIPLOAR, ACELA_SIG_HEAD_WIGWAG};
    private static final int[] ACELA_SIG_HEAD_TYPE_VALUES = new int[]{1, 2, 3, 4};
    private static final String[] UK_SEMAPHORE_TYPES = new String[]{Bundle.getMessage("HomeSignal"), Bundle.getMessage("DistantSignal")};
    private static final String[] UK_SIGNAL_ASPECTS = new String[]{"2", "3", "4"};
    private final JLabel dccPacketSendCount = new JLabel(Bundle.getMessage("DCCMastPacketSendCount"));
    private final JSpinner dccPacketSendCountSpinner = new JSpinner();
    private JSpinner[] dccAspectSpinners;
    private final JCheckBox dccOffSetAddressCheckBox = new JCheckBox(Bundle.getMessage("DccAccessoryAddressOffSet"));
    private JComboBox<String> headTypeBox;
    private final JLabel headTypeLabel = new JLabel();
    private final JComboBox<String> prefixBox = new JComboBox();
    private final JLabel prefixBoxLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("DCCSystem")));
    private final JLabel stateLabel1 = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("TurnoutState")));
    private final JLabel stateLabel2 = new JLabel(this.stateLabel1.getText());
    private final JLabel stateLabel3 = new JLabel(this.stateLabel1.getText());
    private final JLabel stateLabel4 = new JLabel(this.stateLabel1.getText());
    private final JLabel stateLabel5 = new JLabel(this.stateLabel1.getText());
    private final JLabel stateLabel6 = new JLabel(this.stateLabel1.getText());
    private final JLabel stateLabel7 = new JLabel(this.stateLabel1.getText());
    private final JComboBox<String> turnoutStateBox1 = new JComboBox<String>(TURNOUT_STATE_STRINGS);
    private final JComboBox<String> turnoutStateBox2 = new JComboBox<String>(TURNOUT_STATE_STRINGS);
    private final JComboBox<String> turnoutStateBox3 = new JComboBox<String>(TURNOUT_STATE_STRINGS);
    private final JComboBox<String> turnoutStateBox4 = new JComboBox<String>(TURNOUT_STATE_STRINGS);
    private final JComboBox<String> turnoutStateBox5 = new JComboBox<String>(TURNOUT_STATE_STRINGS);
    private final JComboBox<String> turnoutStateBox6 = new JComboBox<String>(TURNOUT_STATE_STRINGS);
    private final JComboBox<String> turnoutStateBox7 = new JComboBox<String>(TURNOUT_STATE_STRINGS);
    private final JComboBox<String> signalStateBox2 = new JComboBox<String>(SIGNAL_STATE_STRINGS);
    private final JComboBox<String> signalStateBox3 = new JComboBox<String>(SIGNAL_STATE_STRINGS);
    private final JComboBox<String> acelaHeadTypeBox = new JComboBox<String>(ACELA_SIG_HEAD_TYPES);
    private final JComboBox<String> ukSignalSemaphoreTypeBox = new JComboBox<String>(UK_SEMAPHORE_TYPES);
    private final JComboBox<String> numberUkAspectsBox = new JComboBox<String>(UK_SIGNAL_ASPECTS);
    private static final Logger log = LoggerFactory.getLogger(SignalHeadAddEditFrame.class);

    public SignalHeadAddEditFrame(@CheckForNull SignalHead head) {
        super(Bundle.getMessage(head == null ? "TitleAddSignalHead" : "TitleEditSignalHead"), false, true);
        this.signalHeadBeingEdited = head;
    }

    protected SignalHead getSignalHead() {
        return this.signalHeadBeingEdited;
    }

    protected void resetAddressFields() {
        this.systemNameField.setText("");
        this.userNameField.setText("");
    }

    @Override
    public void initComponents() {
        this.addHelpMenu("package.jmri.jmrit.beantable.SignalAddEdit", true);
        for (CommandStation station : InstanceManager.getList(CommandStation.class)) {
            this.prefixBox.addItem(station.getUserName());
        }
        this.initDccAppearancePanel();
        this.turnoutSelect1 = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(TurnoutManager.class), null);
        this.turnoutSelect2 = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(TurnoutManager.class), null);
        this.turnoutSelect3 = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(TurnoutManager.class), null);
        this.turnoutSelect4 = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(TurnoutManager.class), null);
        this.turnoutSelect5 = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(TurnoutManager.class), null);
        this.turnoutSelect6 = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(TurnoutManager.class), null);
        this.turnoutSelect7 = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(TurnoutManager.class), null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getHeaderPanel(), "First");
        this.getContentPane().add((Component)new JScrollPane(this.getCentrePanel()), "Center");
        this.getContentPane().add((Component)this.getBottomButtonsPanel(), "Last");
        this.typeChanged();
        this.setHeadToFrame();
        this.setEscapeKeyClosesWindow(true);
        this.pack();
        this.setVisible(true);
    }

    private JPanel getHeaderPanel() {
        JPanel panelHeader = new JPanel();
        panelHeader.setLayout(new BoxLayout(panelHeader, 1));
        this.initTypeBox();
        panelHeader.add(new JSeparator());
        panelHeader.add(this.headTypeBox);
        panelHeader.add(new JSeparator());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridBagLayout());
        labelPanel.add(this.headTypeLabel);
        panelHeader.add(labelPanel);
        panelHeader.add(new JSeparator());
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.prefixBoxLabel);
        this.prefixBoxLabel.setLabelFor(this.prefixBox);
        p.add(this.prefixBox);
        panelHeader.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.systemNameLabel);
        this.systemNameLabel.setLabelFor(this.systemNameField);
        p.add(this.systemNameField);
        panelHeader.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.userNameLabel);
        this.userNameLabel.setLabelFor(this.userNameField);
        this.userNameField.setToolTipText(Bundle.getMessage("SignalHeadUserNameTooltip"));
        p.add(this.userNameField);
        panelHeader.add(p);
        return panelHeader;
    }

    private JPanel getCentrePanel() {
        JPanel panelCentre = new JPanel();
        panelCentre.setLayout(new BoxLayout(panelCentre, 1));
        this.dccOptionsPanel = new JPanel();
        this.dccOptionsPanel.add(this.dccOffSetAddressCheckBox);
        this.dccOffSetAddressCheckBox.setToolTipText(Bundle.getMessage("DccOffsetTooltip"));
        this.dccOptionsPanel.add(this.dccPacketSendCount);
        this.dccPacketSendCountSpinner.setModel(new SpinnerNumberModel(3, 1, 4, 1));
        this.dccPacketSendCountSpinner.setToolTipText(Bundle.getMessage("DCCMastPacketSendCountToolTip"));
        this.dccOptionsPanel.add(this.dccPacketSendCountSpinner);
        panelCentre.add(this.dccOptionsPanel);
        this.centrePanel1 = new JPanel();
        this.centrePanel1.setLayout(this.defaultFlow);
        this.centrePanel1.add(this.turnoutSelect1);
        this.centrePanel1.add(this.stateLabel1);
        this.centrePanel1.add(this.turnoutStateBox1);
        this.turnoutStateBox1.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
        this.centrePanel1.add(this.numberUkAspectsBox);
        this.numberUkAspectsBox.setToolTipText(Bundle.getMessage("SignalHeadMergTooltip"));
        this.numberUkAspectsBox.addActionListener(e -> this.ukAspectChange());
        this.centrePanel1.setBorder(this.centrePanBorder1);
        panelCentre.add(this.centrePanel1);
        this.centrePanel2 = new JPanel();
        this.centrePanel2.setLayout(this.defaultFlow);
        this.centrePanel2.add(this.turnoutSelect2);
        this.centrePanel2.add(this.stateLabel2);
        this.centrePanel2.add(this.turnoutStateBox2);
        this.turnoutStateBox2.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
        this.centrePanel2.add(this.signalStateBox2);
        this.centrePanel2.add(this.ukSignalSemaphoreTypeBox);
        this.ukSignalSemaphoreTypeBox.setToolTipText(Bundle.getMessage("SignalHeadUseTooltip"));
        this.centrePanel2.add(this.dccAppearanceNumberingPanel);
        this.centrePanel2.setBorder(this.centrePanBorder2);
        panelCentre.add(this.centrePanel2);
        this.centrePanel3 = new JPanel();
        this.centrePanel3.setLayout(this.defaultFlow);
        this.centrePanel3.add(this.turnoutSelect3);
        this.centrePanel3.add(this.stateLabel3);
        this.centrePanel3.add(this.turnoutStateBox3);
        this.turnoutStateBox3.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
        this.centrePanel3.add(this.signalStateBox3);
        this.centrePanel3.setBorder(this.centrePanBorder3);
        panelCentre.add(this.centrePanel3);
        this.centrePanel4 = new JPanel();
        this.centrePanel4.setLayout(this.defaultFlow);
        this.centrePanel4.add(this.turnoutSelect4);
        this.centrePanel4.add(this.stateLabel4);
        this.centrePanel4.add(this.turnoutStateBox4);
        this.turnoutStateBox4.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
        this.centrePanel4.setBorder(this.centrePanBorder4);
        panelCentre.add(this.centrePanel4);
        this.centrePanel5 = new JPanel();
        this.centrePanel5.setLayout(this.defaultFlow);
        this.centrePanel5.add(this.turnoutSelect5);
        this.centrePanel5.add(this.stateLabel5);
        this.centrePanel5.add(this.turnoutStateBox5);
        this.turnoutStateBox5.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
        this.centrePanel5.setBorder(this.centrePanBorder5);
        panelCentre.add(this.centrePanel5);
        this.centrePanel6 = new JPanel();
        this.centrePanel6.setLayout(this.defaultFlow);
        this.centrePanel6.add(this.turnoutSelect6);
        this.centrePanel6.add(this.stateLabel6);
        this.centrePanel6.add(this.turnoutStateBox6);
        this.turnoutStateBox6.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
        this.centrePanel6.setBorder(this.centrePanBorder6);
        panelCentre.add(this.centrePanel6);
        this.centrePanel7 = new JPanel();
        this.centrePanel7.setLayout(this.defaultFlow);
        this.centrePanel7.add(this.turnoutSelect7);
        this.centrePanel7.add(this.stateLabel7);
        this.centrePanel7.add(this.turnoutStateBox7);
        this.turnoutStateBox7.setToolTipText(Bundle.getMessage("SignalHeadStateTooltip"));
        this.centrePanel7.setBorder(this.centrePanBorder7);
        panelCentre.add(this.centrePanel7);
        this.acelaHeadPanel = new JPanel();
        this.acelaHeadPanel.setLayout(this.defaultFlow);
        JLabel aspectTypeLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelAspectType")));
        this.acelaHeadPanel.add(aspectTypeLabel);
        this.acelaHeadPanel.add(this.acelaHeadTypeBox);
        panelCentre.add(this.acelaHeadPanel);
        return panelCentre;
    }

    private JPanel getBottomButtonsPanel() {
        JPanel panelBottom = new JPanel();
        panelBottom.setLayout(new BoxLayout(panelBottom, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(4));
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        p.add(cancel);
        cancel.addActionListener(e1 -> this.dispose());
        JButton update = new JButton(Bundle.getMessage(this.signalHeadBeingEdited == null ? "ButtonCreate" : "ButtonUpdate"));
        update.addActionListener(this::updateEditPressed);
        this.getRootPane().setDefaultButton(update);
        p.add(update);
        panelBottom.add(p);
        return panelBottom;
    }

    public void hideAllPanels() {
        this.prefixBoxLabel.setVisible(false);
        this.prefixBox.setVisible(false);
        this.systemNameField.setVisible(false);
        this.systemNameLabel.setVisible(false);
        this.userNameLabel.setVisible(false);
        this.userNameField.setVisible(false);
        this.dccOptionsPanel.setVisible(false);
        this.centrePanel1.setVisible(false);
        this.turnoutSelect1.setVisible(false);
        this.stateLabel1.setVisible(false);
        this.turnoutStateBox1.setVisible(false);
        this.numberUkAspectsBox.setVisible(false);
        this.centrePanel2.setVisible(false);
        this.turnoutSelect2.setVisible(false);
        this.stateLabel2.setVisible(false);
        this.turnoutStateBox2.setVisible(false);
        this.signalStateBox2.setVisible(false);
        this.ukSignalSemaphoreTypeBox.setVisible(false);
        this.dccAppearanceNumberingPanel.setVisible(false);
        this.centrePanel3.setVisible(false);
        this.turnoutSelect3.setVisible(false);
        this.stateLabel3.setVisible(false);
        this.turnoutStateBox3.setVisible(false);
        this.signalStateBox3.setVisible(false);
        this.centrePanel4.setVisible(false);
        this.turnoutSelect4.setVisible(false);
        this.stateLabel4.setVisible(false);
        this.turnoutStateBox4.setVisible(false);
        this.centrePanel5.setVisible(false);
        this.turnoutSelect5.setVisible(false);
        this.stateLabel5.setVisible(false);
        this.turnoutStateBox5.setVisible(false);
        this.centrePanel6.setVisible(false);
        this.turnoutSelect6.setVisible(false);
        this.stateLabel6.setVisible(false);
        this.turnoutStateBox6.setVisible(false);
        this.centrePanel7.setVisible(false);
        this.turnoutSelect7.setVisible(false);
        this.stateLabel7.setVisible(false);
        this.turnoutStateBox7.setVisible(false);
        this.acelaHeadPanel.setVisible(false);
    }

    private void setHeadToFrame() {
        this.headTypeLabel.setVisible(this.signalHeadBeingEdited != null);
        this.headTypeBox.setVisible(this.signalHeadBeingEdited == null);
        if (this.signalHeadBeingEdited == null) {
            this.headTypeBox.setSelectedItem(DOUBLE_TURNOUT);
            this.typeChanged();
            this.systemNameField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
            return;
        }
        this.headTypeBox.setSelectedItem(this.getNameFromClass(this.signalHeadBeingEdited.getClass().getName()));
        this.headTypeLabel.setText("<html><h3>" + this.getNameFromClass(this.signalHeadBeingEdited.getClass().getName()) + "</h3></html>");
        this.typeChanged();
        this.systemNameField.setEditable(false);
        this.systemNameField.setText(this.signalHeadBeingEdited.getSystemName());
        this.userNameField.setText(this.signalHeadBeingEdited.getUserName());
        String type = (String)this.headTypeBox.getSelectedItem();
        if (QUAD_OUTPUT.equals(type)) {
            NamedBeanHandle<Turnout> greenTt = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getGreen();
            NamedBeanHandle<Turnout> yellowTt = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getYellow();
            NamedBeanHandle<Turnout> redTt = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getRed();
            NamedBeanHandle<Turnout> lunarTt = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getLunar();
            if (greenTt != null) {
                this.turnoutSelect1.setDefaultNamedBean(greenTt.getBean());
            }
            if (yellowTt != null) {
                this.turnoutSelect2.setDefaultNamedBean(yellowTt.getBean());
            }
            if (redTt != null) {
                this.turnoutSelect3.setDefaultNamedBean(redTt.getBean());
            }
            if (lunarTt != null) {
                this.turnoutSelect4.setDefaultNamedBean(lunarTt.getBean());
            }
        } else if (TRIPLE_TURNOUT.equals(type)) {
            NamedBeanHandle<Turnout> greenTt = ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).getGreen();
            NamedBeanHandle<Turnout> yellowTt = ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).getYellow();
            NamedBeanHandle<Turnout> redTt = ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).getRed();
            if (greenTt != null) {
                this.turnoutSelect1.setDefaultNamedBean(greenTt.getBean());
            }
            if (yellowTt != null) {
                this.turnoutSelect2.setDefaultNamedBean(yellowTt.getBean());
            }
            if (redTt != null) {
                this.turnoutSelect3.setDefaultNamedBean(redTt.getBean());
            }
        } else if (TRIPLE_OUTPUT.equals(type)) {
            NamedBeanHandle<Turnout> greenTt = ((TripleOutputSignalHead)this.signalHeadBeingEdited).getGreen();
            NamedBeanHandle<Turnout> blueTt = ((TripleOutputSignalHead)this.signalHeadBeingEdited).getBlue();
            NamedBeanHandle<Turnout> redTt = ((TripleOutputSignalHead)this.signalHeadBeingEdited).getRed();
            if (greenTt != null) {
                this.turnoutSelect1.setDefaultNamedBean(greenTt.getBean());
            }
            if (blueTt != null) {
                this.turnoutSelect2.setDefaultNamedBean(blueTt.getBean());
            }
            if (redTt != null) {
                this.turnoutSelect3.setDefaultNamedBean(redTt.getBean());
            }
        } else if (DOUBLE_TURNOUT.equals(type)) {
            NamedBeanHandle<Turnout> greenTt = ((DoubleTurnoutSignalHead)this.signalHeadBeingEdited).getGreen();
            NamedBeanHandle<Turnout> redTt = ((DoubleTurnoutSignalHead)this.signalHeadBeingEdited).getRed();
            if (greenTt != null) {
                this.turnoutSelect1.setDefaultNamedBean(greenTt.getBean());
            }
            if (redTt != null) {
                this.turnoutSelect2.setDefaultNamedBean(redTt.getBean());
            }
        } else if (SINGLE_TURNOUT.equals(type)) {
            NamedBeanHandle<Turnout> tTt = ((SingleTurnoutSignalHead)this.signalHeadBeingEdited).getOutput();
            if (tTt != null) {
                this.turnoutSelect1.setDefaultNamedBean(tTt.getBean());
            }
            this.setSignalStateInBox(this.signalStateBox2, ((SingleTurnoutSignalHead)this.signalHeadBeingEdited).getOnAppearance());
            this.setSignalStateInBox(this.signalStateBox3, ((SingleTurnoutSignalHead)this.signalHeadBeingEdited).getOffAppearance());
        } else if (LSDEC.equals(type)) {
            NamedBeanHandle<Turnout> greenT = ((LsDecSignalHead)this.signalHeadBeingEdited).getGreen();
            NamedBeanHandle<Turnout> yellowT = ((LsDecSignalHead)this.signalHeadBeingEdited).getYellow();
            NamedBeanHandle<Turnout> redT = ((LsDecSignalHead)this.signalHeadBeingEdited).getRed();
            NamedBeanHandle<Turnout> greenTFlash = ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashGreen();
            NamedBeanHandle<Turnout> yellowTFlash = ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashYellow();
            NamedBeanHandle<Turnout> redTFlash = ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashRed();
            NamedBeanHandle<Turnout> darkT = ((LsDecSignalHead)this.signalHeadBeingEdited).getDark();
            if (greenT != null) {
                this.turnoutSelect1.setDefaultNamedBean(greenT.getBean());
            }
            this.setTurnoutStateInBox(this.turnoutStateBox1, ((LsDecSignalHead)this.signalHeadBeingEdited).getGreenState(), TURNOUT_STATE_VALUES);
            if (yellowT != null) {
                this.turnoutSelect2.setDefaultNamedBean(yellowT.getBean());
            }
            this.setTurnoutStateInBox(this.turnoutStateBox2, ((LsDecSignalHead)this.signalHeadBeingEdited).getYellowState(), TURNOUT_STATE_VALUES);
            if (redT != null) {
                this.turnoutSelect3.setDefaultNamedBean(redT.getBean());
            }
            this.setTurnoutStateInBox(this.turnoutStateBox3, ((LsDecSignalHead)this.signalHeadBeingEdited).getRedState(), TURNOUT_STATE_VALUES);
            if (greenTFlash != null) {
                this.turnoutSelect4.setDefaultNamedBean(greenTFlash.getBean());
            }
            this.setTurnoutStateInBox(this.turnoutStateBox4, ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashGreenState(), TURNOUT_STATE_VALUES);
            if (yellowTFlash != null) {
                this.turnoutSelect5.setDefaultNamedBean(yellowTFlash.getBean());
            }
            this.setTurnoutStateInBox(this.turnoutStateBox5, ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashYellowState(), TURNOUT_STATE_VALUES);
            if (redTFlash != null) {
                this.turnoutSelect6.setDefaultNamedBean(redTFlash.getBean());
            }
            this.setTurnoutStateInBox(this.turnoutStateBox6, ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashRedState(), TURNOUT_STATE_VALUES);
            if (darkT != null) {
                this.turnoutSelect7.setDefaultNamedBean(darkT.getBean());
            }
            this.setTurnoutStateInBox(this.turnoutStateBox7, ((LsDecSignalHead)this.signalHeadBeingEdited).getDarkState(), TURNOUT_STATE_VALUES);
        } else if (ACELA_ASPECT.equals(type)) {
            AcelaNode tNode = AcelaAddress.getNodeFromSystemName(this.signalHeadBeingEdited.getSystemName(), InstanceManager.getDefault(AcelaSystemConnectionMemo.class));
            if (tNode == null) {
                log.error("Can't find new Acela Signal with name '{}", (Object)this.signalHeadBeingEdited.getSystemName());
                return;
            }
            int headnumber = Integer.parseInt(this.signalHeadBeingEdited.getSystemName().substring(2));
            this.setSignalheadTypeInBox(this.acelaHeadTypeBox, tNode.getOutputSignalHeadType(headnumber), ACELA_SIG_HEAD_TYPE_VALUES);
        } else if (DCC_SIGNAL_DECODER.equals(type)) {
            for (int i = 0; i < DccSignalHead.getDefaultValidStates().length; ++i) {
                this.dccAspectSpinners[i].setValue(((DccSignalHead)this.signalHeadBeingEdited).getOutputForAppearance(this.signalHeadBeingEdited.getValidStates()[i]));
            }
            this.dccOffSetAddressCheckBox.setSelected(((DccSignalHead)this.signalHeadBeingEdited).useAddressOffSet());
            this.dccPacketSendCountSpinner.setValue(((DccSignalHead)this.signalHeadBeingEdited).getDccSignalHeadPacketSendCount());
            for (CommandStation cs : InstanceManager.getList(CommandStation.class)) {
                if (!this.signalHeadBeingEdited.getSystemName().startsWith(cs.getSystemPrefix())) continue;
                this.prefixBox.setSelectedItem(cs.getUserName());
            }
        } else if (MERG_SIGNAL_DRIVER.equals(type)) {
            this.setUkSignalAspectsFromBox(this.numberUkAspectsBox, ((MergSD2SignalHead)this.signalHeadBeingEdited).getAspects());
            if (((MergSD2SignalHead)this.signalHeadBeingEdited).getHome()) {
                this.setUkSignalType(this.ukSignalSemaphoreTypeBox, Bundle.getMessage("HomeSignal"));
            } else {
                this.setUkSignalType(this.ukSignalSemaphoreTypeBox, Bundle.getMessage("DistantSignal"));
            }
            NamedBeanHandle<Turnout> input1 = ((MergSD2SignalHead)this.signalHeadBeingEdited).getInput1();
            NamedBeanHandle<Turnout> input2 = ((MergSD2SignalHead)this.signalHeadBeingEdited).getInput2();
            NamedBeanHandle<Turnout> input3 = ((MergSD2SignalHead)this.signalHeadBeingEdited).getInput3();
            if (input1 != null) {
                this.turnoutSelect3.setDefaultNamedBean(input1.getBean());
            }
            if (input2 != null) {
                this.turnoutSelect4.setDefaultNamedBean(input2.getBean());
            }
            if (input3 != null) {
                this.turnoutSelect5.setDefaultNamedBean(input3.getBean());
            }
        }
    }

    private String getNameFromClass(@Nonnull String className) {
        switch (className) {
            case "jmri.implementation.QuadOutputSignalHead": {
                return QUAD_OUTPUT;
            }
            case "jmri.implementation.TripleTurnoutSignalHead": {
                return TRIPLE_TURNOUT;
            }
            case "jmri.implementation.TripleOutputSignalHead": {
                return TRIPLE_OUTPUT;
            }
            case "jmri.implementation.DoubleTurnoutSignalHead": {
                return DOUBLE_TURNOUT;
            }
            case "jmri.implementation.SingleTurnoutSignalHead": {
                return SINGLE_TURNOUT;
            }
            case "jmri.implementation.VirtualSignalHead": {
                return VIRTUAL_HEAD;
            }
            case "jmri.implementation.LsDecSignalHead": {
                return LSDEC;
            }
            case "jmri.implementation.SE8cSignalHead": {
                return SE8C4_ASPECT;
            }
            case "jmri.jmrix.grapevine.SerialSignalHead": {
                return GRAPEVINE;
            }
            case "jmri.jmrix.acela.AcelaSignalHead": {
                return ACELA_ASPECT;
            }
            case "jmri.implementation.DccSignalHead": {
                return DCC_SIGNAL_DECODER;
            }
            case "jmri.implementation.MergSD2SignalHead": {
                return MERG_SIGNAL_DRIVER;
            }
        }
        throw new IllegalArgumentException("No implementation for " + className);
    }

    private void typeChanged() {
        this.hideAllPanels();
        if (this.signalHeadBeingEdited == null) {
            this.systemNameField.setToolTipText(Bundle.getMessage("SignalHeadSysNameTooltip"));
        } else {
            this.systemNameField.setToolTipText(null);
        }
        this.systemNameLabel.setText(Bundle.getMessage("LabelSystemName"));
        this.systemNameLabel.setVisible(true);
        this.systemNameField.setVisible(true);
        this.userNameLabel.setText(Bundle.getMessage("LabelUserName"));
        this.userNameLabel.setVisible(true);
        this.userNameField.setVisible(true);
        String type = (String)this.headTypeBox.getSelectedItem();
        if (QUAD_OUTPUT.equals(type)) {
            this.centrePanBorder1.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.centrePanel1.setVisible(true);
            this.turnoutSelect1.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
            this.centrePanel2.setVisible(true);
            this.turnoutSelect2.setVisible(true);
            this.centrePanBorder3.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.centrePanel3.setVisible(true);
            this.turnoutSelect3.setVisible(true);
            this.centrePanBorder4.setTitle(Bundle.getMessage("LabelLunarTurnoutNumber"));
            this.centrePanel4.setVisible(true);
            this.turnoutSelect4.setVisible(true);
        } else if (TRIPLE_TURNOUT.equals(type)) {
            this.centrePanBorder1.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.centrePanel1.setVisible(true);
            this.turnoutSelect1.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
            this.centrePanel2.setVisible(true);
            this.turnoutSelect2.setVisible(true);
            this.centrePanBorder3.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.centrePanel3.setVisible(true);
            this.turnoutSelect3.setVisible(true);
        } else if (TRIPLE_OUTPUT.equals(type)) {
            this.centrePanBorder1.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.centrePanel1.setVisible(true);
            this.turnoutSelect1.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelBlueTurnoutNumber"));
            this.centrePanel2.setVisible(true);
            this.turnoutSelect2.setVisible(true);
            this.centrePanBorder3.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.centrePanel3.setVisible(true);
            this.turnoutSelect3.setVisible(true);
        } else if (DOUBLE_TURNOUT.equals(type)) {
            this.centrePanBorder1.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.centrePanel1.setVisible(true);
            this.turnoutSelect1.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.centrePanel2.setVisible(true);
            this.turnoutSelect2.setVisible(true);
        } else if (SINGLE_TURNOUT.equals(type)) {
            this.centrePanBorder1.setTitle(Bundle.getMessage("LabelTurnoutNumber"));
            this.centrePanel1.setVisible(true);
            this.turnoutSelect1.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelTurnoutThrownAppearance"));
            this.centrePanel2.setVisible(true);
            this.signalStateBox2.setVisible(true);
            this.centrePanBorder3.setTitle(Bundle.getMessage("LabelTurnoutClosedAppearance"));
            this.centrePanel3.setVisible(true);
            this.signalStateBox3.setVisible(true);
        } else if (LSDEC.equals(type)) {
            this.centrePanBorder1.setTitle(Bundle.getMessage("LabelGreenTurnoutNumber"));
            this.centrePanel1.setVisible(true);
            this.turnoutSelect1.setVisible(true);
            this.stateLabel1.setVisible(true);
            this.turnoutStateBox1.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelYellowTurnoutNumber"));
            this.centrePanel2.setVisible(true);
            this.turnoutSelect2.setVisible(true);
            this.stateLabel2.setVisible(true);
            this.turnoutStateBox2.setVisible(true);
            this.centrePanBorder3.setTitle(Bundle.getMessage("LabelRedTurnoutNumber"));
            this.centrePanel3.setVisible(true);
            this.turnoutSelect3.setVisible(true);
            this.stateLabel3.setVisible(true);
            this.turnoutStateBox3.setVisible(true);
            this.centrePanBorder4.setTitle(Bundle.getMessage("LabelFlashGreenTurnoutNumber"));
            this.centrePanel4.setVisible(true);
            this.turnoutSelect4.setVisible(true);
            this.stateLabel4.setVisible(true);
            this.turnoutStateBox4.setVisible(true);
            this.centrePanBorder5.setTitle(Bundle.getMessage("LabelFlashYellowTurnoutNumber"));
            this.centrePanel5.setVisible(true);
            this.turnoutSelect5.setVisible(true);
            this.stateLabel5.setVisible(true);
            this.turnoutStateBox5.setVisible(true);
            this.centrePanBorder6.setTitle(Bundle.getMessage("LabelFlashRedTurnoutNumber"));
            this.centrePanel6.setVisible(true);
            this.turnoutSelect6.setVisible(true);
            this.stateLabel6.setVisible(true);
            this.turnoutStateBox6.setVisible(true);
            this.centrePanBorder7.setTitle(Bundle.getMessage("LabelDarkTurnoutNumber"));
            this.centrePanel7.setVisible(true);
            this.turnoutSelect7.setVisible(true);
            this.stateLabel7.setVisible(true);
            this.turnoutStateBox7.setVisible(true);
        } else if (ACELA_ASPECT.equals(type)) {
            this.acelaHeadPanel.setVisible(true);
            if (this.signalHeadBeingEdited == null) {
                this.systemNameLabel.setText(Bundle.getMessage("LabelSignalheadNumber"));
            }
            this.systemNameField.setToolTipText(Bundle.getMessage("SignalHeadAcelaTooltip"));
        } else if (DCC_SIGNAL_DECODER.equals(type)) {
            if (this.signalHeadBeingEdited == null) {
                this.systemNameLabel.setText(Bundle.getMessage("LabelSignalheadNumber"));
            }
            this.dccOptionsPanel.setVisible(true);
            this.prefixBox.setVisible(true);
            this.prefixBox.setEnabled(this.signalHeadBeingEdited == null);
            this.prefixBoxLabel.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelAspectNumbering"));
            this.centrePanel2.setVisible(true);
            this.dccAppearanceNumberingPanel.setVisible(true);
        } else if (MERG_SIGNAL_DRIVER.equals(type)) {
            this.centrePanBorder1.setTitle(Bundle.getMessage("NumberOfAppearances"));
            this.centrePanel1.setVisible(true);
            this.numberUkAspectsBox.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("UseAs"));
            this.centrePanel2.setVisible(true);
            this.turnoutSelect2.setVisible(false);
            this.ukSignalSemaphoreTypeBox.setVisible(true);
            this.centrePanBorder3.setTitle(Bundle.getMessage("InputNum", " 1 "));
            this.centrePanel3.setVisible(true);
            this.turnoutSelect3.setVisible(true);
            this.centrePanBorder4.setTitle(Bundle.getMessage("InputNum", " 2 "));
            this.centrePanel4.setVisible(true);
            this.turnoutSelect4.setVisible(true);
            this.centrePanBorder5.setTitle(Bundle.getMessage("InputNum", " 3 "));
            this.centrePanel5.setVisible(true);
            this.turnoutSelect5.setVisible(true);
            this.setUkSignalAspectsFromBox(this.numberUkAspectsBox, 2);
            this.ukAspectChange();
        } else if (SE8C4_ASPECT.equals(type)) {
            this.systemNameField.setVisible(this.signalHeadBeingEdited != null);
            this.systemNameLabel.setVisible(this.signalHeadBeingEdited != null);
            this.centrePanBorder1.setTitle(Bundle.getMessage("LabelTurnoutNumber"));
            this.centrePanel1.setVisible(true);
            this.turnoutSelect1.setVisible(true);
            this.centrePanBorder2.setTitle(Bundle.getMessage("LabelSecondNumber"));
            this.centrePanel2.setVisible(true);
            this.turnoutSelect2.setVisible(true);
        } else if (!GRAPEVINE.equals(type) && !VIRTUAL_HEAD.equals(type)) {
            log.error("Cannot edit SignalHead of unrecognized type: {}", (Object)type);
        }
        this.pack();
    }

    private void initTypeBox() {
        this.headTypeBox = new JComboBox<String>(new String[]{ACELA_ASPECT, DCC_SIGNAL_DECODER, DOUBLE_TURNOUT, LSDEC, MERG_SIGNAL_DRIVER, QUAD_OUTPUT, SINGLE_TURNOUT, SE8C4_ASPECT, TRIPLE_TURNOUT, TRIPLE_OUTPUT, VIRTUAL_HEAD});
        if (this.prefixBox.getItemCount() == 0) {
            this.headTypeBox.removeItem(DCC_SIGNAL_DECODER);
        }
        if (!InstanceManager.getList(GrapevineSystemConnectionMemo.class).isEmpty()) {
            this.headTypeBox.addItem(GRAPEVINE);
        }
        if (InstanceManager.getList(AcelaSystemConnectionMemo.class).isEmpty()) {
            this.headTypeBox.removeItem(ACELA_ASPECT);
        }
        this.headTypeBox.addActionListener(e1 -> this.typeChanged());
        JComboBoxUtil.setupComboBoxMaxRows(this.headTypeBox);
        this.headTypeBox.setEnabled(this.signalHeadBeingEdited == null);
    }

    private void initDccAppearancePanel() {
        this.dccAppearanceNumberingPanel = new JPanel();
        this.dccAppearanceNumberingPanel.setLayout(new GridLayout(0, 2));
        this.dccAspectSpinners = new JSpinner[DccSignalHead.getDefaultValidStates().length];
        for (int i = 0; i < DccSignalHead.getDefaultValidStates().length; ++i) {
            String aspect = DccSignalHead.getDefaultValidStateNames()[i];
            this.dccAppearanceNumberingPanel.add(new JLabel(aspect));
            SpinnerNumberModel DccSpinnerModel = new SpinnerNumberModel(1, 0, 31, 1);
            JSpinner tmp = new JSpinner(DccSpinnerModel);
            tmp.setValue(DccSignalHead.getDefaultNumberForAppearance(DccSignalHead.getDefaultValidStates()[i]));
            this.dccAspectSpinners[i] = tmp;
            this.dccAppearanceNumberingPanel.add(tmp);
            tmp.setToolTipText(Bundle.getMessage("DccAccessoryAspect", i));
        }
    }

    private void setSignalStateInBox(JComboBox<String> box, int state) {
        switch (state) {
            case 0: {
                box.setSelectedIndex(0);
                break;
            }
            case 1: {
                box.setSelectedIndex(1);
                break;
            }
            case 64: {
                box.setSelectedIndex(2);
                break;
            }
            case 4: {
                box.setSelectedIndex(3);
                break;
            }
            case 16: {
                box.setSelectedIndex(4);
                break;
            }
            case 2: {
                box.setSelectedIndex(5);
                break;
            }
            case 128: {
                box.setSelectedIndex(6);
                break;
            }
            case 8: {
                box.setSelectedIndex(7);
                break;
            }
            case 32: {
                box.setSelectedIndex(8);
                break;
            }
            default: {
                log.error("unexpected Signal state value: {}", (Object)state);
            }
        }
    }

    private void setTurnoutStateInBox(JComboBox<String> box, int state, int[] iTurnoutStates) {
        if (state == iTurnoutStates[0]) {
            box.setSelectedIndex(0);
        } else if (state == iTurnoutStates[1]) {
            box.setSelectedIndex(1);
        } else {
            log.error("unexpected turnout state value: {}", (Object)state);
        }
    }

    private int turnoutStateFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, TURNOUT_STATE_VALUES, TURNOUT_STATE_STRINGS);
        if (result < 0) {
            log.warn("unexpected mode string in turnoutMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    private void setSignalheadTypeInBox(JComboBox<String> box, int state, int[] iSignalheadTypes) {
        if (state == iSignalheadTypes[0]) {
            box.setSelectedIndex(0);
        } else if (state == iSignalheadTypes[1]) {
            box.setSelectedIndex(1);
        } else if (state == iSignalheadTypes[2]) {
            box.setSelectedIndex(2);
        } else if (state == iSignalheadTypes[3]) {
            box.setSelectedIndex(3);
        } else {
            log.error("unexpected signalhead type value: {}", (Object)state);
        }
    }

    private int signalStateFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, SIGNAL_STATE_VALUES, SIGNAL_STATE_STRINGS);
        if (result < 0) {
            log.warn("unexpected mode string in signalMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    private int ukSignalAspectsFromBox(JComboBox<String> box) {
        switch (box.getSelectedIndex()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        log.warn("unexpected appearance{}", box.getSelectedItem());
        throw new IllegalArgumentException();
    }

    private void setUkSignalAspectsFromBox(JComboBox<String> box, int val) {
        switch (val) {
            case 2: {
                box.setSelectedIndex(0);
                break;
            }
            case 3: {
                box.setSelectedIndex(1);
                break;
            }
            case 4: {
                box.setSelectedIndex(2);
                break;
            }
            default: {
                log.error("Unexpected Signal Appearance{}", (Object)val);
            }
        }
    }

    private String ukSignalTypeFromBox(JComboBox<String> box) {
        switch (box.getSelectedIndex()) {
            case 0: {
                return "Home";
            }
            case 1: {
                return "Distant";
            }
        }
        log.warn("unexpected appearance{}", box.getSelectedItem());
        throw new IllegalArgumentException();
    }

    private void setUkSignalType(JComboBox<String> box, String val) {
        if (val.equals(UK_SEMAPHORE_TYPES[0])) {
            box.setSelectedIndex(0);
        } else if (val.equals(UK_SEMAPHORE_TYPES[1])) {
            box.setSelectedIndex(1);
        } else {
            log.error("Unexpected Signal Type {}", (Object)val);
        }
    }

    private void ukAspectChange() {
        switch (this.ukSignalAspectsFromBox(this.numberUkAspectsBox)) {
            case 2: {
                this.centrePanel2.setVisible(true);
                this.centrePanel4.setVisible(false);
                this.turnoutSelect4.setVisible(false);
                this.centrePanel5.setVisible(false);
                this.turnoutSelect5.setVisible(false);
                this.ukSignalSemaphoreTypeBox.setVisible(true);
                break;
            }
            case 3: {
                this.centrePanel2.setVisible(false);
                this.centrePanel4.setVisible(true);
                this.turnoutSelect4.setVisible(true);
                this.centrePanel5.setVisible(false);
                this.turnoutSelect5.setVisible(false);
                this.ukSignalSemaphoreTypeBox.setVisible(false);
                this.setUkSignalType(this.ukSignalSemaphoreTypeBox, Bundle.getMessage("HomeSignal"));
                break;
            }
            case 4: {
                this.centrePanel2.setVisible(false);
                this.centrePanel4.setVisible(true);
                this.turnoutSelect4.setVisible(true);
                this.centrePanel5.setVisible(true);
                this.turnoutSelect5.setVisible(true);
                this.ukSignalSemaphoreTypeBox.setVisible(false);
                this.setUkSignalType(this.ukSignalSemaphoreTypeBox, Bundle.getMessage("HomeSignal"));
                break;
            }
        }
        this.pack();
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private void updateEditPressed(ActionEvent e) {
        String className;
        log.debug("newedit {}", (Object)e);
        if (this.signalHeadBeingEdited == null) {
            this.createNewSigHead();
            return;
        }
        String nam = this.userNameField.getText();
        String uname = this.signalHeadBeingEdited.getUserName();
        if (uname == null || !uname.equals(nam)) {
            if (this.checkUserName(nam)) {
                this.signalHeadBeingEdited.setUserName(nam);
            } else {
                return;
            }
        }
        block15 : switch (className = this.signalHeadBeingEdited.getClass().getName()) {
            case "jmri.implementation.QuadOutputSignalHead": {
                NamedBeanHandle<Turnout> headType = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getGreen();
                Turnout t1 = this.updateTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green", headType == null ? null : headType.getBean(), this.centrePanBorder1.getTitle());
                if (t1 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.signalHeadBeingEdited).setGreen(this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1));
                headType = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getYellow();
                Turnout t2 = this.updateTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Yellow", headType == null ? null : headType.getBean(), this.centrePanBorder2.getTitle());
                if (t2 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.signalHeadBeingEdited).setYellow(this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2));
                headType = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getRed();
                Turnout t3 = this.updateTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red", headType == null ? null : headType.getBean(), this.centrePanBorder3.getTitle());
                if (t3 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.signalHeadBeingEdited).setRed(this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t3));
                headType = ((QuadOutputSignalHead)this.signalHeadBeingEdited).getLunar();
                Turnout t4 = this.updateTurnoutFromPanel(this.turnoutSelect4, "SignalHead:" + this.systemNameField.getText() + ":Lunar", headType == null ? null : headType.getBean(), this.centrePanBorder4.getTitle());
                if (t4 == null) {
                    return;
                }
                ((QuadOutputSignalHead)this.signalHeadBeingEdited).setLunar(this.nbhm.getNamedBeanHandle(this.turnoutSelect4.getDisplayName(), t4));
                break;
            }
            case "jmri.implementation.TripleTurnoutSignalHead": {
                NamedBeanHandle<Turnout> headType = ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).getGreen();
                Turnout t1 = this.updateTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green", headType == null ? null : headType.getBean(), this.centrePanBorder1.getTitle());
                if (t1 == null) {
                    return;
                }
                ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).setGreen(this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1));
                headType = ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).getYellow();
                Turnout t2 = this.updateTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Yellow", headType == null ? null : headType.getBean(), this.centrePanBorder2.getTitle());
                if (t2 == null) {
                    return;
                }
                ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).setYellow(this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2));
                headType = ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).getRed();
                Turnout t3 = this.updateTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red", headType == null ? null : headType.getBean(), this.centrePanBorder3.getTitle());
                if (t3 == null) {
                    return;
                }
                ((TripleTurnoutSignalHead)this.signalHeadBeingEdited).setRed(this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t3));
                break;
            }
            case "jmri.implementation.TripleOutputSignalHead": {
                NamedBeanHandle<Turnout> headType = ((TripleOutputSignalHead)this.signalHeadBeingEdited).getGreen();
                Turnout t1 = this.updateTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green", headType == null ? null : headType.getBean(), this.centrePanBorder1.getTitle());
                if (t1 == null) {
                    return;
                }
                ((TripleOutputSignalHead)this.signalHeadBeingEdited).setGreen(this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1));
                headType = ((TripleOutputSignalHead)this.signalHeadBeingEdited).getBlue();
                Turnout t2 = this.updateTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Blue", headType == null ? null : headType.getBean(), this.centrePanBorder2.getTitle());
                if (t2 == null) {
                    return;
                }
                ((TripleOutputSignalHead)this.signalHeadBeingEdited).setBlue(this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2));
                headType = ((TripleOutputSignalHead)this.signalHeadBeingEdited).getRed();
                Turnout t3 = this.updateTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red", headType == null ? null : headType.getBean(), this.centrePanBorder3.getTitle());
                if (t3 == null) {
                    return;
                }
                ((TripleOutputSignalHead)this.signalHeadBeingEdited).setRed(this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t3));
                break;
            }
            case "jmri.implementation.DoubleTurnoutSignalHead": {
                NamedBeanHandle<Turnout> headType = ((DoubleTurnoutSignalHead)this.signalHeadBeingEdited).getGreen();
                Turnout t1 = this.updateTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green", headType == null ? null : headType.getBean(), this.centrePanBorder1.getTitle());
                headType = ((DoubleTurnoutSignalHead)this.signalHeadBeingEdited).getRed();
                Turnout t2 = this.updateTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Red", headType == null ? null : headType.getBean(), this.centrePanBorder2.getTitle());
                if (t1 == null) {
                    return;
                }
                ((DoubleTurnoutSignalHead)this.signalHeadBeingEdited).setGreen(this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1));
                if (t2 == null) {
                    return;
                }
                ((DoubleTurnoutSignalHead)this.signalHeadBeingEdited).setRed(this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2));
                break;
            }
            case "jmri.implementation.SingleTurnoutSignalHead": {
                NamedBeanHandle<Turnout> headType = ((SingleTurnoutSignalHead)this.signalHeadBeingEdited).getOutput();
                Turnout t1 = this.updateTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":" + this.signalStateBox2.getSelectedItem() + ":" + this.signalStateBox3.getSelectedItem(), headType == null ? null : headType.getBean(), this.centrePanBorder1.getTitle());
                if (t1 == null) {
                    this.noTurnoutMessage(this.centrePanBorder1.getTitle(), this.turnoutSelect1.getDisplayName());
                    return;
                }
                ((SingleTurnoutSignalHead)this.signalHeadBeingEdited).setOutput(this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1));
                ((SingleTurnoutSignalHead)this.signalHeadBeingEdited).setOnAppearance(this.signalStateFromBox(this.signalStateBox2));
                ((SingleTurnoutSignalHead)this.signalHeadBeingEdited).setOffAppearance(this.signalStateFromBox(this.signalStateBox3));
                break;
            }
            case "jmri.implementation.LsDecSignalHead": {
                NamedBeanHandle<Turnout> headType = ((LsDecSignalHead)this.signalHeadBeingEdited).getGreen();
                Turnout t1 = this.updateTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green", headType == null ? null : headType.getBean(), this.centrePanBorder1.getTitle());
                if (t1 == null) {
                    return;
                }
                ((LsDecSignalHead)this.signalHeadBeingEdited).setGreen(this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1));
                ((LsDecSignalHead)this.signalHeadBeingEdited).setGreenState(this.turnoutStateFromBox(this.turnoutStateBox1));
                headType = ((LsDecSignalHead)this.signalHeadBeingEdited).getYellow();
                Turnout t2 = this.updateTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Yellow", headType == null ? null : headType.getBean(), this.centrePanBorder2.getTitle());
                if (t2 == null) {
                    return;
                }
                ((LsDecSignalHead)this.signalHeadBeingEdited).setYellow(this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2));
                ((LsDecSignalHead)this.signalHeadBeingEdited).setYellowState(this.turnoutStateFromBox(this.turnoutStateBox2));
                headType = ((LsDecSignalHead)this.signalHeadBeingEdited).getRed();
                Turnout t3 = this.updateTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red", headType == null ? null : headType.getBean(), this.centrePanBorder3.getTitle());
                if (t3 == null) {
                    return;
                }
                ((LsDecSignalHead)this.signalHeadBeingEdited).setRed(this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t3));
                ((LsDecSignalHead)this.signalHeadBeingEdited).setRedState(this.turnoutStateFromBox(this.turnoutStateBox3));
                headType = ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashGreen();
                Turnout t4 = this.updateTurnoutFromPanel(this.turnoutSelect4, "SignalHead:" + this.systemNameField.getText() + ":FlashGreen", headType == null ? null : headType.getBean(), this.centrePanBorder4.getTitle());
                if (t4 == null) {
                    return;
                }
                ((LsDecSignalHead)this.signalHeadBeingEdited).setFlashGreen(this.nbhm.getNamedBeanHandle(this.turnoutSelect4.getDisplayName(), t4));
                ((LsDecSignalHead)this.signalHeadBeingEdited).setFlashGreenState(this.turnoutStateFromBox(this.turnoutStateBox4));
                headType = ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashYellow();
                Turnout t5 = this.updateTurnoutFromPanel(this.turnoutSelect5, "SignalHead:" + this.systemNameField.getText() + ":FlashYellow", headType == null ? null : headType.getBean(), this.centrePanBorder5.getTitle());
                if (t5 == null) {
                    return;
                }
                ((LsDecSignalHead)this.signalHeadBeingEdited).setFlashYellow(this.nbhm.getNamedBeanHandle(this.turnoutSelect5.getDisplayName(), t5));
                ((LsDecSignalHead)this.signalHeadBeingEdited).setFlashYellowState(this.turnoutStateFromBox(this.turnoutStateBox5));
                headType = ((LsDecSignalHead)this.signalHeadBeingEdited).getFlashRed();
                Turnout t6 = this.updateTurnoutFromPanel(this.turnoutSelect6, "SignalHead:" + this.systemNameField.getText() + ":FlashRed", headType == null ? null : headType.getBean(), this.centrePanBorder6.getTitle());
                if (t6 == null) {
                    return;
                }
                ((LsDecSignalHead)this.signalHeadBeingEdited).setFlashRed(this.nbhm.getNamedBeanHandle(this.turnoutSelect6.getDisplayName(), t6));
                ((LsDecSignalHead)this.signalHeadBeingEdited).setFlashRedState(this.turnoutStateFromBox(this.turnoutStateBox6));
                headType = ((LsDecSignalHead)this.signalHeadBeingEdited).getDark();
                Turnout t7 = this.updateTurnoutFromPanel(this.turnoutSelect7, "SignalHead:" + this.systemNameField.getText() + ":Dark", headType == null ? null : headType.getBean(), this.centrePanBorder7.getTitle());
                if (t7 == null) {
                    return;
                }
                ((LsDecSignalHead)this.signalHeadBeingEdited).setDark(this.nbhm.getNamedBeanHandle(this.turnoutSelect7.getDisplayName(), t7));
                ((LsDecSignalHead)this.signalHeadBeingEdited).setDarkState(this.turnoutStateFromBox(this.turnoutStateBox7));
                break;
            }
            case "jmri.jmrix.acela.AcelaSignalHead": {
                AcelaNode tNode = AcelaAddress.getNodeFromSystemName(this.signalHeadBeingEdited.getSystemName(), InstanceManager.getDefault(AcelaSystemConnectionMemo.class));
                if (tNode == null) {
                    log.error("Can't find new Acela Signal with name '{}'", (Object)this.signalHeadBeingEdited.getSystemName());
                    return;
                }
                int headnumber = Integer.parseInt(this.signalHeadBeingEdited.getSystemName().substring(2));
                tNode.setOutputSignalHeadTypeString(headnumber, Objects.requireNonNull(this.acelaHeadTypeBox.getSelectedItem()).toString());
                break;
            }
            case "jmri.implementation.MergSD2SignalHead": {
                switch (this.ukSignalAspectsFromBox(this.numberUkAspectsBox)) {
                    case 4: {
                        NamedBeanHandle<Turnout> input3 = ((MergSD2SignalHead)this.signalHeadBeingEdited).getInput3();
                        Turnout t3 = this.updateTurnoutFromPanel(this.turnoutSelect5, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameField.getText(), Bundle.getMessage("InputNum", "3")), input3 == null ? null : input3.getBean(), this.centrePanBorder5.getTitle());
                        if (t3 == null) {
                            return;
                        }
                        ((MergSD2SignalHead)this.signalHeadBeingEdited).setInput3(this.nbhm.getNamedBeanHandle(this.turnoutSelect5.getDisplayName(), t3));
                    }
                    case 3: {
                        NamedBeanHandle<Turnout> input2 = ((MergSD2SignalHead)this.signalHeadBeingEdited).getInput2();
                        Turnout t2 = this.updateTurnoutFromPanel(this.turnoutSelect4, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameField.getText(), Bundle.getMessage("InputNum", "2")), input2 == null ? null : input2.getBean(), this.centrePanBorder4.getTitle());
                        if (t2 == null) {
                            return;
                        }
                        ((MergSD2SignalHead)this.signalHeadBeingEdited).setInput2(this.nbhm.getNamedBeanHandle(this.turnoutSelect4.getDisplayName(), t2));
                    }
                    case 2: {
                        NamedBeanHandle<Turnout> input1 = ((MergSD2SignalHead)this.signalHeadBeingEdited).getInput1();
                        Turnout t1 = this.updateTurnoutFromPanel(this.turnoutSelect3, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameField.getText(), Bundle.getMessage("InputNum", "1")), input1 == null ? null : input1.getBean(), this.centrePanBorder3.getTitle());
                        if (t1 == null) {
                            return;
                        }
                        ((MergSD2SignalHead)this.signalHeadBeingEdited).setInput1(this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t1));
                        ((MergSD2SignalHead)this.signalHeadBeingEdited).setAspects(this.ukSignalAspectsFromBox(this.numberUkAspectsBox));
                        ((MergSD2SignalHead)this.signalHeadBeingEdited).setHome(!this.ukSignalTypeFromBox(this.ukSignalSemaphoreTypeBox).equals("Distant"));
                        break block15;
                    }
                }
                break;
            }
            case "jmri.implementation.DccSignalHead": {
                for (int i = 0; i < this.dccAspectSpinners.length; ++i) {
                    int number = (Integer)this.dccAspectSpinners[i].getValue();
                    try {
                        ((DccSignalHead)this.signalHeadBeingEdited).setOutputForAppearance(this.signalHeadBeingEdited.getValidStates()[i], number);
                        continue;
                    }
                    catch (Exception ex) {
                        log.error("JSpinner for {} did not catch number conversion error", (Object)className, (Object)ex);
                    }
                }
                ((DccSignalHead)this.signalHeadBeingEdited).useAddressOffSet(this.dccOffSetAddressCheckBox.isSelected());
                ((DccSignalHead)this.signalHeadBeingEdited).setDccSignalHeadPacketSendCount((Integer)this.dccPacketSendCountSpinner.getValue());
                break;
            }
            case "jmri.implementation.VirtualSignalHead": 
            case "jmri.implementation.SE8cSignalHead": 
            case "jmri.jmrix.grapevine.SerialSignalHead": {
                break;
            }
            default: {
                log.error("Internal error - cannot update signal of type {}", (Object)className);
            }
        }
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createNewSigHead() {
        if (!this.checkUserName(this.userNameField.getText())) {
            return;
        }
        try {
            if (SE8C4_ASPECT.equals(this.headTypeBox.getSelectedItem())) {
                this.handleSE8cOkPressed();
                return;
            }
            if (ACELA_ASPECT.equals(this.headTypeBox.getSelectedItem())) {
                AcelaNode acelaNode;
                int headnumber;
                String inputusername = this.userNameField.getText();
                String inputsysname = this.systemNameField.getText();
                if (inputsysname.length() == 0) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("signalHeadEntryWarning"));
                    log.warn("must supply a signalhead number (i.e. AH23) using your prefix");
                    return;
                }
                AcelaSystemConnectionMemo acelaMemo = InstanceManager.getNullableDefault(AcelaSystemConnectionMemo.class);
                if (acelaMemo == null) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SystemNotActiveWarning", "Acela"));
                    log.warn("No active Acela connection to create Signal Head");
                    return;
                }
                String acelaPrefix = acelaMemo.getSystemPrefix();
                if (inputsysname.length() > 2) {
                    int offset = Manager.getSystemPrefixLength(inputsysname);
                    if (inputsysname.startsWith(acelaPrefix)) {
                        headnumber = Integer.parseInt(inputsysname.substring(offset));
                    } else {
                        if (!this.checkIntegerOnly(inputsysname)) {
                            log.warn("skipping creation of signal head, '{}' does not start with AxH", (Object)inputsysname);
                            String msg = Bundle.getMessage("acelaSkippingCreation", this.systemNameField.getText());
                            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
                            return;
                        }
                        headnumber = Integer.parseInt(inputsysname);
                    }
                } else {
                    headnumber = Integer.parseInt(inputsysname);
                }
                if ((acelaNode = AcelaAddress.getNodeFromSystemName(acelaPrefix + "H" + headnumber, InstanceManager.getDefault(AcelaSystemConnectionMemo.class))) == null) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("acelaNoNodeFound", Bundle.getMessage("BeanNameSignalHead"), headnumber), Bundle.getMessage("ErrorSignalHeadAddFailed", headnumber), 0);
                    return;
                }
                if (this.checkSysNameOkBeforeCreating(acelaPrefix + "H" + headnumber)) {
                    AcelaSignalHead s = inputusername.length() == 0 ? new AcelaSignalHead(acelaPrefix + "H" + headnumber, InstanceManager.getDefault(AcelaSystemConnectionMemo.class)) : new AcelaSignalHead(acelaPrefix + "H" + headnumber, inputusername, InstanceManager.getDefault(AcelaSystemConnectionMemo.class));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                }
                int st = this.acelaSignalheadTypeFromBox(this.acelaHeadTypeBox);
                switch (st) {
                    case 1: {
                        acelaNode.setOutputSignalHeadType(headnumber, 1);
                        return;
                    }
                    case 2: {
                        acelaNode.setOutputSignalHeadType(headnumber, 2);
                        return;
                    }
                    case 3: {
                        acelaNode.setOutputSignalHeadType(headnumber, 3);
                        return;
                    }
                    case 4: {
                        acelaNode.setOutputSignalHeadType(headnumber, 4);
                        return;
                    }
                }
                log.warn("Unexpected Acela Aspect type: {}", (Object)st);
                acelaNode.setOutputSignalHeadType(headnumber, 0);
                return;
            }
            if (GRAPEVINE.equals(this.headTypeBox.getSelectedItem())) {
                if (this.systemNameField.getText().length() == 0) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("signalHeadEntryWarning"));
                    log.warn("must supply a signalhead number (i.e. GH23) using your prefix");
                    return;
                }
                String inputsysname = this.systemNameField.getText();
                int offset = Manager.getSystemPrefixLength(inputsysname);
                String grapevinePrefix = InstanceManager.getDefault(GrapevineSystemConnectionMemo.class).getSystemPrefix();
                if (inputsysname.startsWith(grapevinePrefix) && inputsysname.charAt(offset) == 'H') {
                    if (!this.checkSysNameOkBeforeCreating(inputsysname)) return;
                    SerialSignalHead s = new SerialSignalHead(inputsysname, this.userNameField.getText(), InstanceManager.getDefault(GrapevineSystemConnectionMemo.class));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal head, '{}' does not start with GxH", (Object)inputsysname);
                String msg = Bundle.getMessage("GrapevineSkippingCreation", inputsysname);
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
                return;
            }
            if (QUAD_OUTPUT.equals(this.headTypeBox.getSelectedItem())) {
                if (!this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Yellow");
                Turnout t3 = this.getTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red");
                Turnout t4 = this.getTurnoutFromPanel(this.turnoutSelect4, "SignalHead:" + this.systemNameField.getText() + ":Lunar");
                if (t1 == null) {
                    this.addTurnoutMessage(this.centrePanBorder1.getTitle(), this.turnoutSelect1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.centrePanBorder2.getTitle(), this.turnoutSelect2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.centrePanBorder3.getTitle(), this.turnoutSelect3.getDisplayName());
                }
                if (t4 == null) {
                    this.addTurnoutMessage(this.centrePanBorder4.getTitle(), this.turnoutSelect4.getDisplayName());
                }
                if (t4 != null && t3 != null && t2 != null && t1 != null) {
                    QuadOutputSignalHead s = new QuadOutputSignalHead(this.systemNameField.getText(), this.userNameField.getText(), this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2), this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t3), this.nbhm.getNamedBeanHandle(this.turnoutSelect4.getDisplayName(), t4));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                return;
            }
            if (TRIPLE_TURNOUT.equals(this.headTypeBox.getSelectedItem())) {
                if (!this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Yellow");
                Turnout t3 = this.getTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red");
                if (t1 == null) {
                    this.addTurnoutMessage(this.centrePanBorder1.getTitle(), this.turnoutSelect1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.centrePanBorder2.getTitle(), this.turnoutSelect2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.centrePanBorder3.getTitle(), this.turnoutSelect3.getDisplayName());
                }
                if (t3 != null && t2 != null && t1 != null) {
                    TripleTurnoutSignalHead s = new TripleTurnoutSignalHead(this.systemNameField.getText(), this.userNameField.getText(), this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2), this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t3));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                return;
            }
            if (TRIPLE_OUTPUT.equals(this.headTypeBox.getSelectedItem())) {
                if (!this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Blue");
                Turnout t3 = this.getTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red");
                if (t1 == null) {
                    this.addTurnoutMessage(this.centrePanBorder1.getTitle(), this.turnoutSelect1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.centrePanBorder2.getTitle(), this.turnoutSelect2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.centrePanBorder3.getTitle(), this.turnoutSelect3.getDisplayName());
                }
                if (t3 != null && t2 != null && t1 != null) {
                    TripleOutputSignalHead s = new TripleOutputSignalHead(this.systemNameField.getText(), this.userNameField.getText(), this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2), this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t3));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                return;
            }
            if (DOUBLE_TURNOUT.equals(this.headTypeBox.getSelectedItem())) {
                if (!this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Red");
                if (t1 == null) {
                    this.addTurnoutMessage(this.centrePanBorder1.getTitle(), this.turnoutSelect1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.centrePanBorder2.getTitle(), this.turnoutSelect2.getDisplayName());
                }
                if (t2 != null && t1 != null) {
                    DoubleTurnoutSignalHead s = new DoubleTurnoutSignalHead(this.systemNameField.getText(), this.userNameField.getText(), this.nbhm.getNamedBeanHandle(this.turnoutSelect1.getDisplayName(), t1), this.nbhm.getNamedBeanHandle(this.turnoutSelect2.getDisplayName(), t2));
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                return;
            }
            if (SINGLE_TURNOUT.equals(this.headTypeBox.getSelectedItem())) {
                if (!this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":" + this.signalStateBox2.getSelectedItem() + ":" + this.signalStateBox3.getSelectedItem());
                int on = this.signalStateFromBox(this.signalStateBox2);
                int off = this.signalStateFromBox(this.signalStateBox3);
                if (t1 == null) {
                    this.addTurnoutMessage(this.centrePanBorder1.getTitle(), this.turnoutSelect1.getDisplayName());
                }
                if (t1 == null) {
                    log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                    return;
                }
                SingleTurnoutSignalHead s = new SingleTurnoutSignalHead(this.systemNameField.getText(), this.userNameField.getText(), this.nbhm.getNamedBeanHandle(t1.getDisplayName(), t1), on, off);
                InstanceManager.getDefault(SignalHeadManager.class).register(s);
                return;
            }
            if (VIRTUAL_HEAD.equals(this.headTypeBox.getSelectedItem())) {
                if (!this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) return;
                VirtualSignalHead s = new VirtualSignalHead(this.systemNameField.getText(), this.userNameField.getText());
                InstanceManager.getDefault(SignalHeadManager.class).register(s);
                return;
            }
            if (LSDEC.equals(this.headTypeBox.getSelectedItem())) {
                if (!this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) return;
                Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":Green");
                Turnout t2 = this.getTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":Yellow");
                Turnout t3 = this.getTurnoutFromPanel(this.turnoutSelect3, "SignalHead:" + this.systemNameField.getText() + ":Red");
                Turnout t4 = this.getTurnoutFromPanel(this.turnoutSelect4, "SignalHead:" + this.systemNameField.getText() + ":FlashGreen");
                Turnout t5 = this.getTurnoutFromPanel(this.turnoutSelect5, "SignalHead:" + this.systemNameField.getText() + ":FlashYellow");
                Turnout t6 = this.getTurnoutFromPanel(this.turnoutSelect6, "SignalHead:" + this.systemNameField.getText() + ":FlashRed");
                Turnout t7 = this.getTurnoutFromPanel(this.turnoutSelect7, "SignalHead:" + this.systemNameField.getText() + ":Dark");
                int s1 = this.turnoutStateFromBox(this.turnoutStateBox1);
                int s2 = this.turnoutStateFromBox(this.turnoutStateBox2);
                int s3 = this.turnoutStateFromBox(this.turnoutStateBox3);
                int s4 = this.turnoutStateFromBox(this.turnoutStateBox4);
                int s5 = this.turnoutStateFromBox(this.turnoutStateBox5);
                int s6 = this.turnoutStateFromBox(this.turnoutStateBox6);
                int s7 = this.turnoutStateFromBox(this.turnoutStateBox7);
                if (t1 == null) {
                    this.addTurnoutMessage(this.centrePanBorder1.getTitle(), this.turnoutSelect1.getDisplayName());
                }
                if (t2 == null) {
                    this.addTurnoutMessage(this.centrePanBorder2.getTitle(), this.turnoutSelect2.getDisplayName());
                }
                if (t3 == null) {
                    this.addTurnoutMessage(this.centrePanBorder3.getTitle(), this.turnoutSelect3.getDisplayName());
                }
                if (t4 == null) {
                    this.addTurnoutMessage(this.centrePanBorder4.getTitle(), this.turnoutSelect4.getDisplayName());
                }
                if (t5 == null) {
                    this.addTurnoutMessage(this.centrePanBorder5.getTitle(), this.turnoutSelect5.getDisplayName());
                }
                if (t6 == null) {
                    this.addTurnoutMessage(this.centrePanBorder6.getTitle(), this.turnoutSelect6.getDisplayName());
                }
                if (t7 == null) {
                    this.addTurnoutMessage(this.centrePanBorder7.getTitle(), this.turnoutSelect7.getDisplayName());
                }
                if (t7 != null && t6 != null && t5 != null && t4 != null && t3 != null && t2 != null && t1 != null) {
                    LsDecSignalHead s = new LsDecSignalHead(this.systemNameField.getText(), this.nbhm.getNamedBeanHandle(t1.getDisplayName(), t1), s1, this.nbhm.getNamedBeanHandle(t2.getDisplayName(), t2), s2, this.nbhm.getNamedBeanHandle(t3.getDisplayName(), t3), s3, this.nbhm.getNamedBeanHandle(t4.getDisplayName(), t4), s4, this.nbhm.getNamedBeanHandle(t5.getDisplayName(), t5), s5, this.nbhm.getNamedBeanHandle(t6.getDisplayName(), t6), s6, this.nbhm.getNamedBeanHandle(t7.getDisplayName(), t7), s7);
                    s.setUserName(this.userNameField.getText());
                    InstanceManager.getDefault(SignalHeadManager.class).register(s);
                    return;
                }
                log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                return;
            }
            if (DCC_SIGNAL_DECODER.equals(this.headTypeBox.getSelectedItem())) {
                this.handleDCCOkPressed();
                return;
            }
            if (!MERG_SIGNAL_DRIVER.equals(this.headTypeBox.getSelectedItem())) throw new UnsupportedOperationException("Unexpected type: " + this.headTypeBox.getSelectedItem());
            this.handleMergSignalDriverOkPressed();
            return;
        }
        catch (NumberFormatException ex) {
            this.handleCreateException(ex, this.systemNameField.getText());
        }
    }

    private void addTurnoutMessage(String s1, String s2) {
        log.warn("Could not provide turnout {}", (Object)s2);
        String msg = Bundle.getMessage("AddNoTurnout", s1, s2);
        JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle") + " " + s1, 0);
    }

    private void handleCreateException(Exception ex, String sysName) {
        if (ex.getLocalizedMessage() != null) {
            JmriJOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
        } else if (ex.getMessage() != null) {
            JmriJOptionPane.showMessageDialog(this, ex.getMessage(), Bundle.getMessage("ErrorTitle"), 0);
        } else {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorSignalHeadAddFailed", sysName) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
        }
    }

    private int acelaSignalheadTypeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, ACELA_SIG_HEAD_TYPE_VALUES, ACELA_SIG_HEAD_TYPES);
        if (result < 0) {
            log.warn("unexpected mode string in signalhead appearance type: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    private void handleSE8cOkPressed() {
        Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect1, "SignalHead:" + this.systemNameField.getText() + ":low");
        Turnout t2 = this.getTurnoutFromPanel(this.turnoutSelect2, "SignalHead:" + this.systemNameField.getText() + ":high");
        if (t1 != null && t2 != null) {
            SE8cSignalHead s;
            try {
                s = new SE8cSignalHead(this.nbhm.getNamedBeanHandle(t1.getSystemName(), t1), this.nbhm.getNamedBeanHandle(t2.getSystemName(), t2), this.userNameField.getText());
            }
            catch (NumberFormatException ex) {
                this.handleCreate2TurnoutException(t1.getSystemName(), t2.getSystemName(), this.userNameField.getText());
                return;
            }
            try {
                InstanceManager.getDefault(SignalHeadManager.class).register(s);
            }
            catch (NamedBean.DuplicateSystemNameException ex) {
                s.dispose();
                JmriJOptionPane.showMessageDialog(this, "<html>" + Bundle.getMessage("ErrorSe8cDuplicateSysName", t1.getDisplayName(), t2.getDisplayName()) + "<br>" + Bundle.getMessage("ErrorReplaceHead") + "<br>" + ex.getLocalizedMessage() + "</html>", Bundle.getMessage("WarningTitle"), 0);
            }
        } else {
            String msg = t1 == null ? Bundle.getMessage("se8c4SkippingDueToErrorInFirst") : Bundle.getMessage("se8c4SkippingDueToErrorInSecond");
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
        }
    }

    private void handleDCCOkPressed() {
        Object systemNameText = null;
        String prefix = (String)this.prefixBox.getSelectedItem();
        if (prefix != null) {
            systemNameText = ConnectionNameFromSystemName.getPrefixFromName(prefix);
        }
        if (systemNameText == null) {
            systemNameText = "I";
        }
        if (this.checkSysNameOkBeforeCreating((String)(systemNameText = (String)systemNameText + "H$" + this.systemNameField.getText()))) {
            DccSignalHead s = new DccSignalHead((String)systemNameText);
            s.setUserName(this.userNameField.getText());
            log.debug("dccAspect Length = {}", (Object)this.dccAspectSpinners.length);
            for (int i = 0; i < DccSignalHead.getDefaultValidStates().length; ++i) {
                log.debug("i = {}", (Object)i);
                int number = (Integer)this.dccAspectSpinners[i].getValue();
                try {
                    s.setOutputForAppearance(s.getValidStates()[i], number);
                    continue;
                }
                catch (RuntimeException ex) {
                    log.warn("error setting \"{}\" output for appearance \"{}\"", systemNameText, (Object)number);
                }
            }
            InstanceManager.getDefault(SignalHeadManager.class).register(s);
            s.useAddressOffSet(this.dccOffSetAddressCheckBox.isSelected());
            s.setDccSignalHeadPacketSendCount((Integer)this.dccPacketSendCountSpinner.getValue());
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private void handleMergSignalDriverOkPressed() {
        NamedBeanHandle<Turnout> nbt1 = null;
        NamedBeanHandle<Turnout> nbt2 = null;
        NamedBeanHandle<Turnout> nbt3 = null;
        if (this.checkSysNameOkBeforeCreating(this.systemNameField.getText())) {
            switch (this.ukSignalAspectsFromBox(this.numberUkAspectsBox)) {
                case 4: {
                    Turnout t3 = this.getTurnoutFromPanel(this.turnoutSelect5, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameField.getText(), Bundle.getMessage("InputNum", "3")));
                    if (t3 == null) {
                        this.addTurnoutMessage(this.centrePanBorder5.getTitle(), this.turnoutSelect5.getDisplayName());
                        log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                        return;
                    }
                    nbt3 = this.nbhm.getNamedBeanHandle(this.turnoutSelect5.getDisplayName(), t3);
                }
                case 3: {
                    Turnout t2 = this.getTurnoutFromPanel(this.turnoutSelect4, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameField.getText(), Bundle.getMessage("InputNum", "2")));
                    if (t2 == null) {
                        this.addTurnoutMessage(this.centrePanBorder4.getTitle(), this.turnoutSelect4.getDisplayName());
                        log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                        return;
                    }
                    nbt2 = this.nbhm.getNamedBeanHandle(this.turnoutSelect4.getDisplayName(), t2);
                }
                case 2: {
                    Turnout t1 = this.getTurnoutFromPanel(this.turnoutSelect3, Bundle.getMessage("OutputComment", Bundle.getMessage("BeanNameSignalHead"), this.systemNameField.getText(), Bundle.getMessage("InputNum", "1")));
                    if (t1 == null) {
                        this.addTurnoutMessage(this.centrePanBorder3.getTitle(), this.turnoutSelect3.getDisplayName());
                        log.warn("skipping creation of signal {} due to error", (Object)this.systemNameField.getText());
                        return;
                    }
                    nbt1 = this.nbhm.getNamedBeanHandle(this.turnoutSelect3.getDisplayName(), t1);
                    break;
                }
            }
            boolean home = !this.ukSignalTypeFromBox(this.ukSignalSemaphoreTypeBox).equals(Bundle.getMessage("DistantSignal"));
            MergSD2SignalHead s = new MergSD2SignalHead(this.systemNameField.getText(), this.ukSignalAspectsFromBox(this.numberUkAspectsBox), nbt1, nbt2, nbt3, false, home);
            s.setUserName(this.userNameField.getText());
            InstanceManager.getDefault(SignalHeadManager.class).register(s);
        }
    }

    private boolean checkSysNameOkBeforeCreating(String sysName) {
        if (DCC_SIGNAL_DECODER.equals(this.headTypeBox.getSelectedItem())) {
            try {
                Integer.valueOf(sysName.substring(sysName.indexOf("$") + 1));
            }
            catch (NumberFormatException ex) {
                String msg = Bundle.getMessage("ShouldBeNumber", "Hardware Address");
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
                return false;
            }
        }
        boolean ok = true;
        try {
            int i = Manager.getSystemPrefixLength(sysName);
            if (sysName.length() < i + 2) {
                ok = false;
            } else if (sysName.charAt(i) != 'H') {
                ok = false;
            }
        }
        catch (NamedBean.BadSystemNameException e) {
            ok = false;
        }
        if (!ok) {
            String msg = Bundle.getMessage("InvalidSignalSystemName", sysName);
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
            return false;
        }
        SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sysName);
        if (s == null) {
            SignalHead nB = InstanceManager.getDefault(SignalHeadManager.class).getByUserName(sysName);
            if (nB != null) {
                log.error("System name is not unique {} It already exists as a User name", (Object)sysName);
                String msg = Bundle.getMessage("WarningSystemNameAsUser", sysName);
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
                return false;
            }
            return true;
        }
        log.warn("Attempt to create signal with duplicate system name {}", (Object)sysName);
        String msg = Bundle.getMessage("DuplicateSignalSystemName", sysName);
        JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
        return false;
    }

    private boolean checkIntegerOnly(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void handleCreate2TurnoutException(String t1, String t2, String uName) {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorSe8cAddFailed", uName, t1, t2) + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), Bundle.getMessage("ErrorTitle"), 0);
    }

    @CheckForNull
    private Turnout updateTurnoutFromPanel(@Nonnull BeanSelectCreatePanel<Turnout> bp, String reference, @CheckForNull Turnout oldTurnout, String title) {
        String comment;
        Turnout newTurnout = this.getTurnoutFromPanel(bp, reference);
        if (newTurnout == null) {
            this.noTurnoutMessage(title, bp.getDisplayName());
        }
        if (newTurnout != null && ((comment = newTurnout.getComment()) == null || comment.isEmpty())) {
            newTurnout.setComment(reference);
        }
        if (oldTurnout == null || newTurnout == oldTurnout) {
            return newTurnout;
        }
        comment = oldTurnout.getComment();
        if (comment != null && comment.equals(reference)) {
            oldTurnout.setComment(null);
        }
        return newTurnout;
    }

    @CheckForNull
    private Turnout getTurnoutFromPanel(@Nonnull BeanSelectCreatePanel<Turnout> bp, String reference) {
        bp.setReference(reference);
        try {
            return bp.getNamedBean();
        }
        catch (JmriException ex) {
            log.warn("skipping creation of turnout not found for {}", (Object)reference);
            return null;
        }
    }

    private boolean checkUserName(String nam) {
        if (nam != null && !nam.isEmpty()) {
            SignalHead nB = InstanceManager.getDefault(SignalHeadManager.class).getByUserName(nam);
            if (nB != null) {
                log.error("User name is not unique {}", (Object)nam);
                String msg = Bundle.getMessage("WarningUserName", nam);
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("InvalidUserNameAlreadyExists", Bundle.getMessage("BeanNameSignalHead"), nam), 0);
                return false;
            }
            nB = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(nam);
            if (nB != null) {
                log.error("User name is not unique {} It already exists as a System name", (Object)nam);
                String msg = Bundle.getMessage("WarningUserNameAsSystem", nam);
                JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("InvalidUserNameAlreadyExists", Bundle.getMessage("BeanNameSignalHead"), nam), 0);
                return false;
            }
        }
        return true;
    }

    private void noTurnoutMessage(String s1, String s2) {
        log.warn("Could not provide turnout {}", (Object)s2);
        String msg = Bundle.getMessage("WarningNoTurnout", s1, s2);
        JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
    }

    @Override
    public void dispose() {
        if (this.turnoutSelect1 != null) {
            this.turnoutSelect1.dispose();
        }
        if (this.turnoutSelect2 != null) {
            this.turnoutSelect2.dispose();
        }
        if (this.turnoutSelect3 != null) {
            this.turnoutSelect3.dispose();
        }
        if (this.turnoutSelect4 != null) {
            this.turnoutSelect4.dispose();
        }
        if (this.turnoutSelect5 != null) {
            this.turnoutSelect5.dispose();
        }
        if (this.turnoutSelect6 != null) {
            this.turnoutSelect6.dispose();
        }
        if (this.turnoutSelect7 != null) {
            this.turnoutSelect7.dispose();
        }
        super.dispose();
    }
}

