/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.RowComboBoxPanel;
import jmri.jmrit.beantable.SignalHeadAddEditFrame;
import jmri.jmrit.beantable.SignalHeadTableAction;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadTableModel
extends BeanTableDataModel<SignalHead> {
    public static final int LITCOL = 5;
    public static final int HELDCOL = 6;
    public static final int EDITCOL = 7;
    final Hashtable<Object, JComboBox<String>> editorMap = new Hashtable();
    final Hashtable<Object, Vector<String>> boxMap = new Hashtable();
    private SignalHeadAddEditFrame editFrame = null;
    private static final Logger log = LoggerFactory.getLogger(SignalHeadTableModel.class);

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 2: {
                return Bundle.getMessage("SignalMastAppearance");
            }
            case 5: {
                return Bundle.getMessage("ColumnHeadLit");
            }
            case 6: {
                return Bundle.getMessage("ColumnHeadHeld");
            }
            case 7: {
                return "";
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: {
                return RowComboBoxPanel.class;
            }
            case 5: 
            case 6: {
                return Boolean.class;
            }
            case 7: {
                return JButton.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 5: 
            case 6: {
                return new JTextField((int)4).getPreferredSize().width;
            }
            case 7: {
                return new JTextField((int)7).getPreferredSize().width;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.sysNameList.size()) {
            log.debug("row is greater than name list");
            return "error";
        }
        String name = (String)this.sysNameList.get(row);
        SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
        if (s == null) {
            return Boolean.FALSE;
        }
        switch (col) {
            case 5: {
                return s.getLit();
            }
            case 6: {
                return s.getHeld();
            }
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 2: {
                String appearance = s.getAppearanceName();
                if (!appearance.isEmpty()) {
                    return appearance;
                }
                log.debug("No Appearance returned for head in row {}", (Object)row);
                return Bundle.getMessage("BeanStateUnknown");
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String name = (String)this.sysNameList.get(row);
        SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
        if (s == null) {
            return;
        }
        switch (col) {
            case 2: {
                if (value == null) break;
                log.debug("SignalHead setValueAt (rowConverted={}; value={})", (Object)row, value);
                int newState = 99;
                String[] stateNameList = s.getValidStateNames();
                int[] validStateList = s.getValidStates();
                for (int i = 0; i < stateNameList.length; ++i) {
                    if (!value.equals(stateNameList[i])) continue;
                    newState = validStateList[i];
                    break;
                }
                if (newState == 99) {
                    if (stateNameList.length == 0) {
                        newState = 0;
                        log.warn("New signal state not found so setting to Dark {}", (Object)s.getDisplayName());
                    } else {
                        newState = validStateList[0];
                        log.warn("New signal state not found so setting to the first available {}", (Object)s.getDisplayName());
                    }
                }
                log.debug("Signal Head set from: {} to: {} [{}]", new Object[]{s.getAppearanceName(), value, newState});
                s.setAppearance(newState);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 5: {
                s.setLit((Boolean)value);
                break;
            }
            case 6: {
                s.setHeld((Boolean)value);
                break;
            }
            case 7: {
                this.editSignal(s);
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    public String getValue(String name) {
        SignalHead s = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
        if (s == null) {
            return "<lost>";
        }
        String val = null;
        try {
            val = s.getAppearanceName();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error("Could not get Appearance Name for {}", (Object)s.getDisplayName(), (Object)e);
        }
        if (val != null) {
            return val;
        }
        return "Unexpected null value";
    }

    public SignalHeadManager getManager() {
        return InstanceManager.getDefault(SignalHeadManager.class);
    }

    @Override
    public SignalHead getBySystemName(@Nonnull String name) {
        return InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
    }

    @Override
    public SignalHead getByUserName(@Nonnull String name) {
        return InstanceManager.getDefault(SignalHeadManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return SignalHeadTableAction.class.getName();
    }

    @Override
    public void clickOn(SignalHead t) {
    }

    @Override
    public JButton configureButton() {
        JButton b = new JButton(Bundle.getMessage("SignalHeadStateYellow"));
        b.putClientProperty("JComponent.sizeVariant", "small");
        b.putClientProperty("JButton.buttonType", "square");
        return b;
    }

    @Override
    public boolean matchPropertyName(PropertyChangeEvent e) {
        if (e.getPropertyName().contains("Lit") || e.getPropertyName().contains("Held") || e.getPropertyName().contains("ValidStatesChanged")) {
            return true;
        }
        return super.matchPropertyName(e);
    }

    @Override
    protected String getBeanType() {
        return Bundle.getMessage("BeanNameSignalHead");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ((!e.getPropertyName().contains("Lit") || e.getPropertyName().contains("Held") || e.getPropertyName().contains("ValidStatesChanged")) && e.getSource() instanceof NamedBean) {
            String name = ((NamedBean)e.getSource()).getSystemName();
            if (log.isDebugEnabled()) {
                log.debug("Update cell {}, {} for {}", new Object[]{this.sysNameList.indexOf(name), 2, name});
            }
            int row = this.sysNameList.indexOf(name);
            this.fireTableRowsUpdated(row, row);
            this.clearAppearanceVector(row);
        }
        super.propertyChange(e);
    }

    @Override
    protected void configValueColumn(JTable table) {
        this.setColumnToHoldButton(table, 2, this.configureButton());
        log.debug("Head configValueColumn (I am {})", (Object)super.toString());
        table.setDefaultEditor(RowComboBoxPanel.class, new AppearanceComboBoxPanel());
        table.setDefaultRenderer(RowComboBoxPanel.class, new AppearanceComboBoxPanel());
    }

    public void clearAppearanceVector(int row) {
        this.boxMap.remove(this.getValueAt(row, 0));
        this.editorMap.remove(this.getValueAt(row, 0));
    }

    public JComboBox<String> getAppearanceEditorBox(int row) {
        JComboBox<String> editCombo = this.editorMap.get(this.getValueAt(row, 0));
        if (editCombo == null) {
            editCombo = new JComboBox<String>(this.getRowVector(row));
            this.editorMap.put(this.getValueAt(row, 0), editCombo);
        }
        return editCombo;
    }

    public Vector<String> getValidAppearances(SignalHead head) {
        String[] app = head.getValidStateNames();
        Vector<String> v = new Vector<String>();
        Collections.addAll(v, app);
        return v;
    }

    Vector<String> getRowVector(int row) {
        Vector<String> comboappearances = this.boxMap.get(this.getValueAt(row, 0));
        if (comboappearances == null) {
            comboappearances = this.getValidAppearances((SignalHead)this.getValueAt(row, 0));
            this.boxMap.put(this.getValueAt(row, 0), comboappearances);
        }
        return comboappearances;
    }

    private void editSignal(@Nonnull SignalHead head) {
        log.debug("editPressed started for {}", (Object)head.getSystemName());
        Runnable t = () -> this.makeEditSignalWindow(head);
        SwingUtilities.invokeLater(t);
    }

    private void makeEditSignalWindow(@Nonnull SignalHead head) {
        if (this.editFrame == null) {
            this.editFrame = new SignalHeadAddEditFrame(head){

                @Override
                public void dispose() {
                    SignalHeadTableModel.this.editFrame = null;
                    super.dispose();
                }
            };
            this.editFrame.initComponents();
        } else if (head.equals(this.editFrame.getSignalHead())) {
            this.editFrame.setVisible(true);
        } else {
            log.error("Attempt to edit two signal heads at the same time-{}-and-{}-", (Object)this.editFrame.getSignalHead(), (Object)head.getSystemName());
            String msg = Bundle.getMessage("WarningEdit", this.editFrame.getSignalHead(), head.getSystemName());
            JmriJOptionPane.showMessageDialog(this.editFrame, msg, Bundle.getMessage("WarningTitle"), 0);
            this.editFrame.setVisible(true);
        }
    }

    @Override
    public void dispose() {
        if (this.editFrame != null) {
            this.editFrame.dispose();
            this.editFrame = null;
        }
        super.dispose();
    }

    class AppearanceComboBoxPanel
    extends RowComboBoxPanel {
        AppearanceComboBoxPanel() {
        }

        @Override
        protected final void eventEditorMousePressed() {
            this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
            this.editor.revalidate();
            SwingUtilities.invokeLater(this.comboBoxFocusRequester);
            log.debug("eventEditorMousePressed in row: {})", (Object)this.currentRow);
        }

        @Override
        protected JComboBox<String> getEditorBox(int row) {
            return SignalHeadTableModel.this.getAppearanceEditorBox(row);
        }
    }
}

