/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SectionManager;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.signalmast.SignalMastLogicTableDataModel;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.signalling.SignallingAction;
import jmri.managers.DefaultSignalMastLogicManager;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastLogicTableAction
extends AbstractTableAction<SignalMastLogic> {
    private JmriJFrame signalMastLogicFrame = null;
    private JLabel sourceLabel = new JLabel();
    private final PropertyChangeListener propertyGenerateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("autoGenerateComplete".equals(evt.getPropertyName())) {
                if (SignalMastLogicTableAction.this.signalMastLogicFrame != null) {
                    SignalMastLogicTableAction.this.signalMastLogicFrame.setVisible(false);
                }
                InstanceManager.getDefault(SignalMastLogicManager.class).removePropertyChangeListener(this);
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SignalMastPairGenerationComplete"));
            } else if ("autoGenerateUpdate".equals(evt.getPropertyName())) {
                SignalMastLogicTableAction.this.sourceLabel.setText((String)evt.getNewValue());
                SignalMastLogicTableAction.this.signalMastLogicFrame.pack();
                SignalMastLogicTableAction.this.signalMastLogicFrame.repaint();
            }
        }
    };
    private final SignallingAction sigLog = new SignallingAction();
    private static final Logger log = LoggerFactory.getLogger(SignalMastLogicTableAction.class);

    public SignalMastLogicTableAction(String s) {
        super(s);
    }

    public SignalMastLogicTableAction() {
        this(Bundle.getMessage("TitleSignalMastLogicTable"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createModel();
        TableRowSorter<BeanTableDataModel> sorter = new TableRowSorter<BeanTableDataModel>(this.m);
        JTable dataTable = this.m.makeJTable(this.m.getMasterClassName(), this.m, sorter);
        this.f = new BeanTableFrame<SignalMastLogic>(this.m, this.helpTarget(), dataTable){};
        this.setMenuBar(this.f);
        this.setTitle();
        this.addToFrame(this.f);
        this.f.pack();
        this.f.setVisible(true);
    }

    @Override
    public void setMenuBar(BeanTableFrame<SignalMastLogic> f) {
        BeanTableFrame<SignalMastLogic> finalF = f;
        JMenuBar menuBar = f.getJMenuBar();
        int pos = menuBar.getMenuCount() - 1;
        int offset = 1;
        log.debug("setMenuBar number of menu items = {}", (Object)pos);
        for (int i = 0; i <= pos; ++i) {
            if (!(menuBar.getComponent(i) instanceof JMenu) || !((AbstractButton)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuHelp"))) continue;
            offset = -1;
        }
        JMenu pathMenu = new JMenu(Bundle.getMessage("MenuTools"));
        menuBar.add((Component)pathMenu, pos + offset);
        JMenuItem item = new JMenuItem(Bundle.getMessage("MenuItemAutoGen"));
        pathMenu.add(item);
        item.addActionListener(e -> this.autoCreatePairs(finalF));
        item = new JMenuItem(Bundle.getMessage("MenuItemAutoGenSections"));
        pathMenu.add(item);
        item.addActionListener(e -> {
            ((DefaultSignalMastLogicManager)InstanceManager.getDefault(SignalMastLogicManager.class)).generateSection();
            InstanceManager.getDefault(SectionManager.class).generateBlockSections();
            JmriJOptionPane.showMessageDialog(finalF, Bundle.getMessage("SectionGenerationComplete"));
        });
        JMenuItem setSMLDirSensors = new JMenuItem(Bundle.getMessage("MenuItemAddDirectionSensors"));
        pathMenu.add(setSMLDirSensors);
        setSMLDirSensors.addActionListener(e -> {
            int n = InstanceManager.getDefault(SignalMastLogicManager.class).setupSignalMastsDirectionSensors();
            if (n > 0) {
                JmriJOptionPane.showMessageDialog(finalF, MessageFormat.format(Bundle.getMessage("MenuItemAddDirectionSensorsErrorCount"), n), Bundle.getMessage("ErrorTitle"), 0);
            }
        });
    }

    @Override
    protected void createModel() {
        this.m = new SignalMastLogicTableDataModel();
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleSignalMastLogicTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.SignalMastLogicTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.sigLog.setMast(null, null);
        this.sigLog.actionPerformed(e);
    }

    void autoCreatePairs(JmriJFrame f) {
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            int response = JmriJOptionPane.showConfirmDialog(f, Bundle.getMessage("EnableLayoutBlockRouting"), Bundle.getMessage("TitleBlockRouting"), 0);
            if (response == 0) {
                InstanceManager.getDefault(LayoutBlockManager.class).enableAdvancedRouting(true);
                JmriJOptionPane.showMessageDialog(f, Bundle.getMessage("LayoutBlockRoutingEnabled"));
            } else {
                return;
            }
        }
        this.signalMastLogicFrame = new JmriJFrame(Bundle.getMessage("DiscoverSignalMastPairs"), false, false);
        this.signalMastLogicFrame.setPreferredSize(null);
        JPanel panel1 = new JPanel();
        this.sourceLabel = new JLabel(Bundle.getMessage("DiscoveringSignalMastPairs"));
        panel1.add(this.sourceLabel);
        this.signalMastLogicFrame.add(panel1);
        this.signalMastLogicFrame.pack();
        this.signalMastLogicFrame.setVisible(true);
        JCheckBox genSect = new JCheckBox(Bundle.getMessage("AutoGenSectionAfterLogic"));
        genSect.setToolTipText(Bundle.getMessage("AutoGenSectionAfterLogicToolTip"));
        Object[] params = new Object[]{Bundle.getMessage("AutoGenSignalMastLogicMessage"), " ", genSect};
        int retval = JmriJOptionPane.showConfirmDialog(f, params, Bundle.getMessage("AutoGenSignalMastLogicTitle"), 0);
        if (retval == 0) {
            InstanceManager.getDefault(SignalMastLogicManager.class).addPropertyChangeListener(this.propertyGenerateListener);
            Runnable r = () -> {
                ((SignalMastLogicTableDataModel)this.m).setSuppressUpdate(true);
                try {
                    InstanceManager.getDefault(SignalMastLogicManager.class).automaticallyDiscoverSignallingPairs();
                }
                catch (JmriException e) {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            InstanceManager.getDefault(SignalMastLogicManager.class).removePropertyChangeListener(this.propertyGenerateListener);
                            JmriJOptionPane.showMessageDialog(f, e.toString());
                            this.signalMastLogicFrame.setVisible(false);
                        });
                    }
                    catch (InvocationTargetException ex) {
                        log.error("failed to notify of problem with automaticallyDiscoverSignallingPairs", (Throwable)ex);
                    }
                    catch (InterruptedException ex) {
                        log.error("interrupted while notifying of problem with automaticallyDiscoverSignallingPairs", (Throwable)ex);
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        this.m.updateNameList();
                        ((SignalMastLogicTableDataModel)this.m).setSuppressUpdate(false);
                        this.m.fireTableDataChanged();
                        if (genSect.isSelected()) {
                            ((DefaultSignalMastLogicManager)InstanceManager.getDefault(SignalMastLogicManager.class)).generateSection();
                            InstanceManager.getDefault(SectionManager.class).generateBlockSections();
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    log.error("failed to update at end of automaticallyDiscoverSignallingPairs", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    log.error("interrupted during update at end of automaticallyDiscoverSignallingPairs", (Throwable)ex);
                }
            };
            Thread thr = ThreadingUtil.newThread(r, "Discover Signal Mast Logic");
            thr.start();
        } else {
            this.signalMastLogicFrame.setVisible(false);
        }
    }

    @Override
    protected String getClassName() {
        return SignalMastLogicTableAction.class.getName();
    }
}

