/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.beans.PropertyChangeEvent;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.StringIO;
import jmri.StringIOManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.StringIOTableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringIOTableDataModel
extends BeanTableDataModel<StringIO> {
    static final int KNOWNCOL = 5;
    private StringIOManager stringIOManager;
    private static final Logger log = LoggerFactory.getLogger(StringIOTableDataModel.class);

    public StringIOTableDataModel(Manager<StringIO> mgr) {
        this.setManager(mgr);
    }

    @Override
    @CheckForNull
    public String getValue(String name) {
        StringIO r = (StringIO)this.getManager().getBySystemName(name);
        if (r == null) {
            return "";
        }
        return r.getCommandedStringValue();
    }

    @Override
    public final void setManager(Manager<StringIO> rm) {
        if (!(rm instanceof StringIOManager)) {
            return;
        }
        this.getManager().removePropertyChangeListener(this);
        if (this.sysNameList != null) {
            for (int i = 0; i < this.sysNameList.size(); ++i) {
                StringIO b = this.getBySystemName((String)this.sysNameList.get(i));
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
        this.stringIOManager = (StringIOManager)rm;
        this.getManager().addPropertyChangeListener(this);
        this.updateNameList();
    }

    public StringIOManager getManager() {
        return this.stringIOManager == null ? InstanceManager.getDefault(StringIOManager.class) : this.stringIOManager;
    }

    @Override
    public StringIO getBySystemName(@Nonnull String name) {
        return (StringIO)this.getManager().getBySystemName(name);
    }

    @Override
    public StringIO getByUserName(@Nonnull String name) {
        return (StringIO)this.getManager().getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return StringIOTableAction.class.getName();
    }

    @Override
    public void clickOn(StringIO t) {
    }

    @Override
    public int getPreferredWidth(int col) {
        if (col == 5) {
            return new JTextField((int)15).getPreferredSize().width;
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 5: {
                StringIO r = (StringIO)this.getManager().getBySystemName((String)this.sysNameList.get(row));
                if (r == null) {
                    return "";
                }
                return r.getKnownStringValue();
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 2: {
                try {
                    this.getBySystemName((String)this.sysNameList.get(row)).setCommandedStringValue(value.toString());
                }
                catch (JmriException ex) {
                    log.error("Exception trying to set value at {},{} to {}", new Object[]{row, col, value});
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 5 + this.getPropertyColumnCount() + 1;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 2: {
                return Bundle.getMessage("StringIOCommanded");
            }
            case 5: {
                return Bundle.getMessage("StringIOKnown");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public void configValueColumn(JTable table) {
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return true;
    }

    @Override
    public JButton configureButton() {
        log.error("configureButton should not have been called");
        return null;
    }
}

