/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Transit;
import jmri.TransitManager;
import jmri.TransitSection;
import jmri.TransitSectionAction;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.dispatcher.TrainInfoFile;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.swing.NamedBeanComboBox;
import jmri.util.AlphanumComparator;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitTableAction
extends AbstractTableAction<Transit> {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.beantable.SectionTransitTableBundle");
    private boolean editMode = false;
    private boolean duplicateMode = false;
    private TransitManager transitManager = null;
    private final SectionManager sectionManager = InstanceManager.getNullableDefault(SectionManager.class);
    private Transit curTransit = null;
    private SectionTableModel sectionTableModel = null;
    private final List<Section> sectionList = new ArrayList<Section>();
    private final List<Integer> direction = new ArrayList<Integer>();
    private final List<Integer> sequence = new ArrayList<Integer>();
    private final List<List<TransitSectionAction>> action = new ArrayList<List<TransitSectionAction>>();
    private final List<Boolean> alternate = new ArrayList<Boolean>();
    private final List<Boolean> safe = new ArrayList<Boolean>();
    private String[] sensorList;
    private final List<String> sensorStopAllocation = new ArrayList<String>();
    private final List<Section> primarySectionBoxList = new ArrayList<Section>();
    private final List<Integer> priSectionDirection = new ArrayList<Integer>();
    private final List<Section> alternateSectionBoxList = new ArrayList<Section>();
    private final List<Integer> altSectionDirection = new ArrayList<Integer>();
    private final List<Section> insertAtBeginningBoxList = new ArrayList<Section>();
    private final List<Integer> insertAtBeginningDirection = new ArrayList<Integer>();
    private Section curSection = null;
    private int curSectionDirection = 0;
    private Section prevSection = null;
    private int prevSectionDirection = 0;
    private int curSequenceNum = 0;
    JmriJFrame addFrame = null;
    JTextField sysName = new JTextField(15);
    JLabel sysNameFixed = new JLabel("");
    JTextField userName = new JTextField(17);
    JLabel sysNameLabel = new JLabel(Bundle.getMessage("LabelSystemName"));
    JLabel userNameLabel = new JLabel(Bundle.getMessage("LabelUserName"));
    JButton create = null;
    JButton update = null;
    JButton deleteSections = null;
    JComboBox<String> primarySectionBox = new JComboBox();
    JButton addNextSection = null;
    JCheckBox addAsSafe = null;
    JComboBox<String> stopAllocatingSensorBox = new JComboBox();
    JButton removeLastSection = null;
    JButton removeFirstSection = null;
    JButton insertAtBeginning = null;
    JComboBox<String> insertAtBeginningBox = new JComboBox();
    JLabel seqNumLabel = new JLabel(rbx.getString("LabelSeqNum"));
    JSpinner seqNum = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
    JButton replacePrimaryForSequence = null;
    JButton deleteAlternateForSequence = null;
    JButton addAlternateForSequence = null;
    JComboBox<String> alternateSectionBox = new JComboBox();
    JButton addAlternateSection = null;
    JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    UserPreferencesManager pref;
    String systemNameAuto = this.getClass().getName() + ".AutoSystemName";
    private int activeRow = 0;
    private SpecialActionTableModel actionTableModel = null;
    private JmriJFrame actionTableFrame = null;
    private final JLabel fixedSectionLabel = new JLabel("X");
    private boolean editActionMode = false;
    private JmriJFrame addEditActionFrame = null;
    private TransitSectionAction curTSA = null;
    private final JComboBox<String> whenBox = new JComboBox();
    private final NamedBeanComboBox<Sensor> whenSensorComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JSpinner whenDataSpinnerFloat = new JSpinner(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(65.0f), Float.valueOf(0.5f)));
    private final JSpinner whenDataSpinnerInt = new JSpinner(new SpinnerNumberModel(0, 0, 65000, 100));
    private final JRadioButton mSecButton = new JRadioButton(Bundle.getMessage("LabelMilliseconds"));
    private final JRadioButton secButton = new JRadioButton(Bundle.getMessage("LabelSeconds"));
    private final JComboBox<String> whatBox = new JComboBox();
    private final JSpinner whatPercentSpinner = new JSpinner();
    private final JSpinner whatMinuteSpinner1 = new JSpinner(new SpinnerNumberModel(1, 1, 65500, 1));
    private final JSpinner whatMinuteSpinner2 = new JSpinner(new SpinnerNumberModel(100, 100, 65500, 1));
    private final JSpinner locoFunctionSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 28, 1));
    private final JTextField whatStringField = new JTextField(12);
    private final JTextField locoAddress = new JTextField(12);
    private final RosterEntryComboBox rosterComboBox = new RosterEntryComboBox();
    private final JComboBox<String> trainInfoComboBox = new JComboBox();
    private final JRadioButton locoAddressDefault = new JRadioButton(rbx.getString("TrainInfoUseDefault"));
    private final JRadioButton locoAddressRoster = new JRadioButton(rbx.getString("TrainInfoUseRoster"));
    private final JRadioButton locoAddressNumber = new JRadioButton(rbx.getString("TrainInfoUseAddress"));
    private final JRadioButton locoAddressCurrent = new JRadioButton(rbx.getString("TrainInfoUseCurrentAddress"));
    private final ButtonGroup locoAddressGroup = new ButtonGroup();
    private JButton updateActionButton = null;
    private JButton createActionButton = null;
    private JButton cancelAddEditActionButton = null;
    private final JComboBox<String> blockBox = new JComboBox();
    private List<Block> blockList = new ArrayList<Block>();
    private final JRadioButton onButton = new JRadioButton(Bundle.getMessage("StateOn"));
    private final JRadioButton offButton = new JRadioButton(Bundle.getMessage("StateOff"));
    private final JLabel doneSensorLabel = new JLabel(rbx.getString("DoneSensorLabel"));
    private JPanel signalPanel;
    private JPanel panelPercentageSpinner;
    private JPanel panelDelay;
    private final JLabel panelDelayLabel = new JLabel();
    private JPanel panelWhatBox;
    private JPanel panelLoadTrainInfo;
    private final NamedBeanComboBox<Sensor> doneSensorComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<SignalMast> signalMastComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalMastManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<SignalHead> signalHeadComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalHeadManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private int tWhen = 0;
    private int tWhenData = 0;
    private String tWhenString = "";
    private int tWhat = 0;
    private int tWhatData1 = 0;
    private int tWhatData2 = 0;
    private String tWhatString = "";
    private String tWhatString2 = "";
    private static final Logger log = LoggerFactory.getLogger(TransitTableAction.class);

    public TransitTableAction(String actionName) {
        super(actionName);
        this.transitManager = InstanceManager.getNullableDefault(TransitManager.class);
        if (this.sectionManager == null || this.transitManager == null) {
            super.setEnabled(false);
        }
        this.updateSensorList();
    }

    public TransitTableAction() {
        this(Bundle.getMessage("TitleTransitTable"));
    }

    @Override
    protected void createModel() {
        this.m = new BeanTableDataModel<Transit>(){
            public static final int EDITCOL = 5;
            public static final int DUPLICATECOL = 6;

            @Override
            public String getValue(String name) {
                if (name == null) {
                    log.warn("requested getValue(null)");
                    return "(no name)";
                }
                Transit z = (Transit)InstanceManager.getDefault(TransitManager.class).getBySystemName(name);
                if (z == null) {
                    log.debug("requested getValue(\"{}\"), Transit doesn't exist", (Object)name);
                    return "(no Transit)";
                }
                return "Transit";
            }

            public TransitManager getManager() {
                return InstanceManager.getDefault(TransitManager.class);
            }

            @Override
            public Transit getBySystemName(@Nonnull String name) {
                return (Transit)InstanceManager.getDefault(TransitManager.class).getBySystemName(name);
            }

            @Override
            public Transit getByUserName(@Nonnull String name) {
                return (Transit)InstanceManager.getDefault(TransitManager.class).getByUserName(name);
            }

            @Override
            protected String getMasterClassName() {
                return TransitTableAction.this.getClassName();
            }

            @Override
            public void clickOn(Transit t) {
            }

            @Override
            public int getColumnCount() {
                return 7;
            }

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 2: {
                        if (row >= this.sysNameList.size()) {
                            log.debug("row is greater than name list");
                            return "";
                        }
                        Transit z = this.getBySystemName((String)this.sysNameList.get(row));
                        if (z == null) {
                            return "";
                        }
                        int state = z.getState();
                        if (state == 2) {
                            return rbx.getString("TransitIdle");
                        }
                        if (state != 4) break;
                        return rbx.getString("TransitAssigned");
                    }
                    case 5: {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    case 6: {
                        return rbx.getString("ButtonDuplicate");
                    }
                    default: {
                        return super.getValueAt(row, col);
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                switch (col) {
                    case 5: {
                        SwingUtilities.invokeLater(() -> TransitTableAction.this.editPressed(((Transit)this.getValueAt(row, 0)).getSystemName()));
                        break;
                    }
                    case 6: {
                        SwingUtilities.invokeLater(() -> TransitTableAction.this.duplicatePressed(((Transit)this.getValueAt(row, 0)).getSystemName()));
                        break;
                    }
                    default: {
                        super.setValueAt(value, row, col);
                    }
                }
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 5: 
                    case 6: {
                        return "";
                    }
                }
                return super.getColumnName(col);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 2: {
                        return String.class;
                    }
                    case 5: 
                    case 6: {
                        return JButton.class;
                    }
                }
                return super.getColumnClass(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 2: {
                        return false;
                    }
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
                return super.isCellEditable(row, col);
            }

            @Override
            public int getPreferredWidth(int col) {
                switch (col) {
                    case 0: {
                        return new JTextField((int)9).getPreferredSize().width;
                    }
                    case 1: {
                        return new JTextField((int)17).getPreferredSize().width;
                    }
                    case 2: 
                    case 5: {
                        return new JTextField((int)6).getPreferredSize().width;
                    }
                    case 6: {
                        return new JTextField((int)10).getPreferredSize().width;
                    }
                }
                return super.getPreferredWidth(col);
            }

            @Override
            public void configValueColumn(JTable table) {
            }

            @Override
            protected boolean matchPropertyName(PropertyChangeEvent e) {
                return true;
            }

            @Override
            public JButton configureButton() {
                log.error("configureButton should not have been called");
                return null;
            }

            @Override
            public void configureTable(JTable table) {
                InstanceManager.getDefault(SensorManager.class).addPropertyChangeListener(this);
                super.configureTable(table);
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getSource() instanceof SensorManager && (e.getPropertyName().equals("DisplayListName") || e.getPropertyName().equals("length"))) {
                    TransitTableAction.this.updateSensorList();
                }
                super.propertyChange(e);
            }

            @Override
            public void dispose() {
                InstanceManager.getDefault(SensorManager.class).removePropertyChangeListener(this);
                super.dispose();
            }
        };
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleTransitTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.TransitTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.editMode = false;
        this.duplicateMode = false;
        if (this.sectionManager.getNamedBeanSet().size() > 0) {
            this.addEditPressed();
        } else {
            JmriJOptionPane.showMessageDialog(null, rbx.getString("Message21"), Bundle.getMessage("ErrorTitle"), 0);
        }
    }

    void editPressed(String sName) {
        this.curTransit = (Transit)this.transitManager.getBySystemName(sName);
        if (this.curTransit == null) {
            return;
        }
        this.sysNameFixed.setText(sName);
        this.editMode = true;
        this.duplicateMode = false;
        this.addEditPressed();
    }

    void duplicatePressed(String sName) {
        this.curTransit = (Transit)this.transitManager.getBySystemName(sName);
        if (this.curTransit == null) {
            return;
        }
        this.duplicateMode = true;
        this.editMode = false;
        this.addEditPressed();
    }

    void addEditPressed() {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddTransit"));
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.TransitAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.sysNameLabel);
            this.sysNameLabel.setLabelFor(this.sysName);
            p.add(this.sysNameFixed);
            p.add(this.sysName);
            p.add(this._autoSystemName);
            this._autoSystemName.addActionListener(e -> this.autoSystemName());
            if (this.pref.getSimplePreferenceState(this.systemNameAuto)) {
                this._autoSystemName.setSelected(true);
            }
            this.sysName.setToolTipText(rbx.getString("TransitSystemNameHint"));
            this.addFrame.getContentPane().add(p);
            p = new JPanel();
            p.add(this.userNameLabel);
            this.userNameLabel.setLabelFor(this.userName);
            p.add(this.userName);
            this.userName.setToolTipText(rbx.getString("TransitUserNameHint"));
            this.addFrame.getContentPane().add(p);
            this.addFrame.getContentPane().add(new JSeparator());
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 1));
            JPanel p11 = new JPanel();
            p11.setLayout(new FlowLayout());
            p11.add(new JLabel(rbx.getString("SectionTableMessage")));
            p1.add(p11);
            JPanel p12 = new JPanel();
            p12.setLayout(new BorderLayout());
            this.sectionTableModel = new SectionTableModel();
            JTable sectionTable = new JTable(this.sectionTableModel);
            sectionTable.setDefaultRenderer(JComboBox.class, new ValueRenderer());
            sectionTable.setDefaultEditor(JComboBox.class, new ValueEditor());
            sectionTable.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
            sectionTable.setRowSelectionAllowed(false);
            TableColumnModel sectionColumnModel = sectionTable.getColumnModel();
            TableColumn sequenceColumn = sectionColumnModel.getColumn(0);
            sequenceColumn.setResizable(true);
            sequenceColumn.setMinWidth(50);
            sequenceColumn.setMaxWidth(70);
            TableColumn sectionColumn = sectionColumnModel.getColumn(1);
            sectionColumn.setResizable(true);
            sectionColumn.setMinWidth(150);
            TableColumn actionColumn = sectionColumnModel.getColumn(2);
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            sectionTable.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            sectionTable.setDefaultEditor(JButton.class, buttonEditor);
            JButton testButton = new JButton(rbx.getString("AddEditActions"));
            sectionTable.setRowHeight(testButton.getPreferredSize().height);
            actionColumn.setResizable(false);
            actionColumn.setMinWidth(testButton.getPreferredSize().width);
            TableColumn directionColumn = sectionColumnModel.getColumn(3);
            directionColumn.setResizable(true);
            String s = rbx.getString("DirectionColName");
            directionColumn.setMinWidth((int)new JLabel(s.substring(1, Math.min(s.length(), 7))).getPreferredSize().getWidth());
            directionColumn.setMaxWidth((int)new JLabel(rbx.getString("DirectionColName").concat("WW")).getPreferredSize().getWidth());
            TableColumn alternateColumn = sectionColumnModel.getColumn(4);
            alternateColumn.setResizable(true);
            s = rbx.getString("AlternateColName");
            alternateColumn.setMinWidth((int)new JLabel(s.substring(1, Math.min(s.length(), 7))).getPreferredSize().getWidth());
            alternateColumn.setMaxWidth((int)new JLabel(rbx.getString("AlternateColName").concat("WW")).getPreferredSize().getWidth());
            JScrollPane sectionTableScrollPane = new JScrollPane(sectionTable);
            p12.add((Component)sectionTableScrollPane, "Center");
            p1.add(p12);
            JPanel p13 = new JPanel();
            p13.add(this.primarySectionBox);
            this.primarySectionBox.setToolTipText(rbx.getString("PrimarySectionBoxHint"));
            this.addNextSection = new JButton(rbx.getString("AddPrimaryButton"));
            p13.add(this.addNextSection);
            this.addAsSafe = new JCheckBox(Bundle.getMessage("TransitSectionIsSafe"));
            p13.add(this.addAsSafe);
            this.addAsSafe.setToolTipText(Bundle.getMessage("TransitSectionIsSafeHint"));
            JPanel p13A = new JPanel();
            p13A.add(new JLabel(Bundle.getMessage("PauseAllocationOnSensorActive")));
            this.stopAllocatingSensorBox = new JComboBox<String>(this.sensorList);
            p13A.add(this.stopAllocatingSensorBox);
            JComboBoxUtil.setupComboBoxMaxRows(this.stopAllocatingSensorBox);
            p13.add(p13A);
            this.stopAllocatingSensorBox.setToolTipText(Bundle.getMessage("PauseAllocationOnSensorActiveHint"));
            this.addNextSection.addActionListener(this::addNextSectionPressed);
            this.addNextSection.setToolTipText(rbx.getString("AddPrimaryButtonHint"));
            p13.setLayout(new FlowLayout());
            p1.add(p13);
            JPanel p14 = new JPanel();
            p14.setLayout(new FlowLayout());
            p14.add(this.alternateSectionBox);
            this.alternateSectionBox.setToolTipText(rbx.getString("AlternateSectionBoxHint"));
            this.addAlternateSection = new JButton(rbx.getString("AddAlternateButton"));
            p14.add(this.addAlternateSection);
            this.addAlternateSection.addActionListener(this::addAlternateSectionPressed);
            this.addAlternateSection.setToolTipText(rbx.getString("AddAlternateButtonHint"));
            p14.add(new JLabel("        "));
            p14.add(this.insertAtBeginningBox);
            this.insertAtBeginningBox.setToolTipText(rbx.getString("InsertAtBeginningBoxHint"));
            this.insertAtBeginning = new JButton(rbx.getString("InsertAtBeginningButton"));
            p14.add(this.insertAtBeginning);
            this.insertAtBeginning.addActionListener(this::insertAtBeginningPressed);
            this.insertAtBeginning.setToolTipText(rbx.getString("InsertAtBeginningButtonHint"));
            p1.add(p14);
            p1.add(new JSeparator());
            JPanel p15 = new JPanel();
            p15.setLayout(new FlowLayout());
            this.deleteSections = new JButton(rbx.getString("DeleteSectionsButton"));
            p15.add(this.deleteSections);
            this.deleteSections.addActionListener(this::deleteAllSections);
            this.deleteSections.setToolTipText(rbx.getString("DeleteSectionsButtonHint"));
            p15.add(new JLabel("  "));
            this.removeLastSection = new JButton(rbx.getString("RemoveLastButton"));
            p15.add(this.removeLastSection);
            this.removeLastSection.addActionListener(this::removeLastSectionPressed);
            this.removeLastSection.setToolTipText(rbx.getString("RemoveLastButtonHint"));
            p15.add(new JLabel("  "));
            this.removeFirstSection = new JButton(rbx.getString("RemoveFirstButton"));
            p15.add(this.removeFirstSection);
            this.removeFirstSection.addActionListener(this::removeFirstSectionPressed);
            this.removeFirstSection.setToolTipText(rbx.getString("RemoveFirstButtonHint"));
            p1.add(p15);
            JPanel p16 = new JPanel();
            p16.setLayout(new FlowLayout());
            p16.add(this.seqNumLabel);
            p16.add(this.seqNum);
            this.seqNum.setToolTipText(rbx.getString("SeqNumHint"));
            p1.add(p16);
            JPanel p17 = new JPanel();
            p17.setLayout(new FlowLayout());
            this.replacePrimaryForSequence = new JButton(rbx.getString("ReplacePrimaryForSeqButton"));
            p17.add(this.replacePrimaryForSequence);
            this.replacePrimaryForSequence.addActionListener(this::replacePrimaryForSeqPressed);
            this.replacePrimaryForSequence.setToolTipText(rbx.getString("ReplacePrimaryForSeqButtonHint"));
            p17.add(new JLabel("  "));
            this.deleteAlternateForSequence = new JButton(rbx.getString("DeleteAlternateForSeqButton"));
            p17.add(this.deleteAlternateForSequence);
            this.deleteAlternateForSequence.addActionListener(this::deleteAlternateForSeqPressed);
            this.deleteAlternateForSequence.setToolTipText(rbx.getString("DeleteAlternateForSeqButtonHint"));
            p17.add(new JLabel("  "));
            this.addAlternateForSequence = new JButton(rbx.getString("AddAlternateForSeqButton"));
            p17.add(this.addAlternateForSequence);
            this.addAlternateForSequence.addActionListener(this::addAlternateForSeqPressed);
            this.addAlternateForSequence.setToolTipText(rbx.getString("AddAlternateForSeqButtonHint"));
            p1.add(p17);
            this.addFrame.getContentPane().add(p1);
            this.addFrame.getContentPane().add(new JSeparator());
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            JPanel pb = new JPanel();
            pb.setLayout(new FlowLayout());
            pb.add(cancel);
            cancel.addActionListener(this::cancelPressed);
            cancel.setToolTipText(rbx.getString("CancelButtonHint"));
            this.create = new JButton(Bundle.getMessage("ButtonCreate"));
            pb.add(this.create);
            this.create.addActionListener(this::createPressed);
            this.create.setToolTipText(rbx.getString("SectionCreateButtonHint"));
            this.update = new JButton(Bundle.getMessage("ButtonUpdate"));
            pb.add(this.update);
            this.update.addActionListener(this::updatePressed);
            this.update.setToolTipText(rbx.getString("SectionUpdateButtonHint"));
            this.addFrame.getContentPane().add(pb);
        }
        if (this.editMode) {
            this.addFrame.setTitle(Bundle.getMessage("TitleEditTransit"));
            this._autoSystemName.setVisible(false);
            this.sysNameLabel.setEnabled(true);
            this.create.setVisible(false);
            this.update.setVisible(true);
            this.sysName.setVisible(false);
            this.sysNameFixed.setVisible(true);
            this.addFrame.getRootPane().setDefaultButton(this.update);
            this.initializeEditInformation();
        } else {
            this.addFrame.setTitle(Bundle.getMessage("TitleAddTransit"));
            this._autoSystemName.setVisible(true);
            this._autoSystemName.setEnabled(true);
            this.autoSystemName();
            this.create.setVisible(true);
            this.create.setEnabled(true);
            this.update.setVisible(false);
            this.sysName.setVisible(true);
            this.sysNameFixed.setVisible(false);
            this.addFrame.getRootPane().setDefaultButton(this.create);
            if (this.duplicateMode) {
                this.initializeEditInformation();
                this.sysName.setText(this.curTransit.getSystemName());
                this.curTransit = null;
            } else {
                this.deleteAllSections(null);
            }
        }
        this.initializeSectionCombos();
        this.updateSeqNum();
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    private void initializeEditInformation() {
        this.sectionList.clear();
        this.sequence.clear();
        this.action.clear();
        this.direction.clear();
        this.alternate.clear();
        this.safe.clear();
        this.sensorStopAllocation.clear();
        this.curSection = null;
        this.curSectionDirection = 0;
        this.curSequenceNum = 0;
        this.prevSection = null;
        this.prevSectionDirection = 0;
        if (this.curTransit != null) {
            this.userName.setText(this.curTransit.getUserName());
            ArrayList<TransitSection> tsList = this.curTransit.getTransitSectionList();
            for (int i = 0; i < tsList.size(); ++i) {
                TransitSection ts = (TransitSection)tsList.get(i);
                if (ts == null) continue;
                this.sectionList.add(ts.getSection());
                this.sequence.add(ts.getSequenceNumber());
                this.direction.add(ts.getDirection());
                this.action.add(ts.getTransitSectionActionList());
                this.alternate.add(ts.isAlternate());
                this.safe.add(ts.isSafe());
                this.sensorStopAllocation.add(ts.getStopAllocatingSensor());
            }
            int index = this.sectionList.size() - 1;
            if (index >= this.alternate.size()) {
                index = this.alternate.size() - 1;
            }
            while (this.alternate.get(index).booleanValue() && index > 0) {
                --index;
            }
            if (index >= 0) {
                this.curSection = this.sectionList.get(index);
                this.curSequenceNum = this.sequence.get(index);
                if (index > 0) {
                    this.curSectionDirection = this.direction.get(index);
                }
                --index;
                while (index >= 0 && this.alternate.get(index).booleanValue()) {
                    --index;
                }
                if (index >= 0) {
                    this.prevSection = this.sectionList.get(index);
                    this.prevSectionDirection = this.direction.get(index);
                }
            }
        }
        this.sectionTableModel.fireTableDataChanged();
    }

    private void deleteAllSections(ActionEvent e) {
        this.sectionList.clear();
        this.direction.clear();
        this.sequence.clear();
        this.action.clear();
        this.alternate.clear();
        this.safe.clear();
        this.sensorStopAllocation.clear();
        this.curSection = null;
        this.curSectionDirection = 0;
        this.prevSection = null;
        this.prevSectionDirection = 0;
        this.curSequenceNum = 0;
        this.initializeSectionCombos();
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void addNextSectionPressed(ActionEvent e) {
        if (this.primarySectionBoxList.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message25"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int index = this.primarySectionBox.getSelectedIndex();
        Section s = this.primarySectionBoxList.get(index);
        if (s != null) {
            int j = this.sectionList.size();
            this.sectionList.add(s);
            this.direction.add(this.priSectionDirection.get(index));
            ++this.curSequenceNum;
            this.sequence.add(this.curSequenceNum);
            this.safe.add(this.addAsSafe.isSelected());
            if (this.stopAllocatingSensorBox.getSelectedIndex() >= 0) {
                this.sensorStopAllocation.add((String)this.stopAllocatingSensorBox.getSelectedItem());
            } else {
                this.sensorStopAllocation.add("");
            }
            this.action.add(new ArrayList());
            this.alternate.add(false);
            if (this.sectionList.size() == 2 && this.curSection != null) {
                if (this.forwardConnected(this.curSection, s, 0)) {
                    this.direction.set(0, 8);
                }
                this.curSectionDirection = this.direction.get(0);
            }
            this.prevSection = this.curSection;
            this.prevSectionDirection = this.curSectionDirection;
            this.curSection = s;
            if (this.prevSection != null) {
                this.curSectionDirection = this.direction.get(j);
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void removeLastSectionPressed(ActionEvent e) {
        if (this.sectionList.size() <= 1) {
            this.deleteAllSections(e);
        } else {
            int j = this.sectionList.size() - 1;
            if (!this.alternate.get(j).booleanValue()) {
                int k;
                --this.curSequenceNum;
                this.curSection = this.sectionList.get(j - 1);
                this.curSectionDirection = this.direction.get(j - 1);
                for (k = j - 2; k >= 0 && this.alternate.get(k).booleanValue(); --k) {
                }
                if (k < 0) {
                    this.prevSection = null;
                } else {
                    this.prevSection = this.sectionList.get(k);
                    this.prevSectionDirection = this.direction.get(k);
                }
            }
            this.removeSupportingArrayEntries(j);
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void insertAtBeginningPressed(ActionEvent e) {
        if (this.insertAtBeginningBoxList.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message35"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int index = this.insertAtBeginningBox.getSelectedIndex();
        Section s = this.insertAtBeginningBoxList.get(index);
        if (s != null) {
            this.sectionList.add(0, s);
            this.direction.add(0, this.insertAtBeginningDirection.get(index));
            ++this.curSequenceNum;
            this.sequence.add(0, 1);
            this.alternate.add(0, false);
            this.safe.add(0, this.addAsSafe.isSelected());
            this.sensorStopAllocation.add(0, "");
            this.action.add(0, new ArrayList());
            if (this.curSequenceNum == 2) {
                this.prevSectionDirection = this.direction.get(0);
                this.prevSection = s;
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void removeFirstSectionPressed(ActionEvent e) {
        if (this.curSequenceNum <= 1) {
            this.deleteAllSections(e);
        } else {
            int keep = 1;
            while (this.alternate.get(keep).booleanValue()) {
                ++keep;
            }
            for (int c = 0; c < keep; ++c) {
                this.removeSupportingArrayEntries(0);
                --this.curSequenceNum;
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void replacePrimaryForSeqPressed(ActionEvent e) {
        int seq = this.getSeqNum();
        if (seq == 0) {
            return;
        }
        Section sOld = null;
        ArrayList<Section> altOldList = new ArrayList<Section>();
        Section beforeSection = null;
        int beforeSectionDirection = 0;
        Section afterSection = null;
        int afterSectionDirection = 0;
        int index = -1;
        for (int i = 0; i < this.sectionList.size(); ++i) {
            if (this.sequence.get(i) == seq && !this.alternate.get(i).booleanValue()) {
                sOld = this.sectionList.get(i);
                index = i;
            }
            if (this.sequence.get(i) == seq && this.alternate.get(i).booleanValue()) {
                altOldList.add(this.sectionList.get(i));
            }
            if (this.sequence.get(i) == seq - 1 && !this.alternate.get(i).booleanValue()) {
                beforeSection = this.sectionList.get(i);
                beforeSectionDirection = this.direction.get(i);
            }
            if (this.sequence.get(i) != seq + 1 || this.alternate.get(i).booleanValue()) continue;
            afterSection = this.sectionList.get(i);
            afterSectionDirection = 4;
            if (afterSectionDirection != this.direction.get(i)) continue;
            afterSectionDirection = 8;
        }
        if (sOld == null) {
            log.error("Missing primary Section for seq = {}", (Object)seq);
            return;
        }
        ArrayList<Section> possibles = new ArrayList<Section>();
        ArrayList<Integer> possiblesDirection = new ArrayList<Integer>();
        ArrayList<String> possibleNames = new ArrayList<String>();
        for (Section s : this.sectionManager.getNamedBeanSet()) {
            Section mayBeSection = null;
            String mayBeName = s.getDisplayName();
            int mayBeDirection = 0;
            if (s == sOld || s == beforeSection || s == afterSection || this.inSectionList(s, altOldList)) continue;
            if (beforeSection != null) {
                if (this.forwardConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                } else if (this.reverseConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                }
                if (mayBeSection != null && afterSection != null) {
                    if (mayBeDirection == 8) {
                        if (!this.forwardConnected(s, afterSection, afterSectionDirection)) {
                            mayBeSection = null;
                        }
                    } else if (!this.reverseConnected(s, afterSection, afterSectionDirection)) {
                        mayBeSection = null;
                    }
                }
            } else if (afterSection != null) {
                if (this.forwardConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                } else if (this.reverseConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                }
            } else {
                mayBeSection = s;
                mayBeDirection = 4;
            }
            if (mayBeSection == null) continue;
            possibles.add(mayBeSection);
            possiblesDirection.add(mayBeDirection);
            possibleNames.add(mayBeName);
        }
        if (possibles.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this.addFrame, MessageFormat.format(rbx.getString("Message36"), "" + seq), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int k = 0;
        if (possibles.size() > 1) {
            Object[] choices = new Object[possibles.size()];
            for (int j = 0; j < possibles.size(); ++j) {
                choices[j] = possibleNames.get(j);
            }
            Object selName = JmriJOptionPane.showInputDialog(this.addFrame, rbx.getString("ReplacePrimaryChoice"), rbx.getString("ReplacePrimaryTitle"), 3, null, choices, choices[0]);
            if (selName == null) {
                return;
            }
            for (int j = 0; j < possibles.size(); ++j) {
                if (!selName.equals(choices[j])) continue;
                k = j;
            }
        }
        this.sectionList.remove(index);
        this.sectionList.add(index, (Section)possibles.get(k));
        this.direction.set(index, (Integer)possiblesDirection.get(k));
        if (index == this.sectionList.size() - 1) {
            this.curSection = this.sectionList.get(index);
            this.curSectionDirection = this.direction.get(index);
        } else if (index == this.sectionList.size() - 2) {
            this.prevSection = this.sectionList.get(index);
            this.prevSectionDirection = this.direction.get(index);
        }
        this.initializeSectionCombos();
        this.sectionTableModel.fireTableDataChanged();
    }

    boolean inSectionList(Section s, List<Section> sList) {
        for (int i = 0; i < sList.size(); ++i) {
            if (sList.get(i) != s) continue;
            return true;
        }
        return false;
    }

    private int getSeqNum() {
        int n = (Integer)this.seqNum.getValue();
        if (n > this.curSequenceNum) {
            JmriJOptionPane.showMessageDialog(null, rbx.getString("Message34"), Bundle.getMessage("ErrorTitle"), 0);
            return 0;
        }
        return n;
    }

    void updateSeqNum() {
        int seqMax = 0;
        int seqNumber = 0;
        for (int ix = 0; ix < this.alternate.size(); ++ix) {
            if (!this.alternate.get(ix).booleanValue()) {
                ++seqNumber;
            }
            this.sequence.set(ix, seqNumber);
        }
        seqMax = seqNumber;
        this.seqNum.setModel(new SpinnerNumberModel(seqMax, Math.min(seqMax, 1), seqMax, 1));
        this.seqNum.setValue(Math.min(seqMax, 1));
    }

    void deleteAlternateForSeqPressed(ActionEvent e) {
        if (this.sectionList.size() <= 1) {
            this.deleteAllSections(e);
        } else {
            int seq = this.getSeqNum();
            if (seq == 0) {
                return;
            }
            for (int i = this.sectionList.size() - 1; i >= seq; --i) {
                if (this.sequence.get(i) != seq || !this.alternate.get(i).booleanValue()) continue;
                this.removeSupportingArrayEntries(i);
            }
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void addAlternateForSeqPressed(ActionEvent e) {
        int seq = this.getSeqNum();
        if (seq == 0) {
            return;
        }
        Section primarySection = null;
        ArrayList<Section> altOldList = new ArrayList<Section>();
        Section beforeSection = null;
        int beforeSectionDirection = 0;
        Section afterSection = null;
        int afterSectionDirection = 0;
        int index = -1;
        for (int i = 0; i < this.sectionList.size(); ++i) {
            if (this.sequence.get(i) == seq && !this.alternate.get(i).booleanValue()) {
                primarySection = this.sectionList.get(i);
                index = i;
            }
            if (this.sequence.get(i) == seq && this.alternate.get(i).booleanValue()) {
                altOldList.add(this.sectionList.get(i));
            }
            if (this.sequence.get(i) == seq - 1 && !this.alternate.get(i).booleanValue()) {
                beforeSection = this.sectionList.get(i);
                beforeSectionDirection = this.direction.get(i);
            }
            if (this.sequence.get(i) != seq + 1 || this.alternate.get(i).booleanValue()) continue;
            afterSection = this.sectionList.get(i);
            afterSectionDirection = 4;
            if (afterSectionDirection != this.direction.get(i)) continue;
            afterSectionDirection = 8;
        }
        if (primarySection == null) {
            log.error("Missing primary Section for seq = {}", (Object)seq);
            return;
        }
        ArrayList<Section> possibles = new ArrayList<Section>();
        ArrayList<Integer> possiblesDirection = new ArrayList<Integer>();
        ArrayList<String> possibleNames = new ArrayList<String>();
        for (Section s : this.sectionManager.getNamedBeanSet()) {
            Section mayBeSection = null;
            String mayBeName = s.getDisplayName();
            int mayBeDirection = 0;
            if (s == primarySection || s == beforeSection || s == afterSection || this.inSectionList(s, altOldList)) continue;
            if (beforeSection != null) {
                if (this.forwardConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                } else if (this.reverseConnected(s, beforeSection, beforeSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                }
                if (mayBeSection != null && afterSection != null) {
                    if (mayBeDirection == 8) {
                        if (!this.forwardConnected(s, afterSection, afterSectionDirection)) {
                            mayBeSection = null;
                        }
                    } else if (!this.reverseConnected(s, afterSection, afterSectionDirection)) {
                        mayBeSection = null;
                    }
                }
            } else if (afterSection != null) {
                if (this.forwardConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 8;
                } else if (this.reverseConnected(s, afterSection, afterSectionDirection)) {
                    mayBeSection = s;
                    mayBeDirection = 4;
                }
            } else {
                mayBeSection = s;
                mayBeDirection = 4;
            }
            if (mayBeSection == null) continue;
            possibles.add(mayBeSection);
            possiblesDirection.add(mayBeDirection);
            possibleNames.add(mayBeName);
        }
        if (possibles.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this.addFrame, MessageFormat.format(rbx.getString("Message37"), "" + seq), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int k = 0;
        if (possibles.size() > 1) {
            Object[] choices = new Object[possibles.size()];
            for (int j = 0; j < possibles.size(); ++j) {
                choices[j] = possibleNames.get(j);
            }
            Object selName = JmriJOptionPane.showInputDialog(this.addFrame, rbx.getString("AddAlternateChoice"), rbx.getString("AddAlternateTitle"), 3, null, choices, choices[0]);
            if (selName == null) {
                return;
            }
            for (int j = 0; j < possibles.size(); ++j) {
                if (!selName.equals(choices[j])) continue;
                k = j;
            }
        }
        index = index + 1 + altOldList.size();
        this.sectionList.add(index, (Section)possibles.get(k));
        this.direction.add(index, (Integer)possiblesDirection.get(k));
        this.sequence.add(index, this.sequence.get(index - 1));
        this.alternate.add(index, true);
        this.safe.add(index, this.addAsSafe.isSelected());
        if (this.stopAllocatingSensorBox.getSelectedIndex() < 0) {
            this.sensorStopAllocation.add(index, "");
        } else {
            this.sensorStopAllocation.add(index, (String)this.stopAllocatingSensorBox.getSelectedItem());
        }
        this.action.add(index, new ArrayList());
        this.initializeSectionCombos();
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void addAlternateSectionPressed(ActionEvent e) {
        if (this.alternateSectionBoxList.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message24"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        int index = this.alternateSectionBox.getSelectedIndex();
        Section s = this.alternateSectionBoxList.get(index);
        if (s != null) {
            this.sectionList.add(s);
            this.direction.add(this.altSectionDirection.get(index));
            this.sequence.add(this.curSequenceNum);
            this.action.add(new ArrayList());
            this.alternate.add(true);
            this.safe.add(this.addAsSafe.isSelected());
            this.sensorStopAllocation.add((String)this.stopAllocatingSensorBox.getSelectedItem());
            this.initializeSectionCombos();
        }
        this.updateSeqNum();
        this.sectionTableModel.fireTableDataChanged();
    }

    void createPressed(ActionEvent e) {
        if (!this.checkTransitInformation()) {
            return;
        }
        String uName = this.userName.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        try {
            if (this._autoSystemName.isSelected()) {
                this.curTransit = this.transitManager.createNewTransit(uName);
            } else {
                String sName = this.sysName.getText();
                this.curTransit = this.transitManager.createNewTransit(sName, uName);
            }
        }
        catch (IllegalArgumentException ex) {
            JmriJOptionPane.showMessageDialog(this.addFrame, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.sysName.setText(this.curTransit.getSystemName());
        this.setTransitInformation();
        this.addFrame.setVisible(false);
        this.pref.setSimplePreferenceState(this.systemNameAuto, this._autoSystemName.isSelected());
    }

    void cancelPressed(ActionEvent e) {
        this.addFrame.setVisible(false);
        this.sectionTableModel.dispose();
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void updatePressed(ActionEvent e) {
        Transit tTransit;
        if (!this.checkTransitInformation()) {
            return;
        }
        String uName = this.userName.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        if (uName != null && !uName.equals(this.curTransit.getUserName()) && (tTransit = (Transit)this.transitManager.getByUserName(uName)) != null) {
            JmriJOptionPane.showMessageDialog(this.addFrame, rbx.getString("Message22"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.curTransit.setUserName(uName);
        if (this.setTransitInformation()) {
            this.addFrame.setVisible(false);
            this.sectionTableModel.dispose();
            this.addFrame.dispose();
            this.addFrame = null;
        }
    }

    private void removeSupportingArrayEntries(int index) {
        this.sectionList.remove(index);
        this.sequence.remove(index);
        this.direction.remove(index);
        this.action.remove(index);
        this.alternate.remove(index);
        this.safe.remove(index);
        this.sensorStopAllocation.remove(index);
    }

    private boolean checkTransitInformation() {
        return true;
    }

    private boolean setTransitInformation() {
        if (this.curTransit == null) {
            return false;
        }
        this.curTransit.removeAllSections();
        for (int i = 0; i < this.sectionList.size(); ++i) {
            TransitSection ts = new TransitSection(this.sectionList.get(i), (int)this.sequence.get(i), (int)this.direction.get(i), (boolean)this.alternate.get(i), (boolean)this.safe.get(i), this.sensorStopAllocation.get(i));
            List<TransitSectionAction> list = this.action.get(i);
            if (list != null) {
                for (int j = 0; j < list.size(); ++j) {
                    ts.addAction(list.get(j));
                }
            }
            this.curTransit.addTransitSection(ts);
        }
        return true;
    }

    private void initializeSectionCombos() {
        this.primarySectionBox.removeAllItems();
        this.alternateSectionBox.removeAllItems();
        this.insertAtBeginningBox.removeAllItems();
        this.primarySectionBoxList.clear();
        this.alternateSectionBoxList.clear();
        this.insertAtBeginningBoxList.clear();
        this.priSectionDirection.clear();
        this.altSectionDirection.clear();
        this.insertAtBeginningDirection.clear();
        if (this.sectionList.isEmpty()) {
            for (Section s : this.sectionManager.getNamedBeanSet()) {
                String sName = s.getDisplayName();
                this.primarySectionBox.addItem(sName);
                this.primarySectionBoxList.add(s);
                this.priSectionDirection.add(4);
            }
        } else {
            String sName;
            for (Section s : this.sectionManager.getNamedBeanSet()) {
                sName = s.getDisplayName();
                if (s != this.prevSection && this.forwardConnected(s, this.curSection, this.curSectionDirection)) {
                    this.primarySectionBox.addItem(sName);
                    this.primarySectionBoxList.add(s);
                    this.priSectionDirection.add(4);
                    continue;
                }
                if (s == this.prevSection || !this.reverseConnected(s, this.curSection, this.curSectionDirection)) continue;
                this.primarySectionBox.addItem(sName);
                this.primarySectionBoxList.add(s);
                this.priSectionDirection.add(8);
            }
            if (this.prevSection != null) {
                for (Section s : this.sectionManager.getNamedBeanSet()) {
                    sName = s.getDisplayName();
                    if (this.notIncludedWithSeq(s, this.curSequenceNum) && this.forwardConnected(s, this.prevSection, this.prevSectionDirection)) {
                        this.alternateSectionBox.addItem(sName);
                        this.alternateSectionBoxList.add(s);
                        this.altSectionDirection.add(4);
                        continue;
                    }
                    if (!this.notIncludedWithSeq(s, this.curSequenceNum) || !this.reverseConnected(s, this.prevSection, this.prevSectionDirection)) continue;
                    this.alternateSectionBox.addItem(sName);
                    this.alternateSectionBoxList.add(s);
                    this.altSectionDirection.add(8);
                }
            }
            Section firstSection = this.sectionList.get(0);
            int testDirection = 4;
            if (this.direction.get(0) == 4) {
                testDirection = 8;
            }
            for (Section s : this.sectionManager.getNamedBeanSet()) {
                String sName2 = s.getDisplayName();
                if (s != firstSection && this.forwardConnected(s, firstSection, testDirection)) {
                    this.insertAtBeginningBox.addItem(sName2);
                    this.insertAtBeginningBoxList.add(s);
                    this.insertAtBeginningDirection.add(8);
                    continue;
                }
                if (s == firstSection || !this.reverseConnected(s, firstSection, testDirection)) continue;
                this.insertAtBeginningBox.addItem(sName2);
                this.insertAtBeginningBoxList.add(s);
                this.insertAtBeginningDirection.add(4);
            }
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.primarySectionBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.alternateSectionBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.insertAtBeginningBox);
    }

    private boolean forwardConnected(Section s1, Section s2, int restrictedDirection) {
        if (s1 != null && s2 != null) {
            List<EntryPoint> s2Entries;
            List<EntryPoint> s1ForwardEntries = s1.getForwardEntryPointList();
            switch (restrictedDirection) {
                case 4: {
                    s2Entries = s2.getReverseEntryPointList();
                    break;
                }
                case 8: {
                    s2Entries = s2.getForwardEntryPointList();
                    break;
                }
                default: {
                    s2Entries = s2.getEntryPointList();
                }
            }
            for (int i = 0; i < s1ForwardEntries.size(); ++i) {
                Block b1 = s1ForwardEntries.get(i).getFromBlock();
                for (int j = 0; j < s2Entries.size(); ++j) {
                    Block b2 = s2Entries.get(j).getFromBlock();
                    if (b1 != s2Entries.get(j).getBlock() || b2 != s1ForwardEntries.get(i).getBlock()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean reverseConnected(Section s1, Section s2, int restrictedDirection) {
        if (s1 != null && s2 != null) {
            List<EntryPoint> s2Entries;
            List<EntryPoint> s1ReverseEntries = s1.getReverseEntryPointList();
            switch (restrictedDirection) {
                case 4: {
                    s2Entries = s2.getReverseEntryPointList();
                    break;
                }
                case 8: {
                    s2Entries = s2.getForwardEntryPointList();
                    break;
                }
                default: {
                    s2Entries = s2.getEntryPointList();
                }
            }
            for (int i = 0; i < s1ReverseEntries.size(); ++i) {
                Block b1 = s1ReverseEntries.get(i).getFromBlock();
                for (int j = 0; j < s2Entries.size(); ++j) {
                    Block b2 = s2Entries.get(j).getFromBlock();
                    if (b1 != s2Entries.get(j).getBlock() || b2 != s1ReverseEntries.get(i).getBlock()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean notIncludedWithSeq(Section s, int seq) {
        for (int i = 0; i < this.sectionList.size(); ++i) {
            if (this.sectionList.get(i) != s || seq != this.sequence.get(i)) continue;
            return false;
        }
        return true;
    }

    private void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this.sysName.setEnabled(false);
            this.sysNameLabel.setEnabled(false);
        } else {
            this.sysName.setEnabled(true);
            this.sysNameLabel.setEnabled(true);
        }
    }

    private void addEditActionsPressed(int r) {
        this.activeRow = r;
        if (this.actionTableModel != null) {
            this.actionTableModel.fireTableStructureChanged();
        }
        if (this.actionTableFrame == null) {
            this.actionTableFrame = new JmriJFrame(rbx.getString("TitleViewActions"));
            this.actionTableFrame.addHelpMenu("package.jmri.jmrit.beantable.ViewSpecialActions", true);
            Container contentPane = this.actionTableFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel sectionNameLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameSection")));
            panel1.add(sectionNameLabel);
            panel1.add(this.fixedSectionLabel);
            contentPane.add(panel1);
            this.addFrame.getContentPane().add(new JSeparator());
            JPanel pct = new JPanel();
            pct.setLayout(new BorderLayout());
            this.actionTableModel = new SpecialActionTableModel();
            JTable actionTable = new JTable(this.actionTableModel);
            actionTable.setRowSelectionAllowed(false);
            TableColumnModel actionColumnModel = actionTable.getColumnModel();
            TableColumn whenColumn = actionColumnModel.getColumn(0);
            whenColumn.setResizable(true);
            TableColumn whatColumn = actionColumnModel.getColumn(1);
            whatColumn.setResizable(true);
            TableColumn editColumn = actionColumnModel.getColumn(2);
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            actionTable.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            actionTable.setDefaultEditor(JButton.class, buttonEditor);
            JButton testButton = new JButton(Bundle.getMessage("ButtonDelete"));
            actionTable.setRowHeight(testButton.getPreferredSize().height);
            editColumn.setResizable(false);
            editColumn.setMinWidth(testButton.getPreferredSize().width);
            editColumn.setMaxWidth(testButton.getPreferredSize().width);
            TableColumn removeColumn = actionColumnModel.getColumn(3);
            removeColumn.setMinWidth(testButton.getPreferredSize().width);
            removeColumn.setMaxWidth(testButton.getPreferredSize().width);
            removeColumn.setResizable(false);
            JScrollPane actionTableScrollPane = new JScrollPane(actionTable);
            pct.add((Component)actionTableScrollPane, "Center");
            contentPane.add(pct);
            pct.setVisible(true);
            JPanel but = new JPanel();
            but.setLayout(new BoxLayout(but, 1));
            JPanel panel4 = new JPanel();
            panel4.setLayout(new FlowLayout());
            JButton newActionButton = new JButton(rbx.getString("ButtonAddNewAction"));
            panel4.add(newActionButton);
            newActionButton.addActionListener(this::newActionPressed);
            newActionButton.setToolTipText(rbx.getString("NewActionButtonHint"));
            JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
            panel4.add(doneButton);
            doneButton.addActionListener(this::doneWithActionsPressed);
            doneButton.setToolTipText(rbx.getString("DoneButtonHint"));
            but.add(panel4);
            contentPane.add(but);
        }
        this.fixedSectionLabel.setText(this.getSectionNameByRow(r) + "    " + rbx.getString("SequenceAbbrev") + ": " + this.sequence.get(r));
        this.actionTableFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TransitTableAction.this.actionTableFrame.setVisible(false);
                TransitTableAction.this.actionTableFrame.dispose();
                TransitTableAction.this.actionTableFrame = null;
                if (TransitTableAction.this.addEditActionFrame != null) {
                    TransitTableAction.this.addEditActionFrame.setVisible(false);
                    TransitTableAction.this.addEditActionFrame.dispose();
                    TransitTableAction.this.addEditActionFrame = null;
                }
            }
        });
        this.actionTableFrame.pack();
        this.actionTableFrame.setVisible(true);
    }

    private void doneWithActionsPressed(ActionEvent e) {
        this.actionTableFrame.setVisible(false);
        this.actionTableFrame.dispose();
        this.actionTableFrame = null;
        if (this.addEditActionFrame != null) {
            this.addEditActionFrame.setVisible(false);
            this.addEditActionFrame.dispose();
            this.addEditActionFrame = null;
        }
    }

    private void newActionPressed(ActionEvent e) {
        this.editActionMode = false;
        this.curTSA = null;
        this.addEditActionWindow();
    }

    private void addEditActionWindow() {
        if (this.addEditActionFrame == null) {
            this.addEditActionFrame = new JmriJFrame(rbx.getString("TitleAddAction"));
            this.addEditActionFrame.addHelpMenu("package.jmri.jmrit.beantable.TransitSectionAddEditAction", true);
            Container contentPane = this.addEditActionFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panelx = new JPanel();
            panelx.setLayout(new BoxLayout(panelx, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            panel1.add(new JLabel(rbx.getString("WhenText")));
            this.initializeWhenBox();
            JComboBoxUtil.setupComboBoxMaxRows(this.whenBox);
            panel1.add(this.whenBox);
            this.whenBox.addActionListener(e -> {
                log.debug("whenBox was set");
                if (this.whenBox.getSelectedItem() != null) {
                    this.setWhen(this.getWhenMenuCode((String)this.whenBox.getSelectedItem()));
                }
            });
            this.whenBox.setToolTipText(rbx.getString("WhenBoxTip"));
            JComboBoxUtil.setupComboBoxMaxRows(this.whenSensorComboBox);
            panel1.add(this.whenSensorComboBox);
            this.whenSensorComboBox.setAllowNull(true);
            this.initializeBlockBox();
            JComboBoxUtil.setupComboBoxMaxRows(this.blockBox);
            panel1.add(this.blockBox);
            panelx.add(panel1);
            this.panelDelay = new JPanel();
            this.panelDelay.setLayout(new FlowLayout());
            this.panelDelayLabel.setText("    " + rbx.getString("OptionalDelay") + ": ");
            this.panelDelay.add(this.panelDelayLabel);
            this.panelDelay.add(this.whenDataSpinnerInt);
            this.whenDataSpinnerInt.setToolTipText(rbx.getString("HintDelayData"));
            this.whenDataSpinnerInt.addChangeListener(e -> {
                if (this.mSecButton.isSelected()) {
                    float fl = ((Integer)this.whenDataSpinnerInt.getValue()).intValue();
                    this.whenDataSpinnerFloat.setValue(Float.valueOf(fl / 1000.0f));
                }
            });
            this.panelDelay.add(this.whenDataSpinnerFloat);
            this.whenDataSpinnerFloat.setToolTipText(rbx.getString("HintDelayData"));
            this.whenDataSpinnerFloat.setPreferredSize(this.whenDataSpinnerInt.getPreferredSize());
            this.whenDataSpinnerFloat.addChangeListener(e -> {
                if (this.secButton.isSelected()) {
                    float dVal = ((Float)this.whenDataSpinnerFloat.getValue()).floatValue();
                    dVal = (float)((double)dVal * 1000.0);
                    this.whenDataSpinnerInt.setValue(Math.round(dVal));
                }
            });
            ButtonGroup secMsec = new ButtonGroup();
            secMsec.add(this.mSecButton);
            secMsec.add(this.secButton);
            this.panelDelay.add(this.mSecButton);
            this.mSecButton.addChangeListener(e -> {
                if (this.mSecButton.isSelected()) {
                    this.whenDataSpinnerFloat.setVisible(false);
                    this.whenDataSpinnerInt.setVisible(true);
                }
            });
            this.panelDelay.add(this.secButton);
            this.secButton.addChangeListener(e -> {
                if (this.secButton.isSelected()) {
                    this.whenDataSpinnerFloat.setVisible(true);
                    this.whenDataSpinnerInt.setVisible(false);
                }
            });
            this.secButton.setSelected(true);
            panelx.add(this.panelDelay);
            JPanel spacer = new JPanel();
            spacer.setLayout(new FlowLayout());
            spacer.add(new JLabel("     "));
            panelx.add(spacer);
            this.panelWhatBox = new JPanel();
            this.panelWhatBox.setLayout(new FlowLayout());
            this.panelWhatBox.add(new JLabel(rbx.getString("WhatText")));
            this.initializeWhatBox(0);
            JComboBoxUtil.setupComboBoxMaxRows(this.whatBox);
            this.panelWhatBox.add(this.whatBox);
            this.whatBox.setToolTipText(rbx.getString("WhatBoxTip"));
            this.whatBox.addActionListener(e -> {
                if (this.whatBox.getSelectedItem() != null) {
                    this.setWhat(this.getWhatMenuCode((String)this.whatBox.getSelectedItem()));
                }
            });
            this.panelWhatBox.add(this.whatStringField);
            this.whatStringField.setToolTipText(rbx.getString("HintSoundHornPatternString"));
            panelx.add(this.panelWhatBox);
            TitledBorder trainInfoBorder = BorderFactory.createTitledBorder(rbx.getString("SelectTrain"));
            this.panelLoadTrainInfo = new JPanel();
            this.panelLoadTrainInfo.setLayout(new BoxLayout(this.panelLoadTrainInfo, 1));
            this.panelLoadTrainInfo.setBorder(trainInfoBorder);
            JPanel panelUseInfo = new JPanel();
            panelUseInfo.setBorder(trainInfoBorder);
            panelUseInfo.add(new JLabel(rbx.getString("TrainInfoFile")));
            panelUseInfo.add(this.trainInfoComboBox);
            this.trainInfoComboBox.setToolTipText(rbx.getString("HintTrainInfoFile"));
            this.panelLoadTrainInfo.add(panelUseInfo);
            TitledBorder useLocoBorder = BorderFactory.createTitledBorder(rbx.getString("SelectALoco"));
            JPanel panelUseLoco = new JPanel();
            panelUseLoco.setBorder(useLocoBorder);
            this.locoAddressGroup.add(this.locoAddressDefault);
            this.locoAddressDefault.setToolTipText(rbx.getString("TrainInfoUseDefaultHint"));
            this.locoAddressDefault.addActionListener(this::updateTrainInfoAddressFields);
            panelUseLoco.add(this.locoAddressDefault);
            this.locoAddressGroup.add(this.locoAddressCurrent);
            this.locoAddressCurrent.setToolTipText(rbx.getString("TrainInfoUseCurrentAddressHint"));
            this.locoAddressCurrent.addActionListener(this::updateTrainInfoAddressFields);
            panelUseLoco.add(this.locoAddressCurrent);
            this.locoAddressGroup.add(this.locoAddressRoster);
            this.locoAddressRoster.addActionListener(this::updateTrainInfoAddressFields);
            panelUseLoco.add(this.locoAddressRoster);
            this.locoAddressGroup.add(this.locoAddressNumber);
            this.locoAddressNumber.addActionListener(this::updateTrainInfoAddressFields);
            panelUseLoco.add(this.locoAddressNumber);
            panelUseLoco.add(this.locoAddress);
            this.locoAddress.setToolTipText(rbx.getString("HintLocoMotiveAddress"));
            panelUseLoco.add(this.rosterComboBox);
            this.panelLoadTrainInfo.add(panelUseLoco);
            panelx.add(this.panelLoadTrainInfo);
            this.panelLoadTrainInfo.setVisible(false);
            this.panelPercentageSpinner = new JPanel();
            this.panelPercentageSpinner.setLayout(new FlowLayout());
            this.whatPercentSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.5f), Float.valueOf(0.01f)));
            this.whatPercentSpinner.setEditor(new JSpinner.NumberEditor(this.whatPercentSpinner, "# %"));
            this.panelPercentageSpinner.add(this.whatPercentSpinner);
            this.panelPercentageSpinner.add(this.whatMinuteSpinner1);
            this.panelPercentageSpinner.add(this.whatMinuteSpinner2);
            this.panelPercentageSpinner.add(this.locoFunctionSpinner);
            TitledBorder border = BorderFactory.createTitledBorder(rbx.getString("SelectASignal"));
            this.signalPanel = new JPanel();
            this.signalPanel.setBorder(border);
            this.signalPanel.add(new JLabel(rbx.getString("MastLabel")));
            JComboBoxUtil.setupComboBoxMaxRows(this.signalMastComboBox);
            this.signalPanel.add(this.signalMastComboBox);
            this.signalMastComboBox.setAllowNull(true);
            this.signalMastComboBox.addActionListener(e -> {
                if (this.signalMastComboBox.getSelectedIndex() > 0) {
                    this.signalHeadComboBox.setSelectedIndex(-1);
                }
            });
            this.signalPanel.add(new JLabel(rbx.getString("HeadLabel")));
            JComboBoxUtil.setupComboBoxMaxRows(this.signalHeadComboBox);
            this.signalPanel.add(this.signalHeadComboBox);
            this.signalHeadComboBox.setAllowNull(true);
            this.signalHeadComboBox.addActionListener(e -> {
                if (this.signalHeadComboBox.getSelectedIndex() > 0) {
                    this.signalMastComboBox.setSelectedIndex(-1);
                }
            });
            this.signalMastComboBox.setToolTipText(rbx.getString("HintSignalEntry"));
            this.signalHeadComboBox.setToolTipText(rbx.getString("HintSignalEntry"));
            this.panelPercentageSpinner.add(this.signalPanel);
            ButtonGroup onOffGroup = new ButtonGroup();
            onOffGroup.add(this.onButton);
            onOffGroup.add(this.offButton);
            this.panelPercentageSpinner.add(this.onButton);
            this.panelPercentageSpinner.add(this.offButton);
            this.panelPercentageSpinner.add(this.doneSensorLabel);
            this.panelPercentageSpinner.add(this.doneSensorComboBox);
            JComboBoxUtil.setupComboBoxMaxRows(this.doneSensorComboBox);
            this.doneSensorComboBox.setAllowNull(true);
            panelx.add(this.panelPercentageSpinner);
            contentPane.add(panelx);
            contentPane.add(new JSeparator());
            JPanel but = new JPanel();
            but.setLayout(new FlowLayout());
            this.cancelAddEditActionButton = new JButton(Bundle.getMessage("ButtonCancel"));
            but.add(this.cancelAddEditActionButton);
            this.cancelAddEditActionButton.addActionListener(this::cancelAddEditActionPressed);
            this.cancelAddEditActionButton.setToolTipText(rbx.getString("CancelButtonHint"));
            this.createActionButton = new JButton(rbx.getString("CreateActionButton"));
            but.add(this.createActionButton);
            this.createActionButton.addActionListener(this::createActionPressed);
            this.createActionButton.setToolTipText(rbx.getString("CreateActionButtonHint"));
            this.updateActionButton = new JButton(rbx.getString("UpdateActionButton"));
            but.add(this.updateActionButton);
            this.updateActionButton.addActionListener(this::updateActionPressed);
            this.updateActionButton.setToolTipText(rbx.getString("UpdateActionButtonHint"));
            contentPane.add(but);
        }
        if (this.editActionMode) {
            this.addEditActionFrame.setTitle(rbx.getString("TitleEditAction"));
            this.updateActionButton.setVisible(true);
            this.createActionButton.setVisible(false);
            this.whenDataSpinnerInt.setValue(this.curTSA.getDataWhen());
            float whenFloat = ((Integer)this.whenDataSpinnerInt.getValue()).intValue();
            this.whenDataSpinnerFloat.setValue(Float.valueOf(whenFloat / 1000.0f));
            this.whenSensorComboBox.setSelectedItemByName(this.curTSA.getStringWhen());
            this.tWhatString2 = this.curTSA.getStringWhat2();
            this.tWhatString = this.curTSA.getStringWhat();
            this.tWhatData1 = this.curTSA.getDataWhat1();
            this.tWhat = this.curTSA.getWhatCode();
            this.tWhen = this.curTSA.getWhenCode();
            this.tWhenData = this.curTSA.getDataWhen();
            this.tWhatData2 = this.curTSA.getDataWhat2();
            this.whatStringField.setText(this.tWhatString);
            this.onButton.setSelected(true);
            if ("Off".equals(this.curTSA.getStringWhat())) {
                this.offButton.setSelected(true);
            }
            this.locoAddress.setText(this.curTSA.getStringWhat2());
            this.panelLoadTrainInfo.setVisible(false);
            log.debug("setWhen called for edit of action, editmode = {}", (Object)this.editActionMode);
            this.whenBox.setSelectedItem(this.getWhenMenuText(this.curTSA.getWhenCode()));
            this.whatBox.setSelectedItem(this.getWhatMenuText(this.curTSA.getWhatCode()));
            this.setBlockBox();
        } else {
            this.addEditActionFrame.setTitle(rbx.getString("TitleAddAction"));
            this.whenBox.setSelectedIndex(0);
            this.whatBox.setSelectedIndex(0);
            this.whenDataSpinnerInt.setValue(0);
            this.whenDataSpinnerFloat.setValue(Float.valueOf(0.0f));
            this.whenSensorComboBox.setSelectedItem(0);
            this.whatPercentSpinner.setValue(Float.valueOf(1.0f));
            this.whatMinuteSpinner1.setValue(100);
            this.whatMinuteSpinner2.setValue(100);
            this.locoFunctionSpinner.setValue(0);
            this.signalMastComboBox.setSelectedItem(0);
            this.signalHeadComboBox.setSelectedItem(0);
            this.doneSensorComboBox.setSelectedItem(0);
            this.whatStringField.setText("");
            this.locoAddress.setText("");
            this.onButton.setSelected(true);
            this.updateActionButton.setVisible(false);
            this.createActionButton.setVisible(true);
            this.panelLoadTrainInfo.setVisible(false);
            this.setBlockBox();
        }
        this.addEditActionFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TransitTableAction.this.addEditActionFrame.setVisible(false);
                TransitTableAction.this.addEditActionFrame.dispose();
                TransitTableAction.this.addEditActionFrame = null;
            }
        });
        this.addEditActionFrame.pack();
        this.addEditActionFrame.setVisible(true);
    }

    private void setWhen(int code) {
        this.whenSensorComboBox.setVisible(false);
        this.blockBox.setVisible(false);
        this.panelDelay.setVisible(true);
        this.panelWhatBox.setVisible(true);
        this.panelPercentageSpinner.setVisible(true);
        this.panelDelayLabel.setText("    " + rbx.getString("OptionalDelay") + ": ");
        log.debug("setWhen code = {}", (Object)code);
        this.initializeWhatBox(code);
        switch (code) {
            case 2: {
                this.panelDelay.setVisible(false);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 9: {
                this.panelDelay.setVisible(true);
                this.panelDelayLabel.setText("    " + rbx.getString("Delay") + ": ");
                this.panelWhatBox.setVisible(false);
                this.panelPercentageSpinner.setVisible(false);
                break;
            }
            case 3: 
            case 4: {
                this.blockBox.setVisible(true);
                this.blockBox.setToolTipText(rbx.getString("HintBlockEntry"));
                break;
            }
            case 7: 
            case 8: {
                this.whenSensorComboBox.setVisible(true);
                this.whenSensorComboBox.setToolTipText(rbx.getString("HintSensorEntry"));
                break;
            }
            case 0: {
                break;
            }
            default: {
                log.debug("Unhandled transit action code: {}", (Object)code);
            }
        }
        this.addEditActionFrame.pack();
        this.addEditActionFrame.setVisible(true);
    }

    private void setWhat(int code) {
        this.whatStringField.setVisible(false);
        this.whatPercentSpinner.setVisible(false);
        this.whatMinuteSpinner1.setVisible(false);
        this.whatMinuteSpinner2.setVisible(false);
        this.locoFunctionSpinner.setVisible(false);
        this.signalPanel.setVisible(false);
        this.onButton.setVisible(false);
        this.offButton.setVisible(false);
        this.doneSensorLabel.setVisible(false);
        this.doneSensorComboBox.setVisible(false);
        this.panelDelay.setEnabled(true);
        this.panelLoadTrainInfo.setVisible(false);
        log.debug("setWhat code = {}", (Object)code);
        switch (code) {
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                this.rosterComboBox.update();
                String[] names = new TrainInfoFile().getTrainInfoFileNames();
                this.trainInfoComboBox.removeAllItems();
                for (String fn : names) {
                    this.trainInfoComboBox.addItem(fn);
                    if (!fn.equals(this.tWhatString)) continue;
                    this.trainInfoComboBox.setSelectedItem(fn);
                }
                this.locoAddress.setText(Integer.toString(this.tWhatData1));
                switch (this.tWhatData2) {
                    case 1: {
                        this.locoAddressRoster.setSelected(true);
                        this.rosterComboBox.setSelectedItem(this.tWhatString2);
                        this.rosterComboBox.setVisible(true);
                        this.locoAddress.setVisible(false);
                        break;
                    }
                    case 2: {
                        this.locoAddressNumber.setSelected(true);
                        this.locoAddress.setText(this.tWhatString2);
                        this.rosterComboBox.setVisible(false);
                        this.locoAddress.setVisible(true);
                        break;
                    }
                    case 3: {
                        this.locoAddressCurrent.setSelected(true);
                        this.locoAddress.setText("");
                        this.rosterComboBox.setVisible(false);
                        this.locoAddress.setVisible(false);
                        break;
                    }
                    default: {
                        this.locoAddressDefault.setSelected(true);
                        this.rosterComboBox.setVisible(false);
                        this.locoAddress.setVisible(false);
                        this.locoAddress.setText("");
                    }
                }
                this.panelLoadTrainInfo.setVisible(true);
                break;
            }
            case 1: {
                if (this.getWhenMenuCode((String)this.whenBox.getSelectedItem()) == 9) {
                    this.panelDelay.setEnabled(false);
                }
                this.whatMinuteSpinner1.setModel(new SpinnerNumberModel(1, 1, 65500, 1));
                if (this.editActionMode) {
                    this.whatMinuteSpinner1.setValue(Math.max(this.curTSA.getDataWhat1(), 1));
                }
                this.whatMinuteSpinner1.setVisible(true);
                this.whatMinuteSpinner1.setToolTipText(rbx.getString("HintPauseData"));
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.editActionMode) {
                    float maxPerc = Math.max(0.01f * (float)this.curTSA.getDataWhat1(), 0.0f);
                    this.whatPercentSpinner.setValue(Float.valueOf(maxPerc));
                }
                this.whatPercentSpinner.setVisible(true);
                this.whatPercentSpinner.setToolTipText(rbx.getString("HintSetSpeedData1"));
                break;
            }
            case 5: {
                if (this.editActionMode) {
                    this.doneSensorComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                }
                this.doneSensorLabel.setVisible(true);
                this.doneSensorComboBox.setVisible(true);
                this.doneSensorComboBox.setToolTipText(rbx.getString("HintDoneSensor"));
                break;
            }
            case 6: {
                this.onButton.setVisible(true);
                this.offButton.setVisible(true);
                this.onButton.setToolTipText(rbx.getString("HintSetLight"));
                this.offButton.setToolTipText(rbx.getString("HintSetLight"));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.whatMinuteSpinner1.setValue(100);
                this.whatMinuteSpinner1.setModel(new SpinnerNumberModel(100, 100, 65500, 1));
                if (this.editActionMode) {
                    this.whatMinuteSpinner1.setValue(this.curTSA.getDataWhat1());
                }
                if ((Integer)this.whatMinuteSpinner1.getValue() < 100) {
                    this.whatMinuteSpinner1.setValue(100);
                }
                this.whatMinuteSpinner1.setVisible(true);
                this.whatMinuteSpinner1.setToolTipText(rbx.getString("HintSoundHornData1"));
                break;
            }
            case 10: {
                this.whatMinuteSpinner1.setValue(100);
                this.whatMinuteSpinner1.setModel(new SpinnerNumberModel(100, 100, 65500, 1));
                if (this.editActionMode) {
                    this.whatMinuteSpinner1.setValue(this.curTSA.getDataWhat1());
                    this.whatMinuteSpinner2.setValue(Math.max(this.curTSA.getDataWhat2(), 100));
                }
                if ((Integer)this.whatMinuteSpinner1.getValue() < 100) {
                    this.whatMinuteSpinner1.setValue(100);
                }
                this.whatMinuteSpinner1.setVisible(true);
                this.whatMinuteSpinner1.setToolTipText(rbx.getString("HintSoundHornPatternData1"));
                this.whatMinuteSpinner2.setVisible(true);
                this.whatMinuteSpinner2.setToolTipText(rbx.getString("HintSoundHornPatternData2"));
                this.whatStringField.setVisible(true);
                break;
            }
            case 11: {
                if (this.editActionMode) {
                    this.locoFunctionSpinner.setValue(this.curTSA.getDataWhat1());
                }
                this.locoFunctionSpinner.setVisible(true);
                this.locoFunctionSpinner.setToolTipText(rbx.getString("HintLocoFunctionData1"));
                this.onButton.setVisible(true);
                this.offButton.setVisible(true);
                this.onButton.setToolTipText(rbx.getString("HintLocoFunctionOnOff"));
                this.offButton.setToolTipText(rbx.getString("HintLocoFunctionOnOff"));
                break;
            }
            case 12: 
            case 13: {
                if (this.editActionMode) {
                    this.doneSensorComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                }
                this.doneSensorComboBox.setVisible(true);
                this.doneSensorComboBox.setToolTipText(rbx.getString("HintSensorEntry"));
                break;
            }
            case 14: 
            case 15: {
                if (this.editActionMode) {
                    SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(this.curTSA.getStringWhat());
                    if (sm != null) {
                        this.signalMastComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                    } else {
                        SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(this.curTSA.getStringWhat());
                        if (sh != null) {
                            this.signalHeadComboBox.setSelectedItemByName(this.curTSA.getStringWhat());
                        }
                    }
                }
                this.signalPanel.setVisible(true);
                break;
            }
            default: {
                log.debug("Unhandled transit section action: {}", (Object)code);
            }
        }
        this.addEditActionFrame.pack();
        this.addEditActionFrame.setVisible(true);
    }

    private void updateTrainInfoAddressFields(ActionEvent e) {
        if (!((JRadioButton)e.getSource()).isSelected()) {
            return;
        }
        if (e.getSource() == this.locoAddressRoster) {
            this.tWhatData2 = 1;
            this.rosterComboBox.setVisible(true);
            this.locoAddress.setVisible(false);
        } else if (e.getSource() == this.locoAddressNumber) {
            this.tWhatData2 = 2;
            this.rosterComboBox.setVisible(false);
            this.locoAddress.setVisible(true);
        } else if (e.getSource() == this.locoAddressDefault) {
            this.tWhatData2 = 0;
            this.rosterComboBox.setVisible(false);
            this.locoAddress.setVisible(false);
        } else if (e.getSource() == this.locoAddressCurrent) {
            this.tWhatData2 = 3;
            this.rosterComboBox.setVisible(false);
            this.locoAddress.setVisible(false);
        } else {
            log.warn("Unknown button Source");
        }
    }

    private void createActionPressed(ActionEvent e) {
        if (!this.validateWhenData() || !this.validateWhatData()) {
            return;
        }
        this.curTSA = new TransitSectionAction(this.tWhen, this.tWhat, this.tWhenData, this.tWhatData1, this.tWhatData2, this.tWhenString, this.tWhatString, this.tWhatString2);
        List<TransitSectionAction> list = this.action.get(this.activeRow);
        list.add(this.curTSA);
        this.actionTableModel.fireTableDataChanged();
        this.addEditActionFrame.setVisible(false);
        this.addEditActionFrame.dispose();
        this.addEditActionFrame = null;
    }

    private void updateActionPressed(ActionEvent e) {
        if (!this.validateWhenData() || !this.validateWhatData()) {
            return;
        }
        this.curTSA.setWhenCode(this.tWhen);
        this.curTSA.setWhatCode(this.tWhat);
        this.curTSA.setDataWhen(this.tWhenData);
        this.curTSA.setDataWhat1(this.tWhatData1);
        this.curTSA.setDataWhat2(this.tWhatData2);
        this.curTSA.setStringWhen(this.tWhenString);
        this.curTSA.setStringWhat(this.tWhatString);
        this.curTSA.setStringWhat2(this.tWhatString2);
        this.actionTableModel.fireTableDataChanged();
        this.addEditActionFrame.setVisible(false);
        this.addEditActionFrame.dispose();
        this.addEditActionFrame = null;
    }

    private void cancelAddEditActionPressed(ActionEvent e) {
        this.addEditActionFrame.setVisible(false);
        this.addEditActionFrame.dispose();
        this.addEditActionFrame = null;
    }

    private boolean validateWhenData() {
        this.tWhen = this.getWhenMenuCode((String)this.whenBox.getSelectedItem());
        this.tWhenData = (Integer)this.whenDataSpinnerInt.getValue();
        this.tWhenString = "";
        if (this.tWhen == 9 && this.tWhenData < 1) {
            return false;
        }
        if (this.tWhen == 7 || this.tWhen == 8) {
            if (this.whenSensorComboBox.getSelectedIndex() != 0) {
                this.tWhenString = this.whenSensorComboBox.getSelectedItemSystemName();
            }
            if (!this.validateSensor(this.tWhenString, true)) {
                return false;
            }
        }
        if (this.tWhen == 3 || this.tWhen == 4) {
            this.tWhenString = this.blockList.get(this.blockBox.getSelectedIndex()).getSystemName();
        }
        return true;
    }

    private boolean validateSensor(String sName, boolean when) {
        if (sName.length() < 1) {
            JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("NoSensorError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(sName);
        if (s == null) {
            JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("SensorEntryError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        if (!sName.equals(s.getUserName())) {
            if (when) {
                this.tWhenString = sName;
            } else {
                this.tWhatString = sName;
            }
        }
        return true;
    }

    private boolean validateSignal(String sName, boolean when) {
        if (sName.length() < 1) {
            JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("NoSignalError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sName);
        SignalHead sh = null;
        if (sm == null) {
            sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(sName);
        }
        if (sm == null && sh == null) {
            JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("SignalEntryError"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    private boolean validateWhatData() {
        this.tWhat = this.getWhatMenuCode((String)this.whatBox.getSelectedItem());
        this.tWhatData1 = 0;
        this.tWhatData2 = 0;
        this.tWhatString = "";
        switch (this.tWhat) {
            case 2: 
            case 3: 
            case 4: {
                this.tWhatData1 = Math.round(100.0f * ((Float)this.whatPercentSpinner.getValue()).floatValue());
                break;
            }
            case 5: {
                this.tWhatString = "";
                if (this.doneSensorComboBox.getSelectedIndex() >= 0) {
                    this.tWhatString = this.doneSensorComboBox.getSelectedItemSystemName();
                }
                if (this.tWhatString.length() < 1 || this.validateSensor(this.tWhatString, false)) break;
                this.tWhatString = "";
                break;
            }
            case 6: {
                this.tWhatString = "On";
                if (!this.offButton.isSelected()) break;
                this.tWhatString = "Off";
                break;
            }
            case 7: 
            case 8: 
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                if (this.trainInfoComboBox.getSelectedIndex() < 0) {
                    JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("MissingTrainInfoFile"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                this.tWhatString = (String)this.trainInfoComboBox.getSelectedItem();
                if (this.locoAddressRoster.isSelected()) {
                    this.tWhatData2 = 1;
                    if (this.rosterComboBox.getSelectedIndex() < 1) {
                        JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("MissingRosterEntryOrLocoAddress"), Bundle.getMessage("ErrorTitle"), 0);
                        return false;
                    }
                    this.tWhatString2 = ((RosterEntry)this.rosterComboBox.getSelectedItem()).getId();
                    break;
                }
                if (this.locoAddressNumber.isSelected()) {
                    this.tWhatData2 = 2;
                    this.tWhatString2 = this.locoAddress.getText();
                    if (this.tWhatString2 != null && !this.tWhatString2.isEmpty() && this.tWhatString2.length() >= 1) break;
                    JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("MissingRosterEntryOrLocoAddress"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                if (this.locoAddressDefault.isSelected()) {
                    this.tWhatData2 = 0;
                    this.tWhatString2 = "";
                    break;
                }
                if (this.locoAddressCurrent.isSelected()) {
                    this.tWhatData2 = 3;
                    this.tWhatString2 = "";
                    break;
                }
                JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("UnKnownlocoaddresstype"), Bundle.getMessage("ErrorTitle"), 0);
                return false;
            }
            case 1: 
            case 9: {
                this.tWhatData1 = (Integer)this.whatMinuteSpinner1.getValue();
                break;
            }
            case 10: {
                this.tWhatData1 = (Integer)this.whatMinuteSpinner1.getValue();
                this.tWhatData2 = (Integer)this.whatMinuteSpinner2.getValue();
                this.tWhatString = this.whatStringField.getText();
                if (this.tWhatString == null || this.tWhatString.isEmpty() || this.tWhatString.length() < 1) {
                    JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("MissingPattern"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                this.tWhatString = this.tWhatString.trim().toLowerCase();
                for (int i = 0; i < this.tWhatString.length(); ++i) {
                    char c = this.tWhatString.charAt(i);
                    if (c == 's' || c == 'l') continue;
                    JmriJOptionPane.showMessageDialog(this.addEditActionFrame, rbx.getString("ErrorPattern"), Bundle.getMessage("ErrorTitle"), 0);
                    return false;
                }
                this.whatStringField.setText(this.tWhatString);
                break;
            }
            case 11: {
                this.tWhatData1 = (Integer)this.locoFunctionSpinner.getValue();
                this.tWhatString = "On";
                if (!this.offButton.isSelected()) break;
                this.tWhatString = "Off";
                break;
            }
            case 12: 
            case 13: {
                if (this.doneSensorComboBox.getSelectedIndex() > 0) {
                    this.tWhatString = this.doneSensorComboBox.getSelectedItemSystemName();
                }
                if (this.validateSensor(this.tWhatString, false)) break;
                return false;
            }
            case 14: 
            case 15: {
                if (this.signalMastComboBox.getSelectedIndex() > 0) {
                    this.tWhatString = this.signalMastComboBox.getSelectedItemSystemName();
                } else if (this.signalHeadComboBox.getSelectedIndex() > 0) {
                    this.tWhatString = this.signalHeadComboBox.getSelectedItemSystemName();
                }
                if (this.validateSignal(this.tWhatString, false)) break;
                return false;
            }
            case 17: {
                break;
            }
            default: {
                log.warn("Unhandled transit section action code: {}", (Object)this.tWhat);
            }
        }
        return true;
    }

    private void initializeWhenBox() {
        this.whenBox.removeAllItems();
        for (int i = 0; i <= 10; ++i) {
            this.whenBox.addItem(this.getWhenMenuText(i));
        }
    }

    private String getWhenMenuText(int i) {
        switch (i) {
            case 1: {
                return rbx.getString("OnEntry");
            }
            case 2: {
                return rbx.getString("OnExit");
            }
            case 3: {
                return rbx.getString("OnBlockEntry");
            }
            case 4: {
                return rbx.getString("OnBlockExit");
            }
            case 5: {
                return rbx.getString("TrainStop");
            }
            case 6: {
                return rbx.getString("TrainStart");
            }
            case 7: {
                return rbx.getString("OnSensorActive");
            }
            case 8: {
                return rbx.getString("OnSensorInactive");
            }
            case 9: {
                return rbx.getString("PreStartDelay");
            }
            case 10: {
                return rbx.getString("PreStartAction");
            }
            case 0: {
                return rbx.getString("SelectWhen");
            }
        }
        log.warn("Unhandled transit section when code: {}", (Object)i);
        return rbx.getString("SelectWhen");
    }

    private int getWhenMenuCode(String s) {
        if (s.equals(rbx.getString("OnEntry"))) {
            return 1;
        }
        if (s.equals(rbx.getString("OnExit"))) {
            return 2;
        }
        if (s.equals(rbx.getString("OnBlockEntry"))) {
            return 3;
        }
        if (s.equals(rbx.getString("OnBlockExit"))) {
            return 4;
        }
        if (s.equals(rbx.getString("TrainStop"))) {
            return 5;
        }
        if (s.equals(rbx.getString("TrainStart"))) {
            return 6;
        }
        if (s.equals(rbx.getString("OnSensorActive"))) {
            return 7;
        }
        if (s.equals(rbx.getString("OnSensorInactive"))) {
            return 8;
        }
        if (s.equals(rbx.getString("PreStartDelay"))) {
            return 9;
        }
        if (s.equals(rbx.getString("PreStartAction"))) {
            return 10;
        }
        return 0;
    }

    private void initializeWhatBox(int code) {
        this.whatBox.removeAllItems();
        ArrayList<Integer> excludeCodes = new ArrayList<Integer>();
        ArrayList<Integer> includeCodes = new ArrayList<Integer>();
        if (code == 10) {
            excludeCodes = new ArrayList<Integer>(Arrays.asList(2, 3, 4));
        } else if (code == 9) {
            includeCodes.add(17);
        } else {
            excludeCodes.add(17);
        }
        for (int i = 0; i <= 20; ++i) {
            if (!excludeCodes.isEmpty()) {
                if (excludeCodes.contains(i)) continue;
                this.whatBox.addItem(this.getWhatMenuText(i));
                continue;
            }
            if (!includeCodes.isEmpty()) {
                if (!includeCodes.contains(i)) continue;
                this.whatBox.addItem(this.getWhatMenuText(i));
                continue;
            }
            this.whatBox.addItem(this.getWhatMenuText(i));
        }
    }

    @Nonnull
    private String getWhatMenuText(int i) {
        switch (i) {
            case 0: {
                return rbx.getString("SelectWhat");
            }
            case 18: {
                return rbx.getString("TerminateTrain");
            }
            case 19: {
                return rbx.getString("LoadTrainInfo");
            }
            case 20: {
                return rbx.getString("ForcePassNextSafe");
            }
            case 1: {
                return rbx.getString("Pause");
            }
            case 2: {
                return rbx.getString("SetMaxSpeed");
            }
            case 3: {
                return rbx.getString("SetTrainSpeed");
            }
            case 4: {
                return rbx.getString("RampTrainSpeed");
            }
            case 5: {
                return rbx.getString("ToManualMode");
            }
            case 6: {
                return rbx.getString("SetLight");
            }
            case 7: {
                return rbx.getString("StartBell");
            }
            case 8: {
                return rbx.getString("StopBell");
            }
            case 9: {
                return rbx.getString("SoundHorn");
            }
            case 10: {
                return rbx.getString("SoundHornPattern");
            }
            case 11: {
                return rbx.getString("LocoFunction");
            }
            case 12: {
                return rbx.getString("SetSensorActive");
            }
            case 13: {
                return rbx.getString("SetSensorInactive");
            }
            case 14: {
                return rbx.getString("HoldSignal");
            }
            case 15: {
                return rbx.getString("ReleaseSignal");
            }
            case 16: {
                return rbx.getString("EStop");
            }
            case 17: {
                return rbx.getString("PreStartResume");
            }
        }
        log.warn("Unhandled transit section action code: {}", (Object)i);
        return rbx.getString("SelectWhat");
    }

    private int getWhatMenuCode(@Nonnull String s) {
        if (s.equals(rbx.getString("SelectWhat"))) {
            return 0;
        }
        if (s.equals(rbx.getString("TerminateTrain"))) {
            return 18;
        }
        if (s.equals(rbx.getString("ForcePassNextSafe"))) {
            return 20;
        }
        if (s.equals(rbx.getString("LoadTrainInfo"))) {
            return 19;
        }
        if (s.equals(rbx.getString("Pause"))) {
            return 1;
        }
        if (s.equals(rbx.getString("SetMaxSpeed"))) {
            return 2;
        }
        if (s.equals(rbx.getString("SetTrainSpeed"))) {
            return 3;
        }
        if (s.equals(rbx.getString("RampTrainSpeed"))) {
            return 4;
        }
        if (s.equals(rbx.getString("ToManualMode"))) {
            return 5;
        }
        if (s.equals(rbx.getString("SetLight"))) {
            return 6;
        }
        if (s.equals(rbx.getString("StartBell"))) {
            return 7;
        }
        if (s.equals(rbx.getString("StopBell"))) {
            return 8;
        }
        if (s.equals(rbx.getString("SoundHorn"))) {
            return 9;
        }
        if (s.equals(rbx.getString("SoundHornPattern"))) {
            return 10;
        }
        if (s.equals(rbx.getString("LocoFunction"))) {
            return 11;
        }
        if (s.equals(rbx.getString("SetSensorActive"))) {
            return 12;
        }
        if (s.equals(rbx.getString("SetSensorInactive"))) {
            return 13;
        }
        if (s.equals(rbx.getString("HoldSignal"))) {
            return 14;
        }
        if (s.equals(rbx.getString("ReleaseSignal"))) {
            return 15;
        }
        if (s.equals(rbx.getString("EStop"))) {
            return 16;
        }
        if (s.equals(rbx.getString("PreStartResume"))) {
            return 17;
        }
        log.warn("Unhandled transit section action text: {}", (Object)s);
        return 0;
    }

    private void initializeBlockBox() {
        this.blockList = this.sectionList.get(this.activeRow).getBlockList();
        this.blockBox.removeAllItems();
        for (int i = 0; i < this.blockList.size(); ++i) {
            String s = this.blockList.get(i).getDisplayName();
            this.blockBox.addItem(s);
        }
    }

    private void setBlockBox() {
        if (this.editActionMode && (this.curTSA.getWhenCode() == 3 || this.curTSA.getWhenCode() == 4)) {
            for (int i = 0; i < this.blockList.size(); ++i) {
                if (!this.curTSA.getStringWhen().equals(this.blockList.get(i).getSystemName())) continue;
                this.blockBox.setSelectedIndex(i);
                return;
            }
        }
        this.blockBox.setSelectedIndex(0);
    }

    private void editAction(int r) {
        this.curTSA = this.action.get(this.activeRow).get(r);
        this.editActionMode = true;
        this.addEditActionWindow();
    }

    private void deleteAction(int r) {
        TransitSectionAction tsa = this.action.get(this.activeRow).get(r);
        this.action.get(this.activeRow).remove(r);
        tsa.dispose();
        this.actionTableModel.fireTableDataChanged();
    }

    private String getWhenText(int r) {
        TransitSectionAction tsa = this.action.get(this.activeRow).get(r);
        switch (tsa.getWhenCode()) {
            case 1: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnEntryDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("OnEntryFull");
            }
            case 2: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnExitDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("OnExitFull");
            }
            case 3: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnBlockEntryDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnBlockEntryFull"), tsa.getStringWhen());
            }
            case 4: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnBlockExitDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnBlockExitFull"), tsa.getStringWhen());
            }
            case 5: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("TrainStopDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("TrainStopFull");
            }
            case 6: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("TrainStartDelayedFull"), "" + tsa.getDataWhen());
                }
                return rbx.getString("TrainStartFull");
            }
            case 7: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnSensorActiveDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnSensorActiveFull"), tsa.getStringWhen());
            }
            case 8: {
                if (tsa.getDataWhen() > 0) {
                    return MessageFormat.format(rbx.getString("OnSensorInactiveDelayedFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
                }
                return MessageFormat.format(rbx.getString("OnSensorInactiveFull"), tsa.getStringWhen());
            }
            case 9: {
                return MessageFormat.format(rbx.getString("PreStartDelayFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
            }
            case 10: {
                return MessageFormat.format(rbx.getString("PreStartActionFull"), "" + tsa.getDataWhen(), tsa.getStringWhen());
            }
        }
        log.warn("Unhandled transit section action When code: {}", (Object)tsa.getWhenCode());
        return "";
    }

    private String getWhatText(int r) {
        TransitSectionAction tsa = this.action.get(this.activeRow).get(r);
        switch (tsa.getWhatCode()) {
            case 1: {
                return MessageFormat.format(rbx.getString("PauseFull"), tsa.getDataWhat1());
            }
            case 2: {
                return MessageFormat.format(rbx.getString("SetMaxSpeedFull"), tsa.getDataWhat1());
            }
            case 3: {
                return MessageFormat.format(rbx.getString("SetTrainSpeedFull"), tsa.getDataWhat1());
            }
            case 4: {
                return MessageFormat.format(rbx.getString("RampTrainSpeedFull"), "" + tsa.getDataWhat1());
            }
            case 5: {
                if (tsa.getStringWhat().length() > 0) {
                    return MessageFormat.format(rbx.getString("ToManualModeAltFull"), tsa.getStringWhat());
                }
                return rbx.getString("ToManualModeFull");
            }
            case 6: {
                if (tsa.getStringWhat().equals("Off")) {
                    return MessageFormat.format(rbx.getString("SetLightFull"), Bundle.getMessage("StateOff"));
                }
                return MessageFormat.format(rbx.getString("SetLightFull"), Bundle.getMessage("StateOn"));
            }
            case 7: {
                return rbx.getString("StartBellFull");
            }
            case 8: {
                return rbx.getString("StopBellFull");
            }
            case 9: {
                return MessageFormat.format(rbx.getString("SoundHornFull"), tsa.getDataWhat1());
            }
            case 10: {
                return MessageFormat.format(rbx.getString("SoundHornPatternFull"), tsa.getStringWhat(), "" + tsa.getDataWhat1(), "" + tsa.getDataWhat2());
            }
            case 11: {
                if (tsa.getStringWhat().equals("Off")) {
                    return MessageFormat.format(rbx.getString("LocoFunctionFull"), "" + tsa.getDataWhat1(), Bundle.getMessage("StateOff"));
                }
                return MessageFormat.format(rbx.getString("LocoFunctionFull"), "" + tsa.getDataWhat1(), Bundle.getMessage("StateOn"));
            }
            case 12: {
                return MessageFormat.format(rbx.getString("SetSensorActiveFull"), tsa.getStringWhat());
            }
            case 13: {
                return MessageFormat.format(rbx.getString("SetSensorInactiveFull"), tsa.getStringWhat());
            }
            case 14: {
                return MessageFormat.format(rbx.getString("HoldSignalFull"), tsa.getStringWhat());
            }
            case 15: {
                return MessageFormat.format(rbx.getString("ReleaseSignalFull"), tsa.getStringWhat());
            }
            case 17: {
                return MessageFormat.format(rbx.getString("PreStartResumeFull"), tsa.getDataWhen());
            }
            case 16: {
                return rbx.getString("EStopFull");
            }
            case 18: {
                return rbx.getString("TerminateTrain");
            }
            case 20: {
                return rbx.getString("ForcePassNextSafe");
            }
            case 19: {
                switch (tsa.getDataWhat2()) {
                    case 1: {
                        return MessageFormat.format(rbx.getString("LoadTrainInfoRosterFull"), tsa.getStringWhat(), tsa.getStringWhat2());
                    }
                    case 2: {
                        return MessageFormat.format(rbx.getString("LoadTrainInfoNumberFull"), tsa.getStringWhat(), tsa.getStringWhat2());
                    }
                    case 3: {
                        return MessageFormat.format(rbx.getString("LoadTrainInfoCurrentFull"), tsa.getStringWhat());
                    }
                }
                return MessageFormat.format(rbx.getString("LoadTrainInfoDefaultFull"), tsa.getStringWhat());
            }
            case 0: {
                return rbx.getString("SelectWhat");
            }
        }
        log.warn("Unhandled transit section action What code: {}", (Object)tsa.getWhatCode());
        return "WHAT";
    }

    private String getSectionNameByRow(int r) {
        return this.sectionList.get(r).getDisplayName();
    }

    private void updateSensorList() {
        SortedSet nameSet = InstanceManager.getDefault(SensorManager.class).getNamedBeanSet();
        String[] displayList = new String[nameSet.size()];
        int i = 0;
        for (Sensor nBean : nameSet) {
            if (nBean == null) continue;
            displayList[i++] = nBean.getDisplayName();
        }
        Arrays.sort(displayList, new AlphanumComparator());
        this.sensorList = new String[displayList.length + 1];
        this.sensorList[0] = "";
        i = 1;
        String[] stringArray = displayList;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String name;
            this.sensorList[i] = name = stringArray[j];
            ++i;
        }
    }

    @Override
    protected String getClassName() {
        return TransitTableAction.class.getName();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleTransitTable");
    }

    public class SpecialActionTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int WHEN_COLUMN = 0;
        public static final int WHAT_COLUMN = 1;
        public static final int EDIT_COLUMN = 2;
        public static final int REMOVE_COLUMN = 3;

        public SpecialActionTableModel() {
            this.addPcl();
        }

        final void addPcl() {
            TransitTableAction.this.sectionManager.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("length".equals(e.getPropertyName())) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 2: 
                case 3: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return TransitTableAction.this.action.get(TransitTableAction.this.activeRow).size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return rbx.getString("WhenColName");
                }
                case 1: {
                    return rbx.getString("WhatColName");
                }
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return new JTextField((int)50).getPreferredSize().width;
                }
            }
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx > TransitTableAction.this.action.get(TransitTableAction.this.activeRow).size()) {
                return null;
            }
            switch (c) {
                case 0: {
                    return TransitTableAction.this.getWhenText(rx);
                }
                case 1: {
                    return TransitTableAction.this.getWhatText(rx);
                }
                case 2: {
                    return Bundle.getMessage("ButtonEdit");
                }
                case 3: {
                    return Bundle.getMessage("ButtonDelete");
                }
            }
            return Bundle.getMessage("BeanStateUnknown");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2) {
                TransitTableAction.this.editAction(row);
            } else if (col == 3) {
                TransitTableAction.this.deleteAction(row);
            }
        }

        public void dispose() {
            TransitTableAction.this.sectionManager.removePropertyChangeListener(this);
        }
    }

    public class SectionTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SEQUENCE_COLUMN = 0;
        public static final int SECTIONNAME_COLUMN = 1;
        public static final int ACTION_COLUMN = 2;
        public static final int SEC_DIRECTION_COLUMN = 3;
        public static final int ALTERNATE_COLUMN = 4;
        public static final int SAFE_COLUMN = 5;
        public static final int STOPALLOCATING_SENSOR = 6;
        public static final int NUMBER_OF_COLUMNS = 7;

        public SectionTableModel() {
            this.addPcl();
        }

        final void addPcl() {
            TransitTableAction.this.sectionManager.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("length".equals(e.getPropertyName())) {
                this.fireTableDataChanged();
            }
            if (e.getSource() instanceof SensorManager && "DisplayListName".equals(e.getPropertyName())) {
                TransitTableAction.this.updateSensorList();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 2: {
                    return JButton.class;
                }
                case 5: {
                    return Boolean.class;
                }
                case 6: {
                    return JComboBox.class;
                }
            }
            return super.getColumnClass(c);
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return TransitTableAction.this.sectionList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                case 2: 
                case 5: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return rbx.getString("SequenceColName");
                }
                case 1: {
                    return Bundle.getMessage("BeanNameSection");
                }
                case 2: {
                    return rbx.getString("ActionColName");
                }
                case 3: {
                    return rbx.getString("DirectionColName");
                }
                case 4: {
                    return rbx.getString("AlternateColName");
                }
                case 5: {
                    return rbx.getString("SafeColName");
                }
                case 6: {
                    return rbx.getString("StopAllocationColName");
                }
            }
            return "";
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 3: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)4).getPreferredSize().width;
                }
                case 6: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx > TransitTableAction.this.sectionList.size()) {
                return null;
            }
            switch (c) {
                case 0: {
                    return "" + TransitTableAction.this.sequence.get(rx);
                }
                case 1: {
                    return TransitTableAction.this.getSectionNameByRow(rx);
                }
                case 2: {
                    return rbx.getString("AddEditActions");
                }
                case 3: {
                    if (TransitTableAction.this.direction.get(rx) == 4) {
                        return rbx.getString("SectionForward");
                    }
                    if (TransitTableAction.this.direction.get(rx) == 8) {
                        return rbx.getString("SectionReverse");
                    }
                    return Bundle.getMessage("BeanStateUnknown");
                }
                case 4: {
                    if (TransitTableAction.this.alternate.get(rx).booleanValue()) {
                        return rbx.getString("Alternate");
                    }
                    return rbx.getString("Primary");
                }
                case 5: {
                    return TransitTableAction.this.safe.get(rx);
                }
                case 6: {
                    String sensor = TransitTableAction.this.sensorStopAllocation.get(rx);
                    JComboBox<String> cb = new JComboBox<String>(TransitTableAction.this.sensorList);
                    JComboBoxUtil.setupComboBoxMaxRows(cb);
                    String name = sensor != null ? sensor : "";
                    cb.setSelectedItem(name);
                    return cb;
                }
            }
            return Bundle.getMessage("BeanStateUnknown");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 2: {
                    TransitTableAction.this.addEditActionsPressed(row);
                    break;
                }
                case 5: {
                    boolean val = (Boolean)value;
                    TransitTableAction.this.safe.set(row, val);
                    break;
                }
                case 6: {
                    JComboBox cb = (JComboBox)value;
                    if (cb.getSelectedIndex() < 0) {
                        TransitTableAction.this.sensorStopAllocation.set(row, "");
                        break;
                    }
                    TransitTableAction.this.sensorStopAllocation.set(row, (String)cb.getSelectedItem());
                    break;
                }
            }
        }

        public void dispose() {
            TransitTableAction.this.sectionManager.removePropertyChangeListener(this);
        }
    }
}

