/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Objects;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.Manager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.AbstractTableTabAction;
import jmri.jmrit.beantable.AddNewHardwareDevicePanel;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.Bundle;
import jmri.jmrit.beantable.turnout.TurnoutTableDataModel;
import jmri.jmrit.turnoutoperations.TurnoutOperationFrame;
import jmri.swing.ManagerComboBox;
import jmri.swing.SystemNameValidator;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.TriStateJCheckBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutTableAction
extends AbstractTableAction<Turnout> {
    protected TurnoutManager turnoutManager = InstanceManager.getDefault(TurnoutManager.class);
    JmriJFrame addFrame = null;
    JTextField hardwareAddressTextField = new JTextField(20);
    JTextField userNameTextField = new JTextField(40);
    ManagerComboBox<Turnout> prefixBox = new ManagerComboBox();
    SpinnerNumberModel rangeSpinner = new SpinnerNumberModel(1, 1, 100, 1);
    JSpinner numberToAddSpinner = new JSpinner(this.rangeSpinner);
    JCheckBox rangeBox = new JCheckBox(Bundle.getMessage("AddRangeBox"));
    String systemSelectionCombo = this.getClass().getName() + ".SystemSelected";
    JButton addButton;
    JLabel statusBarLabel = new JLabel(Bundle.getMessage("HardwareAddStatusEnter"), 10);
    UserPreferencesManager pref;
    SystemNameValidator hardwareAddressValidator;
    private final JCheckBox doAutomationBox = new JCheckBox(Bundle.getMessage("AutomaticRetry"));
    private final TriStateJCheckBox showFeedbackBox = new TriStateJCheckBox(Bundle.getMessage("ShowFeedbackInfo"));
    private final TriStateJCheckBox showLockBox = new TriStateJCheckBox(Bundle.getMessage("ShowLockInfo"));
    private final TriStateJCheckBox showTurnoutSpeedBox = new TriStateJCheckBox(Bundle.getMessage("ShowTurnoutSpeedDetails"));
    private final TriStateJCheckBox showStateForgetAndQueryBox = new TriStateJCheckBox(Bundle.getMessage("ShowStateForgetAndQuery"));
    private String addEntryToolTip;
    private boolean noWarn = false;
    private static final Logger log = LoggerFactory.getLogger(TurnoutTableAction.class);

    public TurnoutTableAction(String actionName) {
        super(actionName);
        if (this.turnoutManager == null) {
            super.setEnabled(false);
        }
    }

    public TurnoutTableAction() {
        this(Bundle.getMessage("TitleTurnoutTable"));
    }

    @Override
    public void setManager(@Nonnull Manager<Turnout> man) {
        if (man instanceof TurnoutManager) {
            log.debug("setting manager of TTAction {} to {}", (Object)this, man.getClass());
            this.turnoutManager = (TurnoutManager)man;
            if (this.m != null) {
                this.m.setManager(man);
            }
        }
    }

    @Override
    protected void createModel() {
        this.m = new TurnoutTableDataModel(this.turnoutManager);
    }

    @Override
    protected void setTitle() {
        this.f.setTitle(Bundle.getMessage("TitleTurnoutTable"));
    }

    @Override
    protected String helpTarget() {
        return "package.jmri.jmrit.beantable.TurnoutTable";
    }

    @Override
    protected void addPressed(ActionEvent e) {
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.addFrame == null) {
            this.addFrame = new JmriJFrame(Bundle.getMessage("TitleAddTurnout"), false, true);
            this.addFrame.addHelpMenu("package.jmri.jmrit.beantable.TurnoutAddEdit", true);
            this.addFrame.getContentPane().setLayout(new BoxLayout(this.addFrame.getContentPane(), 1));
            ActionListener cancelListener = this::cancelPressed;
            ActionListener rangeListener = this::canAddRange;
            this.configureManagerComboBox(this.prefixBox, this.turnoutManager, TurnoutManager.class);
            this.userNameTextField.setName("userNameTextField");
            this.prefixBox.setName("prefixBox");
            this.addButton = new JButton(Bundle.getMessage("ButtonCreate"));
            this.addButton.addActionListener(this::createPressed);
            if (this.hardwareAddressValidator == null) {
                this.hardwareAddressValidator = new SystemNameValidator(this.hardwareAddressTextField, (Manager)Objects.requireNonNull(this.prefixBox.getSelectedItem()), true);
            } else {
                this.hardwareAddressValidator.setManager((Manager<?>)this.prefixBox.getSelectedItem());
            }
            this.addFrame.add(new AddNewHardwareDevicePanel(this.hardwareAddressTextField, this.hardwareAddressValidator, this.userNameTextField, this.prefixBox, this.numberToAddSpinner, this.rangeBox, this.addButton, cancelListener, rangeListener, this.statusBarLabel));
            this.canAddRange(null);
        }
        this.hardwareAddressTextField.setName("hwAddressTextField");
        this.addButton.setName("createButton");
        this.addFrame.setEscapeKeyClosesWindow(true);
        this.addFrame.getRootPane().setDefaultButton(this.addButton);
        this.statusBarLabel.setText(Bundle.getMessage("HardwareAddStatusEnter"));
        this.statusBarLabel.setForeground(Color.gray);
        this.addFrame.pack();
        this.addFrame.setVisible(true);
    }

    public static void updateAutomationBox(final Turnout t, JComboBox<String> cb) {
        int i;
        TurnoutOperation[] ops = InstanceManager.getDefault(TurnoutOperationManager.class).getTurnoutOperations();
        cb.removeAllItems();
        Vector<String> strings = new Vector<String>(20);
        Vector<String> defStrings = new Vector<String>(20);
        log.debug("opsCombo start {}", (Object)ops.length);
        for (TurnoutOperation op : ops) {
            if (log.isDebugEnabled()) {
                log.debug("isDef {} mFMM {} isNonce {}", new Object[]{op.isDefinitive(), op.matchFeedbackMode(t.getFeedbackMode()), op.isNonce()});
            }
            if (op.isDefinitive() || !op.matchFeedbackMode(t.getFeedbackMode()) || op.isNonce()) continue;
            strings.addElement(op.getName());
        }
        log.debug("opsCombo end");
        for (TurnoutOperation op : ops) {
            if (!op.isDefinitive() || !op.matchFeedbackMode(t.getFeedbackMode())) continue;
            defStrings.addElement(op.getName());
        }
        Collections.sort(strings);
        Collections.sort(defStrings);
        strings.insertElementAt(Bundle.getMessage("TurnoutOperationOff"), 0);
        strings.insertElementAt(Bundle.getMessage("TurnoutOperationDefault"), 1);
        for (i = 0; i < defStrings.size(); ++i) {
            try {
                strings.insertElementAt((String)defStrings.elementAt(i), i + 2);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        for (i = 0; i < strings.size(); ++i) {
            cb.addItem((String)strings.elementAt(i));
        }
        if (t.getInhibitOperation()) {
            cb.setSelectedIndex(0);
        } else {
            TurnoutOperation turnOp = t.getTurnoutOperation();
            if (turnOp == null) {
                cb.setSelectedIndex(1);
            } else if (turnOp.isNonce()) {
                cb.setSelectedIndex(2);
            } else {
                cb.setSelectedItem(turnOp.getName());
            }
        }
        cb.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel lbl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    lbl.setToolTipText(InstanceManager.getDefault(TurnoutOperationManager.class).getTooltipForOperator(value.toString(), t));
                }
                return lbl;
            }
        });
    }

    protected void setDefaultSpeeds(JFrame _who) {
        JComboBox<String> thrownCombo = new JComboBox<String>(((TurnoutTableDataModel)this.m).speedListThrown);
        JComboBox<String> closedCombo = new JComboBox<String>(((TurnoutTableDataModel)this.m).speedListClosed);
        thrownCombo.setEditable(true);
        closedCombo.setEditable(true);
        JComboBoxUtil.setupComboBoxMaxRows(thrownCombo);
        JComboBoxUtil.setupComboBoxMaxRows(closedCombo);
        JPanel thrown = new JPanel();
        thrown.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ThrownSpeed"))));
        thrown.add(thrownCombo);
        JPanel closed = new JPanel();
        closed.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ClosedSpeed"))));
        closed.add(closedCombo);
        thrownCombo.removeItem(((TurnoutTableDataModel)this.m).defaultThrownSpeedText);
        closedCombo.removeItem(((TurnoutTableDataModel)this.m).defaultClosedSpeedText);
        thrownCombo.setSelectedItem(this.turnoutManager.getDefaultThrownSpeed());
        closedCombo.setSelectedItem(this.turnoutManager.getDefaultClosedSpeed());
        String title = Bundle.getMessage("TurnoutGlobalSpeedMessageTitle");
        JPanel speedspanel = new JPanel();
        speedspanel.setLayout(new BoxLayout(speedspanel, 3));
        speedspanel.add(new JLabel(Bundle.getMessage("TurnoutGlobalSpeedMessage")));
        thrown.setAlignmentX(0.0f);
        speedspanel.add(thrown);
        closed.setAlignmentX(0.0f);
        speedspanel.add(closed);
        int retval = JmriJOptionPane.showConfirmDialog(_who, speedspanel, title, 2, 1);
        log.debug("Retval = {}", (Object)retval);
        if (retval != 0) {
            return;
        }
        String closedValue = (String)closedCombo.getSelectedItem();
        String thrownValue = (String)thrownCombo.getSelectedItem();
        try {
            assert (thrownValue != null);
            this.turnoutManager.setDefaultThrownSpeed(thrownValue);
        }
        catch (JmriException ex) {
            JmriJOptionPane.showMessageDialog(null, ex.getMessage() + "\n" + thrownValue);
        }
        try {
            assert (closedValue != null);
            this.turnoutManager.setDefaultClosedSpeed(closedValue);
        }
        catch (JmriException ex) {
            JmriJOptionPane.showMessageDialog(null, ex.getMessage() + "\n" + closedValue);
        }
    }

    private void initCheckBoxes() {
        this.doAutomationBox.setSelected(InstanceManager.getDefault(TurnoutOperationManager.class).getDoOperations());
        this.doAutomationBox.setToolTipText(Bundle.getMessage("TurnoutDoAutomationBoxTooltip"));
        this.doAutomationBox.addActionListener(e -> InstanceManager.getDefault(TurnoutOperationManager.class).setDoOperations(this.doAutomationBox.isSelected()));
        this.showFeedbackBox.setToolTipText(Bundle.getMessage("TurnoutFeedbackToolTip"));
        this.showLockBox.setToolTipText(Bundle.getMessage("TurnoutLockToolTip"));
        this.showTurnoutSpeedBox.setToolTipText(Bundle.getMessage("TurnoutSpeedToolTip"));
        this.showStateForgetAndQueryBox.setToolTipText(Bundle.getMessage("StateForgetAndQueryBoxToolTip"));
    }

    @Override
    protected void configureTable(JTable table) {
        super.configureTable(table);
        this.showStateForgetAndQueryBox.addActionListener(e -> ((TurnoutTableDataModel)this.m).showStateForgetAndQueryChanged(this.showStateForgetAndQueryBox.isSelected(), table));
        this.showTurnoutSpeedBox.addActionListener(e -> ((TurnoutTableDataModel)this.m).showTurnoutSpeedChanged(this.showTurnoutSpeedBox.isSelected(), table));
        this.showFeedbackBox.addActionListener(e -> ((TurnoutTableDataModel)this.m).showFeedbackChanged(this.showFeedbackBox.isSelected(), table));
        this.showLockBox.addActionListener(e -> ((TurnoutTableDataModel)this.m).showLockChanged(this.showLockBox.isSelected(), table));
    }

    @Override
    public void addToFrame(BeanTableFrame<Turnout> f) {
        this.initCheckBoxes();
        f.addToBottomBox(this.doAutomationBox, this.getClass().getName());
        f.addToBottomBox(this.showFeedbackBox, this.getClass().getName());
        f.addToBottomBox(this.showLockBox, this.getClass().getName());
        f.addToBottomBox(this.showTurnoutSpeedBox, this.getClass().getName());
        f.addToBottomBox(this.showStateForgetAndQueryBox, this.getClass().getName());
    }

    @Override
    public void addToPanel(AbstractTableTabAction<Turnout> f) {
        String connectionName = this.turnoutManager.getMemo().getUserName();
        if (this.turnoutManager.getClass().getName().contains("ProxyTurnoutManager")) {
            connectionName = "All";
        }
        this.initCheckBoxes();
        f.addToBottomBox(this.doAutomationBox, connectionName);
        f.addToBottomBox(this.showFeedbackBox, connectionName);
        f.addToBottomBox(this.showLockBox, connectionName);
        f.addToBottomBox(this.showTurnoutSpeedBox, connectionName);
        f.addToBottomBox(this.showStateForgetAndQueryBox, connectionName);
    }

    @Override
    protected void columnsVisibleUpdated(boolean[] colsVisible) {
        log.debug("columns updated {}", (Object)colsVisible);
        this.showFeedbackBox.setState(new boolean[]{colsVisible[8], colsVisible[9], colsVisible[10], colsVisible[11], colsVisible[12], colsVisible[13]});
        this.showLockBox.setState(new boolean[]{colsVisible[15], colsVisible[14]});
        this.showTurnoutSpeedBox.setState(new boolean[]{colsVisible[16], colsVisible[17]});
        this.showStateForgetAndQueryBox.setState(new boolean[]{colsVisible[18], colsVisible[19]});
    }

    @Override
    public void setMenuBar(BeanTableFrame<Turnout> f) {
        BeanTableFrame<Turnout> finalF = f;
        JMenuBar menuBar = f.getJMenuBar();
        boolean menuAbsent = true;
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            String name = menuBar.getMenu(i).getAccessibleContext().getAccessibleName();
            if (!name.equals(Bundle.getMessage("TurnoutAutomationMenu"))) continue;
            menuAbsent = false;
            break;
        }
        if (menuAbsent) {
            int pos = menuBar.getMenuCount() - 1;
            int offset = 1;
            log.debug("setMenuBar number of menu items = {}", (Object)pos);
            for (int i = 0; i <= pos; ++i) {
                if (!(menuBar.getComponent(i) instanceof JMenu) || !((JMenu)menuBar.getComponent(i)).getText().equals(Bundle.getMessage("MenuHelp"))) continue;
                offset = -1;
            }
            JMenu opsMenu = new JMenu(Bundle.getMessage("TurnoutAutomationMenu"));
            JMenuItem item = new JMenuItem(Bundle.getMessage("TurnoutAutomationMenuItemEdit"));
            opsMenu.add(item);
            item.addActionListener(e -> new TurnoutOperationFrame(finalF));
            menuBar.add((Component)opsMenu, pos + offset);
            JMenu speedMenu = new JMenu(Bundle.getMessage("SpeedsMenu"));
            item = new JMenuItem(Bundle.getMessage("SpeedsMenuItemDefaults"));
            speedMenu.add(item);
            item.addActionListener(e -> this.setDefaultSpeeds(finalF));
            menuBar.add((Component)speedMenu, pos + offset + 1);
        }
    }

    void cancelPressed(ActionEvent e) {
        this.removePrefixBoxListener(this.prefixBox);
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    void createPressed(ActionEvent e) {
        int numberOfTurnouts = 1;
        if (this.rangeBox.isSelected()) {
            numberOfTurnouts = (Integer)this.numberToAddSpinner.getValue();
        }
        if (numberOfTurnouts >= 65 && JmriJOptionPane.showConfirmDialog(this.addFrame, Bundle.getMessage("WarnExcessBeans", Bundle.getMessage("Turnouts"), numberOfTurnouts), Bundle.getMessage("WarningTitle"), 0) != 0) {
            return;
        }
        String prefix = ((Manager)Objects.requireNonNull(this.prefixBox.getSelectedItem())).getSystemPrefix();
        String curAddress = this.hardwareAddressTextField.getText();
        if (curAddress.length() < 1) {
            this.statusBarLabel.setText(Bundle.getMessage("WarningEmptyHardwareAddress"));
            this.statusBarLabel.setForeground(Color.red);
            this.hardwareAddressTextField.setBackground(Color.red);
            return;
        }
        this.hardwareAddressTextField.setBackground(Color.white);
        String uName = this.userNameTextField.getText();
        if (uName.isEmpty()) {
            uName = null;
        }
        StringBuilder statusMessage = new StringBuilder(Bundle.getMessage("ItemCreateFeedback", Bundle.getMessage("BeanNameTurnout")));
        Object sName = prefix + InstanceManager.getDefault(TurnoutManager.class).typeLetter() + curAddress;
        int iType = 0;
        int iNum = 1;
        boolean useLastBit = false;
        boolean useLastType = false;
        for (int x = 0; x < numberOfTurnouts; ++x) {
            Turnout t;
            StringBuilder sb = new StringBuilder((String)sName);
            int prefixLength = Manager.getSystemPrefixLength((String)sName);
            sb.replace(prefixLength, prefixLength + 1, "L");
            String testSN = new String(sb);
            log.trace("{} maps to {}", sName, (Object)testSN);
            Light testLight = InstanceManager.lightManagerInstance().getBySystemName(testSN);
            if (testLight != null) {
                log.warn("Requested Turnout {} uses same address as Light {}", sName, (Object)testSN);
                if (!this.noWarn) {
                    int selectedValue = JmriJOptionPane.showOptionDialog(this.addFrame, Bundle.getMessage("TurnoutWarn1", sName, testSN) + ".\n" + Bundle.getMessage("TurnoutWarn3"), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYesPlus")}, Bundle.getMessage("ButtonNo"));
                    if (selectedValue == 1) {
                        this.statusBarLabel.setText(Bundle.getMessage("WarningOverlappingAddress", sName));
                        this.statusBarLabel.setForeground(Color.gray);
                        return;
                    }
                    if (selectedValue == 2) {
                        this.noWarn = true;
                    }
                }
            }
            if (!useLastBit) {
                iNum = InstanceManager.getDefault(TurnoutManager.class).askNumControlBits((String)sName);
                if (InstanceManager.getDefault(TurnoutManager.class).isNumControlBitsSupported((String)sName) && this.rangeBox.isSelected()) {
                    if (JmriJOptionPane.showConfirmDialog(this.addFrame, Bundle.getMessage("UseForAllTurnouts"), Bundle.getMessage("UseSetting"), 0) == 0) {
                        useLastBit = true;
                    }
                } else {
                    useLastBit = true;
                }
            }
            if (iNum == 0) {
                this.statusBarLabel.setText(Bundle.getMessage("WarningBitsNotSupported", sName));
                this.statusBarLabel.setForeground(Color.red);
                return;
            }
            try {
                t = InstanceManager.getDefault(TurnoutManager.class).provideTurnout((String)sName);
            }
            catch (IllegalArgumentException ex) {
                this.handleCreateException(ex, (String)sName);
                return;
            }
            if (uName != null && !uName.isEmpty()) {
                if (InstanceManager.getDefault(TurnoutManager.class).getByUserName(uName) == null) {
                    t.setUserName(uName);
                } else if (!this.pref.getPreferenceState(this.getClassName(), "duplicateUserName")) {
                    InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorDuplicateUserName", uName), this.getClassName(), "duplicateUserName", false, true);
                }
            }
            t.setNumberControlBits(iNum);
            if (!useLastType) {
                iType = InstanceManager.getDefault(TurnoutManager.class).askControlType((String)sName);
                if (InstanceManager.getDefault(TurnoutManager.class).isControlTypeSupported((String)sName) && this.rangeBox.isSelected() && JmriJOptionPane.showConfirmDialog(this.addFrame, Bundle.getMessage("UseForAllTurnouts"), Bundle.getMessage("UseSetting"), 0) == 0) {
                    useLastType = true;
                }
            }
            t.setControlType(iType);
            if (x == 0 || x == numberOfTurnouts - 1) {
                statusMessage.append(" ").append((String)sName).append(" (").append(uName).append(")");
            }
            if (x == numberOfTurnouts - 2) {
                statusMessage.append(" ").append(Bundle.getMessage("ItemCreateUpTo")).append(" ");
            }
            if (x >= numberOfTurnouts - 1) continue;
            try {
                sName = InstanceManager.getDefault(TurnoutManager.class).getNextValidSystemName(t);
            }
            catch (JmriException ex) {
                this.displayHwError(curAddress, ex);
                this.statusBarLabel.setText(Bundle.getMessage("ErrorConvertHW", curAddress));
                this.statusBarLabel.setForeground(Color.red);
                return;
            }
            if (uName == null || uName.isEmpty()) continue;
            uName = this.nextName(uName);
        }
        this.statusBarLabel.setText(statusMessage.toString());
        this.statusBarLabel.setForeground(Color.gray);
        this.pref.setComboBoxLastSelection(this.systemSelectionCombo, this.prefixBox.getSelectedItem().getMemo().getUserName());
        this.removePrefixBoxListener(this.prefixBox);
        this.addFrame.setVisible(false);
        this.addFrame.dispose();
        this.addFrame = null;
    }

    private void canAddRange(ActionEvent e) {
        this.rangeBox.setEnabled(false);
        log.debug("T Add box disabled");
        this.rangeBox.setSelected(false);
        if (this.prefixBox.getSelectedIndex() == -1) {
            this.prefixBox.setSelectedIndex(0);
        }
        Object manager = this.prefixBox.getSelectedItem();
        assert (manager != null);
        String systemPrefix = manager.getSystemPrefix();
        this.rangeBox.setEnabled(((TurnoutManager)manager).allowMultipleAdditions(systemPrefix));
        this.addEntryToolTip = manager.getEntryToolTip();
        this.hardwareAddressTextField.setToolTipText(Bundle.getMessage("AddEntryToolTipLine1", manager.getMemo().getUserName(), Bundle.getMessage("Turnouts"), this.addEntryToolTip));
        this.hardwareAddressValidator.setToolTipText(this.hardwareAddressTextField.getToolTipText());
        this.hardwareAddressValidator.verify(this.hardwareAddressTextField);
    }

    void handleCreateException(Exception ex, String sysName) {
        String err = Bundle.getMessage("ErrorBeanCreateFailed", InstanceManager.getDefault(TurnoutManager.class).getBeanTypeHandled(), sysName);
        if (ex.getMessage() != null) {
            this.statusBarLabel.setText(ex.getLocalizedMessage());
            JmriJOptionPane.showMessageDialog(this.addFrame, ex.getLocalizedMessage(), err, 0);
        } else {
            this.statusBarLabel.setText(Bundle.getMessage("WarningInvalidRange"));
            JmriJOptionPane.showMessageDialog(this.addFrame, err + "\n" + Bundle.getMessage("ErrorAddFailedCheck"), err, 0);
        }
        this.statusBarLabel.setForeground(Color.red);
    }

    @Override
    protected String getClassName() {
        return TurnoutTableAction.class.getName();
    }

    @Override
    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "duplicateUserName", Bundle.getMessage("DuplicateUserNameWarn"));
        super.setMessagePreferencesDetails();
    }

    @Override
    public String getClassDescription() {
        return Bundle.getMessage("TitleTurnoutTable");
    }
}

