/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.beanedit;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.UserPreferencesManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.beantable.BlockTableAction;
import jmri.jmrit.beantable.beanedit.BeanEditAction;
import jmri.jmrit.beantable.beanedit.BeanEditItem;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.Bundle;
import jmri.jmrit.beantable.beanedit.SensorDebounceEditAction;
import jmri.jmrit.beantable.block.BlockCurvatureJComboBox;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.swing.NamedBeanComboBox;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;

public class BlockEditAction
extends BeanEditAction<Block> {
    static final Vector<String> speedList = new Vector();
    private NamedBeanComboBox<Reporter> reporterComboBox;
    private final JCheckBox useCurrent = new JCheckBox();
    private final JSpinner lengthSpinner = new JSpinner();
    private final BlockCurvatureJComboBox curvatureField = new BlockCurvatureJComboBox();
    private final JCheckBox permissiveField = new JCheckBox();
    private final JCheckBox ghostField = new JCheckBox();
    private JComboBox<String> speedField;
    private final JRadioButton inch = new JRadioButton(Bundle.getMessage("LengthInches"));
    private final JRadioButton cm = new JRadioButton(Bundle.getMessage("LengthCentimeters"));
    protected boolean metricUi = InstanceManager.getDefault(UserPreferencesManager.class).getSimplePreferenceState(BlockTableAction.BLOCK_METRIC_PREF);
    private NamedBeanComboBox<Sensor> sensorComboBox;

    @Override
    public String helpTarget() {
        return "package.jmri.jmrit.beantable.BlockEdit";
    }

    @Override
    protected void initPanels() {
        super.initPanels();
        this.sensor();
        this.reporterDetails();
        this.physicalDetails();
    }

    @Override
    public Block getByUserName(String name) {
        return (Block)InstanceManager.getDefault(BlockManager.class).getByUserName(name);
    }

    BeanItemPanel reporterDetails() {
        BeanItemPanel reporter = new BeanItemPanel();
        reporter.setName(Bundle.getMessage("BeanNameReporter"));
        this.reporterComboBox = new NamedBeanComboBox<Reporter>(InstanceManager.getDefault(ReporterManager.class), ((Block)this.bean).getReporter(), NamedBean.DisplayOptions.DISPLAYNAME);
        this.reporterComboBox.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(this.reporterComboBox);
        reporter.addItem(new BeanEditItem(this.reporterComboBox, Bundle.getMessage("BeanNameReporter"), Bundle.getMessage("BlockReporterText")));
        this.reporterComboBox.addActionListener(e -> this.useCurrent.setEnabled(this.reporterComboBox.getSelectedItem() != null));
        reporter.addItem(new BeanEditItem(this.useCurrent, Bundle.getMessage("BlockReporterCurrent"), Bundle.getMessage("BlockUseCurrentText")));
        reporter.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlockEditAction.this.reporterComboBox.setSelectedItem(((Block)BlockEditAction.this.bean).getReporter());
                BlockEditAction.this.useCurrent.setSelected(((Block)BlockEditAction.this.bean).isReportingCurrent());
                BlockEditAction.this.useCurrent.setEnabled(((Block)BlockEditAction.this.bean).getReporter() != null);
            }
        });
        reporter.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Block)BlockEditAction.this.bean).setReporter((Reporter)BlockEditAction.this.reporterComboBox.getSelectedItem());
                ((Block)BlockEditAction.this.bean).setReportingCurrent(BlockEditAction.this.useCurrent.isSelected());
            }
        });
        this.bei.add(reporter);
        if (InstanceManager.getNullableDefault(ReporterManager.class) == null) {
            this.setEnabled(false);
        }
        return reporter;
    }

    BeanItemPanel physicalDetails() {
        String defaultBlockSpeedText = Bundle.getMessage("UseGlobal", "Global") + " " + InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        speedList.add(defaultBlockSpeedText);
        Vector<String> _speedMap = InstanceManager.getDefault(SignalSpeedMap.class).getValidSpeedNames();
        for (int i = 0; i < _speedMap.size(); ++i) {
            if (speedList.contains(_speedMap.get(i))) continue;
            speedList.add(_speedMap.get(i));
        }
        BeanItemPanel basic = new BeanItemPanel();
        basic.setName(Bundle.getMessage("BlockPhysicalProperties"));
        basic.addItem(new BeanEditItem(null, null, Bundle.getMessage("BlockPropertiesText")));
        this.lengthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1000.0f), Float.valueOf(0.01f)));
        this.lengthSpinner.setEditor(new JSpinner.NumberEditor(this.lengthSpinner, "###0.00"));
        this.lengthSpinner.setPreferredSize(new JTextField(8).getPreferredSize());
        ButtonGroup rg = new ButtonGroup();
        rg.add(this.inch);
        rg.add(this.cm);
        JPanel p = new JPanel();
        p.add(this.inch);
        p.add(this.cm);
        p.setLayout(new BoxLayout(p, 1));
        this.inch.setSelected(!this.metricUi);
        this.cm.setSelected(this.metricUi);
        this.inch.addActionListener(e -> this.updateLength());
        this.cm.addActionListener(e -> this.updateLength());
        basic.addItem(new BeanEditItem(this.lengthSpinner, Bundle.getMessage("BlockLengthColName"), Bundle.getMessage("BlockLengthText")));
        basic.addItem(new BeanEditItem(p, Bundle.getMessage("BlockLengthUnits"), Bundle.getMessage("BlockLengthUnitsText")));
        basic.addItem(new BeanEditItem(this.curvatureField, Bundle.getMessage("BlockCurveColName"), ""));
        this.speedField = new JComboBox<String>(speedList);
        JComboBoxUtil.setupComboBoxMaxRows(this.speedField);
        basic.addItem(new BeanEditItem(this.speedField, Bundle.getMessage("BlockSpeedColName"), Bundle.getMessage("BlockMaxSpeedText")));
        basic.addItem(new BeanEditItem(this.permissiveField, Bundle.getMessage("BlockPermColName"), Bundle.getMessage("BlockPermissiveText")));
        this.permissiveField.setSelected(((Block)this.bean).getPermissiveWorking());
        basic.addItem(new BeanEditItem(this.ghostField, Bundle.getMessage("BlockGhostColName"), Bundle.getMessage("BlockGhostText")));
        this.ghostField.setSelected(((Block)this.bean).getIsGhost());
        basic.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Block)BlockEditAction.this.bean).setCurvature(BlockEditAction.this.curvatureField.getCurvature());
                String speed = (String)BlockEditAction.this.speedField.getSelectedItem();
                try {
                    ((Block)BlockEditAction.this.bean).setBlockSpeed(speed);
                }
                catch (JmriException ex) {
                    JmriJOptionPane.showMessageDialog(BlockEditAction.this.f, ex.getMessage() + "\n" + speed);
                    return;
                }
                if (!speedList.contains(speed) && !speed.contains("Global")) {
                    speedList.add(speed);
                }
                float len = ((Float)BlockEditAction.this.lengthSpinner.getValue()).floatValue();
                ((Block)BlockEditAction.this.bean).setLength(BlockEditAction.this.metricUi ? len * 10.0f : len * 25.4f);
                ((Block)BlockEditAction.this.bean).setPermissiveWorking(BlockEditAction.this.permissiveField.isSelected());
                ((Block)BlockEditAction.this.bean).setIsGhost(BlockEditAction.this.ghostField.isSelected());
            }
        });
        basic.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlockEditAction.this.curvatureField.setCurvature(((Block)BlockEditAction.this.bean).getCurvature());
                String speed = ((Block)BlockEditAction.this.bean).getBlockSpeed();
                if (!speedList.contains(speed)) {
                    speedList.add(speed);
                }
                BlockEditAction.this.speedField.setEditable(true);
                BlockEditAction.this.speedField.setSelectedItem(speed);
                BlockEditAction.this.updateLength();
                BlockEditAction.this.permissiveField.setSelected(((Block)BlockEditAction.this.bean).getPermissiveWorking());
                BlockEditAction.this.ghostField.setSelected(((Block)BlockEditAction.this.bean).getIsGhost());
            }
        });
        this.bei.add(basic);
        return basic;
    }

    private void updateLength() {
        this.metricUi = this.cm.isSelected();
        this.lengthSpinner.setValue(Float.valueOf(this.metricUi ? ((Block)this.bean).getLengthCm() : ((Block)this.bean).getLengthIn()));
    }

    BeanItemPanel sensor() {
        BeanItemPanel basic = new BeanItemPanel();
        basic.setName(Bundle.getMessage("BeanNameSensor"));
        this.sensorComboBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance(), ((Block)this.bean).getSensor(), NamedBean.DisplayOptions.DISPLAYNAME);
        this.sensorComboBox.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(this.sensorComboBox);
        basic.addItem(new BeanEditItem(this.sensorComboBox, Bundle.getMessage("BeanNameSensor"), Bundle.getMessage("BlockAssignSensorText")));
        final SensorDebounceEditAction debounce = new SensorDebounceEditAction();
        debounce.sensorDebounce(basic);
        this.sensorComboBox.addActionListener(e -> {
            debounce.setBean((Sensor)this.sensorComboBox.getSelectedItem());
            debounce.resetDebounceItems(e);
        });
        basic.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutBlock lBlk = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock((Block)BlockEditAction.this.bean);
                if (lBlk != null) {
                    lBlk.validateSensor(BlockEditAction.this.sensorComboBox.getSelectedItemDisplayName(), null);
                } else {
                    ((Block)BlockEditAction.this.bean).setSensor(BlockEditAction.this.sensorComboBox.getSelectedItemDisplayName());
                }
                debounce.saveDebounceItems(e);
            }
        });
        basic.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlockEditAction.this.sensorComboBox.setSelectedItem(((Block)BlockEditAction.this.bean).getSensor());
                debounce.setBean(((Block)BlockEditAction.this.bean).getSensor());
                debounce.resetDebounceItems(e);
            }
        });
        this.bei.add(basic);
        return basic;
    }
}

