/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.beanedit;

import java.awt.event.ActionEvent;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.Manager;
import jmri.ProxyManager;
import jmri.VariableLight;
import jmri.jmrit.beantable.beanedit.BeanEditAction;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.Bundle;
import jmri.jmrit.beantable.light.LightControlPane;
import jmri.jmrit.beantable.light.LightIntensityPane;

public class LightEditAction
extends BeanEditAction<Light> {
    private LightControlPane lcp;
    private LightIntensityPane lip;

    @Override
    protected void initPanels() {
        if (InstanceManager.getNullableDefault(LightManager.class) == null) {
            this.setEnabled(false);
        }
        super.initPanels();
        this.lightControlPanel();
        this.lightIntensityPanel();
        this.applyBut.setToolTipText(Bundle.getMessage("LightUpdateButtonHint"));
    }

    @Override
    public String helpTarget() {
        return "package.jmri.jmrit.beantable.LightAddEdit";
    }

    @Override
    public Light getByUserName(String name) {
        return InstanceManager.lightManagerInstance().getByUserName(name);
    }

    @Override
    protected void cancelButtonAction(ActionEvent e) {
        if (this.lcp != null) {
            this.lcp.dispose();
        }
        super.cancelButtonAction(e);
    }

    @Override
    BeanItemPanel propertiesDetails() {
        return null;
    }

    BeanItemPanel lightControlPanel() {
        BeanItemPanel lcPanel = new BeanItemPanel();
        lcPanel.setName(Bundle.getMessage("LightControllerTitlePlural"));
        this.lcp = new LightControlPane((Light)this.bean);
        lcPanel.add(this.lcp);
        lcPanel.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LightEditAction.this.lcp != null) {
                    LightEditAction.this.lcp.setToLight((Light)LightEditAction.this.bean);
                }
            }
        });
        lcPanel.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LightEditAction.this.lcp != null) {
                    LightEditAction.this.lcp.setLightFromControlTable((Light)LightEditAction.this.bean);
                }
            }
        });
        this.bei.add(lcPanel);
        return lcPanel;
    }

    BeanItemPanel lightIntensityPanel() {
        BeanItemPanel liPanel = new BeanItemPanel();
        liPanel.setName(Bundle.getMessage("LightVariableBorder"));
        this.lip = new LightIntensityPane(true);
        this.lip.setToLight((Light)this.bean);
        liPanel.add(this.lip);
        liPanel.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LightEditAction.this.lip != null) {
                    LightEditAction.this.lip.setToLight((Light)LightEditAction.this.bean);
                }
            }
        });
        liPanel.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LightEditAction.this.bean instanceof VariableLight && LightEditAction.this.lip != null) {
                    LightEditAction.this.lip.setLightFromPane((VariableLight)LightEditAction.this.bean);
                }
            }
        });
        this.bei.add(liPanel);
        if (!(this.bean instanceof VariableLight)) {
            liPanel.setEnabled(false);
            liPanel.setToolTipText(Bundle.getMessage("NoLightIntensityForHardware", this.getBeanManagerSystemUserName()));
        }
        return liPanel;
    }

    @Nonnull
    private String getBeanManagerSystemUserName() {
        Manager lm = InstanceManager.getDefault(LightManager.class);
        if (lm instanceof ProxyManager) {
            ProxyManager plm = (ProxyManager)lm;
            for (Manager m : plm.getManagerList()) {
                if (m.getBySystemName(((Light)this.bean).getSystemName()) == null) continue;
                return m.getMemo().getUserName();
            }
        }
        return "";
    }
}

