/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.beanedit;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Reporter;
import jmri.Sensor;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.beantable.beanedit.BeanEditAction;
import jmri.jmrit.beantable.beanedit.BeanEditItem;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.Bundle;
import jmri.jmrit.beantable.beanedit.SensorDebounceEditAction;
import jmri.jmrit.beantable.block.BlockCurvatureJComboBox;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.swing.NamedBeanComboBox;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;

public class OBlockEditAction
extends BeanEditAction<OBlock> {
    static final Vector<String> speedList = new Vector();
    private String tabName = Bundle.getMessage("BeanNameOBlock");
    NamedBeanComboBox<Reporter> reporterComboBox;
    JCheckBox useCurrent = new JCheckBox();
    TableFrames.BlockPathJPanel blockPathPanel;
    NamedBeanComboBox<Sensor> sensorComboBox;
    NamedBeanComboBox<Sensor> errorSensorComboBox;
    JSpinner lengthSpinner = new JSpinner();
    private final BlockCurvatureJComboBox curvatureField = new BlockCurvatureJComboBox();
    JCheckBox permissiveField = new JCheckBox();
    JComboBox<String> speedField;
    JRadioButton inch = new JRadioButton(Bundle.getMessage("LengthInches"));
    JRadioButton cm = new JRadioButton(Bundle.getMessage("LengthCentimeters"));
    String defaultBlockSpeedText;

    public OBlockEditAction(ActionEvent ae) {
        if (ae != null) {
            this.tabName = ae.getActionCommand();
        }
    }

    @Override
    public String helpTarget() {
        return "package.jmri.jmrit.beantable.OBlockTable";
    }

    public void setTablePanel(TableFrames.BlockPathJPanel panel) {
        this.blockPathPanel = panel;
    }

    @Override
    protected void initPanels() {
        super.initPanels();
        this.sensor();
        this.paths();
        this.physicalDetails();
    }

    @Override
    public OBlock getByUserName(String name) {
        return (OBlock)InstanceManager.getDefault(OBlockManager.class).getByUserName(name);
    }

    BeanItemPanel sensor() {
        BeanItemPanel basic = new BeanItemPanel();
        basic.setName(Bundle.getMessage("BeanNameSensors"));
        this.sensorComboBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance(), ((OBlock)this.bean).getSensor(), NamedBean.DisplayOptions.DISPLAYNAME);
        this.sensorComboBox.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(this.sensorComboBox);
        basic.addItem(new BeanEditItem(this.sensorComboBox, Bundle.getMessage("BeanNameSensor"), Bundle.getMessage("OBlockAssignSensorText")));
        this.errorSensorComboBox = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance(), ((OBlock)this.bean).getErrorSensor(), NamedBean.DisplayOptions.DISPLAYNAME);
        this.errorSensorComboBox.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(this.errorSensorComboBox);
        basic.addItem(new BeanEditItem(this.errorSensorComboBox, Bundle.getMessage("ErrorSensorCol"), Bundle.getMessage("BlockAssignErrorSensorText")));
        final SensorDebounceEditAction debounce = new SensorDebounceEditAction();
        debounce.sensorDebounce(basic);
        this.sensorComboBox.addActionListener(e -> {
            debounce.setBean((Sensor)this.sensorComboBox.getSelectedItem());
            debounce.resetDebounceItems(e);
        });
        basic.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OBlockEditAction.this.sensorComboBox.getSelectedItem() == null) {
                    ((OBlock)OBlockEditAction.this.bean).setSensor(null);
                } else {
                    ((OBlock)OBlockEditAction.this.bean).setSensor(((Sensor)OBlockEditAction.this.sensorComboBox.getSelectedItem()).getDisplayName());
                }
                if (OBlockEditAction.this.errorSensorComboBox.getSelectedItem() == null) {
                    ((OBlock)OBlockEditAction.this.bean).setErrorSensor(null);
                } else {
                    ((OBlock)OBlockEditAction.this.bean).setErrorSensor(((Sensor)OBlockEditAction.this.errorSensorComboBox.getSelectedItem()).getDisplayName());
                }
            }
        });
        basic.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OBlockEditAction.this.sensorComboBox.setSelectedItem(((OBlock)OBlockEditAction.this.bean).getSensor());
                OBlockEditAction.this.errorSensorComboBox.setSelectedItem(((OBlock)OBlockEditAction.this.bean).getErrorSensor());
                debounce.setBean(((OBlock)OBlockEditAction.this.bean).getSensor());
                debounce.resetDebounceItems(e);
            }
        });
        this.bei.add(basic);
        return basic;
    }

    BeanItemPanel paths() {
        BeanItemPanel paths = new BeanItemPanel();
        String name = Bundle.getMessage("TitlePaths");
        paths.setName(name);
        paths.addItem(new BeanEditItem(this.blockPathPanel, Bundle.getMessage("PathTableLabel", ((OBlock)this.bean).getDisplayName()), null));
        paths.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.bei.add(paths);
        if (InstanceManager.getNullableDefault(OBlockManager.class) == null) {
            this.setEnabled(false);
        }
        if (name.equals(this.tabName)) {
            this.setSelectedComponent(paths);
        }
        return paths;
    }

    BeanItemPanel physicalDetails() {
        this.defaultBlockSpeedText = Bundle.getMessage("UseGlobal", "Global") + " " + InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        speedList.add(this.defaultBlockSpeedText);
        Vector<String> _speedMap = InstanceManager.getDefault(SignalSpeedMap.class).getValidSpeedNames();
        for (String s : _speedMap) {
            if (speedList.contains(s)) continue;
            speedList.add(s);
        }
        BeanItemPanel basic = new BeanItemPanel();
        basic.setName(Bundle.getMessage("BlockPhysicalProperties"));
        basic.addItem(new BeanEditItem(null, null, Bundle.getMessage("OBlockPropertiesText")));
        this.lengthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1000.0f), Float.valueOf(0.01f)));
        this.lengthSpinner.setEditor(new JSpinner.NumberEditor(this.lengthSpinner, "###0.00"));
        this.lengthSpinner.setPreferredSize(new JTextField(8).getPreferredSize());
        this.lengthSpinner.setValue(Float.valueOf(0.0f));
        basic.addItem(new BeanEditItem(this.lengthSpinner, Bundle.getMessage("BlockLengthColName"), Bundle.getMessage("OBlockLengthText")));
        ButtonGroup rg = new ButtonGroup();
        rg.add(this.inch);
        rg.add(this.cm);
        JPanel p = new JPanel();
        p.add(this.inch);
        p.add(this.cm);
        p.setLayout(new BoxLayout(p, 1));
        this.inch.setSelected(true);
        this.inch.addActionListener(e -> {
            this.cm.setSelected(!this.inch.isSelected());
            this.updateLength();
        });
        this.cm.addActionListener(e -> {
            this.inch.setSelected(!this.cm.isSelected());
            this.updateLength();
        });
        this.speedField = new JComboBox<String>(speedList);
        JComboBoxUtil.setupComboBoxMaxRows(this.speedField);
        basic.addItem(new BeanEditItem(p, Bundle.getMessage("BlockLengthUnits"), Bundle.getMessage("BlockLengthUnitsText")));
        basic.addItem(new BeanEditItem(this.curvatureField, Bundle.getMessage("BlockCurveColName"), ""));
        basic.addItem(new BeanEditItem(this.speedField, Bundle.getMessage("BlockSpeedColName"), Bundle.getMessage("BlockMaxSpeedText")));
        basic.addItem(new BeanEditItem(this.permissiveField, Bundle.getMessage("BlockPermColName"), Bundle.getMessage("BlockPermissiveText")));
        this.permissiveField.setSelected(((OBlock)this.bean).getPermissiveWorking());
        basic.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((OBlock)OBlockEditAction.this.bean).setCurvature(OBlockEditAction.this.curvatureField.getCurvature());
                String speed = (String)OBlockEditAction.this.speedField.getSelectedItem();
                try {
                    ((OBlock)OBlockEditAction.this.bean).setBlockSpeed(speed);
                }
                catch (JmriException ex) {
                    JmriJOptionPane.showMessageDialog(OBlockEditAction.this.f, ex.getMessage() + "\n" + speed);
                    return;
                }
                if (speed != null && !speedList.contains(speed) && !speed.contains("Global")) {
                    speedList.add(speed);
                }
                float len = ((Float)OBlockEditAction.this.lengthSpinner.getValue()).floatValue();
                ((OBlock)OBlockEditAction.this.bean).setLength(OBlockEditAction.this.inch.isSelected() ? len * 25.4f : len * 10.0f);
                ((OBlock)OBlockEditAction.this.bean).setPermissiveWorking(OBlockEditAction.this.permissiveField.isSelected());
            }
        });
        basic.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OBlockEditAction.this.lengthSpinner.setValue(Float.valueOf(((OBlock)OBlockEditAction.this.bean).getLengthMm()));
                OBlockEditAction.this.curvatureField.setCurvature(((OBlock)OBlockEditAction.this.bean).getCurvature());
                String speed = ((OBlock)OBlockEditAction.this.bean).getBlockSpeed();
                if (!speedList.contains(speed)) {
                    speedList.add(speed);
                }
                OBlockEditAction.this.speedField.setEditable(true);
                OBlockEditAction.this.speedField.setSelectedItem(speed);
                OBlockEditAction.this.updateLength();
                OBlockEditAction.this.permissiveField.setSelected(((OBlock)OBlockEditAction.this.bean).getPermissiveWorking());
            }
        });
        this.bei.add(basic);
        return basic;
    }

    private void updateLength() {
        this.lengthSpinner.setValue(Float.valueOf(this.inch.isSelected() ? ((OBlock)this.bean).getLengthIn() : ((OBlock)this.bean).getLengthCm()));
    }
}

