/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.beanedit;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.beantable.beanedit.BeanEditAction;
import jmri.jmrit.beantable.beanedit.BeanEditItem;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.Bundle;

public class SensorDebounceEditAction
extends BeanEditAction<Sensor> {
    private final JCheckBox sensorDebounceGlobalCheck = new JCheckBox();
    private final JSpinner sensorDebounceInactiveSpinner = new JSpinner();
    private final JSpinner sensorDebounceActiveSpinner = new JSpinner();

    @Override
    public String helpTarget() {
        return "package.jmri.jmrit.beantable.SensorAddEdit";
    }

    @Override
    public Sensor getByUserName(String name) {
        return InstanceManager.sensorManagerInstance().getByUserName(name);
    }

    @Override
    protected void initPanels() {
    }

    @Override
    public void setBean(Sensor bean) {
        super.setBean(bean);
        if (bean == null) {
            this.enabled(false);
        } else {
            this.resetDebounceItems(null);
            this.enabled(true);
        }
    }

    public BeanItemPanel sensorDebounce(BeanItemPanel basic) {
        if (basic == null) {
            basic = new BeanItemPanel();
            basic.setName(Bundle.getMessage("SensorDebounce"));
        }
        this.sensorDebounceGlobalCheck.addActionListener(e -> {
            this.sensorDebounceInactiveSpinner.setEnabled(!this.sensorDebounceGlobalCheck.isSelected());
            this.sensorDebounceActiveSpinner.setEnabled(!this.sensorDebounceGlobalCheck.isSelected());
        });
        this.sensorDebounceInactiveSpinner.setModel(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Sensor.MAX_DEBOUNCE, (Number)1L));
        this.sensorDebounceInactiveSpinner.setPreferredSize(new JTextField(Long.toString(Sensor.MAX_DEBOUNCE).length() + 1).getPreferredSize());
        this.sensorDebounceActiveSpinner.setModel(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Sensor.MAX_DEBOUNCE, (Number)1L));
        this.sensorDebounceActiveSpinner.setPreferredSize(new JTextField(Long.toString(Sensor.MAX_DEBOUNCE).length() + 1).getPreferredSize());
        basic.addItem(new BeanEditItem(null, null, Bundle.getMessage("SensorDebounceText")));
        basic.addItem(new BeanEditItem(this.sensorDebounceGlobalCheck, Bundle.getMessage("SensorDebounceUseGlobalText"), Bundle.getMessage("SensorGlobalActiveInactiveDelays", InstanceManager.getDefault(SensorManager.class).getDefaultSensorDebounceGoingActive(), InstanceManager.getDefault(SensorManager.class).getDefaultSensorDebounceGoingInActive())));
        basic.addItem(new BeanEditItem(this.sensorDebounceActiveSpinner, Bundle.getMessage("SensorActiveDebounce"), Bundle.getMessage("SensorActiveDebounceText")));
        basic.addItem(new BeanEditItem(this.sensorDebounceInactiveSpinner, Bundle.getMessage("SensorInActiveDebounce"), Bundle.getMessage("SensorInActiveDebounceText")));
        basic.setSaveItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorDebounceEditAction.this.saveDebounceItems(e);
            }
        });
        basic.setResetItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorDebounceEditAction.this.resetDebounceItems(e);
            }
        });
        return basic;
    }

    protected void saveDebounceItems(ActionEvent e) {
        if (this.bean == null) {
            return;
        }
        long time = (Long)this.sensorDebounceActiveSpinner.getValue();
        ((Sensor)this.bean).setSensorDebounceGoingActiveTimer(time);
        time = (Long)this.sensorDebounceInactiveSpinner.getValue();
        ((Sensor)this.bean).setSensorDebounceGoingInActiveTimer(time);
        ((Sensor)this.bean).setUseDefaultTimerSettings(this.sensorDebounceGlobalCheck.isSelected());
    }

    protected void resetDebounceItems(ActionEvent e) {
        if (this.bean == null) {
            this.enabled(false);
            return;
        }
        this.enabled(true);
        this.sensorDebounceGlobalCheck.setSelected(((Sensor)this.bean).getUseDefaultTimerSettings());
        this.sensorDebounceActiveSpinner.setEnabled(!((Sensor)this.bean).getUseDefaultTimerSettings());
        this.sensorDebounceInactiveSpinner.setEnabled(!((Sensor)this.bean).getUseDefaultTimerSettings());
        this.sensorDebounceActiveSpinner.setValue(((Sensor)this.bean).getSensorDebounceGoingActiveTimer());
        this.sensorDebounceInactiveSpinner.setValue(((Sensor)this.bean).getSensorDebounceGoingInActiveTimer());
    }

    public void enabled(Boolean boo) {
        this.sensorDebounceGlobalCheck.setEnabled(boo);
        this.sensorDebounceInactiveSpinner.setEnabled(boo);
        this.sensorDebounceActiveSpinner.setEnabled(boo);
    }
}

