/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.block;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jmri.Block;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.beantable.BeanTableJTable;
import jmri.jmrit.beantable.block.BlockTableDataModel;
import jmri.util.table.JComboBoxEditor;
import jmri.util.table.NamedBeanBoxRenderer;

public class BlockTableJTable
extends BeanTableJTable<Block>
implements Disposable {
    private final HashMap<Block, NamedBeanBoxRenderer<Sensor>> sensorComboMap = new HashMap();
    private final HashMap<Block, NamedBeanBoxRenderer<Reporter>> reporterComboMap = new HashMap();

    public BlockTableJTable(BlockTableDataModel blockTableDataModel) {
        super(blockTableDataModel);
        this.setDefaultRenderer(Float.class, new LengthRenderer());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        switch (this.convertColumnIndexToModel(column)) {
            case 10: {
                return this.getSensorRenderer(this.convertRowIndexToModel(row));
            }
            case 11: {
                return this.getReporterRenderer(this.convertRowIndexToModel(row));
            }
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        switch (this.convertColumnIndexToModel(column)) {
            case 10: {
                Block t = (Block)this.getModel().getValueAt(this.convertRowIndexToModel(row), 0);
                return new JComboBoxEditor((JComboBox)this.sensorComboMap.get(t), null);
            }
            case 11: {
                Block tt = (Block)this.getModel().getValueAt(this.convertRowIndexToModel(row), 0);
                return new JComboBoxEditor((JComboBox)this.reporterComboMap.get(tt), null);
            }
        }
        return super.getCellEditor(row, column);
    }

    private TableCellRenderer getSensorRenderer(int modelRow) {
        Block t = (Block)this.getModel().getValueAt(modelRow, 0);
        Objects.requireNonNull(t, "SYSNAMECOL column content must be nonnull");
        return this.sensorComboMap.computeIfAbsent(t, k -> new NamedBeanBoxRenderer(InstanceManager.getDefault(SensorManager.class)));
    }

    private TableCellRenderer getReporterRenderer(int modelRow) {
        Block t = (Block)this.getModel().getValueAt(modelRow, 0);
        Objects.requireNonNull(t, "SYSNAMECOL column content must be nonnull");
        return this.reporterComboMap.computeIfAbsent(t, k -> new NamedBeanBoxRenderer(InstanceManager.getDefault(ReporterManager.class)));
    }

    @Override
    public void dispose() {
        this.sensorComboMap.forEach((b, s) -> s.dispose());
        this.sensorComboMap.clear();
        this.reporterComboMap.forEach((b, r) -> r.dispose());
        this.reporterComboMap.clear();
    }

    private static class LengthRenderer
    extends DefaultTableCellRenderer {
        private static final DecimalFormat twoDigit = new DecimalFormat("0.00");

        private LengthRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Float && comp instanceof JLabel) {
                ((JLabel)comp).setText(twoDigit.format(value));
            }
            return comp;
        }
    }
}

