/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.light;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jmri.Light;
import jmri.LightControl;
import jmri.jmrit.beantable.light.AddEditSingleLightControlFrame;
import jmri.jmrit.beantable.light.Bundle;
import jmri.jmrit.beantable.light.LightControlTableModel;

public class LightControlPane
extends JPanel {
    private LightControlTableModel lightControlTableModel;
    private JButton addControl;
    private AddEditSingleLightControlFrame addEditCtrlFrame;
    private int defaultControlIndex = 0;

    public LightControlPane() {
        this.init();
    }

    public LightControlPane(Light l) {
        this.init();
        this.setToLight(l);
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.lightControlTableModel = new LightControlTableModel(this);
        JTable lightControlTable = new JTable(this.lightControlTableModel);
        this.lightControlTableModel.configureJTable(lightControlTable);
        lightControlTable.setPreferredScrollableViewportSize(new Dimension(600, 100));
        JScrollPane lightControlTableScrollPane = new JScrollPane(lightControlTable);
        this.add(lightControlTableScrollPane);
        this.addControl = new JButton(Bundle.getMessage("LightAddControlButton"));
        this.addControl.addActionListener(this::addControlPressed);
        this.addControl.setToolTipText(Bundle.getMessage("LightAddControlButtonHint"));
        JPanel panel35 = new JPanel();
        panel35.setLayout(new FlowLayout());
        panel35.add(this.addControl);
        this.add(panel35);
    }

    protected void addControlPressed(ActionEvent e) {
        SwingUtilities.invokeLater(() -> this.addEditControlWindow(null));
    }

    protected void updateControlPressed(LightControl oldControl, LightControl newControl) {
        this.lightControlTableModel.removeControl(oldControl);
        this.lightControlTableModel.addControl(newControl);
    }

    public void setLightFromControlTable(Light g) {
        g.deactivateLight();
        g.clearLightControls();
        this.getControlList().stream().map(control -> {
            control.setParentLight(g);
            return control;
        }).forEachOrdered(control -> g.addLightControl((LightControl)control));
        g.activateLight();
    }

    protected void editControlAction(@Nonnull LightControl lc) {
        this.addEditControlWindow(lc);
    }

    protected void addControlToTable(LightControl lc) {
        this.lightControlTableModel.addControl(lc);
    }

    public List<LightControl> getControlList() {
        return this.lightControlTableModel.getControlList();
    }

    public final void setToLight(Light l) {
        this.lightControlTableModel.setTableToLight(l);
    }

    protected int getLastSelectedControlIndex() {
        return this.defaultControlIndex;
    }

    protected void setLastSelectedControlIndex(int newIndex) {
        this.defaultControlIndex = newIndex;
    }

    private void addEditControlWindow(LightControl lc) {
        this.closeEditControlWindow();
        this.addEditCtrlFrame = new AddEditSingleLightControlFrame(this, lc);
    }

    protected void closeEditControlWindow() {
        if (this.addEditCtrlFrame != null) {
            this.addEditCtrlFrame.dispose();
            this.addEditCtrlFrame = null;
        }
    }

    public void dispose() {
        this.closeEditControlWindow();
    }
}

