/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.light;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightControl;
import jmri.implementation.DefaultLightControl;
import jmri.jmrit.beantable.LightTableAction;
import jmri.jmrit.beantable.light.Bundle;
import jmri.jmrit.beantable.light.LightControlPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class LightControlTableModel
extends AbstractTableModel {
    public static final int TYPE_COLUMN = 0;
    public static final int DESCRIPTION_COLUMN = 1;
    public static final int EDIT_COLUMN = 2;
    public static final int REMOVE_COLUMN = 3;
    private final LightControlPane lcp;
    private final ArrayList<LightControl> controlList = new ArrayList();
    protected static final String sensorControl = Bundle.getMessage("LightSensorControl");
    protected static final String fastClockControl = Bundle.getMessage("LightFastClockControl");
    protected static final String turnoutStatusControl = Bundle.getMessage("LightTurnoutStatusControl");
    protected static final String timedOnControl = Bundle.getMessage("LightTimedOnControl");
    protected static final String twoSensorControl = Bundle.getMessage("LightTwoSensorControl");
    protected static final String noControl = Bundle.getMessage("LightNoControl");
    static final String[] controlTypes = new String[]{noControl, sensorControl, fastClockControl, turnoutStatusControl, timedOnControl, twoSensorControl};

    protected static final List<String> getControlTypeTips() {
        ArrayList<String> typeTooltips = new ArrayList<String>();
        typeTooltips.add(null);
        typeTooltips.add(Bundle.getMessage("LightSensorControlTip"));
        typeTooltips.add(Bundle.getMessage("LightFastClockControlTip"));
        typeTooltips.add(Bundle.getMessage("LightTurnoutStatusControlTip", InstanceManager.turnoutManagerInstance().getClosedText(), InstanceManager.turnoutManagerInstance().getThrownText()));
        typeTooltips.add(Bundle.getMessage("LightTimedOnControlTip"));
        typeTooltips.add(Bundle.getMessage("LightTwoSensorControlTip"));
        return typeTooltips;
    }

    public static String getControlTypeText(int type) {
        switch (type) {
            case 1: {
                return sensorControl;
            }
            case 2: {
                return fastClockControl;
            }
            case 3: {
                return turnoutStatusControl;
            }
            case 4: {
                return timedOnControl;
            }
            case 5: {
                return twoSensorControl;
            }
        }
        return noControl;
    }

    public LightControlTableModel(LightControlPane pane) {
        this.lcp = pane;
    }

    public List<LightControl> getControlList() {
        return Collections.unmodifiableList(this.controlList);
    }

    public void setTableToLight(Light light) {
        this.controlList.clear();
        light.getLightControlList().forEach(lightControlList1 -> this.controlList.add(new DefaultLightControl((LightControl)lightControlList1)));
        this.fireTableDataChanged();
    }

    public void addControl(LightControl lc) {
        this.controlList.add(lc);
        this.fireTableDataChanged();
    }

    public void removeControl(LightControl lc) {
        this.controlList.remove(lc);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 2: 
            case 3: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.controlList.size();
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        switch (c) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return Bundle.getMessage("LightControlType");
        }
        if (col == 1) {
            return Bundle.getMessage("LightControlDescription");
        }
        return "";
    }

    @Override
    public Object getValueAt(int r, int c) {
        LightControl lc = this.controlList.get(r);
        switch (c) {
            case 0: {
                return LightControlTableModel.getControlTypeText(lc.getControlType());
            }
            case 1: {
                return LightTableAction.getDescriptionText(lc, lc.getControlType());
            }
            case 2: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 3: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            SwingUtilities.invokeLater(() -> this.lcp.editControlAction(this.controlList.get(row)));
        } else if (col == 3) {
            this.controlList.remove(row);
            this.fireTableDataChanged();
        }
    }

    protected void configureJTable(JTable table) {
        table.setRowSelectionAllowed(false);
        TableColumnModel lightControlColumnModel = table.getColumnModel();
        TableColumn typeColumn = lightControlColumnModel.getColumn(0);
        typeColumn.setResizable(true);
        typeColumn.setMinWidth(130);
        typeColumn.setMaxWidth(170);
        TableColumn descriptionColumn = lightControlColumnModel.getColumn(1);
        descriptionColumn.setResizable(true);
        descriptionColumn.setMinWidth(270);
        descriptionColumn.setMaxWidth(380);
        table.setDefaultRenderer(JButton.class, new ButtonRenderer());
        table.setDefaultEditor(JButton.class, new ButtonEditor(new JButton()));
        JButton testButton = new JButton(Bundle.getMessage("ButtonDelete"));
        table.setRowHeight(testButton.getPreferredSize().height);
        TableColumn editColumn = lightControlColumnModel.getColumn(2);
        editColumn.setResizable(false);
        editColumn.setMinWidth(new JButton((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width);
        TableColumn removeColumn = lightControlColumnModel.getColumn(3);
        removeColumn.setResizable(false);
        removeColumn.setMinWidth(testButton.getPreferredSize().width);
    }
}

