/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.light;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightControl;
import jmri.LightManager;
import jmri.Manager;
import jmri.VariableLight;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.LightTableAction;
import jmri.jmrit.beantable.beanedit.LightEditAction;
import jmri.jmrit.beantable.light.Bundle;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightTableDataModel
extends BeanTableDataModel<Light> {
    public static final int ENABLECOL = 5;
    public static final int INTENSITYCOL = 6;
    public static final int EDITCOL = 7;
    public static final int CONTROLCOL = 8;
    protected boolean _graphicState = false;
    private Manager<Light> lightManager;
    private static final Logger log = LoggerFactory.getLogger(LightTableDataModel.class);

    public LightTableDataModel() {
        this.initTable();
    }

    public LightTableDataModel(Manager<Light> mgr) {
        this.setManager(mgr);
        this.initTable();
    }

    private void initTable() {
        this._graphicState = InstanceManager.getDefault(GuiLafPreferencesManager.class).isGraphicTableState();
    }

    @Override
    @Nonnull
    public Manager<Light> getManager() {
        if (this.lightManager == null) {
            this.lightManager = InstanceManager.getDefault(LightManager.class);
        }
        return this.lightManager;
    }

    @Override
    protected final void setManager(@Nonnull Manager<Light> manager) {
        if (!(manager instanceof LightManager)) {
            return;
        }
        this.getManager().removePropertyChangeListener(this);
        if (this.sysNameList != null) {
            for (int i = 0; i < this.sysNameList.size(); ++i) {
                Light b = this.getBySystemName((String)this.sysNameList.get(i));
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
        this.lightManager = manager;
        this.getManager().addPropertyChangeListener(this);
        this.updateNameList();
    }

    @Override
    public int getColumnCount() {
        return 9 + this.getPropertyColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 7: {
                return "";
            }
            case 6: {
                return Bundle.getMessage("ColumnHeadIntensity");
            }
            case 5: {
                return Bundle.getMessage("ColumnHeadEnabled");
            }
            case 8: {
                return Bundle.getMessage("LightControllerTitlePlural");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 7: {
                return JButton.class;
            }
            case 6: {
                return Double.class;
            }
            case 5: {
                return Boolean.class;
            }
            case 8: {
                return String.class;
            }
            case 2: {
                return this._graphicState ? JLabel.class : JButton.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 1: 
            case 8: {
                return new JTextField((int)16).getPreferredSize().width;
            }
            case 7: {
                return new JButton((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width + 4;
            }
            case 5: 
            case 6: {
                return new JTextField((int)6).getPreferredSize().width;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 6: {
                return this.getValueAt(row, 0) instanceof VariableLight;
            }
            case 5: 
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public String getValue(String name) {
        Light l = this.lightManager.getBySystemName(name);
        return l == null ? "Failed to find " + name : l.describeState(l.getState());
    }

    @Override
    public Object getValueAt(int row, int col) {
        Light l = (Light)super.getValueAt(row, 0);
        if (l == null) {
            return null;
        }
        switch (col) {
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 6: {
                if (l instanceof VariableLight) {
                    return ((VariableLight)l).getTargetIntensity();
                }
                return 0.0;
            }
            case 5: {
                return l.getEnabled();
            }
            case 8: {
                StringBuilder sb = new StringBuilder();
                for (LightControl lc : l.getLightControlList()) {
                    sb.append(LightTableAction.getDescriptionText(lc, lc.getControlType()));
                    sb.append(" ");
                }
                return sb.toString();
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Light l = (Light)this.getValueAt(row, 0);
        if (l == null) {
            return;
        }
        switch (col) {
            case 7: {
                SwingUtilities.invokeLater(() -> this.editButton(l));
                break;
            }
            case 6: {
                try {
                    if (l instanceof VariableLight) {
                        double intensity = Math.max(0.0, Math.min(1.0, (Double)value));
                        ((VariableLight)l).setTargetIntensity(intensity);
                        break;
                    }
                    double intensity = (Double)value;
                    l.setCommandedState(intensity > 0.5 ? 2 : 4);
                }
                catch (IllegalArgumentException e1) {
                    JmriJOptionPane.showMessageDialog(null, e1.getMessage());
                }
                break;
            }
            case 5: {
                l.setEnabled(!l.getEnabled());
                break;
            }
            case 2: {
                this.clickOn(l);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    private void editButton(Light bean) {
        LightEditAction beanEdit = new LightEditAction();
        beanEdit.setBean(bean);
        beanEdit.actionPerformed(null);
    }

    @Override
    protected void doDelete(Light bean) {
        bean.deactivateLight();
        super.doDelete(bean);
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        return true;
    }

    @Override
    public Light getBySystemName(@Nonnull String name) {
        return this.lightManager.getBySystemName(name);
    }

    @Override
    public Light getByUserName(@Nonnull String name) {
        return InstanceManager.getDefault(LightManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return LightTableAction.class.getName();
    }

    @Override
    public void clickOn(Light t) {
        t.setState(t.getState() == 4 ? 2 : 4);
    }

    @Override
    public JButton configureButton() {
        return new JButton(" " + Bundle.getMessage("StateOff") + " ");
    }

    @Override
    protected void configValueColumn(JTable table) {
        log.debug("Light configValueColumn (I am {})", (Object)this);
        if (this._graphicState) {
            table.setDefaultEditor(JLabel.class, new ImageIconRenderer());
            table.setDefaultRenderer(JLabel.class, new ImageIconRenderer());
        } else {
            super.configValueColumn(table);
        }
    }

    static class ImageIconRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        protected JLabel label;
        protected String rootPath = "resources/icons/misc/switchboard/";
        protected char beanTypeChar = (char)76;
        protected String onIconPath = this.rootPath + this.beanTypeChar + "-on-s.png";
        protected String offIconPath = this.rootPath + this.beanTypeChar + "-off-s.png";
        protected BufferedImage onImage;
        protected BufferedImage offImage;
        protected ImageIcon onIcon;
        protected ImageIcon offIcon;
        protected int iconHeight = -1;

        ImageIconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            return this.updateLabel((String)value, row);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            return this.updateLabel((String)value, row);
        }

        public JLabel updateLabel(String value, final int row) {
            if (this.iconHeight > 0) {
                log.debug("TODO adjust table row height for Lights?");
            }
            if (value.equals(Bundle.getMessage("StateOff")) && this.offIcon != null) {
                this.label = new JLabel(this.offIcon);
                this.label.setVerticalAlignment(3);
                log.debug("offIcon set");
            } else if (value.equals(Bundle.getMessage("StateOn")) && this.onIcon != null) {
                this.label = new JLabel(this.onIcon);
                this.label.setVerticalAlignment(3);
                log.debug("onIcon set");
            } else if (value.equals(Bundle.getMessage("BeanStateInconsistent"))) {
                this.label = new JLabel("X", 0);
                this.label.setForeground(Color.red);
                log.debug("Light state inconsistent");
                this.iconHeight = 0;
            } else if (value.equals(Bundle.getMessage("LightStateIntermediate"))) {
                this.label = new JLabel("...", 0);
                log.debug("Light state in transition");
                this.iconHeight = 0;
            } else {
                this.label = new JLabel(value, 0);
                log.warn("Error reading icons for LightTable");
                this.iconHeight = 0;
            }
            this.label.setToolTipText(value);
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public final void mousePressed(MouseEvent evt) {
                    log.debug("Clicked on icon in row {}", (Object)row);
                    this.stopCellEditing();
                }
            });
            return this.label;
        }

        @Override
        public Object getCellEditorValue() {
            log.debug("getCellEditorValue, me = {})", (Object)this);
            return this.toString();
        }

        protected void loadIcons() {
            try {
                this.onImage = ImageIO.read(new File(this.onIconPath));
                this.offImage = ImageIO.read(new File(this.offIconPath));
            }
            catch (IOException ex) {
                log.error("error reading image from {} or {}", new Object[]{this.onIconPath, this.offIconPath, ex});
            }
            log.debug("Success reading images");
            int imageWidth = this.onImage.getWidth();
            int imageHeight = this.onImage.getHeight();
            Image smallOnImage = this.onImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            Image smallOffImage = this.offImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            this.onIcon = new ImageIcon(smallOnImage);
            this.offIcon = new ImageIcon(smallOffImage);
            this.iconHeight = this.onIcon.getIconHeight();
        }
    }
}

