/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrit.beantable.oblock.BlockPathTableModel;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.PathTurnoutTableModel;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockPathEditFrame
extends JmriJFrame {
    JLabel blockLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameOBlock")), 11);
    JLabel blockName = new JLabel();
    JLabel pathLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("PathName")), 11);
    protected JTextField pathUserName = new JTextField(15);
    JLabel fromPortalLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("FromPortal")), 11);
    JLabel toPortalLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ToPortal")), 11);
    String[] p0 = new String[]{""};
    protected final JComboBox<String> fromPortalComboBox = new JComboBox<String>(this.p0);
    protected final JComboBox<String> toPortalComboBox = new JComboBox<String>(this.p0);
    JLabel statusBar = new JLabel(Bundle.getMessage("AddXStatusInitial1", Bundle.getMessage("Path"), Bundle.getMessage("ButtonOK")), 10);
    private final JSpinner lengthSpinner = new JSpinner();
    private final JRadioButton inch = new JRadioButton(Bundle.getMessage("LengthInches"));
    private final JRadioButton cm = new JRadioButton(Bundle.getMessage("LengthCentimeters"));
    private final BlockPathEditFrame frame = this;
    private boolean _newPath = false;
    PortalManager pm;
    private final OBlock _block;
    private OPath _path;
    TableFrames _core;
    BlockPathTableModel _pathmodel;
    PathTurnoutTableModel _tomodel;
    TableFrames.PathTurnoutJPanel _turnoutTablePane;
    protected UserPreferencesManager pref;
    protected boolean isDirty = false;
    private boolean checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    private static final Logger log = LoggerFactory.getLogger(BlockPathEditFrame.class);

    public BlockPathEditFrame(String title, @Nonnull OBlock block, @CheckForNull OPath path, @CheckForNull TableFrames.PathTurnoutJPanel turnouttable, BlockPathTableModel pathmodel, TableFrames parent) {
        super(title, true, true);
        this._block = block;
        this._turnoutTablePane = turnouttable;
        this._pathmodel = pathmodel;
        this._core = parent;
        if (path == null || turnouttable == null) {
            this._newPath = true;
        } else {
            if (path.getBlock() != null && path.getBlock() != block) {
                log.error("BlockPathEditFrame for OPath {}, but it is not part of OBlock {}", (Object)path.getName(), (Object)block.getDisplayName());
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("OBlockEditWrongPath", path.getName(), block.getDisplayName()), Bundle.getMessage("ErrorTitle"), 0);
                this.closeFrame();
                return;
            }
            this._path = path;
            this._tomodel = turnouttable.getModel();
            if (this._tomodel != null) {
                log.debug("TurnoutModel.size = {}", (Object)this._tomodel.getRowCount());
            }
        }
        this.pm = InstanceManager.getDefault(PortalManager.class);
        for (Portal pi : this.pm.getPortalSet()) {
            if (pi.getFromBlock() != this._block && pi.getToBlock() != this._block) continue;
            this.fromPortalComboBox.addItem(pi.getName());
            this.toPortalComboBox.addItem(pi.getName());
        }
        this.layoutFrame();
        this.blockName.setText(this._block.getDisplayName());
        if (this._newPath) {
            this.resetFrame();
        } else {
            this.populateFrame(path);
        }
        this.addCloseListener(this);
    }

    public void layoutFrame() {
        this.frame.addHelpMenu("package.jmri.jmrit.beantable.OBlockTable", true);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.setSize(400, 500);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JPanel configGrid = new JPanel();
        GridLayout layout = new GridLayout(4, 2, 10, 0);
        configGrid.setLayout(layout);
        configGrid.add(this.blockLabel);
        configGrid.add(this.blockName);
        configGrid.add(this.pathLabel);
        JPanel p1 = new JPanel();
        p1.add(this.pathUserName);
        configGrid.add(p1);
        configGrid.add(this.fromPortalLabel);
        this.fromPortalComboBox.addActionListener(e -> {
            if (this.fromPortalComboBox.getItemCount() > 0 && this.fromPortalComboBox.getSelectedItem() != null && this.toPortalComboBox.getSelectedItem() != null && this.fromPortalComboBox.getSelectedItem().equals(this.toPortalComboBox.getSelectedItem())) {
                log.debug("resetting ToPortal");
                this.toPortalComboBox.setSelectedIndex(0);
            }
        });
        configGrid.add(this.fromPortalComboBox);
        configGrid.add(this.toPortalLabel);
        this.toPortalComboBox.addActionListener(e -> {
            if (this.fromPortalComboBox.getItemCount() > 0 && this.fromPortalComboBox.getSelectedItem() != null && this.toPortalComboBox.getSelectedItem() != null && this.fromPortalComboBox.getSelectedItem().equals(this.toPortalComboBox.getSelectedItem())) {
                log.debug("resetting FromPortal");
                this.fromPortalComboBox.setSelectedIndex(0);
            }
        });
        configGrid.add(this.toPortalComboBox);
        p.add(configGrid);
        JPanel physical = new JPanel();
        this.lengthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1000.0f), Float.valueOf(0.01f)));
        this.lengthSpinner.setEditor(new JSpinner.NumberEditor(this.lengthSpinner, "###0.00"));
        this.lengthSpinner.setPreferredSize(new JTextField(8).getPreferredSize());
        this.lengthSpinner.setValue(Float.valueOf(0.0f));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.inch);
        bg.add(this.cm);
        p1 = new JPanel();
        p1.add(this.inch);
        p1.add(this.cm);
        p1.setLayout(new BoxLayout(p1, 3));
        this.inch.setSelected(true);
        this.inch.addActionListener(e -> {
            this.cm.setSelected(!this.inch.isSelected());
            this.updateLength();
        });
        this.cm.addActionListener(e -> {
            this.inch.setSelected(!this.cm.isSelected());
            this.updateLength();
        });
        physical.add(p1);
        JPanel p2 = new JPanel();
        p2.add(this.lengthSpinner);
        this.lengthSpinner.setToolTipText(Bundle.getMessage("LengthToolTip", Bundle.getMessage("Path")));
        physical.add(p2);
        p.add(physical);
        JPanel totbl = new JPanel();
        totbl.setLayout(new BorderLayout(10, 10));
        totbl.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        totbl.add((Component)this._turnoutTablePane, "Center");
        p.add(totbl);
        p2 = new JPanel();
        this.statusBar.setFont(this.statusBar.getFont().deriveFont(0.9f * (float)this.blockName.getFont().getSize()));
        this.statusBar.setForeground(Color.gray);
        p2.add(this.statusBar);
        p.add(p2);
        p.add(Box.createVerticalGlue());
        p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 2));
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        p2.add(cancel);
        cancel.addActionListener(e -> this.closeFrame());
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        p2.add(ok);
        ok.addActionListener(this::okPressed);
        p.add((Component)p2, "South");
        this.frame.getContentPane().add(p);
    }

    public void resetFrame() {
        this.pathUserName.setText(null);
        if (this.toPortalComboBox.getItemCount() < 2) {
            this.status(Bundle.getMessage("NotEnoughPortals"), true);
        } else {
            this.status(Bundle.getMessage("AddXStatusInitial1", Bundle.getMessage("Path"), Bundle.getMessage("ButtonCreate")), false);
        }
        this.lengthSpinner.setValue(Float.valueOf(0.0f));
        this._newPath = true;
    }

    public void populateFrame(OPath p) {
        if (p == null) {
            throw new IllegalArgumentException("Null OPath object");
        }
        this.pathUserName.setText(p.getName());
        if (p.getFromPortal() != null) {
            log.debug("BPEF FROMPORTAL name = {}", (Object)p.getFromPortal().getName());
            this.fromPortalComboBox.setSelectedItem(p.getFromPortal().getName());
        }
        if (p.getToPortal() != null) {
            log.debug("BPEF TOPORTAL name = {}", (Object)p.getToPortal().getName());
            this.toPortalComboBox.setSelectedItem(p.getToPortal().getName());
        }
        if (this._block.isMetric()) {
            this.cm.setSelected(true);
            this.lengthSpinner.setValue(Float.valueOf(this._path.getLengthCm()));
        } else {
            this.inch.setSelected(true);
            this.lengthSpinner.setValue(Float.valueOf(this._path.getLengthIn()));
        }
        this.status(Bundle.getMessage("AddXStatusInitial3", Bundle.getMessage("Path"), Bundle.getMessage("ButtonOK")), false);
        this._newPath = false;
    }

    protected void okPressed(ActionEvent e) {
        String user = this.pathUserName.getText().trim();
        if (user.equals("") || this._newPath && this._block.getPathByName(user) != null) {
            this.status(user.equals("") ? Bundle.getMessage("WarningSysNameEmpty") : Bundle.getMessage("DuplPathName", user), true);
            this.pathUserName.setBackground(Color.red);
            log.debug("username empty");
            return;
        }
        if (this._newPath) {
            Portal fromPortal = this._block.getPortalByName((String)this.fromPortalComboBox.getSelectedItem());
            Portal toPortal = this._block.getPortalByName((String)this.toPortalComboBox.getSelectedItem());
            if (fromPortal != null || toPortal != null) {
                this._path = new OPath(user, this._block, fromPortal, toPortal, null);
                if (!this._block.addPath(this._path)) {
                    this.status(Bundle.getMessage("AddPathFailed", user), true);
                } else {
                    this._pathmodel.initTempRow();
                    this._core.updateOBlockTablesMenu();
                    this._pathmodel.fireTableDataChanged();
                    this.closeFrame();
                }
            } else {
                log.debug("_newPath - could not get from/to Portal from this OBlock");
            }
        } else if (!this._path.getName().equals(user)) {
            this._path.setName(user);
        }
        try {
            if (!this.setPortal(this.fromPortalComboBox, this.toPortalComboBox, true)) {
                return;
            }
            if (!this.setPortal(this.toPortalComboBox, this.fromPortalComboBox, false)) {
                return;
            }
            this._path.setLength(((Float)this.lengthSpinner.getValue()).floatValue() * (this.cm.isSelected() ? 10.0f : 25.4f));
            this._block.setMetricUnits(this.cm.isSelected());
        }
        catch (IllegalArgumentException ex) {
            JmriJOptionPane.showMessageDialog(this, ex.getMessage(), Bundle.getMessage("PathCreateErrorTitle"), 0);
            this.status(Bundle.getMessage("AddPathFailed", user), true);
            return;
        }
        if (this._pathmodel != null) {
            this._pathmodel.fireTableDataChanged();
        }
        this._core.setPathEdit(false);
        log.debug("BlockPathEditFrame.okPressed complete. pathEdit = false");
        this.closeFrame();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setPortal(JComboBox<String> portalBox, JComboBox<String> compareBox, boolean isFrom) {
        if (portalBox.getSelectedIndex() <= 0) {
            log.debug("fromPortal no selection, require 1 so check toPortal is not empty");
            if (compareBox.getSelectedIndex() <= 0) {
                this.status(Bundle.getMessage("WarnPortalOnPath"), true);
                return false;
            }
            if (isFrom) {
                this._path.setFromPortal(null);
            } else {
                this._path.setToPortal(null);
            }
            log.debug("removed {}Portal", (Object)(isFrom ? "From" : "To"));
            return true;
        }
        String portalName = (String)portalBox.getSelectedItem();
        log.debug("looking for {}Portal {} (combo item {})", new Object[]{isFrom ? "From" : "To", portalName, portalBox.getSelectedIndex()});
        Portal portal = this._block.getPortalByName(portalName);
        if (portal == null || this.pm.getPortal(portalName) == null) {
            int val = this._core.verifyWarning(Bundle.getMessage("BlockPortalConflict", portalName, this._block.getDisplayName()));
            if (val == 2) {
                return false;
            }
            portal = this.pm.providePortal(portalName);
            if (isFrom) {
                if (!portal.setFromBlock(this._block, false)) {
                    val = this._core.verifyWarning(Bundle.getMessage("BlockPathsConflict", portalName, portal.getFromBlockName()));
                }
            } else if (!portal.setToBlock(this._block, false)) {
                val = this._core.verifyWarning(Bundle.getMessage("BlockPathsConflict", portalName, portal.getToBlockName()));
            }
            if (val == 2) {
                return false;
            }
            log.debug("fromPortal == null");
            portal.setFromBlock(this._block, true);
        }
        if (isFrom) {
            this._path.setFromPortal(portal);
        } else {
            this._path.setToPortal(portal);
        }
        if (portal.addPath(this._path)) return true;
        this.status(Bundle.getMessage("AddPathFailed", portalName), true);
        return false;
    }

    protected void closeFrame() {
        if (this.isDirty) {
            this.showReminderMessage();
            this.isDirty = false;
        }
        this.setVisible(false);
        if (this._tomodel != null) {
            this._tomodel.dispose();
        }
        this._core.setPathEdit(false);
        log.debug("BlockPathEditFrame.closeFrame pathEdit=False");
        this.dispose();
    }

    protected void showReminderMessage() {
        if (this.checkEnabled) {
            return;
        }
        InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemOBlockTable")), "BlockPathEditFrame", "remindSaveOBlock");
    }

    private void updateLength() {
        float len = ((Float)this.lengthSpinner.getValue()).floatValue();
        if (this.inch.isSelected()) {
            this.lengthSpinner.setValue(Float.valueOf(len / 2.54f));
        } else {
            this.lengthSpinner.setValue(Float.valueOf(len * 2.54f));
        }
    }

    void status(String message, boolean warn) {
        this.statusBar.setText(message);
        this.statusBar.setForeground(warn ? Color.red : Color.gray);
    }

    void addCloseListener(final JmriJFrame frame) {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BlockPathEditFrame.this._core.setPathEdit(false);
                log.debug("BlockPathEditFrame.closeFrame pathEdit=False");
                frame.dispose();
            }
        });
    }
}

