/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.PortalEditFrame;
import jmri.jmrit.beantable.oblock.TableFrames;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalTableModel
extends AbstractTableModel
implements PropertyChangeListener,
Disposable {
    public static final int FROM_BLOCK_COLUMN = 0;
    public final int NAME_COLUMN = 1;
    public static final int TO_BLOCK_COLUMN = 2;
    public static final int DELETE_COL = 3;
    public static final int EDIT_COL = 4;
    public static final int NUMCOLS = 4;
    private final PortalManager _manager;
    private final String[] tempRow = new String[4];
    private final boolean _tabbed;
    private final TableFrames _parent;
    private static final Logger log = LoggerFactory.getLogger(PortalTableModel.class);

    public PortalTableModel(@Nonnull TableFrames parent) {
        this._parent = parent;
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
        this._manager = InstanceManager.getDefault(PortalManager.class);
        if (!this._tabbed) {
            this.initTempRow();
        }
    }

    public void initListeners() {
        this._manager.addPropertyChangeListener(this);
    }

    private void initTempRow() {
        for (int i = 0; i < 4; ++i) {
            this.tempRow[i] = null;
        }
        this.tempRow[3] = Bundle.getMessage("ButtonClear");
    }

    @Override
    public int getColumnCount() {
        return 4 + (this._tabbed ? 1 : 0);
    }

    @Override
    public int getRowCount() {
        return this._manager.getPortalCount() + (this._tabbed ? 0 : 1);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("FromBlockName");
            }
            case 1: {
                return Bundle.getMessage("PortalName");
            }
            case 2: {
                return Bundle.getMessage("OppBlockName");
            }
            case 4: {
                return "  ";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        log.debug("getValueAt row= {} col= {}", (Object)row, (Object)col);
        if (row == this._manager.getPortalCount()) {
            return this.tempRow[col];
        }
        Portal portal = this._manager.getPortal(row);
        if (portal == null) {
            if (col == 3) {
                return Bundle.getMessage("ButtonClear");
            }
            return this.tempRow[col];
        }
        switch (col) {
            case 0: {
                return portal.getFromBlockName();
            }
            case 1: {
                return portal.getName();
            }
            case 2: {
                return portal.getToBlockName();
            }
            case 3: {
                return Bundle.getMessage("ButtonDelete");
            }
            case 4: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String msg = null;
        if (row == this._manager.getPortalCount()) {
            if (col == 3) {
                this.initTempRow();
                this.fireTableRowsUpdated(row, row);
                return;
            }
            String str = (String)value;
            if (str == null || str.trim().length() == 0) {
                this.tempRow[col] = null;
                return;
            }
            this.tempRow[col] = str.trim();
            OBlockManager oBlockMgr = InstanceManager.getDefault(OBlockManager.class);
            OBlock fromBlock = null;
            OBlock toBlock = null;
            if (this.tempRow[0] != null && (fromBlock = oBlockMgr.getOBlock(this.tempRow[0])) == null) {
                msg = Bundle.getMessage("NoSuchBlock", this.tempRow[0]);
            }
            if (msg == null && this.tempRow[2] != null && (toBlock = oBlockMgr.getOBlock(this.tempRow[2])) == null) {
                msg = Bundle.getMessage("NoSuchBlock", this.tempRow[2]);
            }
            if (msg == null && this.tempRow[1] != null) {
                if (fromBlock != null && toBlock != null) {
                    if (fromBlock.equals(toBlock)) {
                        msg = Bundle.getMessage("SametoFromBlock", fromBlock.getDisplayName());
                    } else {
                        Portal portal = this._manager.createNewPortal(this.tempRow[1]);
                        if (portal != null) {
                            portal.setToBlock(toBlock, false);
                            portal.setFromBlock(fromBlock, false);
                            this.initTempRow();
                            this.fireTableDataChanged();
                        } else {
                            msg = Bundle.getMessage("DuplPortalName", value);
                        }
                    }
                } else if (fromBlock == null ^ toBlock == null) {
                    msg = Bundle.getMessage("PortalNeedsBlock", this.tempRow[1]);
                }
            }
            if (msg != null) {
                JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
            }
            return;
        }
        Portal portal = this._manager.getPortal(row);
        if (portal == null) {
            log.error("Portal null, getValueAt row= {}, col= {}, portalListSize= {}", new Object[]{row, col, this._manager.getPortalCount()});
            return;
        }
        switch (col) {
            case 0: {
                int val;
                OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock((String)value);
                if (block == null) {
                    msg = Bundle.getMessage("NoSuchBlock", value);
                    break;
                }
                if (block.equals(portal.getToBlock())) {
                    msg = Bundle.getMessage("SametoFromBlock", block.getDisplayName());
                    break;
                }
                if (!portal.setFromBlock(block, false) && (val = this._parent.verifyWarning(Bundle.getMessage("BlockPathsConflict", value, portal.getFromBlockName()))) == 2) break;
                portal.setFromBlock(block, true);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 1: {
                msg = portal.setName((String)value);
                if (msg != null) break;
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 2: {
                int val;
                OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock((String)value);
                if (block == null) {
                    msg = Bundle.getMessage("NoSuchBlock", value);
                    break;
                }
                if (block.equals(portal.getFromBlock())) {
                    msg = Bundle.getMessage("SametoFromBlock", block.getDisplayName());
                    break;
                }
                if (!portal.setToBlock(block, false) && (val = this._parent.verifyWarning(Bundle.getMessage("BlockPathsConflict", value, portal.getToBlockName()))) == 2) break;
                portal.setToBlock(block, true);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 3: {
                if (!this.deletePortal(portal)) break;
                this.fireTableDataChanged();
                break;
            }
            case 4: {
                this.editPortal(portal);
                break;
            }
            default: {
                log.warn("Unhandled column: {}", (Object)col);
            }
        }
        if (msg != null) {
            JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 2);
        }
    }

    private boolean deletePortal(Portal portal) {
        int val = this._parent.verifyWarning(Bundle.getMessage("DeletePortalConfirm", portal.getName()));
        if (val != 2) {
            return portal.dispose();
        }
        return false;
    }

    private void editPortal(Portal portal) {
        if (this._tabbed) {
            PortalEditFrame portalFrame = new PortalEditFrame(Bundle.getMessage("TitleEditPortal", portal.getName()), portal, this);
            portalFrame.setVisible(true);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 3: 
            case 4: {
                return JButton.class;
            }
        }
        return String.class;
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return new JTextField((int)15).getPreferredSize().width;
            }
            case 3: 
            case 4: {
                return new JButton((String)"DELETE").getPreferredSize().width;
            }
        }
        return 5;
    }

    protected String getBeanType() {
        return "Portal";
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug("PropertyChangeEvent property = {} source= {}", (Object)property, (Object)e.getSource().getClass().getName());
        }
        switch (property) {
            case "pathCount": 
            case "numPortals": {
                this.initTempRow();
                this.fireTableDataChanged();
                break;
            }
            case "NameChange": {
                int row = this._manager.getIndexOf((Portal)e.getNewValue());
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case "signals": {
                this._parent.getSignalTableModel().propertyChange(e);
                break;
            }
        }
    }

    protected int verifyWarning(String message) {
        return this._parent.verifyWarning(message);
    }

    @Override
    public void dispose() {
        this._manager.removePropertyChangeListener(this);
    }
}

