/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.SignalTableModel;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalEditFrame
extends JmriJFrame {
    private final JPanel main = new JPanel();
    private final SignalTableModel model;
    private NamedBean signal;
    private final PortalManager pm;
    private final OBlockManager obm;
    private final SignalEditFrame frame = this;
    private Portal _portal;
    private SignalTableModel.SignalRow _sr;
    private final JLabel portalLabel = new JLabel(Bundle.getMessage("AtPortalLabel"), 11);
    private final JLabel signalMastLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameSignalMast")));
    private final JLabel signalHeadLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameSignalHead")));
    private final JLabel fromBlockLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("FromBlockName")));
    private final JLabel fromBlock = new JLabel();
    private final JLabel toBlockLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ToBlockName")));
    private final JLabel toBlock = new JLabel();
    private final JLabel mastName = new JLabel();
    private final JLabel headName = new JLabel();
    private final String[] p0 = new String[]{""};
    private final JComboBox<String> portalComboBox = new JComboBox<String>(this.p0);
    private final NamedBeanComboBox<SignalMast> sigMastComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalMastManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<SignalHead> sigHeadComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalHeadManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JButton flipButton = new JButton(Bundle.getMessage("ButtonFlipBlocks"));
    private final JSpinner lengthSpinner = new JSpinner();
    private final JRadioButton inch = new JRadioButton(Bundle.getMessage("LengthInches"));
    private final JRadioButton cm = new JRadioButton(Bundle.getMessage("LengthCentimeters"));
    private final JLabel statusBar = new JLabel(Bundle.getMessage("AddXStatusInitial1", Bundle.getMessage("BeanNameSignalMast") + "/" + Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("ButtonOK")));
    private boolean _newSignal;
    private static final Logger log = LoggerFactory.getLogger(SignalEditFrame.class);

    public SignalEditFrame(@Nonnull String title, @CheckForNull NamedBean signal, @CheckForNull SignalTableModel.SignalRow sr, @CheckForNull SignalTableModel model) {
        super(title, true, true);
        this.model = model;
        this.signal = signal;
        if (signal == null) {
            this._newSignal = true;
        }
        log.debug("SR == {}", (Object)(sr == null ? "null" : "not null"));
        this.obm = InstanceManager.getDefault(OBlockManager.class);
        this.pm = InstanceManager.getDefault(PortalManager.class);
        for (Portal pi : this.pm.getPortalSet()) {
            this.portalComboBox.addItem(pi.getName());
        }
        this.layoutFrame();
        if (sr != null) {
            this._sr = sr;
            this._portal = sr.getPortal();
            this.populateFrame(this._sr);
        } else {
            this.resetFrame();
        }
    }

    @Override
    public void initComponents() {
        this.addCloseListener(this);
    }

    public final void layoutFrame() {
        this.frame.addHelpMenu("package.jmri.jmrit.beantable.OBlockTable", true);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 3));
        this.frame.setSize(300, 200);
        this.main.setLayout(new BoxLayout(this.main, 3));
        JPanel configGrid = new JPanel();
        GridLayout layout = new GridLayout(4, 2, 10, 0);
        configGrid.setLayout(layout);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JPanel p1 = new JPanel();
        p1.add(this.signalMastLabel);
        p1.add(this.sigMastComboBox);
        this.sigMastComboBox.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(this.sigMastComboBox);
        p1.add(this.mastName);
        configGrid.add(p1);
        p1 = new JPanel();
        p1.add(this.signalHeadLabel);
        p1.add(this.sigHeadComboBox);
        this.sigHeadComboBox.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(this.sigHeadComboBox);
        p1.add(this.headName);
        configGrid.add(p1);
        this.sigMastComboBox.addActionListener(e -> {
            if (this.sigMastComboBox.getSelectedIndex() > 0 && this.sigHeadComboBox.getItemCount() > 0) {
                this.sigHeadComboBox.setSelectedIndex(0);
                this.model.checkDuplicateSignal((NamedBean)this.sigMastComboBox.getSelectedItem());
            }
        });
        this.sigHeadComboBox.addActionListener(e -> {
            if (this.sigHeadComboBox.getSelectedIndex() > 0 && this.sigMastComboBox.getItemCount() > 0) {
                this.sigMastComboBox.setSelectedIndex(0);
                this.model.checkDuplicateSignal((NamedBean)this.sigHeadComboBox.getSelectedItem());
            }
        });
        p1 = new JPanel();
        p1.add(this.portalLabel);
        p1.add(this.portalComboBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.portalComboBox);
        this.portalComboBox.addActionListener(e -> {
            if (this.portalComboBox.getSelectedIndex() > 0) {
                this.fromBlock.setText(this.pm.getPortal((String)this.portalComboBox.getSelectedItem()).getFromBlockName());
                this.toBlock.setText(this.pm.getPortal((String)this.portalComboBox.getSelectedItem()).getToBlockName());
            }
        });
        configGrid.add(p1);
        this.flipButton.addActionListener(e -> {
            String left = this.fromBlock.getText();
            this.fromBlock.setText(this.toBlock.getText());
            this.toBlock.setText(left);
        });
        p1 = new JPanel();
        p1.add(this.flipButton);
        this.flipButton.setToolTipText(Bundle.getMessage("FlipToolTip"));
        configGrid.add(p1);
        p1 = new JPanel();
        p1.add(this.fromBlockLabel);
        p1.add(this.fromBlock);
        configGrid.add(p1);
        p1 = new JPanel();
        p1.add(this.toBlockLabel);
        p1.add(this.toBlock);
        configGrid.add(p1);
        p1 = new JPanel();
        p1.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("Offset"))));
        this.lengthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(-2000.0f), Float.valueOf(2000.0f), Float.valueOf(0.01f)));
        this.lengthSpinner.setEditor(new JSpinner.NumberEditor(this.lengthSpinner, "###0.00"));
        this.lengthSpinner.setPreferredSize(new JTextField(8).getPreferredSize());
        this.lengthSpinner.setValue(Float.valueOf(0.0f));
        this.lengthSpinner.setToolTipText(Bundle.getMessage("OffsetToolTip"));
        p1.add(this.lengthSpinner);
        configGrid.add(p1);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.inch);
        bg.add(this.cm);
        p1 = new JPanel();
        p1.add(this.inch);
        p1.add(this.cm);
        p1.setLayout(new BoxLayout(p1, 3));
        this.inch.setSelected(true);
        this.inch.addActionListener(e -> {
            this.cm.setSelected(!this.inch.isSelected());
            this.updateLength();
        });
        this.cm.addActionListener(e -> {
            this.inch.setSelected(!this.cm.isSelected());
            this.updateLength();
        });
        configGrid.add(p1);
        p.add(configGrid);
        p.add(Box.createHorizontalGlue());
        JPanel p2 = new JPanel();
        this.statusBar.setFont(this.statusBar.getFont().deriveFont(0.9f * (float)this.signalMastLabel.getFont().getSize()));
        this.statusBar.setForeground(Color.gray);
        p2.add(this.statusBar);
        p.add(p2);
        p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 2));
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        p2.add(cancel);
        cancel.addActionListener(e -> this.closeFrame());
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        p2.add(ok);
        ok.addActionListener(e -> this.applyPressed());
        p.add(p2);
        this.frame.getContentPane().add(p);
        this.frame.setEscapeKeyClosesWindow(true);
        this.frame.getRootPane().setDefaultButton(ok);
        this.frame.pack();
    }

    public final void resetFrame() {
        if (this.sigMastComboBox.getItemCount() > 0) {
            this.sigMastComboBox.setSelectedIndex(0);
        }
        if (this.sigHeadComboBox.getItemCount() > 0) {
            this.sigHeadComboBox.setSelectedIndex(0);
        }
        if (this.portalComboBox.getItemCount() > 0) {
            this.portalComboBox.setSelectedIndex(0);
        }
        this.lengthSpinner.setValue(Float.valueOf(0.0f));
        if (this.sigMastComboBox.getItemCount() == 0 && this.sigHeadComboBox.getItemCount() == 0) {
            this.status(Bundle.getMessage("NoSignalWarning"), true);
        } else if (this.portalComboBox.getItemCount() > 1) {
            this.status(Bundle.getMessage("AddXStatusInitial1", Bundle.getMessage("BeanNameSignalMast") + "/" + Bundle.getMessage("BeanNameSignalHead"), Bundle.getMessage("ButtonOK")), false);
        } else {
            this.status(Bundle.getMessage("NoSignalPortal"), true);
        }
        this.mastName.setVisible(false);
        this.headName.setVisible(false);
        this.sigMastComboBox.setVisible(true);
        this.sigHeadComboBox.setVisible(true);
        this.frame.pack();
    }

    public final void populateFrame(@Nonnull SignalTableModel.SignalRow sr) {
        Objects.requireNonNull(sr, "Null Signal object");
        this.status(Bundle.getMessage("AddXStatusInitial3", sr.getSignal().getDisplayName(), Bundle.getMessage("ButtonOK")), false);
        this.fromBlock.setText(sr.getFromBlock().getDisplayName());
        this.toBlock.setText(sr.getToBlock().getDisplayName());
        if (this.signal instanceof SignalMast) {
            this.mastName.setText(sr.getSignal().getDisplayName());
            this.headName.setText("-");
        } else if (this.signal instanceof SignalHead) {
            this.mastName.setText("-");
            this.headName.setText(sr.getSignal().getDisplayName());
        }
        this.portalComboBox.setSelectedItem(this._portal.getName());
        this.cm.setSelected(sr._isMetric);
        if (sr.isMetric()) {
            this.lengthSpinner.setValue(Float.valueOf(sr.getLength() / 10.0f));
        } else {
            this.lengthSpinner.setValue(Float.valueOf(sr.getLength() / 25.4f));
        }
        this.mastName.setVisible(true);
        this.headName.setVisible(true);
        this.sigMastComboBox.setVisible(false);
        this.sigHeadComboBox.setVisible(false);
        this.frame.pack();
        this._newSignal = false;
    }

    private void applyPressed() {
        OBlock toOBlock;
        if (this._newSignal) {
            if (this.sigMastComboBox.getSelectedIndex() > 0) {
                this.signal = this.sigMastComboBox.getSelectedItem();
            } else if (this.sigHeadComboBox.getSelectedIndex() > 0) {
                this.signal = this.sigHeadComboBox.getSelectedItem();
            } else {
                this.status(Bundle.getMessage("WarnNoSignal"), true);
                return;
            }
            String msg = this.model.checkDuplicateSignal(this.signal);
            if (msg != null) {
                this.status(msg, true);
                return;
            }
        }
        this._portal = this.pm.getPortal((String)this.portalComboBox.getSelectedItem());
        if (this._portal == null || this.portalComboBox.getSelectedIndex() < 1) {
            this.status(Bundle.getMessage("WarnNoPortal"), true);
            return;
        }
        if (!this._newSignal) {
            this.model.deleteSignal(this._sr);
            this._sr.setPortal(this._portal);
        }
        float length = this.cm.isSelected() ? ((Float)this.lengthSpinner.getValue()).floatValue() * 10.0f : ((Float)this.lengthSpinner.getValue()).floatValue() * 25.4f;
        String toBlockName = this.toBlock.getText();
        OBlock oBlock = toOBlock = toBlockName == null ? null : this.obm.getOBlock(toBlockName);
        if (this._portal.setProtectSignal(this.signal, length, toOBlock) && this.fromBlock.getText() == null && toOBlock != null) {
            this._portal.setFromBlock(this._portal.getOpposingBlock(toOBlock), true);
        }
        if (toOBlock != null) {
            toOBlock.setMetricUnits(this.cm.isSelected());
        }
        this.model.fireTableDataChanged();
        this.closeFrame();
    }

    protected void closeFrame() {
        this.setVisible(false);
        this.model.setEditMode(false);
        log.debug("SignalEditFrame.closeFrame signalEdit=False");
        this.frame.dispose();
    }

    private void updateLength() {
        float len = ((Float)this.lengthSpinner.getValue()).floatValue();
        if (this.inch.isSelected()) {
            this.lengthSpinner.setValue(Float.valueOf(len / 2.54f));
        } else {
            this.lengthSpinner.setValue(Float.valueOf(len * 2.54f));
        }
    }

    void status(String message, boolean warn) {
        this.statusBar.setText(message);
        this.statusBar.setForeground(warn ? Color.red : Color.gray);
    }

    void addCloseListener(final JmriJFrame frame) {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SignalEditFrame.this.model.setEditMode(false);
                log.debug("SignalEditFrame.closeFrame signalEdit=False");
                frame.dispose();
            }
        });
    }
}

