/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.oblock;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jmri.BeanSetting;
import jmri.Block;
import jmri.BlockManager;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Path;
import jmri.Sensor;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.configurexml.StoreMenu;
import jmri.jmrit.beantable.beanedit.OBlockEditAction;
import jmri.jmrit.beantable.oblock.BlockPathEditFrame;
import jmri.jmrit.beantable.oblock.BlockPathTableModel;
import jmri.jmrit.beantable.oblock.BlockPortalTableModel;
import jmri.jmrit.beantable.oblock.Bundle;
import jmri.jmrit.beantable.oblock.OBlockTableModel;
import jmri.jmrit.beantable.oblock.PathTurnoutTableModel;
import jmri.jmrit.beantable.oblock.PortalTableModel;
import jmri.jmrit.beantable.oblock.SignalTableModel;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import jmri.jmrit.logix.WarrantTableAction;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.swing.NamedBeanComboBox;
import jmri.util.DnDTableExportHandler;
import jmri.util.DnDTableImportExportHandler;
import jmri.util.JmriJFrame;
import jmri.util.SystemType;
import jmri.util.com.sun.TransferActionListener;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.ToggleButtonEditor;
import jmri.util.table.ToggleButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFrames
implements InternalFrameListener,
Disposable {
    public static final int ROW_HEIGHT = new JButton((String)"X").getPreferredSize().height * 9 / 10;
    public static final int STRUT_SIZE = 10;
    protected static final String SET_CLOSED = InstanceManager.turnoutManagerInstance().getClosedText();
    protected static final String SET_THROWN = InstanceManager.turnoutManagerInstance().getThrownText();
    private static String oblockPrefix;
    private static final String PORTAL_PREFIX = "IP";
    private String _title;
    private JTable _oBlockTable;
    private final OBlockTableModel _oBlockModel;
    private JTable _portalTable;
    private final PortalTableModel _portalModel;
    private JTable _blockPortalTable;
    private final BlockPortalTableModel _blockPortalXRefModel;
    private JTable _signalTable;
    private final SignalTableModel _signalModel;
    private final boolean _tabbed;
    private boolean pathEdit = false;
    private JmriJFrame desktopframe;
    private static final int MAX_HEIGHT = 600;
    private JInternalFrame _blockTableFrame;
    private JInternalFrame _portalTableFrame;
    private JInternalFrame _blockPortalXRefFrame;
    private JInternalFrame _signalTableFrame;
    private boolean _showWarnings = true;
    private JMenuItem _showWarnItem;
    private JMenu tablesMenu;
    private JMenuItem openBlock;
    private JMenuItem _setUnits;
    private final HashMap<String, BlockPathFrame> _blockPathMap = new HashMap();
    private final HashMap<String, PathTurnoutFrame> _pathTurnoutMap = new HashMap();
    private static final Logger log;

    public TableFrames() {
        this("OBlock Tables");
    }

    public TableFrames(String actionName) {
        this._tabbed = InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed();
        this._title = actionName;
        if (!this._tabbed) {
            this.desktopframe = new JmriJFrame(actionName);
        }
        this._oBlockModel = new OBlockTableModel(this);
        this._portalModel = new PortalTableModel(this);
        this._portalModel.initListeners();
        this._blockPortalXRefModel = new BlockPortalTableModel(this._oBlockModel);
        this._signalModel = new SignalTableModel(this);
        this._signalModel.init();
    }

    public OBlockTableModel getOblockTableModel() {
        return this._oBlockModel;
    }

    public PortalTableModel getPortalTableModel() {
        return this._portalModel;
    }

    public BlockPortalTableModel getPortalXRefTableModel() {
        return this._blockPortalXRefModel;
    }

    public BlockPathTableModel getBlockPathTableModel(OBlock block) {
        return new BlockPathTableModel(block, this);
    }

    public SignalTableModel getSignalTableModel() {
        return this._signalModel;
    }

    public void initComponents() {
        if (!this._tabbed) {
            this.setTitle(Bundle.getMessage("TitleOBlocks"));
            this._blockTableFrame = this.buildFrame(this._oBlockModel, Bundle.getMessage("TitleBlockTable"), Bundle.getMessage("AddBlockPrompt"));
            this._blockTableFrame.setVisible(true);
            this._portalTableFrame = this.buildFrame(this._portalModel, Bundle.getMessage("TitlePortalTable"), Bundle.getMessage("AddPortalPrompt"));
            this._portalTableFrame.setVisible(true);
            this._signalTableFrame = this.buildFrame(this._signalModel, Bundle.getMessage("TitleSignalTable"), Bundle.getMessage("AddSignalPrompt"));
            this._signalTableFrame.setVisible(false);
            this._blockPortalXRefFrame = this.buildFrame(this._blockPortalXRefModel, Bundle.getMessage("TitleBlockPortalXRef"), Bundle.getMessage("XRefPrompt"));
            this._blockPortalXRefFrame.setVisible(false);
            this.desktopframe.setTitle(this.getTitle());
            this.desktopframe.setJMenuBar(this.addMenus(this.desktopframe.getJMenuBar()));
            this.desktopframe.addHelpMenu("package.jmri.jmrit.logix.OBlockTable", true);
            this.createDesktop();
            this.desktopframe.setLocation(10, 30);
            this.desktopframe.setVisible(true);
            this.desktopframe.pack();
            this.addCloseListener(this.desktopframe);
            WarrantTableAction.getDefault().errorCheck();
        }
    }

    public JMenuBar addMenus(JMenuBar mBar) {
        if (mBar == null) {
            mBar = new JMenuBar();
        }
        if (!this._tabbed) {
            JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
            fileMenu.add(new StoreMenu());
            fileMenu.add(this.getPrintMenuItems(this._oBlockTable, this._portalTable, this._signalTable, this._blockPortalTable));
            mBar.add(fileMenu);
            JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
            editMenu.setMnemonic(69);
            TransferActionListener actionListener = new TransferActionListener();
            JMenuItem menuItem = new JMenuItem(Bundle.getMessage("MenuItemCut"));
            menuItem.setActionCommand((String)TransferHandler.getCutAction().getValue("Name"));
            menuItem.addActionListener(actionListener);
            if (SystemType.isMacOSX()) {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 256));
            } else {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
            }
            menuItem.setMnemonic(84);
            editMenu.add(menuItem);
            menuItem = new JMenuItem(Bundle.getMessage("MenuItemCopy"));
            menuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
            menuItem.addActionListener(actionListener);
            if (SystemType.isMacOSX()) {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 256));
            } else {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
            }
            menuItem.setMnemonic(67);
            editMenu.add(menuItem);
            menuItem = new JMenuItem(Bundle.getMessage("MenuItemPaste"));
            menuItem.setActionCommand((String)TransferHandler.getPasteAction().getValue("Name"));
            menuItem.addActionListener(actionListener);
            if (SystemType.isMacOSX()) {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 256));
            } else {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 128));
            }
            menuItem.setMnemonic(80);
            editMenu.add(menuItem);
            mBar.add(editMenu);
        }
        mBar.add(this.getOptionMenu());
        mBar.add(this.getTablesMenu());
        return mBar;
    }

    public JMenu getPrintMenuItems(JTable oBlockTable, JTable portalTable, JTable signalTable, JTable blockPortalTable) {
        JMenu print = new JMenu(Bundle.getMessage("PrintTable"));
        JMenuItem printItem = new JMenuItem(Bundle.getMessage("PrintOBlockTable"));
        print.add(printItem);
        printItem.addActionListener(e -> {
            try {
                MessageFormat headerFormat = new MessageFormat(Bundle.getMessage("TitleOBlockTable"));
                MessageFormat footerFormat = new MessageFormat(this.getTitle() + " page {0,number}");
                oBlockTable.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat);
            }
            catch (PrinterException e1) {
                log.warn("error printing: {}", (Object)e1, (Object)e1);
            }
        });
        printItem = new JMenuItem(Bundle.getMessage("PrintPortalTable"));
        print.add(printItem);
        printItem.addActionListener(e -> {
            try {
                MessageFormat headerFormat = new MessageFormat(Bundle.getMessage("TitlePortalTable"));
                MessageFormat footerFormat = new MessageFormat(this.getTitle() + " page {0,number}");
                portalTable.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat);
            }
            catch (PrinterException e1) {
                log.warn("error printing: {}", (Object)e1, (Object)e1);
            }
        });
        printItem = new JMenuItem(Bundle.getMessage("PrintSignalTable"));
        print.add(printItem);
        printItem.addActionListener(e -> {
            try {
                MessageFormat headerFormat = new MessageFormat(Bundle.getMessage("TitleSignalTable"));
                MessageFormat footerFormat = new MessageFormat(this.getTitle() + " page {0,number}");
                signalTable.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat);
            }
            catch (PrinterException e1) {
                log.warn("error printing: {}", (Object)e1, (Object)e1);
            }
        });
        printItem = new JMenuItem(Bundle.getMessage("PrintXRef"));
        print.add(printItem);
        printItem.addActionListener(e -> {
            try {
                MessageFormat headerFormat = new MessageFormat(Bundle.getMessage("OpenXRefMenu", ""));
                MessageFormat footerFormat = new MessageFormat(this.getTitle() + " page {0,number}");
                blockPortalTable.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat);
            }
            catch (PrinterException e1) {
                log.warn("error printing: {}", (Object)e1, (Object)e1);
            }
        });
        return print;
    }

    private void createDesktop() {
        JDesktopPane desktop = new JDesktopPane();
        desktop.putClientProperty("JDesktopPane.dragMode", "outline");
        int deskWidth = this._blockTableFrame.getWidth();
        int deskHeight = this._blockTableFrame.getHeight();
        desktop.setBackground(new Color(180, 180, 180));
        this.desktopframe.setContentPane(desktop);
        this.desktopframe.setPreferredSize(new Dimension(deskWidth + 16, deskHeight + this._portalTableFrame.getHeight() + 64));
        desktop.add(this._blockTableFrame);
        this._portalTableFrame.setLocation(0, deskHeight);
        desktop.add(this._portalTableFrame);
        this._signalTableFrame.setLocation(200, deskHeight + 100);
        desktop.add(this._signalTableFrame);
        this._blockPortalXRefFrame.setLocation(deskWidth - this._blockPortalXRefFrame.getWidth(), deskHeight);
        desktop.add(this._blockPortalXRefFrame);
    }

    public JMenu getOptionMenu() {
        JMenu optionMenu = new JMenu(Bundle.getMessage("MenuOptions"));
        this._showWarnItem = new JMenuItem(Bundle.getMessage("SuppressWarning"));
        this._showWarnItem.addActionListener(event -> {
            String cmd = event.getActionCommand();
            this.setShowWarnings(cmd);
        });
        optionMenu.add(this._showWarnItem);
        this.setShowWarnings("ShowWarning");
        JMenuItem importBlocksItem = new JMenuItem(Bundle.getMessage("ImportBlocksMenu"));
        importBlocksItem.addActionListener(event -> this.importBlocks());
        optionMenu.add(importBlocksItem);
        if (InstanceManager.getNullableDefault(BlockManager.class) == null) {
            importBlocksItem.setEnabled(false);
        }
        this._setUnits = new JMenuItem(Bundle.getMessage("changeUnits", this._oBlockModel.isMetric() ? Bundle.getMessage("LengthInches") : Bundle.getMessage("LengthCentimeters")));
        this._setUnits.addActionListener(event -> this.setUnits());
        optionMenu.add(this._setUnits);
        return optionMenu;
    }

    public JMenu getTablesMenu() {
        this.tablesMenu = new JMenu(Bundle.getMessage("OpenMenu"));
        this.updateOBlockTablesMenu();
        return this.tablesMenu;
    }

    private String oblockPrefix() {
        if (oblockPrefix == null) {
            oblockPrefix = InstanceManager.getDefault(OBlockManager.class).getSystemNamePrefix();
        }
        return oblockPrefix;
    }

    protected JmriJFrame getDesktopFrame() {
        return this.desktopframe;
    }

    protected void importBlocks() throws IllegalArgumentException {
        int reply;
        Manager bm = InstanceManager.getDefault(BlockManager.class);
        OBlockManager obm = InstanceManager.getDefault(OBlockManager.class);
        PortalManager pom = InstanceManager.getDefault(PortalManager.class);
        SortedSet blkList = bm.getNamedBeanSet();
        if (blkList.isEmpty()) {
            log.warn("no Blocks to convert");
            JmriJOptionPane.showMessageDialog(this.desktopframe, Bundle.getMessage("ImportNoBlocks"), Bundle.getMessage("InfoTitle"), 1);
            return;
        }
        if (this._showWarnings && (reply = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("ImportBlockConfirm", this.oblockPrefix(), blkList.size()), Bundle.getMessage("QuestionTitle"), 0, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonCancel")}, Bundle.getMessage("ButtonYes"))) > 0) {
            return;
        }
        for (Block b : blkList) {
            try {
                String sName = b.getSystemName();
                String uName = b.getUserName();
                String blockNumber = sName.substring(sName.startsWith("IB:AUTO:") ? 8 : 3);
                String oBlockName = this.oblockPrefix() + blockNumber;
                String sensor = "";
                Sensor s = b.getSensor();
                if (s != null) {
                    sensor = s.getDisplayName();
                }
                float length = b.getLengthMm();
                int curve = b.getCurvature();
                List<Path> blockPaths = b.getPaths();
                Portal port = null;
                int n = 0;
                Portal prevPortal = null;
                log.debug("start creating OBlock {} from Block {}", (Object)oBlockName, (Object)sName);
                if (uName != null && obm.getOBlock(uName) != null) {
                    log.warn("an OBlock with this user name already exists, replacing {}", (Object)uName);
                }
                OBlock oBlock = obm.provideOBlock(oBlockName);
                oBlock.setUserName(uName);
                if (!sensor.isEmpty()) {
                    oBlock.setSensor(sensor);
                }
                oBlock.setMetricUnits(true);
                oBlock.setLength(length);
                oBlock.setCurvature(curve);
                for (Path pa : blockPaths) {
                    log.debug("Start loop: Path {} on Block {}", (Object)n, (Object)oBlockName);
                    String toBlockNumber = pa.getBlock().getSystemName().substring(sName.startsWith("IB:AUTO:") ? 8 : 3);
                    String toBlockName = this.oblockPrefix() + toBlockNumber;
                    String portalName = PORTAL_PREFIX + toBlockNumber + "-" + blockNumber;
                    port = pom.getPortal(portalName);
                    if (port == null) {
                        portalName = PORTAL_PREFIX + blockNumber + "-" + toBlockNumber;
                        log.debug("new Portal {} on block {}, path #{}", new Object[]{portalName, toBlockName, n});
                        port = pom.providePortal(portalName);
                        port.setFromBlock(oBlock, false);
                        port.setToBlock(obm.provideOBlock(toBlockName), false);
                    } else {
                        log.debug("duplicate Portal {} on block {}, path #{}", new Object[]{portalName, toBlockName, n});
                    }
                    oBlock.addPortal(port);
                    OPath opa = new OPath(oBlock, PORTAL_PREFIX + n++);
                    opa.setLength(oBlock.getLengthMm());
                    log.debug("new OPath #{} - {} on OBlock {}", new Object[]{n, opa.getName(), opa.getBlock().getDisplayName()});
                    oBlock.addPath(opa);
                    log.debug("number of paths: {}", (Object)oBlock.getPaths().size());
                    if (opa.getFromPortal() == null) {
                        opa.setFromPortal(port);
                    }
                    for (BeanSetting bs : pa.getSettings()) {
                        opa.addSetting(bs);
                    }
                    if (opa.getToPortal() == null && prevPortal != null) {
                        opa.setToPortal(prevPortal);
                    }
                    prevPortal = port;
                }
                OPath p0 = oBlock.getPathByName("IP0");
                if (p0 == null || n <= 1 || p0.getToPortal() != null) continue;
                p0.setToPortal(port);
            }
            catch (IllegalArgumentException iae) {
                log.error("Could not convert Block {} to OBlock. {}", (Object)b.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), (Object)iae.getMessage());
            }
        }
        SortedSet oblkList = obm.getNamedBeanSet();
        for (OBlock oblk : oblkList) {
            for (Portal po : oblk.getPortals()) {
                OBlock oob = (OBlock)obm.getByUserName(po.getFromBlockName());
                if (oob != null) {
                    oob.addPortal(po);
                }
                if ((oob = (OBlock)obm.getByUserName(po.getToBlockName())) == null) continue;
                oob.addPortal(po);
            }
        }
        WarrantTableAction.getDefault().errorCheck();
        if (this._showWarnings) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportBlockComplete", blkList.size(), oblkList.size()), Bundle.getMessage("MessageTitle"), 1);
        }
    }

    protected void setShowWarnings(String cmd) {
        if (cmd.equals("ShowWarning")) {
            this._showWarnings = true;
            this._showWarnItem.setActionCommand("SuppressWarning");
            this._showWarnItem.setText(Bundle.getMessage("SuppressWarning"));
        } else {
            this._showWarnings = false;
            this._showWarnItem.setActionCommand("ShowWarning");
            this._showWarnItem.setText(Bundle.getMessage("ShowWarning"));
        }
        log.debug("setShowWarnings: _showWarnings= {}", (Object)this._showWarnings);
    }

    private void setUnits() {
        this._oBlockModel.changeUnits();
        this._setUnits.setText(Bundle.getMessage("changeUnits", this._oBlockModel.isMetric() ? Bundle.getMessage("LengthInches") : Bundle.getMessage("LengthCentimeters")));
    }

    void addCloseListener(final JmriJFrame desktop) {
        desktop.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WarrantTableAction.getDefault().errorCheck();
                desktop.setDefaultCloseOperation(1);
                log.debug("windowClosing: {}", (Object)this.toString());
                desktop.dispose();
            }
        });
    }

    private String getTitle() {
        return this._title;
    }

    private void setTitle(String title) {
        this._title = title;
    }

    protected void updateOBlockTablesMenu() {
        if (this.tablesMenu == null) {
            return;
        }
        this.tablesMenu.removeAll();
        if (!this._tabbed) {
            this.openBlock = new JMenuItem(Bundle.getMessage("OpenBlockMenu", Bundle.getMessage("HideTable")));
            this.tablesMenu.add(this.openBlock);
            this.openBlock.addActionListener(event -> this.showHideFrame(this._blockTableFrame, this.openBlock, "OpenBlockMenu"));
            JMenuItem openPortal = new JMenuItem(Bundle.getMessage("OpenPortalMenu", Bundle.getMessage("HideTable")));
            this.tablesMenu.add(openPortal);
            openPortal.addActionListener(event -> this.showHideFrame(this._portalTableFrame, openPortal, "OpenPortalMenu"));
            JMenuItem openXRef = new JMenuItem(Bundle.getMessage("OpenXRefMenu", Bundle.getMessage("ShowTable")));
            this.tablesMenu.add(openXRef);
            openXRef.addActionListener(event -> this.showHideFrame(this._blockPortalXRefFrame, openXRef, "OpenXRefMenu"));
            JMenuItem openSignal = new JMenuItem(Bundle.getMessage("OpenSignalMenu", Bundle.getMessage("ShowTable")));
            this.tablesMenu.add(openSignal);
            openSignal.addActionListener(event -> this.showHideFrame(this._signalTableFrame, openSignal, "OpenSignalMenu"));
        }
        OBlockManager manager = InstanceManager.getDefault(OBlockManager.class);
        JMenu openBlockPath = new JMenu(Bundle.getMessage("OpenBlockPathMenu"));
        ActionListener openFrameAction = e -> {
            String blockSystemName = e.getActionCommand();
            this.openBlockPathPane(blockSystemName, Bundle.getMessage("TitlePaths"));
        };
        if (manager.getNamedBeanSet().isEmpty()) {
            JMenuItem mi = new JMenuItem(Bundle.getMessage("NoBlockPathYet"));
            mi.setEnabled(false);
            openBlockPath.add(mi);
        } else {
            for (OBlock block : manager.getNamedBeanSet()) {
                JMenuItem mi = new JMenuItem(Bundle.getMessage("OpenPathMenu", block.getDisplayName()));
                mi.setActionCommand(block.getSystemName());
                mi.addActionListener(openFrameAction);
                openBlockPath.add(mi);
            }
        }
        this.tablesMenu.add(openBlockPath);
        JMenu openTurnoutPath = new JMenu(Bundle.getMessage("OpenBlockPathTurnoutMenu"));
        if (manager.getNamedBeanSet().isEmpty()) {
            JMenuItem mi = new JMenuItem(Bundle.getMessage("NoPathTurnoutYet"));
            mi.setEnabled(false);
            openTurnoutPath.add(mi);
        } else {
            for (OBlock block : manager.getNamedBeanSet()) {
                JMenu openTurnoutMenu = new JMenu(Bundle.getMessage("OpenTurnoutMenu", block.getDisplayName()));
                openTurnoutPath.add(openTurnoutMenu);
                openFrameAction = e -> {
                    String pathTurnoutName = e.getActionCommand();
                    this.openPathTurnoutEditPane(pathTurnoutName);
                };
                for (Path p : block.getPaths()) {
                    if (!(p instanceof OPath)) continue;
                    OPath path = (OPath)p;
                    JMenuItem mi = new JMenuItem(Bundle.getMessage("OpenPathTurnoutMenu", path.getName()));
                    mi.setActionCommand(this.makePathTurnoutName(block.getSystemName(), path.getName()));
                    mi.addActionListener(openFrameAction);
                    openTurnoutMenu.add(mi);
                }
            }
        }
        this.tablesMenu.add(openTurnoutPath);
    }

    public void openPathTurnoutEditPane(String pathTurnoutName) {
        if (this._tabbed) {
            log.debug("openPathTurnoutEditPane for {}", (Object)pathTurnoutName);
            this.openPathTurnoutEditor(pathTurnoutName);
        } else {
            this.openPathTurnoutFrame(pathTurnoutName);
        }
    }

    private void showHideFrame(JInternalFrame frame, JMenuItem menu, String menuName) {
        if (!frame.isVisible()) {
            frame.setVisible(true);
            try {
                frame.setIcon(false);
            }
            catch (PropertyVetoException pve) {
                log.warn("{} Frame vetoed setIcon {}", (Object)frame.getTitle(), (Object)pve.toString());
            }
            frame.moveToFront();
        } else {
            frame.setVisible(false);
        }
        menu.setText(Bundle.getMessage(menuName, frame.isVisible() ? Bundle.getMessage("HideTable") : Bundle.getMessage("ShowTable")));
    }

    protected JInternalFrame buildFrame(AbstractTableModel tableModel, String title, String prompt) {
        JInternalFrame iframe = new JInternalFrame(title, true, false, false, true);
        JTable table = new JTable();
        if (tableModel instanceof OBlockTableModel) {
            table = this.makeOBlockTable((OBlockTableModel)tableModel);
        } else if (tableModel instanceof PortalTableModel) {
            table = this.makePortalTable((PortalTableModel)tableModel);
        } else if (tableModel instanceof BlockPortalTableModel) {
            table = this.makeBlockPortalTable((BlockPortalTableModel)tableModel);
        } else if (tableModel instanceof SignalTableModel) {
            table = this.makeSignalTable((SignalTableModel)tableModel);
        }
        JScrollPane scroll = new JScrollPane(table);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        JLabel _prompt = new JLabel(prompt);
        contentPane.add((Component)_prompt, "North");
        contentPane.add((Component)scroll, "Center");
        iframe.setContentPane(contentPane);
        iframe.pack();
        return iframe;
    }

    protected JTable makeOBlockTable(OBlockTableModel model) {
        this._oBlockTable = new JTable(model);
        TableRowSorter<OBlockTableModel> sorter = new TableRowSorter<OBlockTableModel>(this._oBlockModel);
        this._oBlockTable.setRowSorter(sorter);
        this._oBlockTable.setTransferHandler(new DnDTableImportExportHandler(new int[]{5, 6, 10, 12, 11, 8}));
        this._oBlockTable.setDragEnabled(true);
        XTableColumnModel tcm = new XTableColumnModel();
        this._oBlockTable.setColumnModel(tcm);
        this._oBlockTable.getTableHeader().setReorderingAllowed(true);
        this._oBlockTable.createDefaultColumnsFromModel();
        this._oBlockModel.addHeaderListener(this._oBlockTable);
        this._oBlockTable.setDefaultEditor(JComboBox.class, new ValueEditor());
        this._oBlockTable.getColumnModel().getColumn(5).setCellEditor(new ButtonEditor(new JButton()));
        this._oBlockTable.getColumnModel().getColumn(5).setCellRenderer(new ButtonRenderer());
        this._oBlockTable.getColumnModel().getColumn(6).setCellEditor(new ButtonEditor(new JButton()));
        this._oBlockTable.getColumnModel().getColumn(6).setCellRenderer(new ButtonRenderer());
        this._oBlockTable.getColumnModel().getColumn(8).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("cm"), Bundle.getMessage("in")));
        this._oBlockTable.getColumnModel().getColumn(8).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("cm"), Bundle.getMessage("in")));
        this._oBlockTable.getColumnModel().getColumn(10).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("Current"), Bundle.getMessage("Last")));
        this._oBlockTable.getColumnModel().getColumn(10).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("Current"), Bundle.getMessage("Last")));
        model.configSpeedColumn(this._oBlockTable);
        model.configCurveColumn(this._oBlockTable);
        this._oBlockTable.getColumnModel().getColumn(11).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("Permissive"), Bundle.getMessage("Absolute")));
        this._oBlockTable.getColumnModel().getColumn(11).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("Permissive"), Bundle.getMessage("Absolute")));
        this._oBlockTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TableFrames.this.showPopup(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                TableFrames.this.showPopup(me);
            }
        });
        for (int i = 0; i < this._oBlockModel.getColumnCount(); ++i) {
            int width = this._oBlockModel.getPreferredWidth(i);
            this._oBlockTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._oBlockTable.setAutoResizeMode(0);
        this._oBlockTable.setRowHeight(ROW_HEIGHT);
        TableColumn column = tcm.getColumnByModelIndex(9);
        tcm.setColumnVisible(column, false);
        column = tcm.getColumnByModelIndex(10);
        tcm.setColumnVisible(column, false);
        column = tcm.getColumnByModelIndex(11);
        tcm.setColumnVisible(column, false);
        column = tcm.getColumnByModelIndex(14);
        tcm.setColumnVisible(column, false);
        column = tcm.getColumnByModelIndex(15);
        tcm.setColumnVisible(column, false);
        this._oBlockTable.setPreferredScrollableViewportSize(new Dimension(this._oBlockTable.getPreferredSize().width, ROW_HEIGHT * Math.min(20, InstanceManager.getDefault(OBlockManager.class).getObjectCount())));
        return this._oBlockTable;
    }

    private void showPopup(MouseEvent me) {
        Point p = me.getPoint();
        int col = this._oBlockTable.columnAtPoint(p);
        if (!(me.isPopupTrigger() || me.isMetaDown() || me.isAltDown() || col != 3)) {
            int row = this._oBlockTable.rowAtPoint(p);
            String stateStr = (String)this._oBlockModel.getValueAt(row, col);
            int state = Integer.parseInt(stateStr, 2);
            stateStr = OBlockTableModel.getValue(state);
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(new JMenuItem(stateStr));
            popupMenu.show(this._oBlockTable, me.getX(), me.getY());
        }
    }

    protected boolean openOBlockEditor(String blockSystemName, String tabname) {
        OBlock oblock;
        boolean result = false;
        if (blockSystemName != null && (oblock = (OBlock)InstanceManager.getDefault(OBlockManager.class).getBySystemName(blockSystemName)) != null) {
            BlockPathJPanel panel = this.makeBlockPathEditPanel(oblock);
            OBlockEditAction beanEdit = new OBlockEditAction(new ActionEvent(this, 1001, tabname));
            beanEdit.setBean(oblock);
            beanEdit.setTablePanel(panel);
            beanEdit.actionPerformed(null);
            log.debug("path table created for oblock {}", (Object)blockSystemName);
            result = true;
        }
        return result;
    }

    protected boolean openPathEditor(@Nonnull String blockName, @CheckForNull String pathName, BlockPathTableModel bpmodel) {
        String title;
        OPath path;
        OBlock block = InstanceManager.getDefault(OBlockManager.class).getOBlock(blockName);
        if (block == null) {
            log.error("OBlock {} not found", (Object)blockName);
            return false;
        }
        PathTurnoutJPanel turnouttable = this.makePathTurnoutPanel(block, pathName);
        if (pathName == null) {
            path = null;
            title = Bundle.getMessage("AddPathTitle", blockName);
        } else {
            path = block.getPathByName(pathName);
            title = Bundle.getMessage("EditPathTitle", pathName, blockName);
        }
        BlockPathEditFrame bpef = new BlockPathEditFrame(title, block, path, turnouttable, bpmodel, this);
        bpef.setVisible(true);
        log.debug("Path editor created for path {} on block {}", (Object)pathName, (Object)blockName);
        return true;
    }

    protected JTable makePortalTable(PortalTableModel model) {
        this._portalTable = new JTable(model);
        TableRowSorter<PortalTableModel> sorter = new TableRowSorter<PortalTableModel>(model);
        this._portalTable.setRowSorter(sorter);
        this._portalTable.setTransferHandler(new DnDTableImportExportHandler(new int[]{3}));
        this._portalTable.setDragEnabled(true);
        this._portalTable.getColumnModel().getColumn(3).setCellEditor(new ButtonEditor(new JButton()));
        this._portalTable.getColumnModel().getColumn(3).setCellRenderer(new ButtonRenderer());
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._portalTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._portalTable.doLayout();
        int tableWidth = this._portalTable.getPreferredSize().width;
        this._portalTable.setRowHeight(ROW_HEIGHT);
        this._portalTable.setPreferredScrollableViewportSize(new Dimension(tableWidth, ROW_HEIGHT * Math.min(20, InstanceManager.getDefault(PortalManager.class).getPortalCount())));
        return this._portalTable;
    }

    protected JTable makeBlockPortalTable(BlockPortalTableModel model) {
        this._blockPortalTable = new JTable(model);
        this._blockPortalTable.setTransferHandler(new DnDTableExportHandler());
        this._blockPortalTable.setDragEnabled(true);
        this._blockPortalTable.setDefaultRenderer(String.class, new ValueRenderer());
        this._blockPortalTable.setDefaultEditor(String.class, new ValueEditor());
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            this._blockPortalTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._blockPortalTable.doLayout();
        this._blockPortalTable.setRowHeight(ROW_HEIGHT);
        int tableWidth = this._blockPortalTable.getPreferredSize().width;
        this._blockPortalTable.setPreferredScrollableViewportSize(new Dimension(tableWidth, ROW_HEIGHT * Math.min(20, InstanceManager.getDefault(PortalManager.class).getPortalCount())));
        return this._blockPortalTable;
    }

    protected JTable makeSignalTable(SignalTableModel model) {
        this._signalTable = new JTable(model);
        TableRowSorter<SignalTableModel> sorter = new TableRowSorter<SignalTableModel>(model);
        this._signalTable.setRowSorter(sorter);
        this._signalTable.setTransferHandler(new DnDTableImportExportHandler(new int[]{5, 6}));
        this._signalTable.setDragEnabled(true);
        this._signalTable.getColumnModel().getColumn(5).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("cm"), Bundle.getMessage("in")));
        this._signalTable.getColumnModel().getColumn(5).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("cm"), Bundle.getMessage("in")));
        this._signalTable.getColumnModel().getColumn(6).setCellEditor(new ButtonEditor(new JButton()));
        this._signalTable.getColumnModel().getColumn(6).setCellRenderer(new ButtonRenderer());
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = SignalTableModel.getPreferredWidth(i);
            this._signalTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        this._signalTable.doLayout();
        int tableWidth = this._signalTable.getPreferredSize().width;
        this._signalTable.setRowHeight(ROW_HEIGHT);
        this._signalTable.setPreferredScrollableViewportSize(new Dimension(tableWidth, ROW_HEIGHT * Math.min(10, this._signalTable.getRowCount())));
        return this._signalTable;
    }

    public void openBlockPathPane(String blockSystemName, String editorTabName) {
        if (this._tabbed) {
            if (!this.openOBlockEditor(blockSystemName, editorTabName)) {
                log.error("Failed to open OBlock Path table for {}", (Object)blockSystemName);
            }
        } else {
            this.openBlockPathFrame(blockSystemName);
        }
    }

    protected void openBlockPathFrame(String blockSystemName) {
        BlockPathFrame frame = this._blockPathMap.get(blockSystemName);
        if (frame == null) {
            OBlock block = (OBlock)InstanceManager.getDefault(OBlockManager.class).getBySystemName(blockSystemName);
            if (block == null) {
                return;
            }
            frame = this.makeBlockPathFrame(block);
            this._blockPathMap.put(blockSystemName, frame);
            frame.setVisible(true);
            this.desktopframe.getContentPane().add(frame);
        } else {
            frame.setVisible(true);
            try {
                frame.setIcon(false);
            }
            catch (PropertyVetoException pve) {
                log.warn("BlockPath Table Frame for \"{}\" vetoed setIcon", (Object)blockSystemName, (Object)pve);
            }
        }
        frame.moveToFront();
    }

    protected void disposeBlockPathFrame(OBlock block) {
        if (!this._tabbed) {
            BlockPathFrame frame = this._blockPathMap.get(block.getSystemName());
            frame.getModel().removeListener();
            this._blockPathMap.remove(block.getSystemName());
            frame.dispose();
        }
    }

    protected BlockPathFrame makeBlockPathFrame(@Nonnull OBlock block) {
        String title = Bundle.getMessage("TitleBlockPathTable", block.getDisplayName());
        BlockPathTableModel model = new BlockPathTableModel(block, this);
        JPanel contentPane = this.makeBlockPathTablePanel(model);
        BlockPathFrame frame = new BlockPathFrame(title, true, true, false, true);
        frame.setModel(model, block.getSystemName());
        frame.addInternalFrameListener(this);
        frame.setContentPane(contentPane);
        frame.setLocation(50, 30);
        frame.pack();
        return frame;
    }

    protected BlockPathJPanel makeBlockPathEditPanel(@Nonnull OBlock block) {
        String title = Bundle.getMessage("TitleBlockPathEditor", block.getDisplayName());
        BlockPathTableModel model = new BlockPathTableModel(block, this);
        JPanel bpTablePane = this.makeBlockPathTablePanel(model);
        BlockPathJPanel panel = new BlockPathJPanel(title);
        panel.setModel(model, block.getSystemName());
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(bpTablePane);
        JPanel tblButtons = new JPanel();
        tblButtons.setLayout(new BorderLayout(10, 10));
        tblButtons.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        tblButtons.setLayout(new BoxLayout(tblButtons, 1));
        JButton addPathButton = new JButton(Bundle.getMessage("ButtonAddPath"));
        ActionListener addPathAction = e -> {
            if (!this.isPathEdit()) {
                this.setPathEdit(true);
                log.debug("makeBlockPathEditPanel pathEdit=True");
                this.openPathEditor(block.getDisplayName(), null, model);
            } else {
                log.warn("Close BlockPath Editor to reopen");
            }
        };
        addPathButton.addActionListener(addPathAction);
        addPathButton.setToolTipText(Bundle.getMessage("AddPathTabbedPrompt"));
        tblButtons.add(addPathButton);
        panel.add(tblButtons);
        return panel;
    }

    protected void setPathEdit(boolean edit) {
        this.pathEdit = edit;
    }

    protected boolean isPathEdit() {
        return this.pathEdit;
    }

    @Override
    public void dispose() {
        this._portalModel.dispose();
    }

    protected JPanel makeBlockPathTablePanel(BlockPathTableModel _model) {
        JTable blockPathTable = this.makeBlockPathTable(_model);
        JScrollPane tablePane = new JScrollPane(blockPathTable);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        if (this._tabbed) {
            blockPathTable.setPreferredScrollableViewportSize(new Dimension(600, 100));
        } else {
            JLabel prompt = new JLabel(Bundle.getMessage("AddPathPrompt"));
            contentPane.add((Component)prompt, "North");
        }
        contentPane.add((Component)tablePane, "Center");
        return contentPane;
    }

    protected JTable makeBlockPathTable(BlockPathTableModel _model) {
        JTable blockPathTable = new JTable(_model);
        blockPathTable.setTransferHandler(new DnDTableImportExportHandler(new int[]{5, 6, 4}));
        blockPathTable.setDragEnabled(true);
        blockPathTable.getColumnModel().getColumn(4).setCellRenderer(new ToggleButtonRenderer(Bundle.getMessage("cm"), Bundle.getMessage("in")));
        blockPathTable.getColumnModel().getColumn(4).setCellEditor(new ToggleButtonEditor(new JToggleButton(), Bundle.getMessage("cm"), Bundle.getMessage("in")));
        blockPathTable.getColumnModel().getColumn(5).setCellEditor(new ButtonEditor(new JButton()));
        blockPathTable.getColumnModel().getColumn(5).setCellRenderer(new ButtonRenderer());
        blockPathTable.getColumnModel().getColumn(6).setCellEditor(new ButtonEditor(new JButton()));
        blockPathTable.getColumnModel().getColumn(6).setCellRenderer(new ButtonRenderer());
        for (int i = 0; i < _model.getColumnCount(); ++i) {
            int width = _model.getPreferredWidth(i);
            blockPathTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        blockPathTable.doLayout();
        int tableWidth = blockPathTable.getPreferredSize().width;
        blockPathTable.setRowHeight(ROW_HEIGHT);
        blockPathTable.setPreferredScrollableViewportSize(new Dimension(tableWidth, Math.min(ROW_HEIGHT * 10, 600)));
        return blockPathTable;
    }

    protected PathTurnoutFrame makePathTurnoutFrame(OBlock block, String pathName) {
        String title = Bundle.getMessage("TitlePathTurnoutTable", block.getDisplayName(), pathName);
        PathTurnoutFrame frame = new PathTurnoutFrame(title, true, true, false, true);
        if (log.isDebugEnabled()) {
            log.debug("makePathTurnoutFrame for Block {} and Path {} on _desktop", (Object)block.getDisplayName(), (Object)pathName);
        }
        frame.setName(this.makePathTurnoutName(block.getSystemName(), pathName));
        OPath path = block.getPathByName(pathName);
        if (path == null) {
            return null;
        }
        PathTurnoutTableModel pathTurnoutModel = new PathTurnoutTableModel(path, frame);
        frame.setModel(pathTurnoutModel);
        JTable pathTurnoutTable = this.makePathTurnoutTable(pathTurnoutModel);
        JScrollPane tablePane = new JScrollPane(pathTurnoutTable);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        JLabel prompt = new JLabel(Bundle.getMessage("AddTurnoutPrompt"));
        contentPane.add((Component)prompt, "North");
        contentPane.add((Component)tablePane, "Center");
        frame.addInternalFrameListener(this);
        frame.setContentPane(contentPane);
        frame.setLocation(10, 270);
        frame.pack();
        return frame;
    }

    protected PathTurnoutJPanel makePathTurnoutPanel(@Nonnull OBlock block, @CheckForNull String pathName) {
        JTable pathTurnoutTable;
        String title = Bundle.getMessage("TitlePathTurnoutTable", block.getDisplayName(), pathName);
        PathTurnoutJPanel panel = new PathTurnoutJPanel(title);
        JButton addTurnoutButton = new JButton(Bundle.getMessage("ButtonAddTurnout"));
        addTurnoutButton.setToolTipText(Bundle.getMessage("AddTurnoutTabbedPrompt"));
        JLabel prompt = new JLabel();
        prompt.setFont(prompt.getFont().deriveFont(0.9f * (float)new JLabel().getFont().getSize()));
        prompt.setForeground(Color.gray);
        if (pathName == null) {
            panel.setName(this.makePathTurnoutName(block.getSystemName(), "<new Path>"));
            Object[] columnHeaders = new String[]{Bundle.getMessage("Turnouts")};
            Object[][] emptyTable = new String[][]{{Bundle.getMessage("None")}};
            pathTurnoutTable = new JTable(emptyTable, columnHeaders);
            addTurnoutButton.setEnabled(false);
            prompt.setText(Bundle.getMessage("TurnoutTablePromptNew"));
        } else {
            panel.setName(this.makePathTurnoutName(block.getSystemName(), pathName));
            OPath path = block.getPathByName(pathName);
            if (path == null) {
                return null;
            }
            PathTurnoutTableModel pathTurnoutModel = new PathTurnoutTableModel(path);
            pathTurnoutTable = this.makePathTurnoutTable(pathTurnoutModel);
            panel.setModel(pathTurnoutModel);
            ActionListener addTurnoutAction = e -> this.addTurnoutPane(path, pathTurnoutModel);
            addTurnoutButton.addActionListener(addTurnoutAction);
            prompt.setText(Bundle.getMessage("TurnoutTablePrompt"));
        }
        JScrollPane tablePane = new JScrollPane(pathTurnoutTable);
        JPanel tblButtons = new JPanel();
        tblButtons.setLayout(new BorderLayout(10, 10));
        tblButtons.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        tblButtons.setLayout(new BoxLayout(tblButtons, 1));
        tblButtons.add(addTurnoutButton);
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)prompt, "North");
        panel.add((Component)tablePane, "Center");
        panel.add((Component)tblButtons, "South");
        return panel;
    }

    protected JTable makePathTurnoutTable(PathTurnoutTableModel model) {
        JTable pathTurnoutTable = new JTable(model);
        pathTurnoutTable.setTransferHandler(new DnDTableImportExportHandler(new int[]{1, 2}));
        pathTurnoutTable.setDragEnabled(true);
        model.configTurnoutStateColumn(pathTurnoutTable);
        pathTurnoutTable.getColumnModel().getColumn(2).setCellEditor(new ButtonEditor(new JButton()));
        pathTurnoutTable.getColumnModel().getColumn(2).setCellRenderer(new ButtonRenderer());
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            pathTurnoutTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        pathTurnoutTable.doLayout();
        int tableWidth = pathTurnoutTable.getPreferredSize().width;
        pathTurnoutTable.setRowHeight(ROW_HEIGHT);
        pathTurnoutTable.setPreferredScrollableViewportSize(new Dimension(tableWidth, Math.min(ROW_HEIGHT * 5, 600)));
        return pathTurnoutTable;
    }

    protected String makePathTurnoutName(String blockSysName, String pathName) {
        return "%" + pathName + "&" + blockSysName;
    }

    protected void openPathTurnoutFrame(String pathTurnoutName) {
        PathTurnoutFrame frame = this._pathTurnoutMap.get(pathTurnoutName);
        if (frame == null) {
            int index = pathTurnoutName.indexOf(38);
            String pathName = pathTurnoutName.substring(1, index);
            String blockName = pathTurnoutName.substring(index + 1);
            OBlock block = (OBlock)InstanceManager.getDefault(OBlockManager.class).getBySystemName(blockName);
            if (block == null) {
                return;
            }
            frame = this.makePathTurnoutFrame(block, pathName);
            if (frame == null) {
                return;
            }
            this._pathTurnoutMap.put(pathTurnoutName, frame);
            frame.setVisible(true);
            this.desktopframe.getContentPane().add(frame);
        } else {
            frame.setVisible(true);
            try {
                frame.setIcon(false);
            }
            catch (PropertyVetoException pve) {
                log.warn("PathTurnout Table Frame for \"{}\" vetoed setIcon", (Object)pathTurnoutName, (Object)pve);
            }
        }
        frame.moveToFront();
    }

    protected void openPathTurnoutEditor(String pathTurnoutName) {
        int index = pathTurnoutName.indexOf(38);
        String pathName = pathTurnoutName.substring(1, index);
        String blockName = pathTurnoutName.substring(index + 1);
        OBlock block = (OBlock)InstanceManager.getDefault(OBlockManager.class).getBySystemName(blockName);
        if (block == null) {
            return;
        }
        OPath path = block.getPathByName(pathName);
        if (path == null) {
            return;
        }
        PathTurnoutJPanel turnouttable = this.makePathTurnoutPanel(block, pathName);
        JmriJFrame frame = new JmriJFrame(Bundle.getMessage("TitlePathTurnoutTable", block.getDisplayName(), pathName));
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 3));
        frame.setSize(370, 250);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.add(turnouttable);
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        p.add(ok);
        ok.addActionListener(e -> frame.dispose());
        frame.getContentPane().add(p);
        frame.pack();
        frame.setVisible(true);
    }

    protected void addTurnoutPane(OPath path, PathTurnoutTableModel pathTurnoutModel) {
        JmriJFrame frame = new JmriJFrame(Bundle.getMessage("NewTurnoutTitle", path.getName()));
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 3));
        frame.setSize(200, 150);
        JPanel p = new JPanel();
        NamedBeanComboBox<Object> turnoutBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(TurnoutManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
        JComboBox<String> stateCombo = new JComboBox<String>();
        JLabel statusBar = new JLabel(Bundle.getMessage("AddXStatusInitial1", Bundle.getMessage("BeanNameTurnout"), Bundle.getMessage("ButtonOK")), 10);
        stateCombo.addItem(SET_THROWN);
        stateCombo.addItem(SET_CLOSED);
        turnoutBox.setToolTipText(Bundle.getMessage("TurnoutEditToolTip"));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 2));
        p1.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameTurnout"))));
        p1.add(turnoutBox);
        p.add(p1);
        p1 = new JPanel();
        p1.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ColumnLabelSetState"))));
        p1.add(stateCombo);
        p.add(p1);
        p.add(Box.createVerticalGlue());
        JPanel p2 = new JPanel();
        statusBar.setFont(statusBar.getFont().deriveFont(0.9f * (float)new JLabel().getFont().getSize()));
        if (turnoutBox.getItemCount() < 1) {
            statusBar.setText(Bundle.getMessage("NotEnoughTurnouts"));
            statusBar.setForeground(Color.red);
        } else {
            statusBar.setForeground(Color.gray);
        }
        p2.add(statusBar);
        p.add(p2);
        JPanel btns = new JPanel();
        btns.setLayout(new BoxLayout(btns, 2));
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        btns.add(cancel);
        cancel.addActionListener(e -> frame.dispose());
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        btns.add(ok);
        ok.addActionListener(e -> {
            if (turnoutBox.getSelectedItem() == null || turnoutBox.getSelectedIndex() < 0) {
                statusBar.setText(Bundle.getMessage("WarningSelectionEmpty"));
                statusBar.setForeground(Color.red);
            } else {
                String user = turnoutBox.getSelectedItemDisplayName();
                Turnout t = InstanceManager.turnoutManagerInstance().getTurnout(user);
                if (t != null) {
                    int s = stateCombo.getSelectedItem() != null && stateCombo.getSelectedItem().equals(SET_CLOSED) ? 2 : 4;
                    BeanSetting bs = new BeanSetting(t, user, s);
                    path.addSetting(bs);
                    if (pathTurnoutModel != null) {
                        pathTurnoutModel.fireTableDataChanged();
                    }
                } else {
                    log.error("PathTurnout {} not found", (Object)user);
                }
                frame.dispose();
            }
        });
        p.add((Component)btns, "South");
        frame.getContentPane().add(p);
        frame.pack();
        frame.setVisible(true);
    }

    protected int verifyWarning(String message) {
        int val = 0;
        if (this._showWarnings && (val = JmriJOptionPane.showOptionDialog(null, message, Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonYesPlus"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"))) == 1) {
            this._showWarnings = false;
        }
        return val;
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        JInternalFrame frame = (JInternalFrame)e.getSource();
        log.debug("Internal frame closing: {}", (Object)frame.getTitle());
        if (frame.getTitle().equals(Bundle.getMessage("TitleBlockTable"))) {
            this.showHideFrame(this._blockTableFrame, this.openBlock, "OpenBlockMenu");
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        JInternalFrame frame = (JInternalFrame)e.getSource();
        String name = frame.getName();
        if (log.isDebugEnabled()) {
            log.debug("Internal frame closed: {}, name= {} size ({}, {})", new Object[]{frame.getTitle(), name, frame.getSize().getWidth(), frame.getSize().getHeight()});
        }
        if (name != null && name.startsWith("OB")) {
            this._blockPathMap.remove(name);
            if (frame instanceof BlockPathFrame) {
                String msg = WarrantTableAction.getDefault().checkPathPortals(((BlockPathFrame)frame).getModel().getBlock());
                if (!msg.isEmpty()) {
                    JmriJOptionPane.showMessageDialog(this.desktopframe, msg, Bundle.getMessage("InfoTitle"), 1);
                }
                ((BlockPathFrame)frame).getModel().removeListener();
            }
        } else {
            if (frame instanceof PathTurnoutFrame) {
                ((PathTurnoutFrame)frame).getModel().removeListener();
            }
            this._pathTurnoutMap.remove(name);
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        JInternalFrame frame = (JInternalFrame)e.getSource();
        String name = frame.getName();
        if (log.isDebugEnabled()) {
            log.debug("Internal frame Iconified: {}, name= {} size ({}, {})", new Object[]{frame.getTitle(), name, frame.getSize().getWidth(), frame.getSize().getHeight()});
        }
        if (name != null && name.startsWith(this.oblockPrefix()) && frame instanceof BlockPathFrame) {
            String msg = WarrantTableAction.getDefault().checkPathPortals(((BlockPathFrame)frame).getModel().getBlock());
            JmriJOptionPane.showMessageDialog(this.desktopframe, msg, Bundle.getMessage("InfoTitle"), 1);
        }
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    static {
        log = LoggerFactory.getLogger(TableFrames.class);
    }

    protected static class PathTurnoutJPanel
    extends JPanel {
        PathTurnoutTableModel pathTurnoutModel;

        PathTurnoutJPanel(String pathname) {
            this.setName(pathname);
        }

        PathTurnoutTableModel getModel() {
            return this.pathTurnoutModel;
        }

        void setModel(PathTurnoutTableModel model) {
            this.pathTurnoutModel = model;
        }
    }

    protected static class PathTurnoutFrame
    extends JInternalFrame {
        PathTurnoutTableModel pathTurnoutModel;

        PathTurnoutFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
            super(title, resizable, closable, maximizable, iconifiable);
        }

        PathTurnoutTableModel getModel() {
            return this.pathTurnoutModel;
        }

        void setModel(PathTurnoutTableModel model) {
            this.pathTurnoutModel = model;
        }
    }

    public static class BlockPathJPanel
    extends JPanel {
        BlockPathTableModel blockPathModel;

        BlockPathJPanel(String title) {
            super.setName(title);
        }

        BlockPathTableModel getModel() {
            return this.blockPathModel;
        }

        void setModel(BlockPathTableModel model, String blockName) {
            this.blockPathModel = model;
            this.setName(blockName);
        }
    }

    protected static class BlockPathFrame
    extends JInternalFrame {
        BlockPathTableModel blockPathModel;

        BlockPathFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
            super(title, resizable, closable, maximizable, iconifiable);
        }

        BlockPathTableModel getModel() {
            return this.blockPathModel;
        }

        void setModel(BlockPathTableModel model, String blockName) {
            this.blockPathModel = model;
            this.setName(blockName);
        }
    }
}

