/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrit.beantable.RouteTableAction;
import jmri.jmrit.beantable.routetable.Bundle;
import jmri.jmrit.beantable.routetable.RouteSensor;
import jmri.jmrit.beantable.routetable.RouteSensorModel;
import jmri.jmrit.beantable.routetable.RouteTurnout;
import jmri.jmrit.beantable.routetable.RouteTurnoutModel;
import jmri.script.swing.ScriptFileChooser;
import jmri.swing.NamedBeanComboBox;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.NoArchiveFileFilter;
import jmri.util.StringUtil;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouteAddEditFrame
extends JmriJFrame {
    protected final RouteManager routeManager;
    static final String[] COLUMN_NAMES = new String[]{Bundle.getMessage("ColumnSystemName"), Bundle.getMessage("ColumnUserName"), Bundle.getMessage("Include"), Bundle.getMessage("ColumnLabelSetState")};
    private static final String SET_TO_ACTIVE = Bundle.getMessage("Set") + " " + Bundle.getMessage("SensorStateActive");
    private static final String SET_TO_INACTIVE = Bundle.getMessage("Set") + " " + Bundle.getMessage("SensorStateInactive");
    static final String SET_TO_TOGGLE = Bundle.getMessage("Set") + " " + Bundle.getMessage("Toggle");
    private static final String[] sensorInputModes = new String[]{Bundle.getMessage("OnCondition") + " " + Bundle.getMessage("SensorStateActive"), Bundle.getMessage("OnCondition") + " " + Bundle.getMessage("SensorStateInactive"), Bundle.getMessage("OnConditionChange"), "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SensorStateActive"), "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("SensorStateInactive")};
    private static final int[] sensorInputModeValues = new int[]{0, 1, 32, 2, 3};
    private static final int[] turnoutInputModeValues = new int[]{2, 4, 32, 8, 16};
    private static int ROW_HEIGHT;
    static String SET_TO_CLOSED;
    static String SET_TO_THROWN;
    private static String[] turnoutInputModes;
    private static final String[] turnoutFeedbackModes;
    private static String[] lockTurnoutInputModes;
    final JTextField _systemName = new JTextField(10);
    final JTextField _userName = new JTextField(22);
    final JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    final JTextField soundFile = new JTextField(20);
    final JTextField scriptFile = new JTextField(20);
    final JComboBox<String> sensor1mode = new JComboBox<String>(sensorInputModes);
    final JComboBox<String> sensor2mode = new JComboBox<String>(sensorInputModes);
    final JComboBox<String> sensor3mode = new JComboBox<String>(sensorInputModes);
    final JSpinner timeDelay = new JSpinner();
    final JComboBox<String> cTurnoutStateBox = new JComboBox<String>(turnoutInputModes);
    final JComboBox<String> cTurnoutFeedbackBox = new JComboBox<String>(turnoutFeedbackModes);
    final JComboBox<String> cLockTurnoutStateBox = new JComboBox<String>(lockTurnoutInputModes);
    final JLabel nameLabel = new JLabel(Bundle.getMessage("LabelSystemName"));
    final JLabel userLabel = new JLabel(Bundle.getMessage("LabelUserName"));
    final JLabel status1 = new JLabel();
    final JLabel status2 = new JLabel();
    protected final String systemNameAuto = this.getClass().getName() + ".AutoSystemName";
    private ArrayList<RouteTurnout> _turnoutList;
    private ArrayList<RouteSensor> _sensorList;
    private RouteTurnoutModel _routeTurnoutModel;
    private JScrollPane _routeTurnoutScrollPane;
    private RouteSensorModel _routeSensorModel;
    private JScrollPane _routeSensorScrollPane;
    private NamedBeanComboBox<Sensor> turnoutsAlignedSensor;
    private NamedBeanComboBox<Sensor> sensor1;
    private NamedBeanComboBox<Sensor> sensor2;
    private NamedBeanComboBox<Sensor> sensor3;
    private NamedBeanComboBox<Turnout> cTurnout;
    private NamedBeanComboBox<Turnout> cLockTurnout;
    Route curRoute = null;
    boolean editMode = false;
    protected ArrayList<RouteTurnout> _includedTurnoutList;
    protected ArrayList<RouteSensor> _includedSensorList;
    protected UserPreferencesManager pref;
    private JRadioButton allButton = null;
    protected boolean routeDirty = false;
    private boolean showAll = true;
    private JFileChooser soundChooser = null;
    private ScriptFileChooser scriptChooser = null;
    private boolean checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    private static final Logger log;

    public AbstractRouteAddEditFrame(String name, boolean saveSize, boolean savePosition) {
        super(name, saveSize, savePosition);
        AbstractRouteAddEditFrame.setClosedString(Bundle.getMessage("Set") + " " + InstanceManager.turnoutManagerInstance().getClosedText());
        AbstractRouteAddEditFrame.setThrownString(Bundle.getMessage("Set") + " " + InstanceManager.turnoutManagerInstance().getThrownText());
        AbstractRouteAddEditFrame.setTurnoutInputModes(new String[]{Bundle.getMessage("OnCondition") + " " + InstanceManager.turnoutManagerInstance().getClosedText(), Bundle.getMessage("OnCondition") + " " + InstanceManager.turnoutManagerInstance().getThrownText(), Bundle.getMessage("OnConditionChange"), "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("TurnoutStateClosed"), "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("TurnoutStateThrown")});
        AbstractRouteAddEditFrame.setLockTurnoutModes(new String[]{Bundle.getMessage("OnCondition") + " " + InstanceManager.turnoutManagerInstance().getClosedText(), Bundle.getMessage("OnCondition") + " " + InstanceManager.turnoutManagerInstance().getThrownText(), Bundle.getMessage("OnConditionChange")});
        this.routeManager = InstanceManager.getDefault(RouteManager.class);
    }

    protected static void setClosedString(@Nonnull String newVal) {
        SET_TO_CLOSED = newVal;
    }

    protected static void setThrownString(@Nonnull String newVal) {
        SET_TO_THROWN = newVal;
    }

    protected static void setTurnoutInputModes(@Nonnull String[] newArray) {
        turnoutInputModes = newArray;
    }

    protected static void setLockTurnoutModes(@Nonnull String[] newArray) {
        lockTurnoutInputModes = newArray;
    }

    private static synchronized void setRowHeight(int newVal) {
        ROW_HEIGHT = newVal;
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.pref = InstanceManager.getDefault(UserPreferencesManager.class);
        if (this.editMode) {
            this.cancelEdit();
        }
        TurnoutManager tm = InstanceManager.turnoutManagerInstance();
        this._turnoutList = new ArrayList();
        for (Object t : tm.getNamedBeanSet()) {
            String systemName = t.getSystemName();
            String userName = t.getUserName();
            this._turnoutList.add(new RouteTurnout(systemName, userName));
        }
        SensorManager sm = InstanceManager.sensorManagerInstance();
        this._sensorList = new ArrayList();
        for (Sensor s : sm.getNamedBeanSet()) {
            String systemName = s.getSystemName();
            String userName = s.getUserName();
            this._sensorList.add(new RouteSensor(systemName, userName));
        }
        this.initializeIncludedList();
        this.turnoutsAlignedSensor = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
        this.sensor1 = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
        this.sensor2 = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
        this.sensor3 = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
        this.cTurnout = new NamedBeanComboBox<Turnout>(InstanceManager.turnoutManagerInstance());
        this.cLockTurnout = new NamedBeanComboBox<Turnout>(InstanceManager.turnoutManagerInstance());
        JComboBoxUtil.setupComboBoxMaxRows(this.turnoutsAlignedSensor);
        JComboBoxUtil.setupComboBoxMaxRows(this.sensor1);
        JComboBoxUtil.setupComboBoxMaxRows(this.sensor2);
        JComboBoxUtil.setupComboBoxMaxRows(this.sensor3);
        JComboBoxUtil.setupComboBoxMaxRows(this.cTurnout);
        JComboBoxUtil.setupComboBoxMaxRows(this.cLockTurnout);
        this.addHelpMenu("package.jmri.jmrit.beantable.RouteAddEdit", true);
        this.setLocation(100, 30);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel ps = new JPanel();
        ps.setLayout(new FlowLayout());
        ps.add(this.nameLabel);
        this.nameLabel.setLabelFor(this._systemName);
        ps.add(this._systemName);
        ps.add(this._autoSystemName);
        this._autoSystemName.addActionListener(e1 -> this.autoSystemName());
        if (this.pref.getSimplePreferenceState(this.systemNameAuto)) {
            this._autoSystemName.setSelected(true);
            this._systemName.setEnabled(false);
        }
        this._systemName.setToolTipText(Bundle.getMessage("TooltipRouteSystemName"));
        contentPanel.add(ps);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.userLabel);
        this.userLabel.setLabelFor(this._userName);
        p.add(this._userName);
        this._userName.setToolTipText(Bundle.getMessage("TooltipRouteUserName"));
        contentPanel.add(p);
        JPanel py = new JPanel();
        py.add(new JLabel(Bundle.getMessage("Show") + ":"));
        ButtonGroup selGroup = new ButtonGroup();
        this.allButton = new JRadioButton(Bundle.getMessage("All"), true);
        selGroup.add(this.allButton);
        py.add(this.allButton);
        this.allButton.addActionListener(e1 -> {
            if (!this.showAll) {
                this.showAll = true;
                this._routeTurnoutModel.fireTableDataChanged();
                this._routeSensorModel.fireTableDataChanged();
            }
        });
        JRadioButton includedButton = new JRadioButton(Bundle.getMessage("Included"), false);
        selGroup.add(includedButton);
        py.add(includedButton);
        includedButton.addActionListener(e1 -> {
            if (this.showAll) {
                this.showAll = false;
                this.initializeIncludedList();
                this._routeTurnoutModel.fireTableDataChanged();
                this._routeSensorModel.fireTableDataChanged();
            }
        });
        py.add(new JLabel(Bundle.getMessage("_and_", Bundle.getMessage("Turnouts"), Bundle.getMessage("Sensors"))));
        contentPanel.add(py);
        contentPanel.add(this.getTurnoutPanel());
        contentPanel.add(this.getSensorPanel());
        contentPanel.add(this.getFileNamesPanel());
        contentPanel.add(this.getAlignedSensorPanel());
        contentPanel.add(this.getControlsPanel());
        contentPanel.add(this.getLockPanel());
        contentPanel.add(this.getNotesPanel());
        contentPanel.add(this.getButtonPanel());
        this.getContentPane().add((Component)new JScrollPane(contentPanel), "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractRouteAddEditFrame.this.closeFrame();
            }
        });
    }

    protected abstract JPanel getButtonPanel();

    private JPanel getNotesPanel() {
        JPanel pa = new JPanel();
        pa.setLayout(new BoxLayout(pa, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        this.status1.setText(Bundle.getMessage("RouteAddStatusInitial1", Bundle.getMessage("ButtonCreate")));
        this.status1.setFont(this.status1.getFont().deriveFont(0.9f * (float)this.nameLabel.getFont().getSize()));
        this.status1.setForeground(Color.gray);
        p1.add(this.status1);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        this.status2.setText(Bundle.getMessage("RouteAddStatusInitial5", Bundle.getMessage("ButtonCancel", "")));
        this.status2.setFont(this.status1.getFont().deriveFont(0.9f * (float)this.nameLabel.getFont().getSize()));
        this.status2.setForeground(Color.gray);
        p2.add(this.status2);
        pa.add(p1);
        pa.add(p2);
        Border pBorder = BorderFactory.createEtchedBorder();
        pa.setBorder(pBorder);
        return pa;
    }

    private JPanel getLockPanel() {
        JPanel p4 = new JPanel();
        p4.setLayout(new BoxLayout(p4, 1));
        JPanel p43 = new JPanel();
        p43.add(new JLabel(Bundle.getMessage("LabelLockTurnout")));
        p4.add(p43);
        JPanel p44 = new JPanel();
        p44.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameTurnout"))));
        p44.add(this.cLockTurnout);
        this.cLockTurnout.setAllowNull(true);
        this.cLockTurnout.setSelectedItem(null);
        this.cLockTurnout.setToolTipText(Bundle.getMessage("TooltipEnterTurnout"));
        p44.add(new JLabel("   " + Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelCondition"))));
        this.cLockTurnoutStateBox.setToolTipText(Bundle.getMessage("TooltipLockTurnout"));
        p44.add(this.cLockTurnoutStateBox);
        p4.add(p44);
        Border p4Border = BorderFactory.createEtchedBorder();
        p4.setBorder(p4Border);
        return p4;
    }

    private JPanel getControlsPanel() {
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        JPanel p31 = new JPanel();
        p31.add(new JLabel(Bundle.getMessage("LabelEnterSensors")));
        p3.add(p31);
        JPanel p32 = new JPanel();
        JPanel pS = new JPanel();
        pS.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BeanNameSensor") + " 1"));
        pS.add(this.sensor1);
        pS.add(this.sensor1mode);
        p32.add(pS);
        pS = new JPanel();
        pS.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BeanNameSensor") + " 2"));
        pS.add(this.sensor2);
        pS.add(this.sensor2mode);
        p32.add(pS);
        pS = new JPanel();
        pS.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BeanNameSensor") + " 3"));
        pS.add(this.sensor3);
        pS.add(this.sensor3mode);
        p32.add(pS);
        this.sensor1.setAllowNull(true);
        this.sensor2.setAllowNull(true);
        this.sensor3.setAllowNull(true);
        this.sensor1.setSelectedItem(null);
        this.sensor2.setSelectedItem(null);
        this.sensor3.setSelectedItem(null);
        String sensorHint = Bundle.getMessage("TooltipEnterSensors");
        this.sensor1.setToolTipText(sensorHint);
        this.sensor2.setToolTipText(sensorHint);
        this.sensor3.setToolTipText(sensorHint);
        p3.add(p32);
        JPanel p33 = new JPanel();
        p33.add(new JLabel(Bundle.getMessage("LabelEnterTurnout")));
        p3.add(p33);
        JPanel p34 = new JPanel();
        p34.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameTurnout"))));
        p34.add(this.cTurnout);
        this.cTurnout.setAllowNull(true);
        this.cTurnout.setSelectedItem(null);
        this.cTurnout.setToolTipText(Bundle.getMessage("TooltipEnterTurnout"));
        p34.add(new JLabel("   " + Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelCondition"))));
        this.cTurnoutStateBox.setToolTipText(Bundle.getMessage("TooltipTurnoutCondition"));
        p34.add(this.cTurnoutStateBox);
        p34.add(new JLabel(Bundle.getMessage("Is")));
        this.cTurnoutFeedbackBox.setToolTipText(Bundle.getMessage("TooltipTurnoutFeedback"));
        p34.add(this.cTurnoutFeedbackBox);
        p3.add(p34);
        JPanel p36 = new JPanel();
        p36.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelTurnoutDelay"))));
        this.timeDelay.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        this.timeDelay.setPreferredSize(new JTextField(5).getPreferredSize());
        p36.add(this.timeDelay);
        this.timeDelay.setToolTipText(Bundle.getMessage("TooltipTurnoutDelay"));
        p36.add(new JLabel(Bundle.getMessage("LabelMilliseconds")));
        p3.add(p36);
        Border p3Border = BorderFactory.createEtchedBorder();
        p3.setBorder(p3Border);
        return p3;
    }

    private JPanel getAlignedSensorPanel() {
        JPanel p27 = new JPanel();
        p27.setLayout(new FlowLayout());
        p27.add(new JLabel(Bundle.getMessage("LabelEnterSensorAligned")));
        p27.add(this.turnoutsAlignedSensor);
        this.turnoutsAlignedSensor.setAllowNull(true);
        this.turnoutsAlignedSensor.setSelectedItem(null);
        this.turnoutsAlignedSensor.setToolTipText(Bundle.getMessage("TooltipEnterSensor"));
        return p27;
    }

    private JPanel getFileNamesPanel() {
        JPanel p25 = new JPanel();
        p25.setLayout(new FlowLayout());
        p25.add(new JLabel(Bundle.getMessage("LabelPlaySound")));
        p25.add(this.soundFile);
        JButton ss = new JButton("...");
        ss.addActionListener(e1 -> this.setSoundPressed());
        ss.setToolTipText(Bundle.getMessage("TooltipOpenFile", Bundle.getMessage("BeanNameAudio")));
        p25.add(ss);
        p25.add(new JLabel(Bundle.getMessage("LabelRunScript")));
        p25.add(this.scriptFile);
        ss = new JButton("...");
        ss.addActionListener(e1 -> this.setScriptPressed());
        ss.setToolTipText(Bundle.getMessage("TooltipOpenFile", Bundle.getMessage("Script")));
        p25.add(ss);
        return p25;
    }

    private JPanel getTurnoutPanel() {
        JPanel p2xt = new JPanel();
        JPanel p2xtSpace = new JPanel();
        p2xtSpace.setLayout(new BoxLayout(p2xtSpace, 1));
        p2xtSpace.add(Box.createRigidArea(new Dimension(30, 0)));
        p2xt.add(p2xtSpace);
        JPanel p21t = new JPanel();
        p21t.setLayout(new BoxLayout(p21t, 1));
        p21t.add(new JLabel(Bundle.getMessage("SelectInRoute", Bundle.getMessage("Turnouts"))));
        p2xt.add(p21t);
        this._routeTurnoutModel = new RouteTurnoutModel(this);
        JTable routeTurnoutTable = new JTable(this._routeTurnoutModel);
        TableRowSorter<RouteTurnoutModel> rtSorter = new TableRowSorter<RouteTurnoutModel>(this._routeTurnoutModel);
        rtSorter.setComparator(0, new AlphanumComparator());
        rtSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(rtSorter, 0, SortOrder.ASCENDING);
        routeTurnoutTable.setRowSorter(rtSorter);
        routeTurnoutTable.setRowSelectionAllowed(false);
        routeTurnoutTable.setPreferredScrollableViewportSize(new Dimension(480, 80));
        AbstractRouteAddEditFrame.setRowHeight(routeTurnoutTable.getRowHeight());
        JComboBox<String> stateTCombo = new JComboBox<String>();
        stateTCombo.addItem(SET_TO_CLOSED);
        stateTCombo.addItem(SET_TO_THROWN);
        stateTCombo.addItem(SET_TO_TOGGLE);
        TableColumnModel routeTurnoutColumnModel = routeTurnoutTable.getColumnModel();
        TableColumn includeColumnT = routeTurnoutColumnModel.getColumn(2);
        includeColumnT.setResizable(false);
        includeColumnT.setMinWidth(50);
        includeColumnT.setMaxWidth(60);
        TableColumn sNameColumnT = routeTurnoutColumnModel.getColumn(0);
        sNameColumnT.setResizable(true);
        sNameColumnT.setMinWidth(75);
        sNameColumnT.setMaxWidth(95);
        TableColumn uNameColumnT = routeTurnoutColumnModel.getColumn(1);
        uNameColumnT.setResizable(true);
        uNameColumnT.setMinWidth(210);
        uNameColumnT.setMaxWidth(260);
        TableColumn stateColumnT = routeTurnoutColumnModel.getColumn(3);
        stateColumnT.setCellEditor(new DefaultCellEditor(stateTCombo));
        stateColumnT.setResizable(false);
        stateColumnT.setMinWidth(90);
        stateColumnT.setMaxWidth(100);
        this._routeTurnoutScrollPane = new JScrollPane(routeTurnoutTable);
        p2xt.add((Component)this._routeTurnoutScrollPane, "Center");
        p2xt.setVisible(true);
        return p2xt;
    }

    private JPanel getSensorPanel() {
        JPanel p2xs = new JPanel();
        JPanel p2xsSpace = new JPanel();
        p2xsSpace.setLayout(new BoxLayout(p2xsSpace, 1));
        p2xsSpace.add(Box.createRigidArea(new Dimension(30, 0)));
        p2xs.add(p2xsSpace);
        JPanel p21s = new JPanel();
        p21s.setLayout(new BoxLayout(p21s, 1));
        p21s.add(new JLabel(Bundle.getMessage("SelectInRoute", Bundle.getMessage("Sensors"))));
        p2xs.add(p21s);
        this._routeSensorModel = new RouteSensorModel(this);
        JTable routeSensorTable = new JTable(this._routeSensorModel);
        TableRowSorter<RouteSensorModel> rsSorter = new TableRowSorter<RouteSensorModel>(this._routeSensorModel);
        rsSorter.setComparator(0, new AlphanumComparator());
        rsSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(rsSorter, 0, SortOrder.ASCENDING);
        routeSensorTable.setRowSorter(rsSorter);
        routeSensorTable.setRowSelectionAllowed(false);
        routeSensorTable.setPreferredScrollableViewportSize(new Dimension(480, 80));
        JComboBox<String> stateSCombo = new JComboBox<String>();
        stateSCombo.addItem(SET_TO_ACTIVE);
        stateSCombo.addItem(SET_TO_INACTIVE);
        stateSCombo.addItem(SET_TO_TOGGLE);
        TableColumnModel routeSensorColumnModel = routeSensorTable.getColumnModel();
        TableColumn includeColumnS = routeSensorColumnModel.getColumn(2);
        includeColumnS.setResizable(false);
        includeColumnS.setMinWidth(50);
        includeColumnS.setMaxWidth(60);
        TableColumn sNameColumnS = routeSensorColumnModel.getColumn(0);
        sNameColumnS.setResizable(true);
        sNameColumnS.setMinWidth(75);
        sNameColumnS.setMaxWidth(95);
        TableColumn uNameColumnS = routeSensorColumnModel.getColumn(1);
        uNameColumnS.setResizable(true);
        uNameColumnS.setMinWidth(210);
        uNameColumnS.setMaxWidth(260);
        TableColumn stateColumnS = routeSensorColumnModel.getColumn(3);
        stateColumnS.setCellEditor(new DefaultCellEditor(stateSCombo));
        stateColumnS.setResizable(false);
        stateColumnS.setMinWidth(90);
        stateColumnS.setMaxWidth(100);
        this._routeSensorScrollPane = new JScrollPane(routeSensorTable);
        p2xs.add((Component)this._routeSensorScrollPane, "Center");
        p2xs.setVisible(true);
        return p2xs;
    }

    protected void initializeIncludedList() {
        this._includedTurnoutList = new ArrayList();
        for (RouteTurnout routeTurnout : this._turnoutList) {
            if (!routeTurnout.isIncluded()) continue;
            this._includedTurnoutList.add(routeTurnout);
        }
        this._includedSensorList = new ArrayList();
        for (RouteSensor routeSensor : this._sensorList) {
            if (!routeSensor.isIncluded()) continue;
            this._includedSensorList.add(routeSensor);
        }
    }

    private void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this.nameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this.nameLabel.setEnabled(true);
        }
    }

    protected void showReminderMessage() {
        if (this.checkEnabled) {
            return;
        }
        InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(this, Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemRouteTable")), RouteTableAction.class.getName(), "remindSaveRoute");
    }

    private int sensorModeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        return this.sensorModeFromString(mode);
    }

    int sensorModeFromString(String mode) {
        int result = StringUtil.getStateFromName(mode, sensorInputModeValues, sensorInputModes);
        if (result < 0) {
            log.warn("unexpected mode string in sensorMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setSensorModeBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, sensorInputModeValues, sensorInputModes);
        box.setSelectedItem(result);
    }

    private int turnoutModeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, turnoutInputModeValues, turnoutInputModes);
        if (result < 0) {
            log.warn("unexpected mode string in turnoutMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setTurnoutModeBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, turnoutInputModeValues, turnoutInputModes);
        box.setSelectedItem(result);
    }

    protected void setTurnoutInformation(Route g) {
        for (RouteTurnout t : this._includedTurnoutList) {
            g.addOutputTurnout(t.getDisplayName(), t.getState());
        }
    }

    protected void setSensorInformation(Route g) {
        for (RouteSensor s : this._includedSensorList) {
            g.addOutputSensor(s.getDisplayName(), s.getState());
        }
    }

    protected void setControlInformation(Route g) {
        Sensor sensor = (Sensor)this.sensor1.getSelectedItem();
        if (sensor != null && !g.addSensorToRoute(sensor.getSystemName(), this.sensorModeFromBox(this.sensor1mode))) {
            log.error("Unexpected failure to add Sensor '{}' to route '{}'.", (Object)sensor.getSystemName(), (Object)g.getSystemName());
        }
        if (this.sensor2.getSelectedItem() != null && !g.addSensorToRoute(this.sensor2.getSelectedItemDisplayName(), this.sensorModeFromBox(this.sensor2mode))) {
            log.error("Unexpected failure to add Sensor '{}' to Route '{}'.", (Object)this.sensor2.getSelectedItemDisplayName(), (Object)g.getSystemName());
        }
        if (this.sensor3.getSelectedItem() != null && !g.addSensorToRoute(this.sensor3.getSelectedItemDisplayName(), this.sensorModeFromBox(this.sensor3mode))) {
            log.error("Unexpected failure to add Sensor '{}' to Route '{}'.", (Object)this.sensor3.getSelectedItemDisplayName(), (Object)g.getSystemName());
        }
        if (this.turnoutsAlignedSensor.getSelectedItem() != null) {
            g.setTurnoutsAlignedSensor(this.turnoutsAlignedSensor.getSelectedItemDisplayName());
        } else {
            g.setTurnoutsAlignedSensor("");
        }
        if (this.cTurnout.getSelectedItem() != null) {
            g.setControlTurnout(this.cTurnout.getSelectedItemDisplayName());
            g.setControlTurnoutState(this.turnoutModeFromBox(this.cTurnoutStateBox));
            g.setControlTurnoutFeedback(this.cTurnoutFeedbackBox.getSelectedIndex() == 1);
        } else {
            g.setControlTurnout("");
        }
        int addDelay = (Integer)this.timeDelay.getValue();
        g.setRouteCommandDelay(addDelay);
        if (this.cLockTurnout.getSelectedItem() != null) {
            g.setLockControlTurnout(this.cLockTurnout.getSelectedItemDisplayName());
            g.setLockControlTurnoutState(this.turnoutModeFromBox(this.cLockTurnoutStateBox));
        } else {
            g.setLockControlTurnout("");
        }
    }

    private void setSoundPressed() {
        if (this.soundChooser == null) {
            this.soundChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
            this.soundChooser.setFileFilter(new NoArchiveFileFilter());
        }
        this.soundChooser.rescanCurrentDirectory();
        int retVal = this.soundChooser.showOpenDialog(null);
        if (retVal == 0) {
            try {
                this.soundFile.setText(this.soundChooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException e) {
                log.error("exception setting sound file: ", (Throwable)e);
            }
        }
    }

    private void setScriptPressed() {
        if (this.scriptChooser == null) {
            this.scriptChooser = new ScriptFileChooser();
        }
        this.scriptChooser.rescanCurrentDirectory();
        int retVal = this.scriptChooser.showOpenDialog(null);
        if (retVal == 0) {
            try {
                this.scriptFile.setText(this.scriptChooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException e) {
                log.error("exception setting script file: ", (Throwable)e);
            }
        }
    }

    protected void finishUpdate() {
        this.cancelIncludedOnly();
        this.status2.setVisible(true);
        this.autoSystemName();
        this.setTitle(Bundle.getMessage("TitleAddRoute"));
        this.clearPage();
        this.routeDirty = true;
        this.editMode = false;
        if (this.curRoute != null) {
            this.curRoute.activateRoute();
        }
    }

    protected void setPageContent(Route route) {
        String tSysName;
        int i;
        int setRow = 0;
        for (i = this._turnoutList.size() - 1; i >= 0; --i) {
            RouteTurnout turnout = this._turnoutList.get(i);
            tSysName = turnout.getSysName();
            if (route.isOutputTurnoutIncluded(tSysName)) {
                turnout.setIncluded(true);
                turnout.setState(route.getOutputTurnoutSetState(tSysName));
                setRow = i;
                continue;
            }
            turnout.setIncluded(false);
            turnout.setState(2);
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._routeTurnoutScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._routeTurnoutModel.fireTableDataChanged();
        for (i = this._sensorList.size() - 1; i >= 0; --i) {
            RouteSensor sensor = this._sensorList.get(i);
            tSysName = sensor.getSysName();
            if (route.isOutputSensorIncluded(tSysName)) {
                sensor.setIncluded(true);
                sensor.setState(route.getOutputSensorSetState(tSysName));
                setRow = i;
                continue;
            }
            sensor.setIncluded(false);
            sensor.setState(4);
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._routeSensorScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._routeSensorModel.fireTableDataChanged();
        this.scriptFile.setText(route.getOutputScriptName());
        this.soundFile.setText(route.getOutputSoundName());
        this.turnoutsAlignedSensor.setSelectedItem(route.getTurnoutsAlgdSensor());
        Sensor[] temNames = new Sensor[3];
        int[] temModes = new int[3];
        for (int k = 0; k < 3; ++k) {
            temNames[k] = route.getRouteSensor(k);
            temModes[k] = route.getRouteSensorMode(k);
        }
        this.sensor1.setSelectedItem(temNames[0]);
        this.setSensorModeBox(temModes[0], this.sensor1mode);
        this.sensor2.setSelectedItem(temNames[1]);
        this.setSensorModeBox(temModes[1], this.sensor2mode);
        this.sensor3.setSelectedItem(temNames[2]);
        this.setSensorModeBox(temModes[2], this.sensor3mode);
        this.cTurnout.setSelectedItem(route.getCtlTurnout());
        this.setTurnoutModeBox(route.getControlTurnoutState(), this.cTurnoutStateBox);
        if (route.getControlTurnoutFeedback()) {
            this.cTurnoutFeedbackBox.setSelectedIndex(1);
        } else {
            this.cTurnoutFeedbackBox.setSelectedIndex(0);
        }
        this.cLockTurnout.setSelectedItem(route.getLockCtlTurnout());
        this.setTurnoutModeBox(route.getLockControlTurnoutState(), this.cLockTurnoutStateBox);
        this.timeDelay.setValue(route.getRouteCommandDelay());
    }

    private void clearPage() {
        int i;
        this._systemName.setText("");
        this._userName.setText("");
        this.sensor1.setSelectedItem(null);
        this.sensor2.setSelectedItem(null);
        this.sensor3.setSelectedItem(null);
        this.cTurnout.setSelectedItem(null);
        this.cLockTurnout.setSelectedItem(null);
        this.turnoutsAlignedSensor.setSelectedItem(null);
        this.soundFile.setText("");
        this.scriptFile.setText("");
        for (i = this._turnoutList.size() - 1; i >= 0; --i) {
            this._turnoutList.get(i).setIncluded(false);
        }
        for (i = this._sensorList.size() - 1; i >= 0; --i) {
            this._sensorList.get(i).setIncluded(false);
        }
    }

    private void cancelIncludedOnly() {
        if (!this.showAll) {
            this.allButton.doClick();
        }
    }

    List<RouteTurnout> get_turnoutList() {
        return this._turnoutList;
    }

    List<RouteTurnout> get_includedTurnoutList() {
        return this._includedTurnoutList;
    }

    List<RouteSensor> get_sensorList() {
        return this._sensorList;
    }

    List<RouteSensor> get_includedSensorList() {
        return this._includedSensorList;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    protected void cancelEdit() {
        if (this.editMode) {
            this.status1.setText(Bundle.getMessage("RouteAddStatusInitial1", Bundle.getMessage("ButtonCreate")));
            this.finishUpdate();
            this.editMode = false;
            this.curRoute = null;
        }
        this.closeFrame();
    }

    protected void updatePressed(boolean newRoute) {
        String uName = this._userName.getText();
        Route g = this.checkNamesOK();
        if (g == null) {
            return;
        }
        g.setUserName(uName);
        g.clearOutputTurnouts();
        g.clearOutputSensors();
        g.clearRouteSensors();
        this.initializeIncludedList();
        this.setTurnoutInformation(g);
        this.setSensorInformation(g);
        g.setOutputScriptName(this.scriptFile.getText());
        g.setOutputSoundName(this.soundFile.getText());
        this.setControlInformation(g);
        this.curRoute = g;
        this.finishUpdate();
        this.status1.setForeground(Color.gray);
        this.status1.setText((newRoute ? Bundle.getMessage("RouteAddStatusCreated") : Bundle.getMessage("RouteAddStatusUpdated")) + ": \"" + uName + "\" (" + this._includedTurnoutList.size() + " " + Bundle.getMessage("Turnouts") + ", " + this._includedSensorList.size() + " " + Bundle.getMessage("Sensors") + ")");
        this.closeFrame();
    }

    private Route checkNamesOK() {
        Route g;
        String sName = this._systemName.getText();
        String uName = this._userName.getText();
        if (this._autoSystemName.isSelected() && !this.editMode) {
            log.debug("checkNamesOK new autogroup");
            g = this.routeManager.newRoute(uName);
        } else {
            if (sName.length() == 0) {
                this.status1.setText(Bundle.getMessage("AddBeanStatusEnter"));
                this.status1.setForeground(Color.red);
                return null;
            }
            try {
                sName = this.routeManager.makeSystemName(sName);
                g = this.routeManager.provideRoute(sName, uName);
            }
            catch (IllegalArgumentException ex) {
                g = null;
            }
        }
        if (g == null) {
            log.error("Unknown failure to create Route with System Name: {}", (Object)sName);
        } else {
            g.deActivateRoute();
        }
        return g;
    }

    protected void closeFrame() {
        if (this.routeDirty) {
            this.showReminderMessage();
            this.routeDirty = false;
        }
        this.setVisible(false);
        if (this.editMode) {
            this.cancelEdit();
        }
        this._routeSensorModel.dispose();
        this._routeTurnoutModel.dispose();
        this.dispose();
    }

    static {
        SET_TO_CLOSED = Bundle.getMessage("Set") + " " + Bundle.getMessage("TurnoutStateClosed");
        SET_TO_THROWN = Bundle.getMessage("Set") + " " + Bundle.getMessage("TurnoutStateThrown");
        turnoutInputModes = new String[]{Bundle.getMessage("OnCondition") + " " + Bundle.getMessage("TurnoutStateClosed"), Bundle.getMessage("OnCondition") + " " + Bundle.getMessage("TurnoutStateThrown"), Bundle.getMessage("OnConditionChange"), "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("TurnoutStateClosed"), "Veto " + Bundle.getMessage("WhenCondition") + " " + Bundle.getMessage("TurnoutStateThrown")};
        turnoutFeedbackModes = new String[]{Bundle.getMessage("TurnoutFeedbackKnown"), Bundle.getMessage("TurnoutFeedbackCommanded")};
        lockTurnoutInputModes = new String[]{Bundle.getMessage("OnCondition") + " " + Bundle.getMessage("TurnoutStateClosed"), Bundle.getMessage("OnCondition") + " " + Bundle.getMessage("TurnoutStateThrown"), Bundle.getMessage("OnConditionChange")};
        log = LoggerFactory.getLogger(AbstractRouteAddEditFrame.class);
    }
}

