/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.Application;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.jmrit.beantable.routetable.AbstractRouteAddEditFrame;
import jmri.jmrit.beantable.routetable.Bundle;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;

public class RouteAddFrame
extends AbstractRouteAddEditFrame {
    public RouteAddFrame() {
        this(Bundle.getMessage("TitleAddRoute"));
    }

    public RouteAddFrame(String name) {
        this(name, false, true);
    }

    public RouteAddFrame(String name, boolean saveSize, boolean savePosition) {
        super(name, saveSize, savePosition);
        super.initComponents();
    }

    @Override
    protected JPanel getButtonPanel() {
        JButton copyButton = new JButton(Bundle.getMessage("ButtonCopyRoute"));
        JButton createButton = new JButton(Bundle.getMessage("ButtonCreate"));
        JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        JPanel pb = new JPanel();
        pb.setLayout(new BorderLayout());
        JPanel left = new JPanel();
        left.add(copyButton);
        copyButton.addActionListener(e -> this.copyPressed());
        JPanel right = new JPanel();
        right.setLayout(new FlowLayout(4));
        right.add(cancelButton);
        cancelButton.addActionListener(e -> this.cancelAddPressed());
        right.add(createButton);
        createButton.addActionListener(e -> this.createPressed());
        createButton.setToolTipText(Bundle.getMessage("TooltipCreateRoute"));
        pb.add((Component)left, "West");
        pb.add((Component)right, "East");
        copyButton.setVisible(true);
        cancelButton.setVisible(true);
        updateButton.setVisible(false);
        editButton.setVisible(false);
        createButton.setVisible(true);
        return pb;
    }

    private void cancelAddPressed() {
        if (this.routeDirty) {
            this.showReminderMessage();
        }
        this.curRoute = null;
        this.finishUpdate();
        this.status1.setText(Bundle.getMessage("RouteAddStatusInitial1", Bundle.getMessage("ButtonCreate")));
        this.routeDirty = false;
        this.setVisible(false);
        this.closeFrame();
    }

    private void createPressed() {
        if (!this._autoSystemName.isSelected() && !this.checkNewNamesOK()) {
            return;
        }
        this.updatePressed(true);
        this.pref.setSimplePreferenceState(this.systemNameAuto, this._autoSystemName.isSelected());
        if (this.curRoute != null) {
            this.curRoute.activateRoute();
        }
        this.closeFrame();
    }

    private void copyPressed() {
        Route route;
        String selectedRoute = this.selectSourceRoute();
        if (selectedRoute != null && (route = InstanceManager.getDefault(RouteManager.class).getRoute(selectedRoute)) != null) {
            this.setPageContent(route);
        }
    }

    private String selectSourceRoute() {
        SortedSet routes = InstanceManager.getDefault(RouteManager.class).getNamedBeanSet();
        ArrayList routeList = new ArrayList();
        routes.forEach(r -> routeList.add(r.getDisplayName()));
        Collections.sort(routeList);
        Object[] routeArray = new String[routeList.size()];
        routeList.toArray(routeArray);
        try {
            ImageIcon icon = new ImageIcon(FileUtil.getProgramPath() + Application.getLogo());
            Object choice = JmriJOptionPane.showInputDialog(this, Bundle.getMessage("LabelCopyRoute"), Bundle.getMessage("TitleCopyRoute"), 3, icon, routeArray, null);
            return (String)choice;
        }
        catch (HeadlessException ex) {
            return null;
        }
    }

    private boolean checkNewNamesOK() {
        Route g;
        String sName = this._systemName.getText();
        String uName = this._userName.getText();
        if (sName.length() == 0) {
            this.status1.setText(Bundle.getMessage("AddBeanStatusEnter"));
            this.status1.setForeground(Color.red);
            return false;
        }
        if (!uName.isEmpty() && (g = this.routeManager.getByUserName(uName)) != null) {
            this.status1.setText(Bundle.getMessage("LightError8"));
            return false;
        }
        g = this.routeManager.getBySystemName(sName = this.routeManager.makeSystemName(sName));
        if (g != null) {
            this.status1.setText(Bundle.getMessage("LightError1"));
            return false;
        }
        return true;
    }
}

