/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.jmrit.beantable.routetable.AbstractRouteAddEditFrame;
import jmri.jmrit.beantable.routetable.Bundle;
import jmri.jmrit.beantable.routetable.RouteExportToLogix;

public class RouteEditFrame
extends AbstractRouteAddEditFrame {
    private final String systemName;

    public RouteEditFrame() {
        this(Bundle.getMessage("TitleEditRoute"));
    }

    public RouteEditFrame(String systemName) {
        this(Bundle.getMessage("TitleEditRoute"), systemName);
    }

    public RouteEditFrame(String name, String systemName) {
        this(name, false, true, systemName);
    }

    public RouteEditFrame(String name, boolean saveSize, boolean savePosition, String systemName) {
        super(name, saveSize, savePosition);
        this.systemName = systemName;
        this.initComponents();
    }

    @Override
    public final void initComponents() {
        super.initComponents();
        this._systemName.setText(this.systemName);
        String sName = this._systemName.getText();
        Route g = InstanceManager.getDefault(RouteManager.class).getBySystemName(sName);
        if (g == null) {
            sName = this._userName.getText();
            g = InstanceManager.getDefault(RouteManager.class).getByUserName(sName);
            if (g == null) {
                this.status1.setText(Bundle.getMessage("RouteAddStatusErrorNotFound"));
                return;
            }
        }
        this.curRoute = g;
        this._systemName.setVisible(true);
        this._systemName.setText(sName);
        this._systemName.setEnabled(false);
        this.nameLabel.setEnabled(true);
        this._autoSystemName.setVisible(false);
        this.curRoute.deActivateRoute();
        this._userName.setText(g.getUserName());
        this.setPageContent(g);
        this.status1.setText(Bundle.getMessage("RouteAddStatusInitial3", Bundle.getMessage("ButtonUpdate")));
        this.status2.setText(Bundle.getMessage("RouteAddStatusInitial4", Bundle.getMessage("ButtonCancelEdit", Bundle.getMessage("ButtonEdit"))));
        this.status2.setVisible(true);
        this.setTitle(Bundle.getMessage("TitleEditRoute"));
        this.editMode = true;
    }

    @Override
    protected JPanel getButtonPanel() {
        JButton cancelEditButton = new JButton(Bundle.getMessage("ButtonCancelEdit", Bundle.getMessage("ButtonEdit")));
        JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete") + " " + Bundle.getMessage("BeanNameRoute"));
        JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        JButton exportButton = new JButton(Bundle.getMessage("ButtonExport"));
        JPanel pb = new JPanel();
        pb.setLayout(new FlowLayout(4));
        pb.add(cancelEditButton);
        cancelEditButton.addActionListener(e -> this.cancelEdit());
        cancelEditButton.setToolTipText(Bundle.getMessage("TooltipCancelRoute"));
        pb.add(deleteButton);
        deleteButton.addActionListener(e -> this.deletePressed());
        deleteButton.setToolTipText(Bundle.getMessage("TooltipDeleteRoute"));
        pb.add(updateButton);
        updateButton.addActionListener(e1 -> this.updatePressed(false));
        updateButton.setToolTipText(Bundle.getMessage("TooltipUpdateRoute"));
        pb.add(exportButton);
        exportButton.addActionListener(e -> this.exportButtonPressed());
        exportButton.setToolTipText(Bundle.getMessage("TooltipExportRoute"));
        deleteButton.setVisible(true);
        cancelEditButton.setVisible(true);
        updateButton.setVisible(true);
        exportButton.setVisible(true);
        return pb;
    }

    private void exportButtonPressed() {
        new RouteExportToLogix(this._systemName.getText()).export();
        this.status1.setText(Bundle.getMessage("BeanNameRoute") + "\"" + this._systemName.getText() + "\" " + Bundle.getMessage("RouteAddStatusExported") + " (" + this.get_includedTurnoutList().size() + Bundle.getMessage("Turnouts") + ", " + this.get_includedSensorList().size() + " " + Bundle.getMessage("Sensors") + ")");
        this.finishUpdate();
        this.closeFrame();
    }

    private void deletePressed() {
        this.routeManager.deleteRoute(this.curRoute);
        this.curRoute = null;
        this.finishUpdate();
        this.closeFrame();
    }
}

