/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.routetable;

import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.implementation.DefaultConditionalAction;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteExportToLogix {
    private final String logixSysName;
    private final String conditionalSysPrefix;
    private final String systemName;
    private final RouteManager routeManager;
    private final LogixManager logixManager;
    private final ConditionalManager conditionalManager;
    private static final Logger log = LoggerFactory.getLogger(RouteExportToLogix.class);

    RouteExportToLogix(String systemName) {
        this(systemName, InstanceManager.getDefault(RouteManager.class), InstanceManager.getDefault(LogixManager.class), InstanceManager.getDefault(ConditionalManager.class));
    }

    RouteExportToLogix(String systemName, RouteManager routeManager, LogixManager logixManager, ConditionalManager conditionalManager) {
        this.systemName = systemName;
        this.routeManager = routeManager;
        this.logixManager = logixManager;
        this.conditionalManager = conditionalManager;
        String logixPrefix = logixManager.getSystemNamePrefix();
        this.logixSysName = logixPrefix + ":RTX:";
        this.conditionalSysPrefix = this.logixSysName + "C";
    }

    public void export() {
        String logixSystemName = this.logixSysName + this.systemName;
        Route route = this.routeManager.getBySystemName(this.systemName);
        if (route == null) {
            log.error("Route {} does not exist", (Object)this.systemName);
            return;
        }
        String uName = route.getUserName();
        Logix logix = this.logixManager.getBySystemName(logixSystemName);
        if (logix == null && (logix = this.logixManager.createNewLogix(logixSystemName, uName)) == null) {
            log.error("Failed to create Logix {}, {}", (Object)logixSystemName, (Object)uName);
            return;
        }
        logix.deActivateLogix();
        ArrayList<ConditionalAction> actionList = this.getConditionalActions(route);
        String file = route.getOutputSoundName();
        if (file != null && file.length() > 0) {
            actionList.add(new DefaultConditionalAction(1, Conditional.Action.PLAY_SOUND, "", -1, FileUtil.getPortableFilename(file)));
        }
        if ((file = route.getOutputScriptName()) != null && file.length() > 0) {
            actionList.add(new DefaultConditionalAction(1, Conditional.Action.RUN_SCRIPT, "", -1, FileUtil.getPortableFilename(file)));
        }
        ArrayList<ConditionalVariable> vetoList = this.getVetoVariables(route);
        this.removeOldConditionalNames(route, logix);
        int numConds = 1;
        numConds = this.makeSensorConditional(route.getRouteSensor(0), route.getRouteSensorMode(0), numConds, false, actionList, vetoList, logix, logixSystemName, uName);
        numConds = this.makeSensorConditional(route.getRouteSensor(1), route.getRouteSensorMode(1), numConds, false, actionList, vetoList, logix, logixSystemName, uName);
        numConds = this.makeSensorConditional(route.getRouteSensor(2), route.getRouteSensorMode(2), numConds, false, actionList, vetoList, logix, logixSystemName, uName);
        numConds = this.makeTurnoutConditional(route.getCtlTurnout(), route.getControlTurnoutState(), numConds, false, actionList, vetoList, logix, logixSystemName, uName);
        numConds = this.makeSensorConditional(route.getRouteSensor(0), route.getRouteSensorMode(0), numConds, true, actionList, vetoList, logix, logixSystemName, uName);
        numConds = this.makeSensorConditional(route.getRouteSensor(1), route.getRouteSensorMode(1), numConds, true, actionList, vetoList, logix, logixSystemName, uName);
        numConds = this.makeSensorConditional(route.getRouteSensor(2), route.getRouteSensorMode(2), numConds, true, actionList, vetoList, logix, logixSystemName, uName);
        numConds = this.makeTurnoutConditional(route.getCtlTurnout(), route.getControlTurnoutState(), numConds, true, actionList, vetoList, logix, logixSystemName, uName);
        log.debug("Final number of conditionals: {}", (Object)numConds);
        this.addRouteAlignmentSensorToLogix(logixSystemName, route, uName, logix);
        this.addRouteLockToLogix(logixSystemName, route, uName, logix);
        logix.activateLogix();
        this.routeManager.deleteRoute(route);
    }

    private void addRouteAlignmentSensorToLogix(String logixSystemName, Route route, String uName, Logix logix) {
        Sensor sens = route.getTurnoutsAlgdSensor();
        if (sens != null) {
            String sensorDisplayName = sens.getDisplayName();
            String cSystemName = logixSystemName + "1A";
            String cUserName = sens.getDisplayName() + "A " + uName;
            ArrayList<ConditionalVariable> variableList = new ArrayList<ConditionalVariable>();
            block4: for (int i = 0; i < route.getNumOutputTurnouts(); ++i) {
                Turnout ot = route.getOutputTurnout(i);
                if (ot == null) continue;
                String name = ot.getDisplayName();
                switch (route.getOutputTurnoutState(i)) {
                    case 2: {
                        variableList.add(new ConditionalVariable(false, Conditional.Operator.AND, Conditional.Type.TURNOUT_CLOSED, name, true));
                        continue block4;
                    }
                    case 4: {
                        variableList.add(new ConditionalVariable(false, Conditional.Operator.AND, Conditional.Type.TURNOUT_THROWN, name, true));
                        continue block4;
                    }
                    default: {
                        log.warn("Turnout {} was {}, neither CLOSED nor THROWN; not handled", (Object)name, (Object)route.getOutputTurnoutState(i));
                    }
                }
            }
            ArrayList<ConditionalAction> actionList = new ArrayList<ConditionalAction>();
            actionList.add(new DefaultConditionalAction(1, Conditional.Action.SET_SENSOR, sensorDisplayName, 2, ""));
            actionList.add(new DefaultConditionalAction(2, Conditional.Action.SET_SENSOR, sensorDisplayName, 4, ""));
            Conditional c = this.conditionalManager.createNewConditional(cSystemName, cUserName);
            c.setStateVariables(variableList);
            c.setLogicType(Conditional.AntecedentOperator.ALL_AND, "");
            c.setAction(actionList);
            logix.addConditional(cSystemName, 0);
            c.calculate(true, null);
        }
    }

    private void removeOldConditionalNames(Route route, Logix logix) {
        char[] ch = route.getSystemName().toCharArray();
        int hash = 0;
        for (char value : ch) {
            hash += value;
        }
        String cSystemName = this.conditionalSysPrefix + "T" + hash;
        this.removeConditionals(cSystemName, logix);
        cSystemName = this.conditionalSysPrefix + "F" + hash;
        this.removeConditionals(cSystemName, logix);
        cSystemName = this.conditionalSysPrefix + "A" + hash;
        this.removeConditionals(cSystemName, logix);
        cSystemName = this.conditionalSysPrefix + "L" + hash;
        this.removeConditionals(cSystemName, logix);
        int n = 0;
        while (this.removeConditionals(cSystemName = logix.getSystemName() + ++n + "A", logix)) {
        }
        n = 0;
        while (this.removeConditionals(cSystemName = logix.getSystemName() + ++n + "T", logix)) {
        }
        cSystemName = logix.getSystemName() + "L";
        this.removeConditionals(cSystemName, logix);
    }

    private void addRouteLockToLogix(String logixSystemName, Route route, String uName, Logix logix) {
        Turnout lockControlTurnout = route.getLockCtlTurnout();
        if (lockControlTurnout != null) {
            Turnout ot;
            int i;
            String cSystemName = logixSystemName + "1L";
            String cUserName = lockControlTurnout.getSystemName() + "L " + uName;
            ArrayList<ConditionalVariable> variableList = new ArrayList<ConditionalVariable>();
            int mode = route.getLockControlTurnoutState();
            Conditional.Type conditionalType = Conditional.Type.TURNOUT_CLOSED;
            if (mode == 4) {
                conditionalType = Conditional.Type.TURNOUT_THROWN;
            }
            variableList.add(new ConditionalVariable(false, Conditional.Operator.NONE, conditionalType, lockControlTurnout.getSystemName(), true));
            ArrayList<ConditionalAction> actionList = new ArrayList<ConditionalAction>();
            int option = 1;
            int type = 1;
            if (mode == 32) {
                option = 3;
                type = 8;
            }
            for (i = 0; i < route.getNumOutputTurnouts(); ++i) {
                ot = route.getOutputTurnout(i);
                if (ot == null) continue;
                actionList.add(new DefaultConditionalAction(option, Conditional.Action.LOCK_TURNOUT, ot.getDisplayName(), type, ""));
            }
            if (mode != 32) {
                option = 2;
                type = 0;
                for (i = 0; i < route.getNumOutputTurnouts(); ++i) {
                    ot = route.getOutputTurnout(i);
                    if (ot == null) continue;
                    actionList.add(new DefaultConditionalAction(option, Conditional.Action.LOCK_TURNOUT, ot.getDisplayName(), type, ""));
                }
            }
            Conditional c = this.conditionalManager.createNewConditional(cSystemName, cUserName);
            c.setStateVariables(variableList);
            c.setLogicType(Conditional.AntecedentOperator.ALL_AND, "");
            c.setAction(actionList);
            logix.addConditional(cSystemName, 0);
            c.calculate(true, null);
        }
    }

    private ArrayList<ConditionalVariable> getVetoVariables(Route route) {
        ArrayList<ConditionalVariable> vetoList = new ArrayList<ConditionalVariable>();
        ConditionalVariable cVar = this.makeCtrlSensorVar(route.getRouteSensor(0), route.getRouteSensorMode(0), true, false);
        if (cVar != null) {
            vetoList.add(cVar);
        }
        if ((cVar = this.makeCtrlSensorVar(route.getRouteSensor(1), route.getRouteSensorMode(1), true, false)) != null) {
            vetoList.add(cVar);
        }
        if ((cVar = this.makeCtrlSensorVar(route.getRouteSensor(2), route.getRouteSensorMode(2), true, false)) != null) {
            vetoList.add(cVar);
        }
        if ((cVar = this.makeCtrlTurnoutVar(route.getCtlTurnout(), route.getControlTurnoutState(), true, false)) != null) {
            vetoList.add(cVar);
        }
        return vetoList;
    }

    private ArrayList<ConditionalAction> getConditionalActions(Route route) {
        int i;
        ArrayList<ConditionalAction> actionList = new ArrayList<ConditionalAction>();
        for (i = 0; i < route.getNumOutputSensors(); ++i) {
            Sensor sens = route.getOutputSensor(i);
            if (sens == null) continue;
            actionList.add(new DefaultConditionalAction(1, Conditional.Action.SET_SENSOR, sens.getDisplayName(), route.getOutputSensorState(i), ""));
        }
        for (i = 0; i < route.getNumOutputTurnouts(); ++i) {
            Turnout to = route.getOutputTurnout(i);
            if (to == null) continue;
            actionList.add(new DefaultConditionalAction(1, Conditional.Action.SET_TURNOUT, to.getDisplayName(), route.getOutputTurnoutState(i), ""));
        }
        log.debug("sensor actions {} turnout actions {} resulting Action List size {}", new Object[]{route.getNumOutputSensors(), route.getNumOutputTurnouts(), actionList.size()});
        return actionList;
    }

    private boolean removeConditionals(String cSystemName, Logix logix) {
        Conditional c = this.conditionalManager.getBySystemName(cSystemName);
        if (c != null) {
            logix.deleteConditional(cSystemName);
            this.conditionalManager.deleteConditional(c);
            return true;
        }
        return false;
    }

    private int makeSensorConditional(Sensor selectedSensor, int sensorMode, int numConds, boolean onChange, ArrayList<ConditionalAction> actionList, ArrayList<ConditionalVariable> vetoList, Logix logix, String prefix, String uName) {
        int loop = numConds;
        ConditionalVariable cVar = this.makeCtrlSensorVar(selectedSensor, sensorMode, false, onChange);
        if (cVar != null) {
            Conditional c;
            ArrayList<ConditionalVariable> varList = new ArrayList<ConditionalVariable>();
            varList.add(cVar);
            for (ConditionalVariable conditionalVariable : vetoList) {
                varList.add(this.cloneVariable(conditionalVariable));
            }
            String cSystemName = prefix + loop + "T";
            String cUserName = selectedSensor.getDisplayName() + loop + "C " + uName;
            try {
                c = this.conditionalManager.createNewConditional(cSystemName, cUserName);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("user input no good");
            }
            c.setStateVariables(varList);
            int option = onChange ? 3 : 1;
            c.setAction(this.cloneActionList(actionList, option));
            c.setLogicType(Conditional.AntecedentOperator.ALL_AND, "");
            logix.addConditional(cSystemName, 0);
            c.calculate(true, null);
            ++loop;
        }
        return loop;
    }

    private int makeTurnoutConditional(Turnout turnout, int state, int numConds, boolean onChange, ArrayList<ConditionalAction> actionList, ArrayList<ConditionalVariable> vetoList, Logix logix, String prefix, String uName) {
        int loop = numConds;
        ConditionalVariable cVar = this.makeCtrlTurnoutVar(turnout, state, false, onChange);
        if (cVar != null) {
            Conditional c;
            ArrayList<ConditionalVariable> varList = new ArrayList<ConditionalVariable>();
            varList.add(cVar);
            for (ConditionalVariable conditionalVariable : vetoList) {
                varList.add(this.cloneVariable(conditionalVariable));
            }
            String cSystemName = prefix + loop + "T";
            String cUserName = turnout.getDisplayName() + loop + "C " + uName;
            try {
                c = this.conditionalManager.createNewConditional(cSystemName, cUserName);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("user input no good");
            }
            c.setStateVariables(varList);
            int option = onChange ? 3 : 1;
            c.setAction(this.cloneActionList(actionList, option));
            c.setLogicType(Conditional.AntecedentOperator.ALL_AND, "");
            logix.addConditional(cSystemName, 0);
            c.calculate(true, null);
            ++loop;
        }
        return loop;
    }

    @CheckForNull
    private ConditionalVariable makeCtrlTurnoutVar(@CheckForNull Turnout turnout, int mode, boolean makeVeto, boolean onChange) {
        Conditional.Type type;
        if (turnout == null) {
            return null;
        }
        String devName = turnout.getDisplayName();
        Conditional.Operator oper = Conditional.Operator.AND;
        boolean negated = false;
        boolean trigger = true;
        switch (mode) {
            case 2: {
                if (makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.TURNOUT_CLOSED;
                break;
            }
            case 4: {
                if (makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.TURNOUT_THROWN;
                break;
            }
            case 32: {
                if (makeVeto || !onChange) {
                    return null;
                }
                type = Conditional.Type.TURNOUT_CLOSED;
                break;
            }
            case 8: {
                if (!makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.TURNOUT_CLOSED;
                trigger = false;
                negated = true;
                break;
            }
            case 16: {
                if (!makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.TURNOUT_THROWN;
                trigger = false;
                negated = true;
                break;
            }
            default: {
                log.error("Control Turnout {} has bad mode= {}", (Object)devName, (Object)mode);
                return null;
            }
        }
        return new ConditionalVariable(negated, oper, type, devName, trigger);
    }

    private ConditionalVariable cloneVariable(@Nonnull ConditionalVariable v) {
        return new ConditionalVariable(v.isNegated(), v.getOpern(), v.getType(), v.getName(), v.doTriggerActions());
    }

    private ArrayList<ConditionalAction> cloneActionList(@Nonnull ArrayList<ConditionalAction> actionList, int option) {
        ArrayList<ConditionalAction> list = new ArrayList<ConditionalAction>();
        for (ConditionalAction action : actionList) {
            DefaultConditionalAction clone = new DefaultConditionalAction();
            clone.setType(action.getType());
            clone.setOption(option);
            clone.setDeviceName(action.getDeviceName());
            clone.setActionData(action.getActionData());
            clone.setActionString(action.getActionString());
            list.add(clone);
        }
        return list;
    }

    @CheckForNull
    private ConditionalVariable makeCtrlSensorVar(@CheckForNull Sensor selectedSensor, int mode, boolean makeVeto, boolean onChange) {
        Conditional.Type type;
        if (selectedSensor == null) {
            return null;
        }
        String devName = selectedSensor.getDisplayName();
        Conditional.Operator oper = Conditional.Operator.AND;
        boolean trigger = true;
        boolean negated = false;
        switch (mode) {
            case 0: {
                if (makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.SENSOR_ACTIVE;
                break;
            }
            case 1: {
                if (makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.SENSOR_INACTIVE;
                break;
            }
            case 32: {
                if (makeVeto || !onChange) {
                    return null;
                }
                type = Conditional.Type.SENSOR_ACTIVE;
                break;
            }
            case 2: {
                if (!makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.SENSOR_ACTIVE;
                negated = true;
                trigger = false;
                break;
            }
            case 3: {
                if (!makeVeto || onChange) {
                    return null;
                }
                type = Conditional.Type.SENSOR_INACTIVE;
                negated = true;
                trigger = false;
                break;
            }
            default: {
                log.error("Control Sensor {} has bad mode= {}", (Object)devName, (Object)mode);
                return null;
            }
        }
        return new ConditionalVariable(negated, oper, type, devName, trigger);
    }
}

