/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.sensor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.SensorTableAction;
import jmri.jmrit.beantable.beanedit.SensorEditAction;
import jmri.jmrit.beantable.sensor.Bundle;
import jmri.managers.ProxySensorManager;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorTableDataModel
extends BeanTableDataModel<Sensor> {
    public static final int INVERTCOL = 5;
    public static final int EDITCOL = 6;
    public static final int USEGLOBALDELAY = 7;
    public static final int ACTIVEDELAY = 8;
    public static final int INACTIVEDELAY = 9;
    public static final int PULLUPCOL = 10;
    public static final int FORGETCOL = 11;
    public static final int QUERYCOL = 12;
    private Manager<Sensor> senManager = null;
    protected boolean _graphicState = false;
    private static final Logger log = LoggerFactory.getLogger(SensorTableDataModel.class);

    public SensorTableDataModel() {
        this._graphicState = InstanceManager.getDefault(GuiLafPreferencesManager.class).isGraphicTableState();
    }

    public SensorTableDataModel(Manager<Sensor> manager) {
        this.setManager(manager);
        this._graphicState = InstanceManager.getDefault(GuiLafPreferencesManager.class).isGraphicTableState();
    }

    @Override
    public String getValue(String name) {
        Sensor sen = this.getManager().getBySystemName(name);
        if (sen == null) {
            return "Failed to get sensor " + name;
        }
        return sen.describeState(sen.getKnownState());
    }

    @Override
    protected final void setManager(@Nonnull Manager<Sensor> manager) {
        if (!(manager instanceof SensorManager)) {
            return;
        }
        this.getManager().removePropertyChangeListener(this);
        if (this.sysNameList != null) {
            for (int i = 0; i < this.sysNameList.size(); ++i) {
                Sensor b = this.getBySystemName((String)this.sysNameList.get(i));
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
        this.senManager = manager;
        this.getManager().addPropertyChangeListener(this);
        this.updateNameList();
    }

    @Override
    protected Manager<Sensor> getManager() {
        if (this.senManager == null) {
            this.senManager = InstanceManager.sensorManagerInstance();
        }
        return this.senManager;
    }

    @Override
    protected Sensor getBySystemName(@Nonnull String name) {
        return this.getManager().getBySystemName(name);
    }

    @Override
    protected Sensor getByUserName(@Nonnull String name) {
        return InstanceManager.getDefault(SensorManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return this.getClassName();
    }

    @Override
    protected void clickOn(Sensor t) {
        try {
            t.setKnownState(t.getKnownState() == 4 ? 2 : 4);
        }
        catch (JmriException e) {
            log.warn("Error setting state", (Throwable)e);
        }
    }

    @Override
    public int getColumnCount() {
        return 12 + this.getPropertyColumnCount() + 1;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 5: {
                return Bundle.getMessage("Inverted");
            }
            case 6: {
                return "";
            }
            case 7: {
                return Bundle.getMessage("SensorUseGlobalDebounce");
            }
            case 8: {
                return Bundle.getMessage("SensorActiveDebounce");
            }
            case 9: {
                return Bundle.getMessage("SensorInActiveDebounce");
            }
            case 10: {
                return Bundle.getMessage("SensorPullUp");
            }
            case 11: {
                return Bundle.getMessage("StateForgetHeader");
            }
            case 12: {
                return Bundle.getMessage("StateQueryHeader");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 5: 
            case 7: {
                return Boolean.class;
            }
            case 8: 
            case 9: {
                return Long.class;
            }
            case 10: {
                return JComboBox.class;
            }
            case 6: 
            case 11: 
            case 12: {
                return JButton.class;
            }
            case 2: {
                if (this._graphicState) {
                    return JLabel.class;
                }
                return super.getColumnClass(col);
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 5: {
                return new JTextField((int)4).getPreferredSize().width;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return new JTextField((int)8).getPreferredSize().width;
            }
            case 6: {
                return new JButton((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width + 4;
            }
            case 11: {
                return new JButton((String)Bundle.getMessage((String)"StateForgetButton")).getPreferredSize().width + 4;
            }
            case 12: {
                return new JButton((String)Bundle.getMessage((String)"StateQueryButton")).getPreferredSize().width + 4;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        String name = (String)this.sysNameList.get(row);
        Sensor sen = this.getManager().getBySystemName(name);
        if (sen == null) {
            return false;
        }
        switch (col) {
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                return true;
            }
            case 5: {
                return sen.canInvert();
            }
            case 8: 
            case 9: {
                return !sen.getUseDefaultTimerSettings();
            }
            case 10: {
                if (this.getManager() instanceof ProxySensorManager) {
                    return ((ProxySensorManager)this.getManager()).isPullResistanceConfigurable(name);
                }
                return ((SensorManager)this.getManager()).isPullResistanceConfigurable();
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.sysNameList.size()) {
            log.debug("row is greater than name list");
            return "";
        }
        String name = (String)this.sysNameList.get(row);
        Sensor s = this.senManager.getBySystemName(name);
        if (s == null) {
            log.debug("error null sensor!");
            return "error";
        }
        switch (col) {
            case 5: {
                return s.getInverted();
            }
            case 7: {
                return s.getUseDefaultTimerSettings();
            }
            case 8: {
                return s.getSensorDebounceGoingActiveTimer();
            }
            case 9: {
                return s.getSensorDebounceGoingInActiveTimer();
            }
            case 6: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 10: {
                PullResistanceComboBox c = new PullResistanceComboBox(Sensor.PullResistance.values());
                c.setSelectedItem((Object)s.getPullResistance());
                return c;
            }
            case 11: {
                return Bundle.getMessage("StateForgetButton");
            }
            case 12: {
                return Bundle.getMessage("StateQueryButton");
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row >= this.sysNameList.size()) {
            log.debug("row is greater than name list");
            return;
        }
        String name = (String)this.sysNameList.get(row);
        Sensor s = this.senManager.getBySystemName(name);
        if (s == null) {
            log.debug("error null sensor!");
            return;
        }
        switch (col) {
            case 5: {
                s.setInverted((Boolean)value);
                break;
            }
            case 7: {
                s.setUseDefaultTimerSettings((Boolean)value);
                break;
            }
            case 8: {
                try {
                    long activeDeBounce = (Long)value;
                    if (activeDeBounce < 0L || activeDeBounce > Sensor.MAX_DEBOUNCE) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SensorDebounceActOutOfRange") + "\n\"" + Sensor.MAX_DEBOUNCE + "\"", Bundle.getMessage("ErrorTitle"), 0);
                        break;
                    }
                    s.setSensorDebounceGoingActiveTimer(activeDeBounce);
                }
                catch (NumberFormatException exActiveDeBounce) {
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SensorDebounceActError") + "\n\"" + value + "\"" + exActiveDeBounce.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
                }
                break;
            }
            case 9: {
                try {
                    long inactiveDeBounce = (Long)value;
                    if (inactiveDeBounce < 0L || inactiveDeBounce > Sensor.MAX_DEBOUNCE) {
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SensorDebounceInActOutOfRange") + "\n\"" + Sensor.MAX_DEBOUNCE + "\"", Bundle.getMessage("ErrorTitle"), 0);
                        break;
                    }
                    s.setSensorDebounceGoingInActiveTimer(inactiveDeBounce);
                }
                catch (NumberFormatException exActiveDeBounce) {
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SensorDebounceInActError") + "\n\"" + value + "\"" + exActiveDeBounce.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
                }
                break;
            }
            case 6: {
                SwingUtilities.invokeLater(() -> this.editButton(s));
                break;
            }
            case 10: {
                PullResistanceComboBox cb = (PullResistanceComboBox)value;
                s.setPullResistance((Sensor.PullResistance)((Object)cb.getSelectedItem()));
                break;
            }
            case 11: {
                try {
                    s.setKnownState(1);
                }
                catch (JmriException e) {
                    log.warn("Failed to set state to UNKNOWN: ", (Throwable)e);
                }
                break;
            }
            case 12: {
                try {
                    s.setKnownState(1);
                }
                catch (JmriException e) {
                    log.warn("Failed to set state to UNKNOWN: ", (Throwable)e);
                }
                s.requestUpdateFromLayout();
                break;
            }
            case 2: {
                if (this._graphicState) {
                    this.clickOn(s);
                    this.fireTableRowsUpdated(row, row);
                    break;
                }
                super.setValueAt(value, row, col);
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "inverted": 
            case "GlobalTimer": 
            case "ActiveTimer": 
            case "InActiveTimer": {
                return true;
            }
        }
        return super.matchPropertyName(e);
    }

    @Override
    protected void configValueColumn(JTable table) {
        log.debug("Sensor configValueColumn (I am {})", (Object)this);
        if (this._graphicState) {
            table.setDefaultEditor(JLabel.class, new ImageIconRenderer());
            table.setDefaultRenderer(JLabel.class, new ImageIconRenderer());
        } else {
            super.configValueColumn(table);
        }
    }

    @Override
    public void configureTable(JTable table) {
        super.configureTable(table);
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        columnModel.getColumnByModelIndex(11).setHeaderValue(null);
        columnModel.getColumnByModelIndex(12).setHeaderValue(null);
    }

    void editButton(Sensor s) {
        SensorEditAction beanEdit = new SensorEditAction();
        beanEdit.setBean(s);
        beanEdit.actionPerformed(null);
    }

    public void showDebounce(boolean show, JTable table) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        TableColumn column = columnModel.getColumnByModelIndex(7);
        columnModel.setColumnVisible(column, show);
        column = columnModel.getColumnByModelIndex(8);
        columnModel.setColumnVisible(column, show);
        column = columnModel.getColumnByModelIndex(9);
        columnModel.setColumnVisible(column, show);
    }

    public void showPullUp(boolean show, JTable table) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        TableColumn column = columnModel.getColumnByModelIndex(10);
        columnModel.setColumnVisible(column, show);
    }

    public void showStateForgetAndQuery(boolean show, JTable table) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        TableColumn column = columnModel.getColumnByModelIndex(11);
        columnModel.setColumnVisible(column, show);
        column = columnModel.getColumnByModelIndex(12);
        columnModel.setColumnVisible(column, show);
    }

    protected String getClassName() {
        return SensorTableAction.class.getName();
    }

    public String getClassDescription() {
        return Bundle.getMessage("TitleSensorTable");
    }

    @Override
    protected void setColumnIdentities(JTable table) {
        super.setColumnIdentities(table);
        Enumeration<TableColumn> columns = table.getColumnModel() instanceof XTableColumnModel ? ((XTableColumnModel)table.getColumnModel()).getColumns(false) : table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            switch (column.getModelIndex()) {
                case 11: {
                    column.setIdentifier("ForgetState");
                    break;
                }
                case 12: {
                    column.setIdentifier("QueryState");
                    break;
                }
            }
        }
    }

    static class ImageIconRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        protected JLabel label;
        protected String rootPath = "resources/icons/misc/switchboard/";
        protected char beanTypeChar = (char)83;
        protected String onIconPath = this.rootPath + this.beanTypeChar + "-on-s.png";
        protected String offIconPath = this.rootPath + this.beanTypeChar + "-off-s.png";
        protected BufferedImage onImage;
        protected BufferedImage offImage;
        protected ImageIcon onIcon;
        protected ImageIcon offIcon;
        protected int iconHeight = -1;

        ImageIconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            return this.updateLabel((String)value, row, table);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            return this.updateLabel((String)value, row, table);
        }

        public JLabel updateLabel(String value, final int row, JTable table) {
            if (this.iconHeight > 0) {
                table.setRowHeight(row, Math.max(table.getRowHeight(), this.iconHeight - 5));
            }
            if (value.equals(Bundle.getMessage("SensorStateInactive")) && this.offIcon != null) {
                this.label = new JLabel(this.offIcon);
                this.label.setVerticalAlignment(3);
                log.debug("offIcon set");
            } else if (value.equals(Bundle.getMessage("SensorStateActive")) && this.onIcon != null) {
                this.label = new JLabel(this.onIcon);
                this.label.setVerticalAlignment(3);
                log.debug("onIcon set");
            } else if (value.equals(Bundle.getMessage("BeanStateInconsistent"))) {
                this.label = new JLabel("X", 0);
                this.label.setForeground(Color.red);
                log.debug("Sensor state inconsistent");
                this.iconHeight = 0;
            } else if (value.equals(Bundle.getMessage("BeanStateUnknown"))) {
                this.label = new JLabel("?", 0);
                log.debug("Sensor state unknown");
                this.iconHeight = 0;
            } else {
                this.label = new JLabel(value, 0);
                log.warn("Error reading icons for SensorTable");
                this.iconHeight = 0;
            }
            this.label.setToolTipText(value);
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public final void mousePressed(MouseEvent evt) {
                    log.debug("Clicked on icon in row {}", (Object)row);
                    this.stopCellEditing();
                }
            });
            return this.label;
        }

        @Override
        public Object getCellEditorValue() {
            log.debug("getCellEditorValue, me = {})", (Object)this);
            return this.toString();
        }

        protected void loadIcons() {
            try {
                this.onImage = ImageIO.read(new File(this.onIconPath));
                this.offImage = ImageIO.read(new File(this.offIconPath));
            }
            catch (IOException ex) {
                log.error("error reading image from {} or {}", new Object[]{this.onIconPath, this.offIconPath, ex});
            }
            log.debug("Success reading images");
            int imageWidth = this.onImage.getWidth();
            int imageHeight = this.onImage.getHeight();
            Image smallOnImage = this.onImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            Image smallOffImage = this.offImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            this.onIcon = new ImageIcon(smallOnImage);
            this.offIcon = new ImageIcon(smallOffImage);
            this.iconHeight = this.onIcon.getIconHeight();
        }
    }

    private static class PullResistanceComboBox
    extends JComboBox<Sensor.PullResistance> {
        PullResistanceComboBox(Sensor.PullResistance[] values) {
            super(values);
        }
    }
}

