/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.SignalSystem;
import jmri.SignalSystemManager;
import jmri.UserPreferencesManager;
import jmri.implementation.DefaultSignalAppearanceMap;
import jmri.jmrit.XmlFile;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.jmrit.beantable.signalmast.SignalMastAddPane;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSignalMastPanel
extends JPanel {
    JTextField userName = new JTextField(20);
    JComboBox<String> sigSysBox = new JComboBox();
    JComboBox<String> mastBox = new JComboBox<String>(new String[]{Bundle.getMessage("MastEmpty")});
    boolean mastBoxPassive = false;
    JComboBox<String> signalMastDriver;
    List<SignalMastAddPane> panes = new ArrayList<SignalMastAddPane>();
    JPanel centerPanel = new JPanel();
    CardLayout cl = new CardLayout();
    SignalMastAddPane currentPane;
    JPanel signalHeadPanel = new JPanel();
    JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
    JButton apply = new JButton(Bundle.getMessage("ButtonApply"));
    JButton create = new JButton(Bundle.getMessage("ButtonCreate"));
    private UserPreferencesManager prefs = InstanceManager.getDefault(UserPreferencesManager.class);
    private String systemSelectionCombo = this.getClass().getName() + ".SignallingSystemSelected";
    private String mastSelectionCombo = this.getClass().getName() + ".SignallingMastSelected";
    private String driverSelectionCombo = this.getClass().getName() + ".SignallingDriverSelected";
    private String sigsysname;
    private ArrayList<File> mastFiles = new ArrayList();
    private LinkedHashMap<String, Integer> mapNameToShowSize = new LinkedHashMap();
    private LinkedHashMap<String, String> mapTypeToName = new LinkedHashMap();
    private static final Logger log = LoggerFactory.getLogger(AddSignalMastPanel.class);

    public AddSignalMastPanel() {
        log.debug("AddSignalMastPanel()");
        SignalMastAddPane.SignalMastAddPaneProvider.getInstancesCollection().forEach(provider -> {
            if (provider.isAvailable()) {
                this.panes.add(provider.getNewPane());
            }
        });
        String[] tempMastNamesArray = new String[this.panes.size()];
        int i = 0;
        for (SignalMastAddPane pane : this.panes) {
            tempMastNamesArray[i++] = pane.getPaneName();
        }
        this.signalMastDriver = new JComboBox<String>(tempMastNamesArray);
        this.init();
    }

    final void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridLayout2(5, 2));
        JLabel l = new JLabel(Bundle.getMessage("LabelUserName"));
        p.add(l);
        p.add(this.userName);
        l = new JLabel(Bundle.getMessage("SigSys") + ": ");
        p.add(l);
        p.add(this.sigSysBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.sigSysBox);
        l = new JLabel(Bundle.getMessage("MastType") + ": ");
        p.add(l);
        p.add(this.mastBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.mastBox);
        l = new JLabel(Bundle.getMessage("DriverType") + ": ");
        p.add(l);
        p.add(this.signalMastDriver);
        JComboBoxUtil.setupComboBoxMaxRows(this.signalMastDriver);
        this.add(p);
        this.centerPanel.setLayout(this.cl);
        for (SignalMastAddPane pane : this.panes) {
            this.centerPanel.add((Component)pane, pane.getPaneName());
        }
        this.add(this.centerPanel);
        this.signalMastDriver.addItemListener(evt -> {
            log.trace("about to call selection() from signalMastDriver itemStateChanged");
            this.selection((String)evt.getItem());
        });
        JPanel buttonHolder = new JPanel();
        buttonHolder.setLayout(new FlowLayout(4));
        this.cancel.setVisible(true);
        buttonHolder.add(this.cancel);
        this.cancel.addActionListener(e -> this.cancelPressed());
        this.cancel.setVisible(true);
        buttonHolder.add(this.create);
        this.create.addActionListener(e -> this.okPressed());
        this.create.setVisible(true);
        buttonHolder.add(this.apply);
        this.apply.addActionListener(e -> this.okPressed());
        this.apply.setVisible(false);
        this.add(buttonHolder);
        this.currentPane = this.panes.get(0);
        SignalSystemManager man = InstanceManager.getDefault(SignalSystemManager.class);
        SortedSet systems = man.getNamedBeanSet();
        for (SignalSystem system : systems) {
            this.sigSysBox.addItem(system.getUserName());
        }
        if (this.prefs.getComboBoxLastSelection(this.systemSelectionCombo) != null) {
            this.sigSysBox.setSelectedItem(this.prefs.getComboBoxLastSelection(this.systemSelectionCombo));
        }
        log.trace("  preferences set {} into sigSysBox", this.sigSysBox.getSelectedItem());
        this.loadMastDefinitions();
        this.selection(this.panes.get(0).getPaneName());
        if (this.prefs.getComboBoxLastSelection(this.driverSelectionCombo) != null) {
            this.signalMastDriver.setSelectedItem(this.prefs.getComboBoxLastSelection(this.driverSelectionCombo));
        }
        this.sigSysBox.addItemListener(e -> {
            this.loadMastDefinitions();
            this.updateSelectedDriver();
        });
    }

    final void selection(String view) {
        log.trace(" selection({}) start", (Object)view);
        for (SignalMastAddPane pane : this.panes) {
            if (!pane.getPaneName().equals(view)) continue;
            this.currentPane = pane;
        }
        this.updateSelectedDriver();
        this.cl.show(this.centerPanel, view);
        log.trace(" selection({}) end", (Object)view);
    }

    public AddSignalMastPanel(SignalMast mast) {
        this();
        log.debug("AddSignalMastPanel({}) start", (Object)mast);
        this.apply.setVisible(true);
        this.create.setVisible(false);
        this.sigSysBox.setEnabled(false);
        this.mastBox.setEnabled(false);
        this.signalMastDriver.setEnabled(false);
        this.userName.setEnabled(false);
        this.userName.setText(mast.getUserName());
        log.trace("Prior content system name: {}  mast type: {}", (Object)mast.getSignalSystem().getUserName(), (Object)mast.getMastType());
        if (mast.getMastType() == null) {
            log.error("MastType was null, and never should be");
        }
        this.sigSysBox.setSelectedItem(mast.getSignalSystem().getUserName());
        for (SignalMastAddPane pane : this.panes) {
            if (!pane.canHandleMast(mast)) continue;
            this.currentPane = pane;
            this.signalMastDriver.setSelectedItem(pane.getPaneName());
            log.trace("About to call selection() from SignalMastAddPane loop in AddSignalMastPanel(SignalMast mast)");
            this.selection(pane.getPaneName());
            this.mastBoxPassive = false;
            if (this.mapTypeToName.get(mast.getMastType()) == null) {
                log.error("About to set mast to null, which shouldn't happen. mast.getMastType() is {}", (Object)mast.getMastType(), (Object)new Exception("Traceback Exception"));
            }
            log.trace("set mastBox to \"{}\" from \"{}\"", (Object)this.mapTypeToName.get(mast.getMastType()), (Object)mast.getMastType());
            this.mastBox.setSelectedItem(this.mapTypeToName.get(mast.getMastType()));
            pane.setMast(mast);
            break;
        }
        this.mastBoxPassive = true;
        String newMastType = this.mapTypeToName.get(mast.getMastType());
        log.debug("Setting type to {}", (Object)newMastType);
        this.mastBox.setSelectedItem(newMastType);
        this.mastBoxPassive = false;
        log.debug("AddSignalMastPanel({}) end", (Object)mast);
    }

    void loadMastDefinitions() {
        log.trace(" loadMastDefinitions() start");
        if (this.mastBox.getItemListeners().length > 0) {
            this.mastBox.removeItemListener(this.mastBox.getItemListeners()[0]);
        }
        this.mastBox.removeAllItems();
        try {
            this.mastFiles = new ArrayList();
            SignalSystemManager man = InstanceManager.getDefault(SignalSystemManager.class);
            String u = (String)this.sigSysBox.getSelectedItem();
            SignalSystem sig = man.getByUserName(u);
            if (sig == null) {
                log.error("Signal System Not found for Username {}", (Object)u);
                return;
            }
            this.sigsysname = sig.getSystemName();
            log.trace("     loadMastDefinitions with sigsysname {}", (Object)this.sigsysname);
            this.mapNameToShowSize = new LinkedHashMap();
            this.mapTypeToName = new LinkedHashMap();
            File[] programDirArray = new File[]{};
            URL pathProgramDir = FileUtil.findURL("xml/signals/" + this.sigsysname, FileUtil.Location.INSTALLED);
            if (pathProgramDir != null) {
                programDirArray = new File(pathProgramDir.toURI()).listFiles();
            }
            if (programDirArray == null) {
                programDirArray = new File[]{};
            }
            File[] profileDirArray = new File[]{};
            URL pathProfileDir = FileUtil.findURL("resources/signals/" + this.sigsysname, FileUtil.Location.USER);
            if (pathProfileDir != null) {
                profileDirArray = new File(pathProfileDir.toURI()).listFiles();
            }
            if (profileDirArray == null) {
                profileDirArray = new File[]{};
            }
            File[] apps = Arrays.copyOf(programDirArray, programDirArray.length + profileDirArray.length);
            System.arraycopy(profileDirArray, 0, apps, programDirArray.length, profileDirArray.length);
            if (apps != null) {
                for (File app : apps) {
                    if (!app.getName().startsWith("appearance") || !app.getName().endsWith(".xml")) continue;
                    log.debug("   found file: {}", (Object)app.getName());
                    this.mastFiles.add(app);
                    XmlFile xf = new XmlFile(){};
                    Element root = xf.rootFromFile(app);
                    String name = root.getChild("name").getText();
                    log.trace("mastNames adding \"{}\" mastBox adding \"{}\" ", (Object)app, (Object)name);
                    this.mastBox.addItem(name);
                    log.trace("mapTypeToName adding key \"{}\" value \"{}\"", (Object)app.getName().substring(11, app.getName().indexOf(".xml")), (Object)name);
                    this.mapTypeToName.put(app.getName().substring(11, app.getName().indexOf(".xml")), name);
                    this.mapNameToShowSize.put(name, root.getChild("appearances").getChild("appearance").getChildren("show").size());
                }
            } else {
                log.error("Unexpected null list of signal definition files");
            }
        }
        catch (JDOMException e2) {
            this.mastBox.addItem(Bundle.getMessage("ErrorSignalMastBox1"));
            log.warn("in loadMastDefinitions", (Throwable)e2);
        }
        catch (IOException | URISyntaxException e3) {
            this.mastBox.addItem(Bundle.getMessage("ErrorSignalMastBox2"));
            log.warn("in loadMastDefinitions", (Throwable)e3);
        }
        try {
            URL path = FileUtil.findURL("signals/" + this.sigsysname, FileUtil.Location.USER, "xml", "resources");
            if (path != null) {
                File[] apps = new File(path.toURI()).listFiles();
                if (apps != null) {
                    for (File app : apps) {
                        if (!app.getName().startsWith("appearance") || !app.getName().endsWith(".xml")) continue;
                        log.debug("   found file: {}", (Object)app.getName());
                        if (this.mastFiles.contains(app)) continue;
                        this.mastFiles.add(app);
                        XmlFile xf = new XmlFile(){};
                        Element root = xf.rootFromFile(app);
                        String name = root.getChild("name").getText();
                        if (this.mapNameToShowSize.containsKey(name)) continue;
                        this.mastBox.addItem(name);
                        this.mapNameToShowSize.put(name, root.getChild("appearances").getChild("appearance").getChildren("show").size());
                    }
                } else {
                    log.warn("No mast definition files found");
                }
            }
        }
        catch (IOException | URISyntaxException | JDOMException e4) {
            log.warn("in loadMastDefinitions", e4);
        }
        this.mastBox.addItemListener(e -> {
            if (!this.mastBoxPassive) {
                this.updateSelectedDriver();
            }
        });
        this.updateSelectedDriver();
        if (this.prefs.getComboBoxLastSelection(this.mastSelectionCombo + ":" + (String)this.sigSysBox.getSelectedItem()) != null) {
            this.mastBox.setSelectedItem(this.prefs.getComboBoxLastSelection(this.mastSelectionCombo + ":" + (String)this.sigSysBox.getSelectedItem()));
        }
        log.trace(" loadMastDefinitions() end");
    }

    protected void updateSelectedDriver() {
        log.trace(" updateSelectedDriver() start");
        if (this.mastBox.getSelectedIndex() < 0) {
            return;
        }
        String mastFile = this.mastFiles.get(this.mastBox.getSelectedIndex()).getName();
        String mastType = mastFile.substring(11, mastFile.indexOf(".xml"));
        DefaultSignalAppearanceMap sigMap = DefaultSignalAppearanceMap.getMap(this.sigsysname, mastType);
        SignalSystem sigsys = InstanceManager.getDefault(SignalSystemManager.class).getSystem(this.sigsysname);
        if (sigsys == null) {
            log.error("Signalling System for {} Not Found", (Object)this.sigsysname);
        } else {
            this.currentPane.setAspectNames(sigMap, sigsys);
        }
        this.currentPane.setMast(null);
        this.currentPane.revalidate();
        Container ancestor = this.getTopLevelAncestor();
        if (ancestor instanceof JmriJFrame) {
            ((JmriJFrame)ancestor).pack();
        } else {
            log.debug("Can't call pack() on {}", (Object)ancestor);
        }
        log.trace(" updateSelectedDriver() end");
    }

    boolean checkUserName(String nam) {
        if (nam != null && !nam.isEmpty()) {
            SignalMast nB = InstanceManager.getDefault(SignalMastManager.class).getByUserName(nam);
            if (nB != null) {
                this.issueWarningUserName(nam);
                return false;
            }
            nB = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(nam);
            if (nB != null) {
                this.issueWarningUserNameAsSystem(nam);
                return false;
            }
        }
        return true;
    }

    void issueWarningUserName(String nam) {
        log.error("User Name \"{}\" is already in use", (Object)nam);
        if (!GraphicsEnvironment.isHeadless()) {
            String msg = Bundle.getMessage("WarningUserName", nam);
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
        }
    }

    void issueWarningUserNameAsSystem(String nam) {
        log.error("User Name \"{}\" already exists as a System name", (Object)nam);
        if (!GraphicsEnvironment.isHeadless()) {
            String msg = Bundle.getMessage("WarningUserNameAsSystem", nam);
            JmriJOptionPane.showMessageDialog(this, msg, Bundle.getMessage("WarningTitle"), 0);
        }
    }

    private void okPressed() {
        boolean success;
        int i;
        String user;
        log.trace(" okPressed() start");
        if (this.mastBox.getSelectedIndex() < 0 || this.mastFiles.get(this.mastBox.getSelectedIndex()) == null) {
            this.issueDialogFailMessage(new RuntimeException("There's something wrong with the mast type selection"));
            return;
        }
        String mastname = this.mastFiles.get(this.mastBox.getSelectedIndex()).getName();
        String tmpUserName = NamedBean.normalizeUserName(this.userName.getText());
        String string = user = tmpUserName != null ? tmpUserName : "";
        if (!GraphicsEnvironment.isHeadless() && user.isEmpty() && (i = this.issueNoUserNameGiven()) != 0) {
            return;
        }
        try {
            success = this.currentPane.createMast(this.sigsysname, mastname, user);
        }
        catch (RuntimeException ex) {
            this.issueDialogFailMessage(ex);
            return;
        }
        if (!success) {
            return;
        }
        this.clearPanel();
        log.trace(" okPressed() end");
    }

    int issueNoUserNameGiven() {
        return JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("SignalMastEmptyUserNameDialog"), Bundle.getMessage("SignalMastEmptyUserNameDialogTitle"), 0);
    }

    void issueDialogFailMessage(RuntimeException ex) {
        log.error("Failed during createMast", (Throwable)ex);
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DialogFailMessage", ex.toString()), Bundle.getMessage("DialogFailTitle"), 0);
    }

    public void refresh() {
        log.trace(" refresh() start");
        this.centerPanel.removeAll();
        for (SignalMastAddPane pane : this.panes) {
            this.centerPanel.add((Component)pane, pane.getPaneName());
        }
        log.trace("about to call selection from refresh");
        this.selection(this.signalMastDriver.getItemAt(this.signalMastDriver.getSelectedIndex()));
        log.trace(" refresh() end");
    }

    private void cancelPressed() {
        log.trace(" cancelPressed() start");
        this.clearPanel();
        log.trace(" cancelPressed() end");
    }

    private void clearPanel() {
        log.trace(" clearPanel() start");
        Container ancestor = this.getTopLevelAncestor();
        if (ancestor instanceof JmriJFrame) {
            ((JmriJFrame)ancestor).dispose();
        } else {
            log.warn("Unexpected top level ancestor: {}", (Object)ancestor);
        }
        this.userName.setText("");
        log.trace(" clearPanel() end");
    }
}

