/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.SignalMastLogicTableAction;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.jmrit.signalling.SignallingAction;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastLogicTableDataModel
extends BeanTableDataModel<SignalMastLogic> {
    public static final int SOURCECOL = 0;
    public static final int SOURCEAPPCOL = 1;
    public static final int DESTCOL = 2;
    public static final int DESTAPPCOL = 3;
    public static final int COMCOL = 4;
    public static final int DELCOL = 5;
    public static final int ENABLECOL = 6;
    public static final int EDITLOGICCOL = 7;
    public static final int MAXSPEEDCOL = 8;
    public static final int COLUMNCOUNT = 9;
    private boolean suppressUpdate = false;
    private ArrayList<Hashtable<SignalMastLogic, SignalMast>> signalMastLogicList = null;
    final SignallingAction sigLog = new SignallingAction();
    private static final Logger log = LoggerFactory.getLogger(SignalMastLogicTableDataModel.class);

    public SignalMastLogicTableDataModel() {
        this.updateNameList();
    }

    protected SignalMastLogicManager getManager() {
        return InstanceManager.getDefault(SignalMastLogicManager.class);
    }

    @Override
    public String getValue(String s) {
        return "Set";
    }

    @Override
    protected String getMasterClassName() {
        return SignalMastLogicTableAction.class.getName();
    }

    @Override
    public void clickOn(SignalMastLogic t) {
    }

    @Nonnull
    private List<Hashtable<SignalMastLogic, SignalMast>> getSMLList() {
        if (this.signalMastLogicList == null) {
            this.signalMastLogicList = new ArrayList();
        }
        return this.signalMastLogicList;
    }

    @Override
    protected synchronized void updateNameList() {
        for (int i = 0; i < this.getSMLList().size(); ++i) {
            Hashtable<SignalMastLogic, SignalMast> b = this.getSMLList().get(i);
            Enumeration<SignalMastLogic> en = b.keys();
            while (en.hasMoreElements()) {
                SignalMastLogic sm = en.nextElement();
                SignalMast dest = b.get(sm);
                sm.removePropertyChangeListener(this);
                sm.getSourceMast().removePropertyChangeListener(this);
                dest.removePropertyChangeListener(this);
            }
        }
        List<SignalMastLogic> source = this.getManager().getSignalMastLogicList();
        this.signalMastLogicList.clear();
        for (int i = 0; i < source.size(); ++i) {
            List<SignalMast> destList = source.get(i).getDestinationList();
            source.get(i).addPropertyChangeListener(this);
            source.get(i).getSourceMast().addPropertyChangeListener(this);
            for (int j = 0; j < destList.size(); ++j) {
                Hashtable<SignalMastLogic, SignalMast> hash = new Hashtable<SignalMastLogic, SignalMast>(1);
                hash.put(source.get(i), destList.get(j));
                destList.get(j).addPropertyChangeListener(this);
                this.getSMLList().add(hash);
            }
        }
    }

    public void setSuppressUpdate(boolean newVal) {
        this.suppressUpdate = newVal;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block7: {
            block8: {
                block6: {
                    if (this.suppressUpdate) {
                        return;
                    }
                    if (!"length".equals(e.getPropertyName()) && !"updatedDestination".equals(e.getPropertyName()) && !"updatedSource".equals(e.getPropertyName())) break block6;
                    this.updateNameList();
                    log.debug("Table changed length to {}", (Object)this.getSMLList().size());
                    this.fireTableDataChanged();
                    break block7;
                }
                if (!(e.getSource() instanceof SignalMastLogic)) break block8;
                SignalMastLogic logic = (SignalMastLogic)e.getSource();
                if (!this.matchPropertyName(e)) break block7;
                for (int i = 0; i < this.getSMLList().size(); ++i) {
                    Hashtable<SignalMastLogic, SignalMast> b = this.getSMLList().get(i);
                    Enumeration<SignalMastLogic> en = b.keys();
                    while (en.hasMoreElements()) {
                        SignalMastLogic sm = en.nextElement();
                        if (sm != logic) continue;
                        this.fireTableRowsUpdated(i, i);
                    }
                }
                break block7;
            }
            if (e.getSource() instanceof SignalMast) {
                SignalMast sigMast = (SignalMast)e.getSource();
                for (int i = 0; i < this.getSMLList().size(); ++i) {
                    Hashtable<SignalMastLogic, SignalMast> b = this.getSMLList().get(i);
                    Enumeration<SignalMastLogic> en = b.keys();
                    while (en.hasMoreElements()) {
                        SignalMastLogic sm = en.nextElement();
                        if (sm.getSourceMast() != sigMast) continue;
                        this.fireTableRowsUpdated(i, i);
                    }
                }
            }
        }
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "Enabled": 
            case "updatedDestination": {
                return true;
            }
        }
        return super.matchPropertyName(e);
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public int getRowCount() {
        return this.getSMLList().size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getSMLList().size()) {
            log.debug("row index is greater than signalMastLogicList size");
            return null;
        }
        SignalMastLogic b = this.getLogicFromRow(row);
        if (b == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return b.getSourceMast().getDisplayName();
            }
            case 2: {
                SignalMast destMast = this.getDestMastFromRow(row);
                return destMast != null ? destMast.getDisplayName() : null;
            }
            case 1: {
                return b.getSourceMast().getAspect();
            }
            case 3: {
                SignalMast destMast = this.getDestMastFromRow(row);
                return destMast != null ? destMast.getAspect() : null;
            }
            case 4: {
                return b.getComment(this.getDestMastFromRow(row));
            }
            case 5: {
                return Bundle.getMessage("ButtonDelete");
            }
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 6: {
                return b.isEnabled(this.getDestMastFromRow(row));
            }
            case 8: {
                return Float.valueOf(b.getMaximumSpeed(this.getDestMastFromRow(row)));
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        SignalMastLogic rowLogic = this.getLogicFromRow(row);
        if (rowLogic == null) {
            return;
        }
        switch (col) {
            case 4: {
                rowLogic.setComment((String)value, this.getDestMastFromRow(row));
                break;
            }
            case 7: {
                ThreadingUtil.runOnGUIEventually(() -> this.editLogic(row));
                break;
            }
            case 5: {
                this.deleteLogic(row);
                break;
            }
            case 6: {
                SignalMast destMast = this.getDestMastFromRow(row);
                if (destMast == null) break;
                if (((Boolean)value).booleanValue()) {
                    rowLogic.setEnabled(destMast);
                    break;
                }
                rowLogic.setDisabled(destMast);
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Source");
            }
            case 2: {
                return Bundle.getMessage("Destination");
            }
            case 1: {
                return Bundle.getMessage("LabelAspectType");
            }
            case 3: {
                return Bundle.getMessage("LabelAspectType");
            }
            case 4: {
                return Bundle.getMessage("Comment");
            }
            case 5: {
                return "";
            }
            case 7: {
                return "";
            }
            case 6: {
                return Bundle.getMessage("ColumnHeadEnabled");
            }
            case 8: {
                return Bundle.getMessage("LabelMaxSpeed");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return String.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 5: 
            case 7: {
                return JButton.class;
            }
            case 8: {
                return Float.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    void editLogic(int row) {
        SignalMastLogic sml = this.getLogicFromRow(row);
        if (sml != null) {
            this.sigLog.setMast(sml.getSourceMast(), this.getDestMastFromRow(row));
            this.sigLog.actionPerformed(null);
        }
    }

    void deleteLogic(int row) {
        SignalMastLogic sml = this.getLogicFromRow(row);
        SignalMast destMast = this.getDestMastFromRow(row);
        if (sml != null && destMast != null) {
            InstanceManager.getDefault(SignalMastLogicManager.class).removeSignalMastLogic(sml, destMast);
        }
    }

    @CheckForNull
    public SignalMast getDestMastFromRow(int row) {
        Hashtable<SignalMastLogic, SignalMast> b = this.getSMLList().get(row);
        Enumeration<SignalMastLogic> en = b.keys();
        if (en.hasMoreElements()) {
            return b.get(en.nextElement());
        }
        return null;
    }

    @CheckForNull
    public SignalMastLogic getLogicFromRow(int row) {
        Hashtable<SignalMastLogic, SignalMast> b = this.getSMLList().get(row);
        Enumeration<SignalMastLogic> en = b.keys();
        if (en.hasMoreElements()) {
            return en.nextElement();
        }
        return null;
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 4: {
                return 75;
            }
            case 7: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 5: 
            case 6: {
                return new JTextField((int)5).getPreferredSize().width;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public void configureTable(JTable table) {
        this.setColumnToHoldButton(table, 7, new JButton(Bundle.getMessage("ButtonEdit")));
        table.getTableHeader().setReorderingAllowed(true);
        table.setAutoResizeMode(0);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int width = this.getPreferredWidth(i);
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        table.sizeColumnsToFit(-1);
        this.configDeleteColumn(table);
    }

    @Override
    public SignalMastLogic getBySystemName(@Nonnull String name) {
        return null;
    }

    @Override
    public SignalMastLogic getByUserName(@Nonnull String name) {
        return null;
    }

    @Override
    public synchronized void dispose() {
        this.getManager().removePropertyChangeListener(this);
        for (int i = 0; i < this.getSMLList().size(); ++i) {
            SignalMastLogic b = this.getLogicFromRow(i);
            if (b == null) continue;
            b.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    protected void configDeleteColumn(JTable table) {
        this.setColumnToHoldButton(table, 5, new JButton(Bundle.getMessage("ButtonDelete")));
    }

    @Override
    protected String getBeanType() {
        return "Signal Mast Logic";
    }

    @Override
    protected void showPopup(JmriMouseEvent e) {
    }

    @Override
    protected void setColumnIdentities(JTable table) {
        super.setColumnIdentities(table);
        Enumeration<TableColumn> columns = table.getColumnModel() instanceof XTableColumnModel ? ((XTableColumnModel)table.getColumnModel()).getColumns(false) : table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            switch (column.getModelIndex()) {
                case 1: {
                    column.setIdentifier("SrcAspect");
                    break;
                }
                case 3: {
                    column.setIdentifier("DstAspect");
                    break;
                }
                case 5: {
                    column.setIdentifier("Delete");
                    break;
                }
                case 7: {
                    column.setIdentifier("Edit");
                    break;
                }
            }
        }
    }

    @Override
    public String getCellToolTip(JTable table, int row, int col) {
        SignalMastLogic sml = this.getLogicFromRow(row);
        if (sml == null) {
            return null;
        }
        String tip = null;
        switch (col) {
            case 0: {
                tip = this.formatToolTip(sml.getSourceMast().getComment());
                break;
            }
            case 2: {
                SignalMast dest = this.getDestMastFromRow(row);
                if (dest == null) break;
                tip = this.formatToolTip(dest.getComment());
                break;
            }
            case 4: {
                SignalMast dest = this.getDestMastFromRow(row);
                if (dest == null) break;
                tip = this.formatToolTip(sml.getComment(dest));
                break;
            }
        }
        return tip;
    }
}

