/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.signalmast;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.RowComboBoxPanel;
import jmri.jmrit.beantable.SignalMastTableAction;
import jmri.jmrit.beantable.signalmast.AddSignalMastJFrame;
import jmri.jmrit.beantable.signalmast.Bundle;
import jmri.jmrit.signalling.SignallingSourceAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastTableDataModel
extends BeanTableDataModel<SignalMast> {
    public static final int EDITMASTCOL = 5;
    public static final int EDITLOGICCOL = 6;
    public static final int LITCOL = 7;
    public static final int HELDCOL = 8;
    HashMap<Object, JComboBox<String>> editorMap = new HashMap();
    HashMap<Object, Vector<String>> boxMap = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(SignalMastTableDataModel.class);

    @Override
    public String getValue(String name) {
        SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(name);
        if (sm != null) {
            return sm.getAspect();
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 2: {
                return Bundle.getMessage("LabelAspectType");
            }
            case 5: {
                return "";
            }
            case 6: {
                return "";
            }
            case 7: {
                return Bundle.getMessage("ColumnHeadLit");
            }
            case 8: {
                return Bundle.getMessage("ColumnHeadHeld");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: {
                return RowComboBoxPanel.class;
            }
            case 5: 
            case 6: {
                return JButton.class;
            }
            case 7: 
            case 8: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 7: {
                return new JTextField((int)Bundle.getMessage((String)"ColumnHeadLit").length()).getPreferredSize().width;
            }
            case 8: {
                return new JTextField((int)Bundle.getMessage((String)"ColumnHeadHeld").length()).getPreferredSize().width;
            }
            case 6: {
                return new JTextField((int)Bundle.getMessage((String)"EditSignalLogicButton").length()).getPreferredSize().width;
            }
            case 5: {
                return new JTextField((int)Bundle.getMessage((String)"ButtonEdit").length()).getPreferredSize().width;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    protected Manager<SignalMast> getManager() {
        return InstanceManager.getDefault(SignalMastManager.class);
    }

    @Override
    protected SignalMast getBySystemName(@Nonnull String name) {
        return InstanceManager.getDefault(SignalMastManager.class).getBySystemName(name);
    }

    @Override
    protected SignalMast getByUserName(@Nonnull String name) {
        return InstanceManager.getDefault(SignalMastManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return this.getClassName();
    }

    @Override
    protected void clickOn(SignalMast t) {
        log.debug("No action for click on {}", (Object)t.getDisplayName());
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.sysNameList.size()) {
            log.debug("row index is greater than name list");
            return "error";
        }
        String name = (String)this.sysNameList.get(row);
        SignalMast s = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(name);
        if (s == null) {
            return false;
        }
        switch (col) {
            case 7: {
                return s.getLit();
            }
            case 8: {
                return s.getHeld();
            }
            case 6: {
                return Bundle.getMessage("EditSignalLogicButton");
            }
            case 5: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 2: {
                String aspect = s.getAspect();
                if (aspect != null) {
                    return aspect;
                }
                return Bundle.getMessage("BeanStateUnknown");
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String name = (String)this.sysNameList.get(row);
        SignalMast s = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(name);
        if (s == null) {
            return;
        }
        switch (col) {
            case 2: {
                if ((String)value == null) break;
                log.debug("setValueAt (rowConverted={}; value={})", (Object)row, value);
                s.setAspect((String)value);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 7: {
                boolean b = (Boolean)value;
                s.setLit(b);
                break;
            }
            case 8: {
                boolean b = (Boolean)value;
                s.setHeld(b);
                break;
            }
            case 6: {
                this.editLogic(row, col);
                break;
            }
            case 5: {
                this.editMast(row, col);
                break;
            }
            default: {
                super.setValueAt(value, row, col);
            }
        }
    }

    void editLogic(int row, int col) {
        SwingUtilities.invokeLater(() -> {
            SignallingSourceAction action = new SignallingSourceAction(Bundle.getMessage("TitleSignalMastLogicTable"), this.getBySystemName((String)this.sysNameList.get(row)));
            action.actionPerformed(null);
        });
    }

    void editMast(int row, int col) {
        SwingUtilities.invokeLater(() -> {
            AddSignalMastJFrame editFrame = new AddSignalMastJFrame(this.getBySystemName((String)this.sysNameList.get(row)));
            editFrame.setVisible(true);
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ((e.getPropertyName().contains("aspectEnabled") || e.getPropertyName().contains("aspectDisabled")) && e.getSource() instanceof NamedBean) {
            String name = ((NamedBean)e.getSource()).getSystemName();
            if (log.isDebugEnabled()) {
                log.debug("Update cell {}, {} for {}", new Object[]{this.sysNameList.indexOf(name), 2, name});
            }
            int row = this.sysNameList.indexOf(name);
            this.fireTableRowsUpdated(row, row);
            this.clearAspectVector(row);
        }
        super.propertyChange(e);
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        if (e.getPropertyName().contains("Aspect") || e.getPropertyName().contains("Lit") || e.getPropertyName().contains("Held") || e.getPropertyName().contains("aspectDisabled") || e.getPropertyName().contains("aspectEnabled")) {
            return true;
        }
        return super.matchPropertyName(e);
    }

    @Override
    protected void configValueColumn(JTable table) {
        this.setColumnToHoldButton(table, 2, this.configureButton());
        log.debug("Mast configValueColumn (I am {})", (Object)super.toString());
        table.setDefaultEditor(RowComboBoxPanel.class, new AspectComboBoxPanel());
        table.setDefaultRenderer(RowComboBoxPanel.class, new AspectComboBoxPanel());
    }

    @Override
    public JButton configureButton() {
        JButton b = new JButton("Diverging Approach Medium");
        b.putClientProperty("JComponent.sizeVariant", "small");
        b.putClientProperty("JButton.buttonType", "square");
        return b;
    }

    public void clearAspectVector(int row) {
        this.boxMap.remove(this.getValueAt(row, 0));
        this.editorMap.remove(this.getValueAt(row, 0));
    }

    JComboBox<String> getAspectEditorBox(int row) {
        JComboBox<String> editCombo = this.editorMap.get(this.getValueAt(row, 0));
        if (editCombo == null) {
            editCombo = new JComboBox<String>(this.getAspectVector(row));
            this.editorMap.put(this.getValueAt(row, 0), editCombo);
        }
        return editCombo;
    }

    Vector<String> getAspectVector(int row) {
        Vector<String> comboaspects = this.boxMap.get(this.getValueAt(row, 0));
        if (comboaspects == null) {
            Vector<String> v = ((SignalMast)this.getValueAt(row, 0)).getValidAspects();
            comboaspects = v;
            this.boxMap.put(this.getValueAt(row, 0), comboaspects);
        }
        return comboaspects;
    }

    protected String getClassName() {
        return SignalMastTableAction.class.getName();
    }

    public String getClassDescription() {
        return Bundle.getMessage("TitleSignalMastTable");
    }

    public class AspectComboBoxPanel
    extends RowComboBoxPanel {
        @Override
        protected final void eventEditorMousePressed() {
            this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
            this.editor.revalidate();
            SwingUtilities.invokeLater(this.comboBoxFocusRequester);
            log.debug("eventEditorMousePressed in row: {}; me = {})", (Object)this.currentRow, (Object)this.toString());
        }

        @Override
        protected JComboBox<String> getEditorBox(int row) {
            return SignalMastTableDataModel.this.getAspectEditorBox(row);
        }
    }
}

