/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.turnout;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import jmri.Turnout;
import jmri.TurnoutOperation;
import jmri.jmrit.beantable.turnout.Bundle;
import jmri.jmrit.beantable.turnout.TurnoutTableDataModel;
import jmri.jmrit.turnoutoperations.TurnoutOperationConfig;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutOperationEditorDialog
extends JDialog {
    private TurnoutOperation myOp;
    final Turnout myTurnout;
    final TurnoutOperationEditorDialog self = this;
    private static final Logger log = LoggerFactory.getLogger(TurnoutOperationEditorDialog.class);

    TurnoutOperationEditorDialog(@Nonnull TurnoutOperation op, @Nonnull Turnout t, @CheckForNull Window window) {
        super(window);
        this.myOp = op;
        this.myTurnout = t;
        this.init();
    }

    private void init() {
        this.myOp.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("Deleted")) {
                this.setVisible(false);
            }
        });
        TurnoutOperationConfig config = TurnoutOperationConfig.getConfigPanel(this.myOp);
        this.setTitle();
        log.debug("TurnoutOpsEditDialog title set");
        if (config != null) {
            log.debug("OpsEditDialog opening");
            Box outerBox = Box.createVerticalBox();
            outerBox.add(config);
            Box buttonBox = Box.createHorizontalBox();
            JButton nameButton = new JButton(Bundle.getMessage("NameSetting"));
            nameButton.addActionListener(e -> {
                String newName = JmriJOptionPane.showInputDialog((Component)this.self, Bundle.getMessage("NameParameterSetting"), "");
                if (newName != null && !newName.isEmpty()) {
                    if (!this.myOp.rename(newName)) {
                        JmriJOptionPane.showMessageDialog(this.self, Bundle.getMessage("TurnoutErrorDuplicate"), Bundle.getMessage("WarningTitle"), 0);
                    }
                    this.setTitle();
                    this.myTurnout.setTurnoutOperation(null);
                    this.myTurnout.setTurnoutOperation(this.myOp);
                }
            });
            JButton okButton = new JButton(Bundle.getMessage("ButtonOK"));
            okButton.addActionListener(e -> {
                config.endConfigure();
                if (this.myOp.isNonce() && this.myOp.equivalentTo(this.myOp.getDefinitive())) {
                    this.myTurnout.setTurnoutOperation(null);
                    this.myOp.dispose();
                    this.myOp = null;
                }
                this.self.setVisible(false);
                TurnoutTableDataModel.editingOps.set(false);
            });
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            cancelButton.addActionListener(e -> {
                this.self.setVisible(false);
                TurnoutTableDataModel.editingOps.set(false);
            });
            buttonBox.add(Box.createHorizontalGlue());
            if (!this.myOp.isDefinitive()) {
                buttonBox.add(nameButton);
            }
            buttonBox.add(okButton);
            buttonBox.add(cancelButton);
            outerBox.add(buttonBox);
            this.getContentPane().add(outerBox);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TurnoutTableDataModel.editingOps.set(false);
                }
            });
        } else {
            log.error("Error opening Turnout automation edit pane");
        }
        this.pack();
    }

    private void setTitle() {
        String title = Bundle.getMessage("TurnoutOperationTitle") + " \"" + this.myOp.getName() + "\"";
        if (this.myOp.isNonce()) {
            title = Bundle.getMessage("TurnoutOperationForTurnout") + " " + this.myTurnout.getSystemName();
        }
        this.setTitle(title);
    }
}

