/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.turnout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.beantable.TurnoutTableAction;
import jmri.jmrit.beantable.beanedit.TurnoutEditAction;
import jmri.jmrit.beantable.turnout.Bundle;
import jmri.jmrit.beantable.turnout.TurnoutOperationEditorDialog;
import jmri.jmrit.beantable.turnout.TurnoutTableJTable;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutTableDataModel
extends BeanTableDataModel<Turnout> {
    public static final int INVERTCOL = 5;
    public static final int LOCKCOL = 6;
    public static final int EDITCOL = 7;
    public static final int KNOWNCOL = 8;
    public static final int MODECOL = 9;
    public static final int SENSOR1COL = 10;
    public static final int SENSOR2COL = 11;
    public static final int OPSONOFFCOL = 12;
    public static final int OPSEDITCOL = 13;
    public static final int LOCKOPRCOL = 14;
    public static final int LOCKDECCOL = 15;
    public static final int STRAIGHTCOL = 16;
    public static final int DIVERGCOL = 17;
    public static final int FORGETCOL = 18;
    public static final int QUERYCOL = 19;
    private boolean _graphicState;
    private TurnoutManager turnoutManager;
    String closedText;
    String thrownText;
    public String defaultThrownSpeedText;
    public String defaultClosedSpeedText;
    String useBlockSpeed;
    String bothText = "Both";
    String cabOnlyText = "Cab only";
    String pushbutText = "Pushbutton only";
    String noneText = "None";
    public final Vector<String> speedListClosed = new Vector();
    public final Vector<String> speedListThrown = new Vector();
    protected static AtomicBoolean editingOps = new AtomicBoolean(false);
    private static final Logger log = LoggerFactory.getLogger(TurnoutTableDataModel.class);

    public TurnoutTableDataModel() {
        this.initTable();
    }

    public TurnoutTableDataModel(Manager<Turnout> mgr) {
        this.setManager(mgr);
        this.initTable();
    }

    private void initTable() {
        this._graphicState = InstanceManager.getDefault(GuiLafPreferencesManager.class).isGraphicTableState();
        this.closedText = this.turnoutManager.getClosedText();
        this.thrownText = this.turnoutManager.getThrownText();
        this.defaultThrownSpeedText = Bundle.getMessage("UseGlobal", "Global") + " " + this.turnoutManager.getDefaultThrownSpeed();
        this.defaultClosedSpeedText = Bundle.getMessage("UseGlobal", "Global") + " " + this.turnoutManager.getDefaultClosedSpeed();
        this.useBlockSpeed = Bundle.getMessage("UseGlobal", "Block Speed");
        this.speedListClosed.add(this.defaultClosedSpeedText);
        this.speedListThrown.add(this.defaultThrownSpeedText);
        this.speedListClosed.add(this.useBlockSpeed);
        this.speedListThrown.add(this.useBlockSpeed);
        Vector<String> _speedMap = InstanceManager.getDefault(SignalSpeedMap.class).getValidSpeedNames();
        for (String s : _speedMap) {
            if (!this.speedListClosed.contains(s)) {
                this.speedListClosed.add(s);
            }
            if (this.speedListThrown.contains(s)) continue;
            this.speedListThrown.add(s);
        }
    }

    @Override
    public int getColumnCount() {
        return 19 + this.getPropertyColumnCount() + 1;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 5: {
                return Bundle.getMessage("Inverted");
            }
            case 6: {
                return Bundle.getMessage("Locked");
            }
            case 8: {
                return Bundle.getMessage("Feedback");
            }
            case 9: {
                return Bundle.getMessage("ModeLabel");
            }
            case 10: {
                return Bundle.getMessage("BlockSensor") + " 1";
            }
            case 11: {
                return Bundle.getMessage("BlockSensor") + " 2";
            }
            case 12: {
                return Bundle.getMessage("TurnoutAutomationMenu");
            }
            case 13: {
                return "";
            }
            case 14: {
                return Bundle.getMessage("LockMode");
            }
            case 15: {
                return Bundle.getMessage("Decoder");
            }
            case 17: {
                return Bundle.getMessage("ThrownSpeed");
            }
            case 16: {
                return Bundle.getMessage("ClosedSpeed");
            }
            case 18: {
                return Bundle.getMessage("StateForgetHeader");
            }
            case 19: {
                return Bundle.getMessage("StateQueryHeader");
            }
            case 7: {
                return "";
            }
        }
        return super.getColumnName(col);
    }

    @Override
    protected String getHeaderTooltip(int col) {
        switch (col) {
            case 10: {
                return Bundle.getMessage("Sensor1Tip", this.turnoutManager.getThrownText());
            }
            case 11: {
                return Bundle.getMessage("Sensor2Tip", this.turnoutManager.getClosedText());
            }
            case 12: {
                return Bundle.getMessage("TurnoutAutomationTip");
            }
            case 8: {
                return Bundle.getMessage("FeedbackTip");
            }
            case 9: {
                return Bundle.getMessage("FeedbackModeTip");
            }
        }
        return super.getHeaderTooltip(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 5: 
            case 6: {
                return Boolean.class;
            }
            case 8: {
                return String.class;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return JComboBox.class;
            }
            case 7: 
            case 13: 
            case 18: 
            case 19: {
                return JButton.class;
            }
            case 2: {
                return this._graphicState ? JLabel.class : JButton.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public int getPreferredWidth(int col) {
        switch (col) {
            case 5: 
            case 6: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 10: 
            case 11: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 13: {
                return new JButton((String)Bundle.getMessage((String)"EditTurnoutOperation")).getPreferredSize().width;
            }
            case 7: {
                return new JButton((String)Bundle.getMessage((String)"ButtonEdit")).getPreferredSize().width + 4;
            }
            case 12: {
                return new JTextField((String)Bundle.getMessage((String)"TurnoutAutomationMenu")).getPreferredSize().width;
            }
            case 16: 
            case 17: {
                return new JTextField((int)14).getPreferredSize().width;
            }
            case 18: {
                return new JButton((String)Bundle.getMessage((String)"StateForgetButton")).getPreferredSize().width;
            }
            case 19: {
                return new JButton((String)Bundle.getMessage((String)"StateQueryButton")).getPreferredSize().width;
            }
        }
        return super.getPreferredWidth(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Turnout t = this.turnoutManager.getBySystemName((String)this.sysNameList.get(row));
        if (t == null) {
            return false;
        }
        switch (col) {
            case 5: {
                return t.canInvert();
            }
            case 6: {
                return t.canLock(3);
            }
            case 13: {
                return t.getTurnoutOperation() != null;
            }
            case 8: {
                return false;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.sysNameList.size()) {
            log.warn("row is greater than name list");
            return "error";
        }
        TurnoutManager manager = this.turnoutManager;
        String name = (String)this.sysNameList.get(row);
        Turnout t = manager.getBySystemName(name);
        if (t == null) {
            log.debug("error null turnout!");
            return "error";
        }
        if (col == 5) {
            return t.getInverted();
        }
        if (col == 6) {
            return t.getLocked(3);
        }
        if (col == 8) {
            return t.describeState(t.getKnownState());
        }
        if (col == 9) {
            JComboBox<String> c = new JComboBox<String>(t.getValidFeedbackNames());
            c.setSelectedItem(t.getFeedbackModeName());
            return c;
        }
        if (col == 10) {
            return t.getFirstSensor();
        }
        if (col == 11) {
            return t.getSecondSensor();
        }
        if (col == 12) {
            return this.makeAutomationBox(t);
        }
        if (col == 13) {
            return Bundle.getMessage("EditTurnoutOperation");
        }
        if (col == 7) {
            return Bundle.getMessage("ButtonEdit");
        }
        if (col == 15) {
            JComboBox<String> c = (t.getPossibleLockModes() & 2) != 0 ? new JComboBox<String>(t.getValidDecoderNames()) : new JComboBox<String>(new String[]{t.getDecoderName()});
            c.setSelectedItem(t.getDecoderName());
            return c;
        }
        if (col == 14) {
            Vector<String> lockOperations = new Vector<String>();
            int modes = t.getPossibleLockModes();
            if ((modes & 1) != 0 && (modes & 2) != 0) {
                lockOperations.add(this.bothText);
            }
            if ((modes & 1) != 0) {
                lockOperations.add(this.cabOnlyText);
            }
            if ((modes & 2) != 0) {
                lockOperations.add(this.pushbutText);
            }
            lockOperations.add(this.noneText);
            JComboBox c = new JComboBox(lockOperations);
            if (t.canLock(1) && t.canLock(2)) {
                c.setSelectedItem(this.bothText);
            } else if (t.canLock(2)) {
                c.setSelectedItem(this.pushbutText);
            } else if (t.canLock(1)) {
                c.setSelectedItem(this.cabOnlyText);
            } else {
                c.setSelectedItem(this.noneText);
            }
            return c;
        }
        if (col == 16) {
            String speed = t.getStraightSpeed();
            if (!this.speedListClosed.contains(speed)) {
                this.speedListClosed.add(speed);
            }
            JComboBox<String> c = new JComboBox<String>(this.speedListClosed);
            c.setEditable(true);
            c.setSelectedItem(speed);
            JComboBoxUtil.setupComboBoxMaxRows(c);
            return c;
        }
        if (col == 17) {
            String speed = t.getDivergingSpeed();
            if (!this.speedListThrown.contains(speed)) {
                this.speedListThrown.add(speed);
            }
            JComboBox<String> c = new JComboBox<String>(this.speedListThrown);
            c.setEditable(true);
            c.setSelectedItem(speed);
            JComboBoxUtil.setupComboBoxMaxRows(c);
            return c;
        }
        if (col == 18) {
            return Bundle.getMessage("StateForgetButton");
        }
        if (col == 19) {
            return Bundle.getMessage("StateQueryButton");
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String name = (String)this.sysNameList.get(row);
        Turnout t = this.turnoutManager.getBySystemName(name);
        if (t == null) {
            NullPointerException ex = new NullPointerException("Unexpected null turnout in turnout table");
            log.error("No Turnout with system name \"{}\" exists ", (Object)name, (Object)ex);
            throw ex;
        }
        if (col == 5) {
            if (t.canInvert()) {
                t.setInverted((Boolean)value);
            }
        } else if (col == 6) {
            t.setLocked(3, (Boolean)value);
        } else if (col == 9) {
            String modeName = (String)((JComboBox)value).getSelectedItem();
            assert (modeName != null);
            t.setFeedbackMode(modeName);
        } else if (col == 10) {
            try {
                Sensor sensor = (Sensor)value;
                t.provideFirstFeedbackSensor(sensor != null ? sensor.getDisplayName() : null);
            }
            catch (JmriException e) {
                JmriJOptionPane.showMessageDialog(null, e.toString());
            }
        } else if (col == 11) {
            try {
                Sensor sensor = (Sensor)value;
                t.provideSecondFeedbackSensor(sensor != null ? sensor.getDisplayName() : null);
            }
            catch (JmriException e) {
                JmriJOptionPane.showMessageDialog(null, e.toString());
            }
        } else if (col != 12) {
            if (col == 13) {
                t.setInhibitOperation(false);
                JComboBox cb = (JComboBox)this.getValueAt(row, 12);
                log.debug("opsSelected = {}", (Object)this.getValueAt(row, 12).toString());
                this.editTurnoutOperation(t, cb);
                this.fireTableRowsUpdated(row, row);
            } else if (col == 7) {
                SwingUtilities.invokeLater(() -> this.editButton(t));
            } else if (col == 14) {
                String lockOpName = (String)((JComboBox)value).getSelectedItem();
                assert (lockOpName != null);
                if (lockOpName.equals(this.bothText)) {
                    t.enableLockOperation(3, true);
                }
                if (lockOpName.equals(this.cabOnlyText)) {
                    t.enableLockOperation(1, true);
                    t.enableLockOperation(2, false);
                }
                if (lockOpName.equals(this.pushbutText)) {
                    t.enableLockOperation(1, false);
                    t.enableLockOperation(2, true);
                }
                this.fireTableRowsUpdated(row, row);
            } else if (col == 15) {
                String decoderName = (String)((JComboBox)value).getSelectedItem();
                t.setDecoderName(decoderName);
                this.fireTableRowsUpdated(row, row);
            } else if (col == 16) {
                String speed = (String)((JComboBox)value).getSelectedItem();
                try {
                    t.setStraightSpeed(speed);
                }
                catch (JmriException ex) {
                    JmriJOptionPane.showMessageDialog(null, ex.getMessage() + "\n" + speed);
                    return;
                }
                if (!this.speedListClosed.contains(speed)) {
                    assert (speed != null);
                    if (!speed.contains("Global")) {
                        this.speedListClosed.add(speed);
                    }
                }
            } else if (col == 17) {
                String speed = (String)((JComboBox)value).getSelectedItem();
                try {
                    t.setDivergingSpeed(speed);
                }
                catch (JmriException ex) {
                    JmriJOptionPane.showMessageDialog(null, ex.getMessage() + "\n" + speed);
                    return;
                }
                if (!this.speedListThrown.contains(speed)) {
                    assert (speed != null);
                    if (!speed.contains("Global")) {
                        this.speedListThrown.add(speed);
                    }
                }
            } else if (col == 18) {
                t.setCommandedState(1);
            } else if (col == 19) {
                t.setCommandedState(1);
                t.requestUpdateFromLayout();
            } else if (col == 2 && this._graphicState) {
                this.clickOn(t);
                this.fireTableRowsUpdated(row, row);
            } else {
                super.setValueAt(value, row, col);
                if (row < this.getRowCount()) {
                    this.fireTableRowsUpdated(row, row);
                }
            }
        }
    }

    @Override
    public String getValue(@Nonnull String name) {
        Turnout turn = this.turnoutManager.getBySystemName(name);
        if (turn != null) {
            return turn.describeState(turn.getCommandedState());
        }
        return "Turnout not found";
    }

    @Override
    public Manager<Turnout> getManager() {
        if (this.turnoutManager == null) {
            this.turnoutManager = InstanceManager.getDefault(TurnoutManager.class);
        }
        return this.turnoutManager;
    }

    @Override
    protected final void setManager(@Nonnull Manager<Turnout> manager) {
        if (!(manager instanceof TurnoutManager)) {
            return;
        }
        this.getManager().removePropertyChangeListener(this);
        if (this.sysNameList != null) {
            for (int i = 0; i < this.sysNameList.size(); ++i) {
                Turnout b = this.getBySystemName((String)this.sysNameList.get(i));
                if (b == null) continue;
                b.removePropertyChangeListener(this);
            }
        }
        this.turnoutManager = (TurnoutManager)manager;
        this.getManager().addPropertyChangeListener(this);
        this.updateNameList();
    }

    @Override
    public Turnout getBySystemName(@Nonnull String name) {
        return this.turnoutManager.getBySystemName(name);
    }

    @Override
    public Turnout getByUserName(@Nonnull String name) {
        return InstanceManager.getDefault(TurnoutManager.class).getByUserName(name);
    }

    @Override
    protected String getMasterClassName() {
        return TurnoutTableAction.class.getName();
    }

    protected String getClassName() {
        return TurnoutTableAction.class.getName();
    }

    @Override
    public void clickOn(Turnout t) {
        t.setCommandedState(t.getCommandedState() == 2 ? 4 : 2);
    }

    @Override
    public void configureTable(JTable tbl) {
        this.setColumnToHoldButton(tbl, 7, this.editButton());
        this.setColumnToHoldButton(tbl, 13, this.editButton());
        XTableColumnModel columnModel = (XTableColumnModel)tbl.getColumnModel();
        TableColumn column = columnModel.getColumnByModelIndex(16);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(17);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(8);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(9);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(10);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(11);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(12);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(13);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(14);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(15);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(18);
        columnModel.setColumnVisible(column, false);
        column = columnModel.getColumnByModelIndex(19);
        columnModel.setColumnVisible(column, false);
        super.configureTable(tbl);
        columnModel.getColumnByModelIndex(18).setHeaderValue(null);
        columnModel.getColumnByModelIndex(19).setHeaderValue(null);
    }

    @Override
    protected boolean matchPropertyName(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "locked": 
            case "inverted": 
            case "feedbackchange": 
            case "TurnoutDivergingSpeedChange": 
            case "TurnoutStraightSpeedChange": 
            case "turnoutFeedbackFirstSensorChange": 
            case "turnoutFeedbackSecondSensorChange": 
            case "decoderNameChange": 
            case "TurnoutOperationState": 
            case "KnownState": 
            case "CommandedState": {
                return true;
            }
        }
        return super.matchPropertyName(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "DefaultTurnoutClosedSpeedChange": {
                this.updateClosedList();
                break;
            }
            case "DefaultTurnoutThrownSpeedChange": {
                this.updateThrownList();
                break;
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    protected void configValueColumn(JTable table) {
        log.debug("Turnout configValueColumn (I am {})", (Object)super.toString());
        if (this._graphicState) {
            table.setDefaultEditor(JLabel.class, new ImageIconRenderer());
            table.setDefaultRenderer(JLabel.class, new ImageIconRenderer());
        } else {
            super.configValueColumn(table);
        }
    }

    @Override
    public JTable makeJTable(@Nonnull String name, @Nonnull TableModel model, @CheckForNull RowSorter<? extends TableModel> sorter) {
        if (!(model instanceof TurnoutTableDataModel)) {
            throw new IllegalArgumentException("Model is not a TurnoutTableDataModel");
        }
        return this.configureJTable(name, new TurnoutTableJTable((TurnoutTableDataModel)model), sorter);
    }

    @Override
    protected void setColumnIdentities(JTable table) {
        super.setColumnIdentities(table);
        Enumeration<TableColumn> columns = table.getColumnModel() instanceof XTableColumnModel ? ((XTableColumnModel)table.getColumnModel()).getColumns(false) : table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            switch (column.getModelIndex()) {
                case 18: {
                    column.setIdentifier("ForgetState");
                    break;
                }
                case 19: {
                    column.setIdentifier("QueryState");
                    break;
                }
                case 10: {
                    column.setIdentifier("Sensor1");
                    break;
                }
                case 11: {
                    column.setIdentifier("Sensor2");
                    break;
                }
            }
        }
    }

    protected void editTurnoutOperation(@Nonnull Turnout t, JComboBox<String> box) {
        if (!editingOps.getAndSet(true)) {
            TurnoutOperation proto;
            TurnoutOperation op = t.getTurnoutOperation();
            if (op == null && (proto = InstanceManager.getDefault(TurnoutOperationManager.class).getMatchingOperationAlways(t)) != null) {
                op = proto.makeNonce(t);
                t.setTurnoutOperation(op);
            }
            if (op != null) {
                if (!op.isNonce()) {
                    op = op.makeNonce(t);
                }
                log.debug("TurnoutOpsEditDialog starting");
                Window w = JmriJOptionPane.findWindowForObject(box);
                TurnoutOperationEditorDialog dialog = new TurnoutOperationEditorDialog(op, t, w);
                dialog.setVisible(true);
            } else {
                JmriJOptionPane.showMessageDialog(box, Bundle.getMessage("TurnoutOperationErrorDialog"), Bundle.getMessage("ErrorTitle"), 0);
            }
        }
    }

    protected JComboBox<String> makeAutomationBox(Turnout t) {
        String[] str = new String[]{"empty"};
        final JComboBox<String> cb = new JComboBox<String>(str);
        final Turnout myTurnout = t;
        TurnoutTableAction.updateAutomationBox(t, cb);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TurnoutTableDataModel.this.setTurnoutOperation(myTurnout, cb);
                cb.removeActionListener(this);
                TurnoutTableAction.updateAutomationBox(myTurnout, cb);
                cb.addActionListener(this);
            }
        });
        return cb;
    }

    protected void setTurnoutOperation(@Nonnull Turnout t, JComboBox<String> cb) {
        switch (cb.getSelectedIndex()) {
            case 0: {
                t.setInhibitOperation(true);
                t.setTurnoutOperation(null);
                break;
            }
            case 1: {
                t.setInhibitOperation(false);
                t.setTurnoutOperation(null);
                break;
            }
            default: {
                t.setInhibitOperation(false);
                t.setTurnoutOperation(InstanceManager.getDefault(TurnoutOperationManager.class).getOperation((String)Objects.requireNonNull(cb.getSelectedItem())));
            }
        }
    }

    void editButton(Turnout t) {
        TurnoutEditAction beanEdit = new TurnoutEditAction();
        beanEdit.setBean(t);
        beanEdit.actionPerformed(null);
    }

    protected JButton editButton() {
        return new JButton(Bundle.getMessage("EditTurnoutOperation"));
    }

    private void updateClosedList() {
        this.speedListClosed.remove(this.defaultClosedSpeedText);
        this.defaultClosedSpeedText = Bundle.getMessage("UseGlobal", "Global") + " " + this.turnoutManager.getDefaultClosedSpeed();
        this.speedListClosed.add(0, this.defaultClosedSpeedText);
        this.fireTableDataChanged();
    }

    private void updateThrownList() {
        this.speedListThrown.remove(this.defaultThrownSpeedText);
        this.defaultThrownSpeedText = Bundle.getMessage("UseGlobal", "Global") + " " + this.turnoutManager.getDefaultThrownSpeed();
        this.speedListThrown.add(0, this.defaultThrownSpeedText);
        this.fireTableDataChanged();
    }

    public void showFeedbackChanged(boolean visible, JTable table) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        TableColumn column = columnModel.getColumnByModelIndex(8);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(9);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(10);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(11);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(12);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(13);
        columnModel.setColumnVisible(column, visible);
    }

    public void showLockChanged(boolean visible, JTable table) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        TableColumn column = ((XTableColumnModel)table.getColumnModel()).getColumnByModelIndex(15);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(14);
        columnModel.setColumnVisible(column, visible);
    }

    public void showTurnoutSpeedChanged(boolean visible, JTable table) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        TableColumn column = ((XTableColumnModel)table.getColumnModel()).getColumnByModelIndex(16);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(17);
        columnModel.setColumnVisible(column, visible);
    }

    public void showStateForgetAndQueryChanged(boolean visible, JTable table) {
        XTableColumnModel columnModel = (XTableColumnModel)table.getColumnModel();
        TableColumn column = columnModel.getColumnByModelIndex(18);
        columnModel.setColumnVisible(column, visible);
        column = columnModel.getColumnByModelIndex(19);
        columnModel.setColumnVisible(column, visible);
    }

    class ImageIconRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        protected JLabel label;
        protected String rootPath = "resources/icons/misc/switchboard/";
        protected char beanTypeChar = (char)84;
        protected String onIconPath = this.rootPath + this.beanTypeChar + "-on-s.png";
        protected String offIconPath = this.rootPath + this.beanTypeChar + "-off-s.png";
        protected BufferedImage onImage;
        protected BufferedImage offImage;
        protected ImageIcon onIcon;
        protected ImageIcon offIcon;
        protected int iconHeight = -1;

        ImageIconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            return this.updateLabel((String)value, row, table);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            log.debug("Renderer Item = {}, State = {}", (Object)row, value);
            if (this.iconHeight < 0) {
                this.loadIcons();
                log.debug("icons loaded");
            }
            return this.updateLabel((String)value, row, table);
        }

        public JLabel updateLabel(String value, final int row, JTable table) {
            if (this.iconHeight > 0) {
                table.setRowHeight(row, Math.max(table.getRowHeight(), this.iconHeight - 5));
            }
            if (value.equals(TurnoutTableDataModel.this.closedText) && this.onIcon != null) {
                this.label = new JLabel(this.onIcon);
                this.label.setVerticalAlignment(3);
                log.debug("onIcon set");
            } else if (value.equals(TurnoutTableDataModel.this.thrownText) && this.offIcon != null) {
                this.label = new JLabel(this.offIcon);
                this.label.setVerticalAlignment(3);
                log.debug("offIcon set");
            } else if (value.equals(Bundle.getMessage("BeanStateInconsistent"))) {
                this.label = new JLabel("X", 0);
                this.label.setForeground(Color.red);
                log.debug("Turnout state inconsistent");
                this.iconHeight = 0;
            } else if (value.equals(Bundle.getMessage("BeanStateUnknown"))) {
                this.label = new JLabel("?", 0);
                log.debug("Turnout state unknown");
                this.iconHeight = 0;
            } else {
                this.label = new JLabel(value, 0);
                log.warn("Error reading icons for TurnoutTable");
                this.iconHeight = 0;
            }
            this.label.setToolTipText(value);
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public final void mousePressed(MouseEvent evt) {
                    log.debug("Clicked on icon in row {}", (Object)row);
                    ImageIconRenderer.this.stopCellEditing();
                }
            });
            return this.label;
        }

        @Override
        public Object getCellEditorValue() {
            log.debug("getCellEditorValue, me = {})", (Object)this.toString());
            return this.toString();
        }

        protected void loadIcons() {
            try {
                this.onImage = ImageIO.read(new File(this.onIconPath));
                this.offImage = ImageIO.read(new File(this.offIconPath));
            }
            catch (IOException ex) {
                log.error("error reading image from {} or {}", new Object[]{this.onIconPath, this.offIconPath, ex});
            }
            log.debug("Success reading images");
            int imageWidth = this.onImage.getWidth();
            int imageHeight = this.onImage.getHeight();
            Image smallOnImage = this.onImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            Image smallOffImage = this.offImage.getScaledInstance(imageWidth / 2, imageHeight / 2, 1);
            this.onIcon = new ImageIcon(smallOnImage);
            this.offIcon = new ImageIcon(smallOffImage);
            this.iconHeight = this.onIcon.getIconHeight();
        }
    }
}

